/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public enum DotColor {
    MAGIC("Magic", "magic"),
    YELLOW("Yellow", "gold", "yellow", "lightgoldenrod", "yellow", "tol_light_yellow"),
    GREEN("Green", "limegreen", "green2", "darkolivegreen2", "chartreuse2", "tol_light_green"),
    BLUE("Blue", "cornflowerblue", "blue", "cadetblue", "cyan", "tol_light_blue"),
    RED("Red", "palevioletred", "red", "salmon", "magenta", "tol_light_red"),
    GRAY("Gray", "lightgray", "lightgray", "lightgray", "lightgray", "tol_light_gray"),
    WHITE("White", "white"),
    BLACK("Black", "black");

    private final String displayText;
    private final List<String> colors = new ArrayList<String>();
    private final List<Icon> icons = new ArrayList<Icon>();
    private static final Map<String, Color> name2color;

    private DotColor(String text, String ... colors) {
        this.displayText = text;
        for (int i = 0; i < colors.length; ++i) {
            this.colors.add(colors[i]);
            this.icons.add(OurUtil.loadIcon((String)("icons/ColorIcons/" + colors[i] + ".gif")));
        }
    }

    public static Object[] valuesWithout(DotColor exclude) {
        Object[] ans = new Object[DotColor.values().length - 1];
        int i = 0;
        for (DotColor d : DotColor.values()) {
            if (d == exclude) continue;
            ans[i++] = d;
        }
        return ans;
    }

    public Icon getIcon(DotPalette pal) {
        int i = 0;
        for (DotPalette choice : DotPalette.values()) {
            if (i >= this.icons.size()) break;
            if (pal == choice) {
                return this.icons.get(i);
            }
            ++i;
        }
        return this.icons.get(0);
    }

    public Color getColor(DotPalette pal) {
        String name = this.getDotText(pal);
        Color ans = name2color.get(name);
        if (ans != null) {
            return ans;
        }
        ans = name.equals("palevioletred") ? new Color(222, 113, 148) : (name.equals("red") ? new Color(255, 0, 0) : (name.equals("tol_light_red") ? new Color(204, 102, 119) : (name.equals("salmon") ? new Color(255, 130, 115) : (name.equals("magenta") ? new Color(255, 0, 255) : (name.equals("limegreen") ? new Color(49, 207, 49) : (name.equals("green2") ? new Color(0, 239, 0) : (name.equals("tol_light_green") ? new Color(170, 170, 0) : (name.equals("darkolivegreen2") ? new Color(189, 239, 107) : (name.equals("chartreuse2") ? new Color(115, 239, 0) : (name.equals("gold") ? new Color(255, 215, 0) : (name.equals("yellow") ? new Color(255, 255, 0) : (name.equals("tol_light_yellow") ? new Color(238, 221, 136) : (name.equals("lightgoldenrod") ? new Color(239, 223, 132) : (name.equals("cornflowerblue") ? new Color(99, 150, 239) : (name.equals("blue") ? new Color(0, 0, 255) : (name.equals("tol_light_blue") ? new Color(119, 170, 221) : (name.equals("cadetblue") ? new Color(90, 158, 165) : (name.equals("cyan") ? new Color(0, 255, 255) : (name.equals("lightgray") ? new Color(214, 214, 214) : (name.equals("tol_light_gray") ? new Color(221, 221, 221) : (name.equals("white") ? Color.WHITE : Color.BLACK)))))))))))))))))))));
        name2color.put(name, ans);
        return ans;
    }

    public String getDotText(DotPalette pal) {
        int i = 0;
        for (DotPalette choice : DotPalette.values()) {
            if (i >= this.colors.size()) break;
            if (pal == choice) {
                return this.colors.get(i);
            }
            ++i;
        }
        return this.colors.get(0);
    }

    public String getDisplayedText() {
        return this.displayText;
    }

    public static DotColor parse(String x) {
        if (x != null) {
            for (DotColor d : DotColor.values()) {
                if (!d.toString().equals(x)) continue;
                return d;
            }
        }
        return null;
    }

    public String toString() {
        return this.displayText;
    }

    static {
        name2color = new HashMap<String, Color>();
    }
}

