/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4.OurUtil;
import javax.swing.Icon;

public enum DotShape {
    ELLIPSE("Ellipse", "ellipse"),
    BOX("Box", "box"),
    CIRCLE("Circle", "circle"),
    EGG("Egg", "egg"),
    TRIANGLE("Triangle", "triangle"),
    DIAMOND("Diamond", "diamond"),
    TRAPEZOID("Trapezoid", "trapezium"),
    PARALLELOGRAM("Parallelogram", "parallelogram"),
    HOUSE("House", "house"),
    HEXAGON("Hexagon", "hexagon"),
    OCTAGON("Octagon", "octagon"),
    DOUBLE_CIRCLE("Dbl Circle", "doublecircle"),
    DOUBLE_OCTAGON("Dbl Octagon", "doubleoctagon"),
    TRIPLE_OCTAGON("Tpl Octagon", "tripleoctagon"),
    INV_TRIANGLE("Inv Triangle", "invtriangle"),
    INV_HOUSE("Inv House", "invhouse"),
    INV_TRAPEZOID("Inv Trapezoid", "invtrapezium"),
    M_DIAMOND("Lined Diamond", "Mdiamond"),
    M_SQUARE("Lined Square", "Msquare"),
    M_CIRCLE("Lined Circle", "Mcircle");

    private final String name;
    private final Icon icon;
    private final String dotName;

    private DotShape(String name, String dotName) {
        this.name = name;
        this.icon = OurUtil.loadIcon((String)("icons/ShapeIcons/" + dotName + ".gif"));
        this.dotName = dotName;
    }

    public String getDisplayedText() {
        return this.name;
    }

    public String getDotText() {
        return this.dotName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public static DotShape parse(String x) {
        if (x != null) {
            for (DotShape d : DotShape.values()) {
                if (!d.name.equals(x)) continue;
                return d;
            }
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

