/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4.Pair;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.Artist;
import edu.mit.csail.sdg.alloy4graph.AvailableSpace;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.GraphEdge;
import edu.mit.csail.sdg.alloy4graph.GraphNode;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class Graph {
    static final int xJump = 30;
    static final int yJump = 60;
    static final int selfLoopA = 40;
    static final int selfLoopGL = 2;
    static final int selfLoopGR = 20;
    private final int ad = Artist.getMaxAscentAndDescent();
    final double defaultScale;
    private int left = 0;
    private int top = 0;
    private int bottom = 0;
    private int totalWidth = 0;
    private int totalHeight = 0;
    int[] layerPH = null;
    final List<List<GraphNode>> layerlist = new ArrayList<List<GraphNode>>();
    final List<GraphNode> nodelist = new ArrayList<GraphNode>();
    final List<GraphEdge> edgelist = new ArrayList<GraphEdge>();
    public final List<GraphNode> nodes = Collections.unmodifiableList(this.nodelist);
    public final List<GraphEdge> edges = Collections.unmodifiableList(this.edgelist);
    private final List<GraphNode> emptyListOfNodes = Collections.unmodifiableList(new ArrayList(0));
    private final SortedMap<Comparable<?>, Pair<String, Color>> legends = new TreeMap();

    public Graph(double defaultScale) {
        this.defaultScale = defaultScale;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    List<GraphNode> layer(int i) {
        if (i >= 0 && i < this.layerlist.size()) {
            return Collections.unmodifiableList(this.layerlist.get(i));
        }
        return this.emptyListOfNodes;
    }

    int layers() {
        return this.layerlist.size();
    }

    void swapNodes(int layer, int node1, int node2) {
        List<GraphNode> list = this.layerlist.get(layer);
        GraphNode n1 = list.get(node1);
        GraphNode n2 = list.get(node2);
        list.set(node1, n2);
        list.set(node2, n1);
    }

    void sortNodes(Iterable<GraphNode> newOrder) {
        int i = 0;
        int n = this.nodelist.size();
        block0: for (GraphNode x : newOrder) {
            for (int j = i; j < n; ++j) {
                if (this.nodelist.get(j) != x) continue;
                if (i != j) {
                    GraphNode tmp = this.nodelist.get(i);
                    this.nodelist.set(i, x);
                    this.nodelist.set(j, tmp);
                }
                ++i;
                continue block0;
            }
        }
        i = 0;
        for (GraphNode x : this.nodelist) {
            x.pos = i++;
        }
    }

    void sortLayer(int layer, Comparator<GraphNode> comparator) {
        Collections.sort(this.layerlist.get(layer), comparator);
    }

    public void addLegend(Comparable<?> object, String label, Color color) {
        this.legends.put(object, (Pair<String, Color>)new Pair((Object)label, (Object)color));
    }

    private void layout_assignOrder() {
        int num = this.nodes.size();
        if (0x3FFFFFFF < num) {
            throw new OutOfMemoryError();
        }
        ArrayList bins = new ArrayList(2 * num + 1);
        for (int i = 0; i < 2 * num + 1; ++i) {
            bins.add(new LinkedList());
        }
        ArrayList grIN = new ArrayList(num);
        ArrayList grOUT = new ArrayList(num);
        int[] grBIN = new int[num];
        for (GraphNode n : this.nodes) {
            int ni = n.pos();
            LinkedList<GraphNode> in = new LinkedList<GraphNode>();
            LinkedList<GraphNode> out = new LinkedList<GraphNode>();
            for (GraphEdge e : n.ins) {
                GraphNode a = e.a();
                if (in.contains(a)) continue;
                in.add(a);
            }
            for (GraphEdge e : n.outs) {
                GraphNode b = e.b();
                if (out.contains(b)) continue;
                out.add(b);
            }
            grIN.add(in);
            grOUT.add(out);
            grBIN[ni] = out.size() == 0 ? 0 : (in.size() == 0 ? 2 * num : out.size() - in.size() + num);
            ((List)bins.get(grBIN[ni])).add(n);
        }
        LinkedList<GraphNode> s1 = new LinkedList<GraphNode>();
        LinkedList<GraphNode> s2 = new LinkedList<GraphNode>();
        block4: while (true) {
            GraphNode x = null;
            if (!((List)bins.get(0)).isEmpty()) {
                x = (GraphNode)((List)bins.get(0)).remove(((List)bins.get(0)).size() - 1);
                s1.add(x);
            } else {
                for (int j = 2 * num; j > 0; --j) {
                    List bin = (List)bins.get(j);
                    int sz = bin.size();
                    if (sz <= 0) continue;
                    x = (GraphNode)bin.remove(sz - 1);
                    s2.addFirst(x);
                    break;
                }
            }
            if (x == null) break;
            ((List)bins.get(grBIN[x.pos()])).remove(x);
            for (GraphNode n : (LinkedList)grIN.get(x.pos())) {
                ((LinkedList)grOUT.get(n.pos())).remove(x);
            }
            for (GraphNode n : (LinkedList)grOUT.get(x.pos())) {
                ((LinkedList)grIN.get(n.pos())).remove(x);
            }
            ArrayList<GraphNode> aux = new ArrayList<GraphNode>((Collection)grIN.get(x.pos()));
            aux.addAll((Collection)grOUT.get(x.pos()));
            aux.sort(new Comparator<GraphNode>(){

                @Override
                public int compare(GraphNode o1, GraphNode o2) {
                    return -o1.uuid.toString().compareTo(o2.uuid.toString());
                }
            });
            Iterator iterator = aux.iterator();
            while (true) {
                if (!iterator.hasNext()) continue block4;
                GraphNode n = (GraphNode)iterator.next();
                int ni = n.pos();
                int out = ((LinkedList)grOUT.get(ni)).size();
                int in = ((LinkedList)grIN.get(ni)).size();
                int b = out == 0 ? 0 : (in == 0 ? 2 * num : out - in + num);
                if (grBIN[ni] == b) continue;
                ((List)bins.get(grBIN[ni])).remove(n);
                grBIN[ni] = b;
                ((List)bins.get(b)).add(n);
            }
            break;
        }
        this.sortNodes(Util.fastJoin(s1, s2));
    }

    private void layout_backEdges() {
        for (GraphEdge e : this.edges) {
            if (e.a().pos() >= e.b().pos()) continue;
            e.set(e.bhead(), e.ahead()).reverse();
        }
    }

    private int layout_decideLayer() {
        boolean changed;
        int n = this.nodes.size();
        int[] len = new int[n];
        for (GraphNode x : this.nodes) {
            int max = 0;
            for (GraphEdge e : x.outs) {
                GraphNode y = e.b();
                int yLen = len[y.pos()] + 1;
                if (max >= yLen) continue;
                max = yLen;
            }
            len[x.pos()] = max;
        }
        for (GraphNode x : this.nodes) {
            x.setLayer(len[x.pos()]);
        }
        do {
            changed = false;
            for (GraphNode x : this.nodes) {
                if (x.ins.size() <= 0) continue;
                int closestLayer = this.layers() + 1;
                for (GraphEdge e : x.ins) {
                    int y = e.a().layer();
                    if (closestLayer <= y) continue;
                    closestLayer = y;
                }
                if (closestLayer - 1 <= x.layer()) continue;
                x.setLayer(closestLayer - 1);
                changed = true;
            }
        } while (changed);
        return this.layers();
    }

    private void layout_dummyNodesIfNeeded() {
        Iterator<GraphEdge> iterator = new ArrayList<GraphEdge>(this.edges).iterator();
        while (iterator.hasNext()) {
            GraphEdge edge;
            GraphEdge e = edge = iterator.next();
            GraphNode a = e.a();
            GraphNode b = e.b();
            while (a.layer() - b.layer() > 1) {
                GraphNode tmp = a;
                a = new GraphNode(a.graph, e.uuid, new String[0]).set((DotShape)null);
                a.setLayer(tmp.layer() - 1);
                e.change(a);
                e = new GraphEdge(a, b, e.uuid, "", e.ahead(), e.bhead(), e.style(), e.color(), e.group);
            }
        }
    }

    private void layout_reorderPerLayer() {
        IdentityHashMap<GraphNode, GraphNode> map = new IdentityHashMap<GraphNode, GraphNode>();
        final double[] bc = new double[this.nodes.size() + 1];
        int i = 1;
        for (GraphNode n : this.layer(0)) {
            bc[n.pos()] = i;
            ++i;
        }
        for (int layer = 0; layer < this.layers() - 1; ++layer) {
            for (GraphNode n : this.layer(layer + 1)) {
                map.clear();
                int count = 0;
                double sum = 0.0;
                for (GraphEdge e : n.outs) {
                    GraphNode nn = e.b();
                    if (map.put(nn, nn) != null) continue;
                    ++count;
                    sum += bc[nn.pos()];
                }
                bc[n.pos()] = count == 0 ? 0.0 : sum / (double)count;
            }
            this.sortLayer(layer + 1, new Comparator<GraphNode>(){

                @Override
                public int compare(GraphNode o1, GraphNode o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    int n = Double.compare(bc[o1.pos()], bc[o2.pos()]);
                    if (n != 0) {
                        return n;
                    }
                    if (o1.pos() < o2.pos()) {
                        return -1;
                    }
                    return 1;
                }
            });
            int j = 1;
            for (GraphNode n : this.layer(layer + 1)) {
                bc[n.pos()] = j;
                ++j;
            }
        }
    }

    private void layout_xAssignment(List<GraphNode> nodes) {
        Block b;
        int i;
        int n = nodes.size();
        if (n == 0) {
            return;
        }
        Block[] block = new Block[n + 1];
        block[0] = new Block();
        for (i = 1; i <= n; ++i) {
            block[i] = b = new Block(nodes.get(i - 1), i);
            while (block[b.first - 1].posn + block[b.first - 1].width > b.posn) {
                block[b.last] = b = new Block(block[b.first - 1], b);
                block[b.first] = b;
            }
        }
        i = 1;
        do {
            b = block[i];
            double tmp = b.posn + (double)(nodes.get(b.first - 1).getWidth() + nodes.get(b.first - 1).getReserved() + 30) / 2.0;
            nodes.get(i - 1).setX((int)tmp);
            ++i;
            while (i <= b.last) {
                GraphNode v1 = nodes.get(i - 1);
                GraphNode v2 = nodes.get(i - 2);
                int xsep = (v1.getWidth() + v1.getReserved() + v2.getWidth() + v2.getReserved()) / 2 + 30;
                v1.setX(v2.x() + xsep);
                ++i;
            }
        } while ((i = b.last + 1) <= n);
    }

    private static double des(GraphNode n) {
        int wt = Graph.wt(n);
        if (wt == 0) {
            return 0.0;
        }
        double ans = 0.0;
        for (GraphEdge e : n.ins) {
            ans += (double)e.weight() * (double)e.a().x();
        }
        for (GraphEdge e : n.outs) {
            ans += (double)e.weight() * (double)e.b().x();
        }
        return ans / (double)wt;
    }

    private static int wt(GraphNode n) {
        int ans = 0;
        for (GraphEdge e : n.ins) {
            ans += e.weight();
        }
        for (GraphEdge e : n.outs) {
            ans += e.weight();
        }
        return ans;
    }

    private void checkUpperCollision(List<GraphNode> top) {
        int room = 2;
        for (int i = 0; i < top.size(); ++i) {
            GraphNode a = top.get(i);
            double left = a.x() - a.getWidth() / 2;
            double right = a.x() - a.getWidth() / 2;
            for (GraphEdge e : a.outs) {
                double cbottom;
                double ctop;
                GraphNode c;
                int j;
                GraphNode b = e.b();
                if ((double)b.x() >= right) {
                    for (j = i + 1; j < top.size(); ++j) {
                        c = top.get(j);
                        if (c.shape() == null) continue;
                        ctop = c.y() - c.getHeight() / 2;
                        double cleft = c.x() - c.getWidth() / 2;
                        cbottom = c.y() + c.getHeight() / 2;
                        e.path().bendDown(cleft, ctop - 2.0, cbottom + 2.0, 3.0);
                    }
                    continue;
                }
                if (!((double)b.x() <= left)) continue;
                for (j = i - 1; j >= 0; --j) {
                    c = top.get(j);
                    if (c.shape() == null) continue;
                    ctop = c.y() - c.getHeight() / 2;
                    double cright = c.x() + c.getWidth() / 2;
                    cbottom = c.y() + c.getHeight() / 2;
                    e.path().bendDown(cright, ctop - 2.0, cbottom + 2.0, 3.0);
                }
            }
        }
    }

    private void checkLowerCollision(List<GraphNode> bottom) {
        int room = 2;
        for (int i = 0; i < bottom.size(); ++i) {
            GraphNode b = bottom.get(i);
            double left = b.x() - b.getWidth() / 2;
            double right = b.x() - b.getWidth() / 2;
            for (GraphEdge e : b.ins) {
                double cbottom;
                double ctop;
                GraphNode c;
                int j;
                GraphNode a = e.a();
                if ((double)a.x() <= left) {
                    for (j = i - 1; j >= 0; --j) {
                        c = bottom.get(j);
                        if (c.shape() == null) continue;
                        ctop = c.y() - c.getHeight() / 2;
                        double cright = c.x() + c.getWidth() / 2;
                        cbottom = c.y() + c.getHeight() / 2;
                        e.path().bendUp(cright, ctop - 2.0, cbottom + 2.0, 3.0);
                    }
                    continue;
                }
                if (!((double)a.x() >= right)) continue;
                for (j = i + 1; j < bottom.size(); ++j) {
                    c = bottom.get(j);
                    if (c.shape() == null) continue;
                    ctop = c.y() - c.getHeight() / 2;
                    double cleft = c.x() - c.getWidth() / 2;
                    cbottom = c.y() + c.getHeight() / 2;
                    e.path().bendUp(cleft, ctop - 2.0, cbottom + 2.0, 3.0);
                }
            }
        }
    }

    private boolean free(GraphNode a, GraphNode b) {
        if (a.layer() > b.layer()) {
            GraphNode tmp = a;
            a = b;
            b = tmp;
        }
        Line2D.Double line = new Line2D.Double(a.x(), a.y(), b.x(), b.y());
        for (GraphNode n : this.nodes) {
            if (n == a || n == b || a.layer() >= n.layer() || n.layer() >= b.layer() || n.shape() == null || !line.intersects(n.getBoundingBox(10, 10))) continue;
            return false;
        }
        return true;
    }

    public void layout() {
        int layer;
        if (this.nodes.size() == 0) {
            return;
        }
        for (GraphNode n : this.nodes) {
            n.calcBounds();
        }
        this.layout_assignOrder();
        this.layout_backEdges();
        int layers = this.layout_decideLayer();
        this.layout_dummyNodesIfNeeded();
        this.layout_reorderPerLayer();
        this.layerPH = new int[layers];
        for (int layer2 = layers - 1; layer2 >= 0; --layer2) {
            int x = 5;
            int h = 0;
            for (GraphNode n : this.layer(layer2)) {
                int nHeight = n.getHeight();
                int nWidth = n.getWidth();
                n.setX(x + nWidth / 2);
                if (h < nHeight) {
                    h = nHeight;
                }
                x = x + nWidth + n.getReserved() + 20;
            }
            this.layerPH[layer2] = h;
        }
        if (layers > 1) {
            for (int i = 0; i < 3; ++i) {
                for (layer = 0; layer < layers; ++layer) {
                    this.layout_xAssignment(this.layer(layer));
                }
            }
        }
        int py = 5;
        for (layer = layers - 1; layer >= 0; --layer) {
            int ph = this.layerPH[layer];
            for (GraphNode n : this.layer(layer)) {
                n.setY(py + ph / 2);
            }
            py = py + ph + 60;
        }
        this.relayout_edges(true);
        this.recalcBound(true);
    }

    /*
     * WARNING - void declaration
     */
    void recalcBound(boolean fresh) {
        if (this.nodes.size() == 0) {
            this.top = 0;
            this.bottom = 10;
            this.totalHeight = 10;
            this.left = 0;
            this.totalWidth = 10;
            return;
        }
        if (fresh) {
            this.top = this.nodes.get(0).y() - this.nodes.get(0).getHeight() / 2 - 5;
            this.bottom = this.nodes.get(0).y() + this.nodes.get(0).getHeight() / 2 + 5;
        }
        int minX = this.nodes.get(0).x() - this.nodes.get(0).getWidth() / 2 - 5;
        int maxX = this.nodes.get(0).x() + this.nodes.get(0).getWidth() / 2 + this.nodes.get(0).getReserved() + 5;
        for (GraphNode graphNode : this.nodes) {
            int max;
            int min = graphNode.x() - graphNode.getWidth() / 2 - 5;
            if (minX > min) {
                minX = min;
            }
            if (maxX >= (max = graphNode.x() + graphNode.getWidth() / 2 + graphNode.getReserved() + 5)) continue;
            maxX = max;
        }
        for (GraphEdge graphEdge : this.edges) {
            if (graphEdge.getLabelW() <= 0 || graphEdge.getLabelH() <= 0) continue;
            int x1 = graphEdge.getLabelX();
            int x2 = x1 + graphEdge.getLabelW() - 1;
            if (minX > x1) {
                minX = x1;
            }
            if (maxX >= x2) continue;
            maxX = x2;
        }
        this.left = minX - 20;
        this.totalWidth = maxX - minX + 20;
        for (int layer = this.layers() - 1; layer >= 0; --layer) {
            for (GraphNode n : this.layer(layer)) {
                int ybottom;
                int ytop = n.y() - n.getHeight() / 2 - 5;
                if (this.top > ytop) {
                    this.top = ytop;
                }
                if (this.bottom >= (ybottom = n.y() + n.getHeight() / 2 + 5)) continue;
                this.bottom = ybottom;
            }
        }
        this.totalHeight = this.bottom - this.top;
        int widestLegend = 0;
        int n = 30;
        for (Pair<String, Color> e : this.legends.values()) {
            if (e.b == null) continue;
            int widthOfLegend = (int)Artist.getBounds(true, (String)e.a).getWidth();
            if (widestLegend < widthOfLegend) {
                widestLegend = widthOfLegend;
            }
            var5_12 += this.ad;
        }
        if (widestLegend > 0) {
            void var5_12;
            this.left -= widestLegend + 10;
            this.totalWidth += widestLegend * 2 + 10;
            if (this.totalHeight < var5_12) {
                this.bottom += var5_12 - this.totalHeight;
                this.totalHeight = var5_12;
            }
        }
    }

    void relayout_edges(boolean straighten) {
        double xx;
        int i;
        if (straighten) {
            for (i = 0; i < 5; ++i) {
                for (GraphNode n : this.nodes) {
                    if (n.shape() != null) continue;
                    GraphEdge e1 = n.ins.get(0);
                    GraphEdge e2 = n.outs.get(0);
                    if (!this.free(e1.a(), e2.b())) continue;
                    double slope = (double)(e2.b().x() - e1.a().x()) / (double)(e2.b().y() - e1.a().y());
                    xx = (double)(n.y() - e1.a().y()) * slope + (double)e1.a().x();
                    n.setX((int)xx);
                }
            }
        }
        if (straighten) {
            for (GraphEdge e : this.edges) {
                GraphNode b;
                if (e.a().shape() == null || e.b().shape() != null) continue;
                GraphNode a = e.a();
                GraphEdge ee = e;
                while ((b = ee.b()).shape() == null) {
                    ee = b.outs.get(0);
                }
                if (!this.free(a, b)) continue;
                double slope = (double)(b.x() - a.x()) / (double)(b.y() - a.y());
                GraphEdge ee2 = e;
                while ((b = ee2.b()).shape() == null) {
                    xx = (double)(b.y() - a.y()) * slope + (double)a.x();
                    b.setX((int)xx);
                    ee2 = b.outs.get(0);
                }
            }
        }
        if (straighten) {
            for (i = 0; i < this.layers(); ++i) {
                int bx;
                int ax;
                GraphNode b;
                GraphNode a;
                int j;
                this.sortLayer(i, new Comparator<GraphNode>(){

                    @Override
                    public int compare(GraphNode o1, GraphNode o2) {
                        if (o1.x() < o2.x()) {
                            return -1;
                        }
                        if (o1.x() > o2.x()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                ArrayList<GraphNode> layer = new ArrayList<GraphNode>(this.layer(i));
                for (j = layer.size() / 2; j >= 0 && j < layer.size() - 1; ++j) {
                    a = (GraphNode)layer.get(j);
                    b = (GraphNode)layer.get(j + 1);
                    ax = a.shape() == null ? a.x() : a.x() + a.getWidth() / 2 + a.getReserved();
                    int n = bx = b.shape() == null ? b.x() : b.x() - b.getWidth() / 2;
                    if (bx > ax && bx - ax >= 5) continue;
                    b.setX(ax + 5 + b.getWidth() / 2);
                }
                for (j = layer.size() / 2; j > 0 && j < layer.size(); --j) {
                    a = (GraphNode)layer.get(j - 1);
                    b = (GraphNode)layer.get(j);
                    ax = a.shape() == null ? a.x() : a.x() + a.getWidth() / 2 + a.getReserved();
                    int n = bx = b.shape() == null ? b.x() : b.x() - b.getWidth() / 2;
                    if (bx > ax && bx - ax >= 5) continue;
                    a.setX(bx - 5 - a.getWidth() / 2 - a.getReserved());
                }
            }
        }
        for (GraphEdge e : this.edges) {
            e.resetPath();
        }
        for (int layer = this.layers() - 1; layer > 0; --layer) {
            List<GraphNode> top = this.layer(layer);
            List<GraphNode> bottom = this.layer(layer - 1);
            this.checkUpperCollision(top);
            this.checkLowerCollision(bottom);
            this.checkUpperCollision(top);
        }
        AvailableSpace sp = new AvailableSpace();
        for (GraphNode n : this.nodes) {
            if (n.shape() == null) continue;
            sp.add(n.x() - n.getWidth() / 2, n.y() - n.getHeight() / 2, n.getWidth() + n.getReserved(), n.getHeight());
        }
        for (GraphEdge e : this.edges) {
            e.layout_arrowHead();
            e.repositionLabel(sp);
        }
    }

    void relayout_edges(int i) {
        List<GraphNode> bottom;
        List<GraphNode> top;
        if (this.nodes.size() == 0) {
            return;
        }
        for (GraphNode n : this.layer(i)) {
            for (GraphEdge e : n.selfs) {
                e.resetPath();
                e.layout_arrowHead();
            }
        }
        if (i > 0) {
            top = this.layer(i);
            bottom = this.layer(i - 1);
            for (GraphNode n : top) {
                for (GraphEdge e : n.outs) {
                    e.resetPath();
                }
            }
            this.checkUpperCollision(top);
            this.checkLowerCollision(bottom);
            this.checkUpperCollision(top);
        }
        if (i < this.layers() - 1) {
            top = this.layer(i + 1);
            bottom = this.layer(i);
            for (GraphNode n : top) {
                for (GraphEdge e : n.outs) {
                    e.resetPath();
                }
            }
            this.checkUpperCollision(top);
            this.checkLowerCollision(bottom);
            this.checkUpperCollision(top);
        }
        AvailableSpace sp = new AvailableSpace();
        for (GraphNode n : this.nodes) {
            if (n.shape() == null) continue;
            sp.add(n.x() - n.getWidth() / 2, n.y() - n.getHeight() / 2, n.getWidth() + n.getReserved(), n.getHeight());
        }
        for (GraphEdge e : this.edges) {
            e.layout_arrowHead();
            e.repositionLabel(sp);
        }
    }

    public Object find(double scale, int mouseX, int mouseY) {
        int h = this.getTop() + 10 - this.ad;
        double x = (double)mouseX / scale + (double)this.getLeft();
        double y = (double)mouseY / scale + (double)this.getTop();
        for (Map.Entry<Comparable<?>, Pair<String, Color>> entry : this.legends.entrySet()) {
            if (entry.getValue().b == null || y < (double)(h += this.ad) || y >= (double)(h + this.ad)) continue;
            int w = (int)Artist.getBounds(true, (String)entry.getValue().a).getWidth();
            if (!(x >= (double)(this.getLeft() + 10)) || !(x <= (double)(this.getLeft() + 10 + w))) continue;
            return entry.getKey();
        }
        for (GraphNode graphNode : this.nodes) {
            if (graphNode.shape() == null && Math.abs((double)graphNode.x() - x) < 10.0 && Math.abs((double)graphNode.y() - y) < 10.0) {
                return graphNode;
            }
            if (!graphNode.contains(x, y)) continue;
            return graphNode;
        }
        for (GraphEdge graphEdge : this.edges) {
            double dx;
            if (graphEdge.a() != graphEdge.b()) {
                dx = graphEdge.path().getXatY(y, 0.0, 1.0, Double.NaN);
                if (Double.isNaN(dx) || !(StrictMath.abs(x - dx) < 12.0 / scale)) continue;
                return graphEdge;
            }
            dx = graphEdge.path().getXatY(y, 0.25, 0.75, Double.NaN);
            if (!Double.isNaN(dx) && StrictMath.abs(x - dx) < 12.0 / scale) {
                return graphEdge;
            }
            dx = graphEdge.path().getXatY(y, 0.0, 0.25, Double.NaN);
            if (!Double.isNaN(dx) && StrictMath.abs(x - dx) < 12.0 / scale) {
                return graphEdge;
            }
            dx = graphEdge.path().getXatY(y, 0.75, 1.0, Double.NaN);
            if (Double.isNaN(dx) || !(StrictMath.abs(x - dx) < 12.0 / scale)) continue;
            return graphEdge;
        }
        return null;
    }

    void draw(Artist gr, double scale, Object highlight, boolean showLegends) {
        if (this.nodes.size() == 0) {
            return;
        }
        Object group = null;
        GraphNode highFirstNode = null;
        GraphNode highLastNode = null;
        GraphEdge highFirstEdge = null;
        GraphEdge highLastEdge = null;
        if (highlight instanceof GraphEdge) {
            highLastEdge = highFirstEdge = (GraphEdge)highlight;
            group = highFirstEdge.group;
            while (highFirstEdge.a().shape() == null) {
                highFirstEdge = highFirstEdge.a().ins.get(0);
            }
            while (highLastEdge.b().shape() == null) {
                highLastEdge = highLastEdge.b().outs.get(0);
            }
            highFirstNode = highFirstEdge.a();
            highLastNode = highLastEdge.b();
        } else if (!(highlight instanceof GraphNode) && highlight != null) {
            group = highlight;
        }
        int maxAscent = Artist.getMaxAscent();
        for (GraphNode n : this.nodes) {
            if (n.shape() == null) continue;
            for (GraphEdge e : n.outs) {
                if (e.group == group) continue;
                e.draw(gr, scale, highFirstEdge, group);
            }
            for (GraphEdge e : n.selfs) {
                if (e.group == group) continue;
                e.draw(gr, scale, highFirstEdge, group);
            }
        }
        if (group != null) {
            for (GraphNode n : this.nodes) {
                if (n.shape() == null) continue;
                for (GraphEdge e : n.outs) {
                    if (e.group != group || e == highFirstEdge) continue;
                    e.draw(gr, scale, highFirstEdge, group);
                }
                for (GraphEdge e : n.selfs) {
                    if (e.group != group || e == highFirstEdge) continue;
                    e.draw(gr, scale, highFirstEdge, group);
                }
            }
            if (highFirstEdge != null) {
                highFirstEdge.draw(gr, scale, highFirstEdge, group);
            }
        }
        for (GraphNode n : this.nodes) {
            if (highFirstNode == n || highLastNode == n) continue;
            n.draw(gr, scale, n == highlight);
        }
        if (highFirstNode != null) {
            highFirstNode.draw(gr, scale, true);
        }
        if (highLastNode != null && highLastNode != highFirstNode) {
            highLastNode.draw(gr, scale, true);
        }
        if (highFirstEdge != null) {
            highFirstEdge.drawLabel(gr, highFirstEdge.color(), new Color(255, 255, 255, 160));
        }
        if (!showLegends || this.legends.size() == 0) {
            return;
        }
        boolean groupFound = false;
        int y = 0;
        int maxWidth = 0;
        for (Map.Entry<Comparable<?>, Pair<String, Color>> e : this.legends.entrySet()) {
            int w;
            if (e.getValue().b == null) continue;
            if (group != null && e.getKey() == group) {
                groupFound = true;
            }
            if (maxWidth < (w = (int)Artist.getBounds(true, (String)e.getValue().a).getWidth())) {
                maxWidth = w;
            }
            y += this.ad;
        }
        if (y == 0) {
            return;
        }
        gr.setColor(Color.GRAY);
        gr.draw(new RoundRectangle2D.Double(5.0, 5.0, maxWidth + 10, y + 10, 5.0, 5.0), false);
        y = 10;
        for (Map.Entry<Comparable<?>, Pair<String, Color>> e : this.legends.entrySet()) {
            Color color = (Color)e.getValue().b;
            if (color == null) continue;
            gr.setFont(groupFound && e.getKey() == group || !groupFound);
            gr.setColor(!groupFound || e.getKey() == group ? color : Color.GRAY);
            gr.drawString((String)e.getValue().a, 8, y + maxAscent);
            y += this.ad;
        }
    }

    static String esc(String name) {
        if (name.indexOf(34) < 0) {
            return name;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph \"graph\" {\ngraph [fontsize=12]\nnode [fontsize=12]\nedge [fontsize=12]\nrankdir=TB;\n");
        for (GraphEdge e : this.edges) {
            sb.append(e);
        }
        for (GraphNode n : this.nodes) {
            sb.append(n);
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static final class Block {
        private final int first;
        private final int last;
        private final int weight;
        private final double width;
        private final double posn;
        private final double wposn;

        public Block(GraphNode v, int i) {
            this.first = i;
            this.last = i;
            this.width = v.getWidth() + v.getReserved() + 30;
            this.posn = Graph.des(v) - this.width / 2.0;
            this.weight = Graph.wt(v);
            this.wposn = (double)this.weight * this.posn;
        }

        public Block(Block a, Block b) {
            this.first = a.first;
            this.last = b.last;
            this.width = a.width + b.width;
            this.wposn = a.wposn + b.wposn - a.width * (double)b.weight;
            this.weight = a.weight + b.weight;
            this.posn = this.wposn / (double)this.weight;
        }

        public Block() {
            this.posn = Double.NEGATIVE_INFINITY;
            this.first = 0;
            this.last = 0;
            this.weight = 0;
            this.width = 0.0;
            this.wposn = 0.0;
        }
    }
}

