/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4graph.Artist;
import edu.mit.csail.sdg.alloy4graph.AvailableSpace;
import edu.mit.csail.sdg.alloy4graph.Curve;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4graph.Graph;
import edu.mit.csail.sdg.alloy4graph.GraphNode;
import java.awt.Color;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public final class GraphEdge {
    private final double smallFan = StrictMath.toRadians(16.0);
    private final double bigFan = StrictMath.toRadians(32.0);
    private final int ad = Artist.getMaxAscentAndDescent();
    public final Object uuid;
    public final Object group;
    private GraphNode a;
    private GraphNode b;
    private final String label;
    private boolean ahead = false;
    private boolean bhead = true;
    private Color color = Color.BLACK;
    private DotStyle style = DotStyle.SOLID;
    private int weight = 1;
    private final AvailableSpace.Box labelbox;
    private Curve path = null;

    GraphEdge(GraphNode from, GraphNode to, Object uuid, String label, boolean drawArrowHeadOnFrom, boolean drawArrowHeadOnTo, DotStyle style, Color color, Object group) {
        if (group instanceof GraphNode) {
            throw new IllegalArgumentException("group cannot be a GraphNode");
        }
        if (group instanceof GraphEdge) {
            throw new IllegalArgumentException("group cannot be a GraphEdge");
        }
        if (group == null) {
            group = new Object();
        }
        this.a = from;
        this.b = to;
        if (this.a.graph != this.b.graph) {
            throw new IllegalArgumentException("You cannot draw an edge between two different graphs.");
        }
        if (this.a == this.b) {
            this.a.selfs.add(this);
        } else {
            this.a.outs.add(this);
            this.b.ins.add(this);
        }
        this.a.graph.edgelist.add(this);
        this.uuid = uuid;
        this.group = group;
        this.label = label == null ? "" : label;
        this.ahead = drawArrowHeadOnFrom;
        this.bhead = drawArrowHeadOnTo;
        if (style != null) {
            this.style = style;
        }
        if (color != null) {
            this.color = color;
        }
        if (this.label.length() > 0) {
            Rectangle2D box = Artist.getBounds(false, label);
            this.labelbox = new AvailableSpace.Box(0, 0, (int)box.getWidth(), (int)box.getHeight());
        } else {
            this.labelbox = new AvailableSpace.Box(0, 0, 0, 0);
        }
    }

    public GraphEdge(GraphNode from, GraphNode to, Object uuid, String label, Object group) {
        this(from, to, uuid, label, false, true, null, null, group);
    }

    public GraphNode a() {
        return this.a;
    }

    public GraphNode b() {
        return this.b;
    }

    void reverse() {
        if (this.a == this.b) {
            return;
        }
        this.a.outs.remove(this);
        this.b.ins.remove(this);
        this.a.ins.add(this);
        this.b.outs.add(this);
        GraphNode x = this.a;
        this.a = this.b;
        this.b = x;
    }

    void change(GraphNode newTo) {
        if (this.b.graph != newTo.graph) {
            throw new IllegalArgumentException("You cannot draw an edge between two different graphs.");
        }
        if (this.a == this.b) {
            this.a.selfs.remove(this);
        } else {
            this.a.outs.remove(this);
            this.b.ins.remove(this);
        }
        this.b = newTo;
        if (this.a == this.b) {
            this.a.selfs.add(this);
        } else {
            this.a.outs.add(this);
            this.b.ins.add(this);
        }
    }

    public int getLabelX() {
        return this.labelbox.x;
    }

    public int getLabelY() {
        return this.labelbox.y;
    }

    public int getLabelW() {
        return this.labelbox.w;
    }

    public int getLabelH() {
        return this.labelbox.h;
    }

    public int weight() {
        return this.weight;
    }

    public DotStyle style() {
        return this.style;
    }

    public Color color() {
        return this.color;
    }

    public boolean ahead() {
        return this.ahead;
    }

    public boolean bhead() {
        return this.bhead;
    }

    public String label() {
        return this.label;
    }

    public GraphEdge set(int weightBetween1And10000) {
        if (weightBetween1And10000 < 1) {
            weightBetween1And10000 = 1;
        }
        if (weightBetween1And10000 > 10000) {
            weightBetween1And10000 = 10000;
        }
        this.weight = weightBetween1And10000;
        return this;
    }

    public GraphEdge set(boolean from, boolean to) {
        this.ahead = from;
        this.bhead = to;
        return this;
    }

    public GraphEdge set(DotStyle style) {
        if (style != null) {
            this.style = style;
        }
        return this;
    }

    public GraphEdge set(Color color) {
        if (color != null) {
            this.color = color;
        }
        return this;
    }

    Curve path() {
        if (this.path == null) {
            this.resetPath();
        }
        return this.path;
    }

    void resetPath() {
        double ax = this.a.x();
        double ay = this.a.y();
        if (this.a == this.b) {
            double w = 0.0;
            int n = this.a.selfs.size();
            for (int i = 0; i < n; ++i) {
                w = i == 0 ? (double)(this.a.getWidth() / 2 + 40) : w + Artist.getBounds(false, this.a.selfs.get(i - 1).label()).getWidth() + 2.0 + 20.0;
                GraphEdge e = this.a.selfs.get(i);
                if (e != this) continue;
                double h = (double)this.a.getHeight() / 2.0 * 0.7;
                double k = 0.55238;
                double wa = (double)this.a.getWidth() / 2.0;
                double wb = w - wa;
                e.path = new Curve(ax, ay);
                e.path.cubicTo(ax, ay - k * h, ax + wa - k * wa, ay - h, ax + wa, ay - h);
                e.path.cubicTo(ax + wa + k * wb, ay - h, ax + wa + wb, ay - k * h, ax + wa + wb, ay);
                e.path.cubicTo(ax + wa + wb, ay + k * h, ax + wa + k * wb, ay + h, ax + wa, ay + h);
                e.path.cubicTo(ax + wa - k * wa, ay + h, ax, ay + k * h, ax, ay);
                e.labelbox.x = (int)(ax + w + 2.0);
                e.labelbox.y = (int)(ay - Artist.getBounds(false, e.label()).getHeight() / 2.0);
                break;
            }
        } else {
            int i = 0;
            int n = 0;
            for (GraphEdge e : this.a.outs) {
                if (e == this) {
                    i = n++;
                    continue;
                }
                if (e.b != this.b) continue;
                ++n;
            }
            double cx = this.b.x();
            double cy = this.b.y();
            double bx = (ax + cx) / 2.0;
            double by = (ay + cy) / 2.0;
            this.path = new Curve(ax, ay);
            if (n > 1 && (n & 1) == 1) {
                if (i < n / 2) {
                    bx -= (double)((n / 2 - i) * 10);
                } else if (i > n / 2) {
                    bx += (double)((i - n / 2) * 10);
                }
                this.path.lineTo(bx, by).lineTo(cx, cy);
            } else if (n > 1) {
                bx = i < n / 2 ? bx - (double)((n / 2 - i) * 10) + 5.0 : bx + (double)((i - n / 2) * 10) + 5.0;
                this.path.lineTo(bx, by).lineTo(cx, cy);
            } else {
                this.path.lineTo(cx, cy);
            }
        }
    }

    void repositionLabel(AvailableSpace sp) {
        GraphEdge e;
        if (this.label.length() == 0 || this.a == this.b) {
            return;
        }
        int gap = this.style == DotStyle.BOLD ? 4 : 2;
        boolean failed = false;
        Curve p = this.path;
        GraphNode a = this.a;
        while (a.shape() == null) {
            e = a.ins.get(0);
            a = e.a;
            p = e.path().join(p);
        }
        GraphNode b = this.b;
        while (b.shape() == null) {
            e = b.outs.get(0);
            b = e.b;
            p = p.join(e.path());
        }
        double t = 0.5;
        while (true) {
            double y;
            double x2;
            double x1;
            if (t >= 1.0) {
                failed = true;
                t = 0.7;
            }
            int x = (int)((x1 = p.getX(t)) < (x2 = p.getXatY((y = p.getY(t)) + (double)this.labelbox.h, t, 1.0, x1)) ? x2 + (double)gap : x1 + (double)gap);
            if (failed || sp.ok(x, (int)y, this.labelbox.w, this.labelbox.h)) {
                this.labelbox.x = x;
                this.labelbox.y = (int)y;
                sp.add(this.labelbox.x, this.labelbox.y, this.labelbox.w, this.labelbox.h);
                return;
            }
            double t2 = 1.0 - t;
            x1 = p.getX(t2);
            x = (int)(x1 < (x2 = p.getXatY((y = p.getY(t2)) + (double)this.labelbox.h, t2, 1.0, x1)) ? x2 + (double)gap : x1 + (double)gap);
            if (sp.ok(x, (int)y, this.labelbox.w, this.labelbox.h)) {
                this.labelbox.x = x;
                this.labelbox.y = (int)y;
                sp.add(this.labelbox.x, this.labelbox.y, this.labelbox.w, this.labelbox.h);
                return;
            }
            t += 0.05;
        }
    }

    void layout_arrowHead() {
        double t;
        double out;
        double in;
        Curve c = this.path();
        if (this.ahead() && this.a.shape() != null) {
            in = 0.0;
            out = 1.0;
            while (StrictMath.abs(out - in) > 1.0E-4) {
                t = (in + out) / 2.0;
                if (this.a.contains(c.getX(t), c.getY(t))) {
                    in = t;
                    continue;
                }
                out = t;
            }
            c.chopStart(in);
        }
        if (this.bhead() && this.b.shape() != null) {
            in = 1.0;
            double d = out = this.a == this.b ? 0.5 : 0.0;
            while (StrictMath.abs(out - in) > 1.0E-4) {
                t = (in + out) / 2.0;
                if (this.b.contains(c.getX(t), c.getY(t))) {
                    in = t;
                    continue;
                }
                out = t;
            }
            c.chopEnd(in);
        }
    }

    void draw(Artist gr, double scale, GraphEdge highEdge, Object highGroup) {
        int top = this.a.graph.getTop();
        int left = this.a.graph.getLeft();
        gr.translate(-left, -top);
        if (highEdge == this) {
            gr.setColor(this.color);
            gr.set(DotStyle.BOLD, scale);
        } else if (highEdge == null && highGroup == null || highGroup == this.group) {
            gr.setColor(this.color);
            gr.set(this.style, scale);
        } else {
            gr.setColor(Color.LIGHT_GRAY);
            gr.set(this.style, scale);
        }
        if (this.a == this.b) {
            gr.draw(this.path);
        } else {
            Curve p = null;
            GraphEdge e = this;
            while (e.a.shape() == null) {
                e = e.a.ins.get(0);
            }
            while (true) {
                Curve curve = p = p == null ? e.path : p.join(e.path);
                if (e.b.shape() != null) break;
                e = e.b.outs.get(0);
            }
            gr.drawSmoothly(p);
        }
        gr.set(DotStyle.SOLID, scale);
        gr.translate(left, top);
        if (highEdge == null && highGroup == null && this.label.length() > 0) {
            this.drawLabel(gr, this.color, null);
        }
        this.drawArrowhead(gr, scale, highEdge, highGroup);
    }

    void drawLabel(Artist gr, Color color, Color erase) {
        if (this.label.length() > 0) {
            int top = this.a.graph.getTop();
            int left = this.a.graph.getLeft();
            gr.translate(-left, -top);
            if (erase != null && this.a != this.b) {
                Rectangle2D.Double rect = new Rectangle2D.Double(this.labelbox.x, this.labelbox.y, this.labelbox.w, this.labelbox.h);
                gr.setColor(erase);
                gr.draw(rect, true);
            }
            gr.setColor(color);
            gr.drawString(this.label, this.labelbox.x, this.labelbox.y + Artist.getMaxAscent());
            gr.translate(left, top);
            return;
        }
    }

    private void drawArrowhead(Artist gr, double scale, GraphEdge highEdge, Object highGroup) {
        double fan;
        double tipLength = (double)this.ad * 0.6;
        int top = this.a.graph.getTop();
        int left = this.a.graph.getLeft();
        double d = fan = this.style == DotStyle.BOLD ? this.bigFan : this.smallFan;
        if (highEdge == this) {
            fan = this.bigFan;
            gr.setColor(this.color);
            gr.set(DotStyle.BOLD, scale);
        } else if (highEdge == null && highGroup == null || highGroup == this.group) {
            gr.setColor(this.color);
            gr.set(this.style, scale);
        } else {
            gr.setColor(Color.LIGHT_GRAY);
            gr.set(this.style, scale);
        }
        GraphEdge e = this;
        while (true) {
            if (e.ahead && e.a.shape() != null || e.bhead && e.b.shape() != null) {
                GeneralPath gp;
                double gy2;
                double gx2;
                double gy1;
                double gx1;
                double t;
                CubicCurve2D.Double bez;
                Curve cv = e.path();
                if (e.ahead && e.a.shape() != null) {
                    bez = cv.list.get(0);
                    double ax = bez.x1;
                    double ay = bez.y1;
                    double bx = bez.ctrlx1;
                    double by = bez.ctrly1;
                    t = Math.PI + StrictMath.atan2(ay - by, ax - bx);
                    gx1 = ax + tipLength * StrictMath.cos(t - fan);
                    gy1 = ay + tipLength * StrictMath.sin(t - fan);
                    gx2 = ax + tipLength * StrictMath.cos(t + fan);
                    gy2 = ay + tipLength * StrictMath.sin(t + fan);
                    gp = new GeneralPath();
                    gp.moveTo((float)(gx1 - (double)left), (float)(gy1 - (double)top));
                    gp.lineTo((float)(ax - (double)left), (float)(ay - (double)top));
                    gp.lineTo((float)(gx2 - (double)left), (float)(gy2 - (double)top));
                    gp.closePath();
                    gr.draw(gp, true);
                }
                if (e.bhead && e.b.shape() != null) {
                    bez = cv.list.get(cv.list.size() - 1);
                    double bx = bez.x2;
                    double by = bez.y2;
                    double ax = bez.ctrlx2;
                    double ay = bez.ctrly2;
                    t = Math.PI + StrictMath.atan2(by - ay, bx - ax);
                    gx1 = bx + tipLength * StrictMath.cos(t - fan);
                    gy1 = by + tipLength * StrictMath.sin(t - fan);
                    gx2 = bx + tipLength * StrictMath.cos(t + fan);
                    gy2 = by + tipLength * StrictMath.sin(t + fan);
                    gp = new GeneralPath();
                    gp.moveTo((float)(gx1 - (double)left), (float)(gy1 - (double)top));
                    gp.lineTo((float)(bx - (double)left), (float)(by - (double)top));
                    gp.lineTo((float)(gx2 - (double)left), (float)(gy2 - (double)top));
                    gp.closePath();
                    gr.draw(gp, true);
                }
            }
            if (e.b.shape() != null) break;
            e = e.b.outs.get(0);
        }
    }

    public String toString() {
        GraphNode a = this.a;
        GraphNode b = this.b;
        if (a.shape() == null) {
            return "";
        }
        while (b.shape() == null) {
            b = b.outs.get((int)0).b;
        }
        Object color = Integer.toHexString(this.color.getRGB() & 0xFFFFFF);
        while (((String)color).length() < 6) {
            color = "0" + (String)color;
        }
        StringBuilder out = new StringBuilder();
        out.append("\"N" + a.pos() + "\"");
        out.append(" -> ");
        out.append("\"N" + b.pos() + "\"");
        out.append(" [");
        out.append("uuid = \"" + (this.uuid == null ? "" : Graph.esc(this.uuid.toString())) + "\"");
        out.append(", color = \"#" + (String)color + "\"");
        out.append(", fontcolor = \"#" + (String)color + "\"");
        out.append(", style = \"" + this.style.getDotText() + "\"");
        out.append(", label = \"" + Graph.esc(this.label) + "\"");
        out.append(", dir = \"" + (this.ahead && this.bhead ? "both" : (this.bhead ? "forward" : "back")) + "\"");
        out.append(", weight = \"" + this.weight + "\"");
        out.append("]\n");
        return out.toString();
    }
}

