/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4graph.Artist;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4graph.Graph;
import edu.mit.csail.sdg.alloy4graph.GraphEdge;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class GraphNode {
    private static final int dummyWidth = 30;
    private static final int dummyHeight = 10;
    private static final int labelPadding = 5;
    private static final Color COLOR_CHOSENNODE = Color.LIGHT_GRAY;
    private final int ad = Artist.getMaxAscentAndDescent();
    private static final double sqrt3 = 1.7320508075688772;
    private static final double sin36 = 0.5877852522924731;
    private static final double cos36 = 0.8090169943749475;
    private static final double cos18 = 0.9510565162951535;
    private static final double tan18 = 0.32491969623290634;
    public final Object uuid;
    private int centerX = 0;
    private int centerY = 0;
    final Graph graph;
    private int layer = 0;
    int pos;
    final LinkedList<GraphEdge> ins = new LinkedList();
    final LinkedList<GraphEdge> outs = new LinkedList();
    final LinkedList<GraphEdge> selfs = new LinkedList();
    private boolean fontBold = false;
    private List<String> labels = null;
    private Color color = Color.WHITE;
    private DotStyle style = DotStyle.SOLID;
    private DotShape shape = DotShape.BOX;
    private int updown = -1;
    private int side = 0;
    private int yShift = 0;
    private int width = 0;
    private int height = 0;
    private int reserved = 0;
    private Shape poly = null;
    private Shape poly2 = null;
    private Shape poly3 = null;

    public GraphNode(Graph graph, Object uuid, String ... labels) {
        this.uuid = uuid;
        this.graph = graph;
        this.pos = graph.nodelist.size();
        graph.nodelist.add(this);
        if (graph.layerlist.size() == 0) {
            graph.layerlist.add(new ArrayList());
        }
        graph.layerlist.get(0).add(this);
        if (labels != null && labels.length > 0) {
            this.labels = new ArrayList<String>(labels.length);
            for (int i = 0; i < labels.length; ++i) {
                this.labels.add(labels[i]);
            }
        }
    }

    void setLayer(int newLayer) {
        if (newLayer < 0) {
            throw new IllegalArgumentException("The layer cannot be negative!");
        }
        if (this.layer == newLayer) {
            return;
        }
        this.graph.layerlist.get(this.layer).remove(this);
        this.layer = newLayer;
        while (this.layer >= this.graph.layerlist.size()) {
            this.graph.layerlist.add(new ArrayList());
        }
        this.graph.layerlist.get(this.layer).add(this);
    }

    public List<GraphEdge> inEdges() {
        return Collections.unmodifiableList(this.ins);
    }

    public List<GraphEdge> outEdges() {
        return Collections.unmodifiableList(this.outs);
    }

    public List<GraphEdge> selfEdges() {
        return Collections.unmodifiableList(this.selfs);
    }

    int pos() {
        return this.pos;
    }

    int layer() {
        return this.layer;
    }

    public int x() {
        return this.centerX;
    }

    public int y() {
        return this.centerY;
    }

    void setX(int x) {
        this.centerX = x;
    }

    void setY(int y) {
        this.centerY = y;
    }

    DotShape shape() {
        return this.shape;
    }

    public GraphNode set(DotShape shape) {
        if (this.shape != shape) {
            this.shape = shape;
            this.updown = -1;
        }
        return this;
    }

    public GraphNode set(Color color) {
        if (this.color != color && color != null) {
            this.color = color;
            this.updown = -1;
        }
        return this;
    }

    public GraphNode set(DotStyle style) {
        if (this.style != style && style != null) {
            this.style = style;
            this.updown = -1;
        }
        return this;
    }

    public GraphNode setFontBoldness(boolean bold) {
        if (this.fontBold != bold) {
            this.fontBold = bold;
            this.updown = -1;
        }
        return this;
    }

    public GraphNode addLabel(String label) {
        if (label == null || label.length() == 0) {
            return this;
        }
        if (this.labels == null) {
            this.labels = new ArrayList<String>();
        }
        this.labels.add(label);
        this.updown = -1;
        return this;
    }

    int getHeight() {
        if (this.updown < 0) {
            this.calcBounds();
        }
        return this.updown + this.updown;
    }

    int getWidth() {
        if (this.updown < 0) {
            this.calcBounds();
        }
        return this.side + this.side;
    }

    Rectangle2D getBoundingBox(int xfluff, int yfluff) {
        if (this.updown < 0) {
            this.calcBounds();
        }
        return new Rectangle2D.Double(this.x() - this.side - xfluff, this.y() - this.updown - yfluff, this.side + this.side + xfluff + xfluff, this.updown + this.updown + yfluff + yfluff);
    }

    int getReserved() {
        if (this.selfs.isEmpty()) {
            return 0;
        }
        if (this.updown < 0) {
            this.calcBounds();
        }
        return this.reserved;
    }

    boolean contains(double x, double y) {
        if (this.shape == null) {
            return false;
        }
        if (this.updown < 0) {
            this.calcBounds();
        }
        return this.poly.contains(x - (double)this.centerX, y - (double)this.centerY);
    }

    void draw(Artist gr, double scale, boolean highlight) {
        if (this.shape == null) {
            return;
        }
        if (this.updown < 0) {
            this.calcBounds();
        }
        int top = this.graph.getTop();
        int left = this.graph.getLeft();
        gr.set(this.style, scale);
        gr.translate(this.centerX - left, this.centerY - top);
        gr.setFont(this.fontBold);
        if (highlight) {
            gr.setColor(COLOR_CHOSENNODE);
        } else {
            gr.setColor(this.color);
        }
        if (this.shape == DotShape.CIRCLE || this.shape == DotShape.M_CIRCLE || this.shape == DotShape.DOUBLE_CIRCLE) {
            int d;
            int hw = this.width / 2;
            int hh = this.height / 2;
            int radius = (int)StrictMath.sqrt((double)hw * (double)hw + (double)hh * (double)hh) + 2;
            if (this.shape == DotShape.DOUBLE_CIRCLE) {
                radius += 5;
            }
            gr.fillCircle(radius);
            gr.setColor(Color.BLACK);
            gr.drawCircle(radius);
            if (this.style == DotStyle.DOTTED || this.style == DotStyle.DASHED) {
                gr.set(DotStyle.SOLID, scale);
            }
            if (this.shape == DotShape.M_CIRCLE && 10 * radius >= 25 && radius > 5 && (d = (int)StrictMath.sqrt((double)(10 * radius) - 25.0)) > 0) {
                gr.drawLine(-d, -radius + 5, d, -radius + 5);
                gr.drawLine(-d, radius - 5, d, radius - 5);
            }
            if (this.shape == DotShape.DOUBLE_CIRCLE) {
                gr.drawCircle(radius - 5);
            }
        } else {
            gr.draw(this.poly, true);
            gr.setColor(Color.BLACK);
            gr.draw(this.poly, false);
            if (this.poly2 != null) {
                gr.draw(this.poly2, false);
            }
            if (this.poly3 != null) {
                gr.draw(this.poly3, false);
            }
            if (this.style == DotStyle.DOTTED || this.style == DotStyle.DASHED) {
                gr.set(DotStyle.SOLID, scale);
            }
            if (this.shape == DotShape.M_DIAMOND) {
                gr.drawLine(-this.side + 8, -8, -this.side + 8, 8);
                gr.drawLine(-8, -this.side + 8, 8, -this.side + 8);
                gr.drawLine(this.side - 8, -8, this.side - 8, 8);
                gr.drawLine(-8, this.side - 8, 8, this.side - 8);
            }
            if (this.shape == DotShape.M_SQUARE) {
                gr.drawLine(-this.side, -this.side + 8, -this.side + 8, -this.side);
                gr.drawLine(this.side, -this.side + 8, this.side - 8, -this.side);
                gr.drawLine(-this.side, this.side - 8, -this.side + 8, this.side);
                gr.drawLine(this.side, this.side - 8, this.side - 8, this.side);
            }
        }
        gr.set(DotStyle.SOLID, scale);
        int clr = this.color.getRGB() & 0xFFFFFF;
        gr.setColor(clr == 0 || clr == 0xFF0000 || clr == 255 ? Color.WHITE : Color.BLACK);
        if (this.labels != null && this.labels.size() > 0) {
            int x = -this.width / 2;
            int y = this.yShift + -this.labels.size() * this.ad / 2;
            for (int i = 0; i < this.labels.size(); ++i) {
                String t = this.labels.get(i);
                int w = (int)Artist.getBounds(this.fontBold, t).getWidth() + 1;
                w = this.width > w ? (this.width - w) / 2 : 0;
                gr.drawString(t, x + w, y + Artist.getMaxAscent());
                y += this.ad;
            }
        }
        gr.translate(left - this.centerX, top - this.centerY);
    }

    private void setY(int layer, int y) {
        for (GraphNode n : this.graph.layer(layer)) {
            n.centerY = y;
        }
    }

    private void shiftUp(int y) {
        int[] ph = this.graph.layerPH;
        int yJump = 10;
        int i = this.layer();
        this.setY(i, y);
        y -= ph[i] / 2;
        ++i;
        while (i < this.graph.layers()) {
            List<GraphNode> list = this.graph.layer(i);
            GraphNode first = list.get(0);
            if (first.centerY + ph[i] / 2 + 10 > y) {
                this.setY(i, y - ph[i] / 2 - 10);
            }
            y = first.centerY - ph[i] / 2;
            ++i;
        }
        this.graph.relayout_edges(false);
    }

    private void shiftDown(int y) {
        int[] ph = this.graph.layerPH;
        int yJump = 10;
        int i = this.layer();
        this.setY(i, y);
        y += ph[i] / 2;
        --i;
        while (i >= 0) {
            List<GraphNode> list = this.graph.layer(i);
            GraphNode first = list.get(0);
            if (first.centerY - ph[i] / 2 - 10 < y) {
                this.setY(i, y + ph[i] / 2 + 10);
            }
            y = first.centerY + ph[i] / 2;
            --i;
        }
        this.graph.relayout_edges(false);
    }

    private void shiftLeft(List<GraphNode> peers, int i, int x) {
        int xJump = 10;
        this.centerX = x;
        x -= this.shape == null ? 0 : this.side;
        --i;
        while (i >= 0) {
            int side;
            GraphNode node = peers.get(i);
            int n = side = node.shape == null ? 0 : node.side;
            if (node.centerX + side + node.getReserved() + 10 > x) {
                node.centerX = x - side - node.getReserved() - 10;
            }
            x = node.centerX - side;
            --i;
        }
    }

    private void shiftRight(List<GraphNode> peers, int i, int x) {
        int xJump = 10;
        this.centerX = x;
        x = x + (this.shape == null ? 0 : this.side) + this.getReserved();
        ++i;
        while (i < peers.size()) {
            int side;
            GraphNode node = peers.get(i);
            int n = side = node.shape == null ? 0 : node.side;
            if (node.centerX - side - 10 < x) {
                node.centerX = x + side + 10;
            }
            x = node.centerX + side + node.getReserved();
            ++i;
        }
    }

    private void swapLeft(List<GraphNode> peers, int i, int x) {
        int side = this.shape == null ? 2 : this.side;
        int left = x - side;
        while (true) {
            GraphNode other;
            if (i == 0) {
                this.centerX = x;
                return;
            }
            int otherSide = other.shape == null ? 0 : other.side;
            int otherRight = other.centerX + otherSide + (other = peers.get(i - 1)).getReserved();
            if (otherRight < left) {
                this.centerX = x;
                return;
            }
            this.graph.swapNodes(this.layer(), i, i - 1);
            --i;
            if (other.shape == null) continue;
            other.shiftRight(peers, i + 1, x + side + this.getReserved() + otherSide);
        }
    }

    private void swapRight(List<GraphNode> peers, int i, int x) {
        int side = this.shape == null ? 2 : this.side;
        int right = x + side + this.getReserved();
        while (true) {
            if (i == peers.size() - 1) {
                this.centerX = x;
                return;
            }
            GraphNode other = peers.get(i + 1);
            int otherSide = other.shape == null ? 0 : other.side;
            int otherLeft = other.centerX - otherSide;
            if (otherLeft > right) {
                this.centerX = x;
                return;
            }
            this.graph.swapNodes(this.layer(), i, i + 1);
            ++i;
            if (other.shape == null) continue;
            other.shiftLeft(peers, i - 1, x - side - other.getReserved() - otherSide);
        }
    }

    void tweak(int x, int y) {
        int i;
        if (this.centerX == x && this.centerY == y) {
            return;
        }
        List<GraphNode> layer = this.graph.layer(this.layer());
        int n = layer.size();
        for (i = 0; i < n && layer.get(i) != this; ++i) {
        }
        if (this.centerX > x) {
            this.swapLeft(layer, i, x);
        } else if (this.centerX < x) {
            this.swapRight(layer, i, x);
        }
        if (this.centerY > y) {
            this.shiftUp(y);
        } else if (this.centerY < y) {
            this.shiftDown(y);
        } else {
            this.graph.relayout_edges(this.layer());
        }
        this.graph.recalcBound(false);
    }

    void calcBounds() {
        int hw;
        this.yShift = 0;
        this.reserved = 0;
        this.width = 10;
        if (this.width < 30) {
            this.side = 15;
        }
        this.height = this.width;
        if (this.height < 10) {
            this.updown = 5;
        }
        this.poly3 = null;
        this.poly2 = null;
        this.poly = null;
        if (this.shape == null) {
            return;
        }
        Polygon poly = new Polygon();
        if (this.labels != null) {
            for (int i = 0; i < this.labels.size(); ++i) {
                String t = this.labels.get(i);
                Rectangle2D rect = Artist.getBounds(this.fontBold, t);
                int ww = (int)rect.getWidth() + 1;
                if (this.width < ww) {
                    this.width = ww;
                }
                this.height += this.ad;
            }
        }
        if ((hw = (this.width + 1) / 2 + 5) < this.ad / 2) {
            hw = this.ad / 2;
        }
        this.width = hw * 2;
        this.side = hw;
        int hh = (this.height + 1) / 2 + 5;
        if (hh < this.ad / 2) {
            hh = this.ad / 2;
        }
        this.height = hh * 2;
        this.updown = hh;
        switch (this.shape) {
            case HOUSE: {
                this.yShift = this.ad / 2;
                this.updown += this.yShift;
                poly.addPoint(-hw, this.yShift - hh);
                poly.addPoint(0, -this.updown);
                poly.addPoint(hw, this.yShift - hh);
                poly.addPoint(hw, this.yShift + hh);
                poly.addPoint(-hw, this.yShift + hh);
                break;
            }
            case INV_HOUSE: {
                this.yShift = -this.ad / 2;
                this.updown -= this.yShift;
                poly.addPoint(-hw, this.yShift - hh);
                poly.addPoint(hw, this.yShift - hh);
                poly.addPoint(hw, this.yShift + hh);
                poly.addPoint(0, this.updown);
                poly.addPoint(-hw, this.yShift + hh);
                break;
            }
            case TRIANGLE: 
            case INV_TRIANGLE: {
                int dx = (int)((double)this.height / 1.7320508075688772);
                if (++dx < 6) {
                    dx = 6;
                }
                int dy = (int)((double)hw * 1.7320508075688772);
                if (++dy < 6) {
                    dy = 6;
                }
                dy = dy / 2 * 2;
                this.side += dx;
                this.updown += dy / 2;
                if (this.shape == DotShape.TRIANGLE) {
                    this.yShift = dy / 2;
                    poly.addPoint(0, -this.updown);
                    poly.addPoint(hw + dx, this.updown);
                    poly.addPoint(-hw - dx, this.updown);
                    break;
                }
                this.yShift = -dy / 2;
                poly.addPoint(0, this.updown);
                poly.addPoint(hw + dx, -this.updown);
                poly.addPoint(-hw - dx, -this.updown);
                break;
            }
            case HEXAGON: {
                this.side += this.ad;
                poly.addPoint(-hw - this.ad, 0);
                poly.addPoint(-hw, -hh);
                poly.addPoint(hw, -hh);
                poly.addPoint(hw + this.ad, 0);
                poly.addPoint(hw, hh);
                poly.addPoint(-hw, hh);
                break;
            }
            case TRAPEZOID: {
                this.side += this.ad;
                poly.addPoint(-hw, -hh);
                poly.addPoint(hw, -hh);
                poly.addPoint(hw + this.ad, hh);
                poly.addPoint(-hw - this.ad, hh);
                break;
            }
            case INV_TRAPEZOID: {
                this.side += this.ad;
                poly.addPoint(-hw - this.ad, -hh);
                poly.addPoint(hw + this.ad, -hh);
                poly.addPoint(hw, hh);
                poly.addPoint(-hw, hh);
                break;
            }
            case PARALLELOGRAM: {
                this.side += this.ad;
                poly.addPoint(-hw, -hh);
                poly.addPoint(hw + this.ad, -hh);
                poly.addPoint(hw, hh);
                poly.addPoint(-hw - this.ad, hh);
                break;
            }
            case M_DIAMOND: 
            case DIAMOND: {
                if (this.shape == DotShape.M_DIAMOND) {
                    if (hw < 10) {
                        hw = 10;
                        this.side = 10;
                        this.width = 20;
                    }
                    if (hh < 10) {
                        hh = 10;
                        this.updown = 10;
                        this.height = 20;
                    }
                }
                this.updown += hw;
                this.side += hh;
                poly.addPoint(-hw - hh, 0);
                poly.addPoint(0, -hh - hw);
                poly.addPoint(hw + hh, 0);
                poly.addPoint(0, hh + hw);
                break;
            }
            case M_SQUARE: {
                if (hh < hw) {
                    hh = hw;
                } else {
                    hw = hh;
                }
                if (hh < 6) {
                    hh = 6;
                    hw = 6;
                }
                this.width = hw * 2;
                this.side = hw;
                this.height = hh * 2;
                this.updown = hh;
                this.side += 4;
                this.updown += 4;
                poly.addPoint(-hw - 4, -hh - 4);
                poly.addPoint(hw + 4, -hh - 4);
                poly.addPoint(hw + 4, hh + 4);
                poly.addPoint(-hw - 4, hh + 4);
                break;
            }
            case OCTAGON: 
            case DOUBLE_OCTAGON: 
            case TRIPLE_OCTAGON: {
                int dx = this.width / 3;
                int dy = this.ad;
                this.updown += dy;
                poly.addPoint(-hw, -hh);
                poly.addPoint(-hw + dx, -hh - dy);
                poly.addPoint(hw - dx, -hh - dy);
                poly.addPoint(hw, -hh);
                poly.addPoint(hw, hh);
                poly.addPoint(hw - dx, hh + dy);
                poly.addPoint(-hw + dx, hh + dy);
                poly.addPoint(-hw, hh);
                if (this.shape == DotShape.OCTAGON) break;
                double c = StrictMath.sqrt(dx * dx + dy * dy);
                double a = (double)(dx * dy) / c;
                double k = (a + 5.0) * (double)dy / (double)dx;
                double r = StrictMath.sqrt((a + 5.0) * (a + 5.0) + k * k) - (double)dy;
                double dx1 = (r - 5.0) * (double)dx / (double)dy;
                double dy1 = -(((double)dx + 5.0) * (double)dy / (double)dx - (double)dy - r);
                int x1 = (int)StrictMath.round(dx1);
                int y1 = (int)StrictMath.round(dy1);
                this.updown += 5;
                this.side += 5;
                this.poly2 = poly;
                poly = new Polygon();
                poly.addPoint(-hw - 5, -hh - y1);
                poly.addPoint(-hw + dx - x1, -hh - dy - 5);
                poly.addPoint(hw - dx + x1, -hh - dy - 5);
                poly.addPoint(hw + 5, -hh - y1);
                poly.addPoint(hw + 5, hh + y1);
                poly.addPoint(hw - dx + x1, hh + dy + 5);
                poly.addPoint(-hw + dx - x1, hh + dy + 5);
                poly.addPoint(-hw - 5, hh + y1);
                if (this.shape == DotShape.DOUBLE_OCTAGON) break;
                this.updown += 5;
                this.side += 5;
                this.poly3 = poly;
                poly = new Polygon();
                x1 = (int)StrictMath.round(dx1 * 2.0);
                y1 = (int)StrictMath.round(dy1 * 2.0);
                poly.addPoint(-hw - 10, -hh - y1);
                poly.addPoint(-hw + dx - x1, -hh - dy - 10);
                poly.addPoint(hw - dx + x1, -hh - dy - 10);
                poly.addPoint(hw + 10, -hh - y1);
                poly.addPoint(hw + 10, hh + y1);
                poly.addPoint(hw - dx + x1, hh + dy + 10);
                poly.addPoint(-hw + dx - x1, hh + dy + 10);
                poly.addPoint(-hw - 10, hh + y1);
                break;
            }
            case M_CIRCLE: 
            case CIRCLE: 
            case DOUBLE_CIRCLE: {
                int radius = (int)StrictMath.sqrt((double)hw * (double)hw + (double)hh * (double)hh) + 2;
                if (this.shape == DotShape.DOUBLE_CIRCLE) {
                    radius += 5;
                }
                int L = (int)((double)radius / 0.9510565162951535) + 2;
                int a = (int)((double)L * 0.5877852522924731);
                int b = (int)((double)L * 0.8090169943749475);
                int c = (int)((double)radius * 0.32491969623290634);
                poly.addPoint(-L, 0);
                poly.addPoint(-b, a);
                poly.addPoint(-c, L);
                poly.addPoint(c, L);
                poly.addPoint(b, a);
                poly.addPoint(L, 0);
                poly.addPoint(b, -a);
                poly.addPoint(c, -L);
                poly.addPoint(-c, -L);
                poly.addPoint(-b, -a);
                this.updown = L;
                this.side = L;
                break;
            }
            case EGG: 
            case ELLIPSE: {
                int pad = this.ad / 2;
                this.side += pad;
                this.updown += pad;
                int d = this.shape == DotShape.ELLIPSE ? 0 : this.ad / 2;
                GeneralPath path = new GeneralPath();
                path.moveTo(-this.side, d);
                path.quadTo(-this.side, -this.updown, 0.0f, -this.updown);
                path.quadTo(this.side, -this.updown, this.side, d);
                path.quadTo(this.side, this.updown, 0.0f, this.updown);
                path.quadTo(-this.side, this.updown, -this.side, d);
                path.closePath();
                this.poly = path;
            }
            default: {
                if (this.shape != DotShape.BOX) {
                    int d = this.ad / 2;
                    this.side = hw += d;
                    this.updown = hh += d;
                }
                poly.addPoint(-hw, -hh);
                poly.addPoint(hw, -hh);
                poly.addPoint(hw, hh);
                poly.addPoint(-hw, hh);
            }
        }
        if (this.shape != DotShape.EGG && this.shape != DotShape.ELLIPSE) {
            this.poly = poly;
        }
        for (int i = 0; i < this.selfs.size(); ++i) {
            if (i == 0) {
                this.reserved = this.side + 40;
                continue;
            }
            String label = this.selfs.get(i - 1).label();
            this.reserved = this.reserved + (int)Artist.getBounds(false, label).getWidth() + 2 + 20;
        }
        if (this.reserved > 0) {
            String label = this.selfs.get(this.selfs.size() - 1).label();
            this.reserved = this.reserved + (int)Artist.getBounds(false, label).getWidth() + 2 + 20;
        }
    }

    public String toString() {
        if (this.shape == null) {
            return "";
        }
        int rgb = this.color.getRGB() & 0xFFFFFF;
        String text = rgb == 0xFF0000 || rgb == 255 || rgb == 0 ? "FFFFFF" : "000000";
        Object main = Integer.toHexString(rgb);
        while (((String)main).length() < 6) {
            main = "0" + (String)main;
        }
        StringBuilder out = new StringBuilder();
        out.append("\"N" + this.pos + "\"");
        out.append(" [");
        out.append("uuid=\"");
        if (this.uuid != null) {
            out.append(Graph.esc(this.uuid.toString()));
        }
        out.append("\", label=\"");
        boolean first = true;
        if (this.labels != null) {
            for (String label : this.labels) {
                if (label.length() <= 0) continue;
                out.append((first ? "" : "\\n") + Graph.esc(label));
                first = false;
            }
        }
        out.append("\", color=\"#" + (String)main + "\"");
        out.append(", fontcolor = \"#" + text + "\"");
        out.append(", shape = \"" + this.shape.getDotText() + "\"");
        out.append(", style = \"filled, " + this.style.getDotText() + "\"");
        out.append("]\n");
        return out.toString();
    }
}

