/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4graph;

import edu.mit.csail.sdg.alloy4.OurDialog;
import edu.mit.csail.sdg.alloy4.OurPDFWriter;
import edu.mit.csail.sdg.alloy4.OurPNGWriter;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.Artist;
import edu.mit.csail.sdg.alloy4graph.Graph;
import edu.mit.csail.sdg.alloy4graph.GraphEdge;
import edu.mit.csail.sdg.alloy4graph.GraphNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public final class GraphViewer
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final Graph graph;
    private double scale = 1.0;
    private Object highlight = null;
    private Object selected = null;
    private int dragButton = 0;
    public final JPopupMenu pop = new JPopupMenu();
    private int oldMouseX = 0;
    private int oldMouseY = 0;
    private int oldX = 0;
    private int oldY = 0;
    private final Color badColor = new Color(255, 200, 200);
    private static volatile double oldDPI = 72.0;
    private boolean recursive = false;

    private Object alloyFind(int mouseX, int mouseY) {
        return this.graph.find(this.scale, mouseX, mouseY);
    }

    public Object alloyGetAnnotationAtXY(int mouseX, int mouseY) {
        Object obj = this.alloyFind(mouseX, mouseY);
        if (obj instanceof GraphNode) {
            return ((GraphNode)obj).uuid;
        }
        if (obj instanceof GraphEdge) {
            return ((GraphEdge)obj).uuid;
        }
        return null;
    }

    public Object alloyGetSelectedAnnotation() {
        if (this.selected instanceof GraphNode) {
            return ((GraphNode)this.selected).uuid;
        }
        if (this.selected instanceof GraphEdge) {
            return ((GraphEdge)this.selected).uuid;
        }
        return null;
    }

    public Object alloyGetHighlightedAnnotation() {
        if (this.highlight instanceof GraphNode) {
            return ((GraphNode)this.highlight).uuid;
        }
        if (this.highlight instanceof GraphEdge) {
            return ((GraphEdge)this.highlight).uuid;
        }
        return null;
    }

    public void alloyRepaint() {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
        }
        this.setSize((int)((double)this.graph.getTotalWidth() * this.scale), (int)((double)this.graph.getTotalHeight() * this.scale));
        if (c != null) {
            c.invalidate();
            c.repaint();
            c.validate();
        } else {
            this.invalidate();
            this.repaint();
            this.validate();
        }
    }

    public GraphViewer(final JFrame parent, final Graph graph) {
        OurUtil.make((JComponent)this, (Object[])new Object[]{Color.BLACK, Color.WHITE, new EmptyBorder(0, 0, 0, 0)});
        this.setBorder(null);
        this.scale = graph.defaultScale;
        this.graph = graph;
        graph.layout();
        final JMenuItem zoomIn = new JMenuItem("Zoom In");
        final JMenuItem zoomOut = new JMenuItem("Zoom Out");
        final JMenuItem zoomToFit = new JMenuItem("Zoom to Fit");
        final JMenuItem print = new JMenuItem("Export to PNG or PDF");
        this.pop.add(zoomIn);
        this.pop.add(zoomOut);
        this.pop.add(zoomToFit);
        this.pop.add(print);
        ActionListener act = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Container c;
                for (c = GraphViewer.this.getParent(); c != null && !(c instanceof JViewport); c = c.getParent()) {
                }
                if (e.getSource() == print) {
                    GraphViewer.this.alloySaveAs(parent);
                }
                if (e.getSource() == zoomIn) {
                    GraphViewer.this.scale *= 1.33;
                    if (!(GraphViewer.this.scale < 500.0)) {
                        GraphViewer.this.scale = 500.0;
                    }
                }
                if (e.getSource() == zoomOut) {
                    GraphViewer.this.scale /= 1.33;
                    if (!(GraphViewer.this.scale > 0.1)) {
                        GraphViewer.this.scale = 0.1;
                    }
                }
                if (e.getSource() == zoomToFit) {
                    double scale2;
                    if (c == null) {
                        return;
                    }
                    int w = c.getWidth() - 15;
                    int h = c.getHeight() - 15;
                    if (w <= 0 || h <= 0) {
                        return;
                    }
                    double scale1 = (double)w / (double)graph.getTotalWidth();
                    GraphViewer.this.scale = scale1 < (scale2 = (double)h / (double)graph.getTotalHeight()) ? scale1 : scale2;
                }
                GraphViewer.this.alloyRepaint();
            }
        };
        zoomIn.addActionListener(act);
        zoomOut.addActionListener(act);
        zoomToFit.addActionListener(act);
        print.addActionListener(act);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent ev) {
                if (GraphViewer.this.pop.isVisible()) {
                    return;
                }
                Object obj = GraphViewer.this.alloyFind(ev.getX(), ev.getY());
                if (GraphViewer.this.highlight != obj) {
                    GraphViewer.this.highlight = obj;
                    GraphViewer.this.alloyRepaint();
                }
            }

            @Override
            public void mouseDragged(MouseEvent ev) {
                if (GraphViewer.this.selected instanceof GraphNode && GraphViewer.this.dragButton == 1) {
                    int newX = (int)((double)GraphViewer.this.oldX + (double)(ev.getX() - GraphViewer.this.oldMouseX) / GraphViewer.this.scale);
                    int newY = (int)((double)GraphViewer.this.oldY + (double)(ev.getY() - GraphViewer.this.oldMouseY) / GraphViewer.this.scale);
                    GraphNode n = (GraphNode)GraphViewer.this.selected;
                    if (n.x() != newX || n.y() != newY) {
                        n.tweak(newX, newY);
                        GraphViewer.this.alloyRepaint();
                        GraphViewer.this.scrollRectToVisible(new Rectangle((int)((double)(newX - graph.getLeft()) * GraphViewer.this.scale) - n.getWidth() / 2 - 5, (int)((double)(newY - graph.getTop()) * GraphViewer.this.scale) - n.getHeight() / 2 - 5, n.getWidth() + n.getReserved() + 10, n.getHeight() + 10));
                    }
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                Object obj = GraphViewer.this.alloyFind(ev.getX(), ev.getY());
                graph.recalcBound(true);
                GraphViewer.this.selected = null;
                GraphViewer.this.highlight = obj;
                GraphViewer.this.alloyRepaint();
            }

            @Override
            public void mousePressed(MouseEvent ev) {
                GraphViewer.this.dragButton = 0;
                int mod = ev.getModifiers();
                if ((mod & 4) != 0) {
                    GraphViewer.this.selected = GraphViewer.this.alloyFind(ev.getX(), ev.getY());
                    GraphViewer.this.highlight = null;
                    GraphViewer.this.alloyRepaint();
                    GraphViewer.this.pop.show(GraphViewer.this, ev.getX(), ev.getY());
                } else if ((mod & 0x10) != 0 && (mod & 2) != 0) {
                    GraphViewer.this.selected = GraphViewer.this.alloyFind(ev.getX(), ev.getY());
                    GraphViewer.this.highlight = null;
                    GraphViewer.this.alloyRepaint();
                    GraphViewer.this.pop.show(GraphViewer.this, ev.getX(), ev.getY());
                } else if ((mod & 0x10) != 0) {
                    GraphViewer.this.dragButton = 1;
                    GraphViewer.this.oldMouseX = ev.getX();
                    GraphViewer.this.oldMouseY = ev.getY();
                    GraphViewer.this.selected = GraphViewer.this.alloyFind(GraphViewer.this.oldMouseX, GraphViewer.this.oldMouseY);
                    GraphViewer.this.highlight = null;
                    GraphViewer.this.alloyRepaint();
                    if (GraphViewer.this.selected instanceof GraphNode) {
                        GraphViewer.this.oldX = ((GraphNode)GraphViewer.this.selected).x();
                        GraphViewer.this.oldY = ((GraphNode)GraphViewer.this.selected).y();
                    }
                }
            }

            @Override
            public void mouseExited(MouseEvent ev) {
                if (GraphViewer.this.highlight != null) {
                    GraphViewer.this.highlight = null;
                    GraphViewer.this.alloyRepaint();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int alloyRefresh(int who, double ratio, JTextField w1, JLabel w2, JTextField h1, JLabel h2, JTextField d1, JLabel d2, JLabel msg) {
        if (this.recursive) {
            return 0;
        }
        try {
            double d;
            double h;
            double w;
            this.recursive = true;
            w1.setBackground(Color.WHITE);
            h1.setBackground(Color.WHITE);
            d1.setBackground(Color.WHITE);
            boolean bad = false;
            try {
                w = Double.parseDouble(w1.getText());
            }
            catch (NumberFormatException ex) {
                w = 0.0;
            }
            try {
                h = Double.parseDouble(h1.getText());
            }
            catch (NumberFormatException ex) {
                h = 0.0;
            }
            try {
                d = Double.parseDouble(d1.getText());
            }
            catch (NumberFormatException ex) {
                d = 0.0;
            }
            if (who == 1) {
                h = (double)((int)(w * 100.0 / ratio)) / 100.0;
                h1.setText("" + h);
            }
            if (who == 2) {
                w = (double)((int)(h * 100.0 * ratio)) / 100.0;
                w1.setText("" + w);
            }
            if (!(d >= 0.01) || !(d <= 10000.0)) {
                bad = true;
                d1.setBackground(this.badColor);
                msg.setText("DPI must be between 0.01 and 10000");
            }
            if (!(h >= 0.01) || !(h <= 10000.0)) {
                bad = true;
                h1.setBackground(this.badColor);
                msg.setText("Height must be between 0.01 and 10000");
                if (who == 1) {
                    h1.setText("");
                }
            }
            if (!(w >= 0.01) || !(w <= 10000.0)) {
                bad = true;
                w1.setBackground(this.badColor);
                msg.setText("Width must be between 0.01 and 10000");
                if (who == 2) {
                    w1.setText("");
                }
            }
            if (bad) {
                w2.setText(" inches");
                h2.setText(" inches");
                int n = 0;
                return n;
            }
            msg.setText(" ");
            w2.setText(" inches (" + (int)(w * d) + " pixels)");
            h2.setText(" inches (" + (int)(h * d) + " pixels)");
            int n = (int)(w * d);
            return n;
        }
        finally {
            this.recursive = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alloySaveAs(JFrame parent) {
        double iw = 8.5;
        final double ratio = (double)this.graph.getTotalWidth() / (double)this.graph.getTotalHeight();
        double ih = (double)((int)(iw * 100.0 / ratio)) / 100.0;
        if (ih > 11.0) {
            ih = 11.0;
            iw = (double)((int)(ih * 100.0 * ratio)) / 100.0;
        }
        Class<GraphViewer> clazz = GraphViewer.class;
        synchronized (GraphViewer.class) {
            double myScale;
            Object err;
            JRadioButton b3;
            double dpi;
            block19: {
                block20: {
                    dpi = oldDPI;
                    // ** MonitorExit[var10_5] (shouldn't be in output)
                    final JLabel msg = OurUtil.label((String)" ", (Object[])new Object[]{Color.RED});
                    JLabel w = OurUtil.label((String)("Width: " + (int)((double)this.graph.getTotalWidth() * this.scale) + " pixels"), (Object[])new Object[0]);
                    JLabel h = OurUtil.label((String)("Height: " + (int)((double)this.graph.getTotalHeight() * this.scale) + " pixels"), (Object[])new Object[0]);
                    final JTextField w1 = new JTextField("" + iw);
                    JLabel w0 = OurUtil.label((String)"Width: ", (Object[])new Object[0]);
                    final JLabel w2 = OurUtil.label((String)"", (Object[])new Object[0]);
                    final JTextField h1 = new JTextField("" + ih);
                    JLabel h0 = OurUtil.label((String)"Height: ", (Object[])new Object[0]);
                    final JLabel h2 = OurUtil.label((String)"", (Object[])new Object[0]);
                    final JTextField d1 = new JTextField("" + (int)dpi);
                    JLabel d0 = OurUtil.label((String)"Resolution: ", (Object[])new Object[0]);
                    final JLabel d2 = OurUtil.label((String)" dots per inch", (Object[])new Object[0]);
                    final JTextField dp1 = new JTextField("" + (int)dpi);
                    JLabel dp0 = OurUtil.label((String)"Resolution: ", (Object[])new Object[0]);
                    JLabel dp2 = OurUtil.label((String)" dots per inch", (Object[])new Object[0]);
                    this.alloyRefresh(0, ratio, w1, w2, h1, h2, d1, d2, msg);
                    Dimension dim = new Dimension(100, 20);
                    w1.setMaximumSize(dim);
                    w1.setPreferredSize(dim);
                    w1.setEnabled(false);
                    h1.setMaximumSize(dim);
                    h1.setPreferredSize(dim);
                    h1.setEnabled(false);
                    d1.setMaximumSize(dim);
                    d1.setPreferredSize(dim);
                    d1.setEnabled(false);
                    dp1.setMaximumSize(dim);
                    dp1.setPreferredSize(dim);
                    dp1.setEnabled(false);
                    w1.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            GraphViewer.this.alloyRefresh(1, ratio, w1, w2, h1, h2, d1, d2, msg);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }
                    });
                    h1.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            GraphViewer.this.alloyRefresh(2, ratio, w1, w2, h1, h2, d1, d2, msg);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }
                    });
                    d1.getDocument().addDocumentListener(new DocumentListener(){

                        @Override
                        public void changedUpdate(DocumentEvent e) {
                            GraphViewer.this.alloyRefresh(3, ratio, w1, w2, h1, h2, d1, d2, msg);
                        }

                        @Override
                        public void insertUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }

                        @Override
                        public void removeUpdate(DocumentEvent e) {
                            this.changedUpdate(null);
                        }
                    });
                    final JRadioButton b1 = new JRadioButton("As a PNG with the window's current magnification:", true);
                    final JRadioButton b2 = new JRadioButton("As a PNG with a specific width, height, and resolution:", false);
                    b3 = new JRadioButton("As a PDF with the given resolution:", false);
                    b1.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            b2.setSelected(false);
                            b3.setSelected(false);
                            if (!b1.isSelected()) {
                                b1.setSelected(true);
                            }
                            w1.setEnabled(false);
                            h1.setEnabled(false);
                            d1.setEnabled(false);
                            dp1.setEnabled(false);
                            msg.setText(" ");
                            w1.setBackground(Color.WHITE);
                            h1.setBackground(Color.WHITE);
                            d1.setBackground(Color.WHITE);
                        }
                    });
                    b2.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            b1.setSelected(false);
                            b3.setSelected(false);
                            if (!b2.isSelected()) {
                                b2.setSelected(true);
                            }
                            w1.setEnabled(true);
                            h1.setEnabled(true);
                            d1.setEnabled(true);
                            dp1.setEnabled(false);
                            msg.setText(" ");
                            GraphViewer.this.alloyRefresh(1, ratio, w1, w2, h1, h2, d1, d2, msg);
                        }
                    });
                    b3.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            b1.setSelected(false);
                            b2.setSelected(false);
                            if (!b3.isSelected()) {
                                b3.setSelected(true);
                            }
                            w1.setEnabled(false);
                            h1.setEnabled(false);
                            d1.setEnabled(false);
                            dp1.setEnabled(true);
                            msg.setText(" ");
                            w1.setBackground(Color.WHITE);
                            h1.setBackground(Color.WHITE);
                            d1.setBackground(Color.WHITE);
                        }
                    });
                    while (true) {
                        if (!OurDialog.getInput((JFrame)parent, (String)"Export as PNG or PDF", (Object[])new Object[]{b1, OurUtil.makeH((Object[])new Object[]{20, w, null}), OurUtil.makeH((Object[])new Object[]{20, h, null}), " ", b2, OurUtil.makeH((Object[])new Object[]{20, w0, w1, w2, null}), OurUtil.makeH((Object[])new Object[]{20, h0, h1, h2, null}), OurUtil.makeH((Object[])new Object[]{20, d0, d1, d2, null}), OurUtil.makeH((Object[])new Object[]{20, msg, null}), b3, OurUtil.makeH((Object[])new Object[]{20, dp0, dp1, dp2, null})})) {
                            return;
                        }
                        if (b2.isSelected()) {
                            int widthInPixel = this.alloyRefresh(3, ratio, w1, w2, h1, h2, d1, d2, msg);
                            err = msg.getText().trim();
                            if (((String)err).length() > 0) continue;
                            dpi = Double.parseDouble(d1.getText());
                            myScale = (double)widthInPixel / (double)this.graph.getTotalWidth();
                            int heightInPixel = (int)((double)this.graph.getTotalHeight() * myScale);
                            if (!(widthInPixel <= 4000 && heightInPixel <= 4000 || OurDialog.yesno((JFrame)parent, (Object)("The image dimension (" + widthInPixel + "x" + heightInPixel + ") is very large. Are you sure?")))) {
                                continue;
                            }
                            break block19;
                        }
                        if (!b3.isSelected()) break block20;
                        try {
                            dpi = Double.parseDouble(dp1.getText());
                        }
                        catch (NumberFormatException ex) {
                            dpi = -1.0;
                        }
                        if (!(dpi < 50.0) && !(dpi > 3000.0)) break;
                        OurDialog.alert((JFrame)parent, (Object)"The DPI must be between 50 and 3000.");
                    }
                    myScale = 0.0;
                    break block19;
                }
                dpi = 72.0;
                myScale = this.scale;
            }
            File filename = b3.isSelected() ? OurDialog.askFile((Frame)parent, (boolean)false, null, (String)".pdf", (String)"PDF file") : OurDialog.askFile((Frame)parent, (boolean)false, null, (String)".png", (String)"PNG file");
            if (filename == null) {
                return;
            }
            if (filename.exists() && !OurDialog.askOverwrite((JFrame)parent, (String)filename.getAbsolutePath())) {
                return;
            }
            try {
                System.gc();
                if (b3.isSelected()) {
                    this.alloySaveAsPDF(filename.getAbsolutePath(), (int)dpi);
                } else {
                    this.alloySaveAsPNG(filename.getAbsolutePath(), myScale, dpi, dpi);
                }
                err = GraphViewer.class;
                synchronized (GraphViewer.class) {
                    oldDPI = dpi;
                    // ** MonitorExit[err] (shouldn't be in output)
                    Util.setCurrentDirectory((File)filename.getParentFile());
                }
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)parent, (Object)("An error has occurred in writing the output file:\n" + String.valueOf(ex)));
            }
            return;
        }
    }

    public void alloySaveAsPDF(String filename, int dpi) throws IOException {
        try {
            double xwidth = (long)dpi * 8L + (long)dpi / 2L;
            double xheight = (long)dpi * 11L;
            double scale1 = (xwidth - (double)dpi) / (double)this.graph.getTotalWidth();
            double scale2 = (xheight - (double)dpi) / (double)this.graph.getTotalHeight();
            if (scale1 < scale2) {
                scale2 = scale1;
            }
            OurPDFWriter x = new OurPDFWriter(filename, dpi, scale2);
            this.graph.draw(new Artist(x), scale2, null, false);
            x.close();
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException("Failure writing the PDF file to " + filename + " (" + String.valueOf(ex) + ")");
        }
    }

    public void alloySaveAsPNG(String filename, double scale, double dpiX, double dpiY) throws IOException {
        try {
            int height;
            int width = (int)((double)this.graph.getTotalWidth() * scale);
            if (width < 10) {
                width = 10;
            }
            if ((height = (int)((double)this.graph.getTotalHeight() * scale)) < 10) {
                height = 10;
            }
            BufferedImage bf = new BufferedImage(width, height, 1);
            Graphics2D gr = (Graphics2D)bf.getGraphics();
            gr.setColor(Color.WHITE);
            gr.fillRect(0, 0, width, height);
            gr.setColor(Color.BLACK);
            gr.scale(scale, scale);
            gr.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graph.draw(new Artist(gr), scale, null, false);
            OurPNGWriter.writePNG((BufferedImage)bf, (String)filename, (double)dpiX, (double)dpiY);
        }
        catch (Throwable ex) {
            if (ex instanceof IOException) {
                throw (IOException)ex;
            }
            throw new IOException("Failure writing the PNG file to " + filename + " (" + String.valueOf(ex) + ")");
        }
    }

    public void alloyPopup(Component c, int x, int y) {
        this.pop.show(c, x, y);
    }

    @Override
    public String toString() {
        return this.graph.toString();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension((int)((double)this.graph.getTotalWidth() * this.scale), (int)((double)this.graph.getTotalHeight() * this.scale));
    }

    public double getScale() {
        return this.scale;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    @Override
    public void paintComponent(Graphics gr) {
        super.paintComponent(gr);
        Graphics2D g2 = (Graphics2D)gr;
        AffineTransform oldAF = (AffineTransform)g2.getTransform().clone();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.scale(this.scale, this.scale);
        Object sel = this.selected != null ? this.selected : this.highlight;
        GraphNode c = null;
        if (sel instanceof GraphNode && ((GraphNode)sel).shape() == null) {
            c = (GraphNode)sel;
            sel = c.ins.get(0);
        }
        this.graph.draw(new Artist(g2), this.scale, sel, true);
        if (c != null) {
            gr.setColor(((GraphEdge)sel).color());
            gr.fillArc(c.x() - 5 - this.graph.getLeft(), c.y() - 5 - this.graph.getTop(), 10, 10, 0, 360);
        }
        g2.setTransform(oldAF);
    }
}

