/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.VizState;

public final class AlloyAtom
implements Comparable<AlloyAtom> {
    private final String originalName;
    private final AlloyType type;
    private final int index;

    public AlloyAtom(AlloyType type, int index) {
        this.type = type;
        this.index = index;
        this.originalName = type.getName() + "." + index;
    }

    public AlloyAtom(AlloyType type, int index, String originalName) {
        this.type = type;
        this.index = index;
        this.originalName = originalName;
    }

    public String getVizName(VizState theme, boolean numberAtoms) {
        if (theme != null) {
            if (theme.useOriginalName() || this.type.getName().equals("String")) {
                return this.originalName;
            }
            if (this.index == Integer.MAX_VALUE && this.type.getName().equals("Int") && theme.label.get(this.type).length() == 0) {
                return "Int";
            }
            if (this.index == Integer.MIN_VALUE && this.type.getName().equals("seq/Int") && theme.label.get(this.type).length() == 0) {
                return "seq/Int";
            }
            if (this.index == Integer.MAX_VALUE || !numberAtoms) {
                return theme.label.get(this.type);
            }
            return theme.label.get(this.type) + this.index;
        }
        if (this.type.getName().equals("Int")) {
            return "" + this.index;
        }
        if (this.type.getName().equals("seq/Int")) {
            return "" + this.index;
        }
        if (this.index == Integer.MAX_VALUE || !numberAtoms) {
            return this.type.getName();
        }
        return this.type.getName() + this.index;
    }

    public AlloyType getType() {
        return this.type;
    }

    public String toString() {
        return this.getVizName(null, true);
    }

    @Override
    public int compareTo(AlloyAtom otherAtom) {
        AlloyType bt;
        if (otherAtom == null) {
            return 1;
        }
        AlloyType at = this.type;
        if (at.equals(AlloyType.SEQINT)) {
            at = AlloyType.INT;
        }
        if ((bt = otherAtom.type).equals(AlloyType.SEQINT)) {
            bt = AlloyType.INT;
        }
        if (at.equals(AlloyType.INT) && bt.equals(AlloyType.INT)) {
            return this.index < otherAtom.index ? -1 : (this.index > otherAtom.index ? 1 : 0);
        }
        int result = at.compareTo(bt);
        if (result != 0) {
            return result;
        }
        if (this.index != otherAtom.index) {
            return this.index < otherAtom.index ? -1 : 1;
        }
        return this.originalName.compareTo(otherAtom.originalName);
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyAtom)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AlloyAtom otherAtom = (AlloyAtom)other;
        return this.index == otherAtom.index && this.type.equals(otherAtom.type) && this.originalName.equals(otherAtom.originalName);
    }

    public int hashCode() {
        return 7 * this.type.hashCode() + 5 * this.index + 17 * this.originalName.hashCode();
    }
}

