/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyTuple;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.translator.A4Solution;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class AlloyInstance {
    final A4Solution originalA4;
    public final boolean isMetamodel;
    public final String filename;
    public final String commandname;
    public final AlloyModel model;
    private final Map<AlloyAtom, ConstList<AlloySet>> atom2sets;
    private final Map<AlloyType, List<AlloyAtom>> type2atoms;
    private final Map<AlloySet, List<AlloyAtom>> set2atoms;
    private final Map<AlloyRelation, Set<AlloyTuple>> rel2tuples;
    private static final List<AlloyAtom> noAtom = ConstList.make();
    private static final List<AlloySet> noSet = ConstList.make();
    private static final Set<AlloyTuple> noTuple = Collections.unmodifiableSet(new TreeSet());
    public final int tracelen;
    public final int looplen;

    public AlloyInstance(A4Solution originalA4, String filename, String commandname, AlloyModel model, Map<AlloyAtom, Set<AlloySet>> atom2sets, Map<AlloyRelation, Set<AlloyTuple>> rel2tuples, boolean isMetamodel, int tracelen, int looplen) {
        List atoms;
        this.originalA4 = originalA4;
        this.filename = filename;
        this.commandname = commandname;
        this.model = model;
        this.isMetamodel = isMetamodel;
        this.tracelen = tracelen;
        this.looplen = looplen;
        TreeMap<Object, ConstList> a2s = new TreeMap<Object, ConstList>();
        for (Map.Entry<AlloyAtom, Set<AlloySet>> entry : atom2sets.entrySet()) {
            AlloyAtom atom = entry.getKey();
            if (!model.hasType(atom.getType())) continue;
            ArrayList<AlloySet> sets = new ArrayList<AlloySet>();
            for (AlloySet set : entry.getValue()) {
                if (!model.getSets().contains(set) || !model.isEqualOrSubtype(atom.getType(), set.getType())) continue;
                sets.add(set);
            }
            Collections.sort(sets);
            a2s.put(atom, ConstList.make(sets));
        }
        this.atom2sets = Collections.unmodifiableMap(a2s);
        LinkedHashMap<AlloySet, List<AlloyAtom>> s2a = new LinkedHashMap<AlloySet, List<AlloyAtom>>();
        for (Map.Entry<AlloyAtom, Set<AlloySet>> entry : this.atom2sets.entrySet()) {
            for (AlloySet set : (ConstList)entry.getValue()) {
                ArrayList<AlloyAtom> atoms2 = (ArrayList<AlloyAtom>)s2a.get(set);
                if (atoms2 == null) {
                    atoms2 = new ArrayList<AlloyAtom>();
                    s2a.put(set, atoms2);
                }
                atoms2.add(entry.getKey());
            }
        }
        for (AlloySet alloySet : model.getSets()) {
            atoms = (List)s2a.get(alloySet);
            if (atoms == null) continue;
            Collections.sort(atoms);
            s2a.put(alloySet, Collections.unmodifiableList(atoms));
        }
        this.set2atoms = Collections.unmodifiableMap(s2a);
        LinkedHashMap<AlloyType, List<AlloyAtom>> t2a = new LinkedHashMap<AlloyType, List<AlloyAtom>>();
        for (AlloyAtom alloyAtom : this.atom2sets.keySet()) {
            AlloyType t = alloyAtom.getType();
            while (t != null) {
                ArrayList<AlloyAtom> atoms3 = (ArrayList<AlloyAtom>)t2a.get(t);
                if (atoms3 == null) {
                    atoms3 = new ArrayList<AlloyAtom>();
                    t2a.put(t, atoms3);
                }
                atoms3.add(alloyAtom);
                t = model.getSuperType(t);
            }
        }
        for (AlloyType alloyType : model.getTypes()) {
            atoms = (List)t2a.get(alloyType);
            if (atoms == null) continue;
            Collections.sort(atoms);
            t2a.put(alloyType, Collections.unmodifiableList(atoms));
        }
        this.type2atoms = Collections.unmodifiableMap(t2a);
        LinkedHashMap r2t = new LinkedHashMap();
        for (Map.Entry entry : rel2tuples.entrySet()) {
            AlloyRelation rel = (AlloyRelation)entry.getKey();
            if (!model.getRelations().contains(rel)) continue;
            TreeSet<AlloyTuple> tuples = new TreeSet<AlloyTuple>();
            block9: for (AlloyTuple tuple : (Set)entry.getValue()) {
                if (tuple.getArity() != rel.getArity()) continue;
                int i = 0;
                while (true) {
                    if (i == tuple.getArity()) {
                        tuples.add(tuple);
                        continue block9;
                    }
                    AlloyAtom a = tuple.getAtoms().get(i);
                    if (!this.atom2sets.containsKey(a) || !model.isEqualOrSubtype(a.getType(), rel.getTypes().get(i))) continue block9;
                    ++i;
                }
            }
            if (tuples.size() == 0) continue;
            r2t.put(rel, Collections.unmodifiableSet(tuples));
        }
        this.rel2tuples = Collections.unmodifiableMap(r2t);
    }

    public Set<AlloyAtom> getAllAtoms() {
        return Collections.unmodifiableSet(this.atom2sets.keySet());
    }

    public List<AlloySet> atom2sets(AlloyAtom atom) {
        List<AlloySet> answer = (List<AlloySet>)this.atom2sets.get(atom);
        return answer != null ? answer : noSet;
    }

    public List<AlloyAtom> type2atoms(AlloyType type) {
        List<AlloyAtom> answer = this.type2atoms.get(type);
        return answer != null ? answer : noAtom;
    }

    public List<AlloyAtom> set2atoms(AlloySet set) {
        List<AlloyAtom> answer = this.set2atoms.get(set);
        return answer != null ? answer : noAtom;
    }

    public Set<AlloyTuple> relation2tuples(AlloyRelation rel) {
        Set<AlloyTuple> answer = this.rel2tuples.get(rel);
        return answer != null ? answer : noTuple;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyInstance)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AlloyInstance x = (AlloyInstance)other;
        if (!this.filename.equals(x.filename)) {
            return false;
        }
        if (!this.commandname.equals(x.commandname)) {
            return false;
        }
        if (!this.model.equals(x.model)) {
            return false;
        }
        if (!this.atom2sets.equals(x.atom2sets)) {
            return false;
        }
        if (!this.type2atoms.equals(x.type2atoms)) {
            return false;
        }
        if (!this.set2atoms.equals(x.set2atoms)) {
            return false;
        }
        return this.rel2tuples.equals(x.rel2tuples);
    }

    public int hashCode() {
        int n = 5 * this.filename.hashCode() + 7 * this.commandname.hashCode();
        n = n + 7 * this.atom2sets.hashCode() + 31 * this.type2atoms.hashCode() + 71 * this.set2atoms.hashCode() + 3 * this.rel2tuples.hashCode();
        return 17 * n + this.model.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Instance's model:\n");
        sb.append(this.model.toString());
        sb.append("Instance's atom2sets:\n");
        for (Map.Entry<AlloyAtom, ConstList<AlloySet>> entry : this.atom2sets.entrySet()) {
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" ");
            sb.append(entry.getValue());
            sb.append('\n');
        }
        sb.append("Instance's rel2tuples:\n");
        for (Map.Entry<Comparable<AlloyAtom>, Object> entry : this.rel2tuples.entrySet()) {
            sb.append("  ");
            sb.append(entry.getKey());
            sb.append(" ");
            sb.append(entry.getValue());
            sb.append('\n');
        }
        return sb.toString();
    }
}

