/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class AlloyModel {
    private final Set<AlloyType> types;
    private final Set<AlloySet> sets;
    private final Set<AlloyRelation> relations;
    private final Set<AlloyElement> nonempty;
    private final Map<AlloyType, AlloyType> hierarchy;
    private final Map<String, AlloyType> name2types = new HashMap<String, AlloyType>();

    public static boolean isCycle(Map<AlloyType, AlloyType> map, AlloyType x) {
        int i = -5;
        int n = map.size();
        while (x != null) {
            x = map.get(x);
            if (++i < n) continue;
            return true;
        }
        return false;
    }

    public AlloyModel(Collection<AlloyType> types, Collection<AlloySet> sets, Collection<AlloyRelation> rels, Set<AlloyElement> nonempty, Map<AlloyType, AlloyType> map) {
        TreeSet<AlloyType> allTypes = new TreeSet<AlloyType>();
        TreeSet<AlloySet> allSets = new TreeSet<AlloySet>();
        TreeSet<AlloyRelation> allRelations = new TreeSet<AlloyRelation>();
        allTypes.addAll(types);
        allTypes.add(AlloyType.UNIV);
        for (AlloySet s : sets) {
            if (!allTypes.contains(s.getType())) continue;
            allSets.add(s);
        }
        for (AlloyRelation r : rels) {
            if (!allTypes.containsAll(r.getTypes())) continue;
            allRelations.add(r);
        }
        this.types = Collections.unmodifiableSet(allTypes);
        this.sets = Collections.unmodifiableSet(allSets);
        this.relations = Collections.unmodifiableSet(allRelations);
        this.nonempty = Collections.unmodifiableSet(nonempty);
        LinkedHashMap<AlloyType, AlloyType> newmap = new LinkedHashMap<AlloyType, AlloyType>();
        for (AlloyType type : allTypes) {
            AlloyType sup;
            AlloyType alloyType = sup = AlloyModel.isCycle(map, type) ? null : map.get(type);
            if (sup == null || !allTypes.contains(sup)) {
                sup = AlloyType.UNIV;
            }
            newmap.put(type, sup);
        }
        newmap.remove(AlloyType.UNIV);
        this.hierarchy = Collections.unmodifiableMap(newmap);
        for (AlloyType t : this.types) {
            this.name2types.put(t.getName(), t);
        }
    }

    public AlloyModel(Collection<AlloyType> types, Collection<AlloySet> sets, Collection<AlloyRelation> rels, AlloyModel old) {
        this(types, sets, rels, old.nonempty, old.hierarchy);
    }

    public AlloyType getSuperType(AlloyType type) {
        if (type.getName().equals("univ")) {
            return null;
        }
        AlloyType answer = this.hierarchy.get(type);
        return answer == null ? AlloyType.UNIV : answer;
    }

    public AlloyType getTopmostSuperType(AlloyType type) {
        AlloyType top;
        if (type == null || type.equals(AlloyType.UNIV)) {
            return null;
        }
        while ((top = this.getSuperType(type)) != null && !top.equals(AlloyType.UNIV)) {
            type = top;
        }
        return type;
    }

    public ConstList<AlloyType> getSubTypes(AlloyType type) {
        ConstList.TempList subtypes = new ConstList.TempList();
        for (AlloyType subType : this.types) {
            if (!this.isSubtype(subType, type)) continue;
            subtypes.add((Object)subType);
        }
        return subtypes.makeConst();
    }

    public ConstList<AlloyType> getDirectSubTypes(AlloyType type) {
        ConstList.TempList subtypes = new ConstList.TempList();
        for (AlloyType subType : this.types) {
            if (!this.isDirectSubtype(subType, type)) continue;
            subtypes.add((Object)subType);
        }
        return subtypes.makeConst();
    }

    public boolean isSubtype(AlloyType subType, AlloyType superType) {
        if (subType == null || superType == null || !this.types.contains(subType) || subType.equals(AlloyType.UNIV)) {
            return false;
        }
        while (subType != null) {
            if (!superType.equals(subType = this.getSuperType(subType))) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectSubtype(AlloyType subType, AlloyType superType) {
        if (subType == null || superType == null || !this.types.contains(subType) || subType.equals(AlloyType.UNIV)) {
            return false;
        }
        if (superType.equals(AlloyType.UNIV) && this.hierarchy.get(subType) == null) {
            return true;
        }
        return superType.equals(this.hierarchy.get(subType));
    }

    public boolean isEqualOrSubtype(AlloyType subType, AlloyType superType) {
        if (superType == null) {
            return false;
        }
        while (subType != null) {
            if (superType.equals(subType)) {
                return true;
            }
            subType = this.getSuperType(subType);
        }
        return false;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyModel)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AlloyModel x = (AlloyModel)other;
        return this.types.equals(x.types) && this.sets.equals(x.sets) && this.relations.equals(x.relations) && this.hierarchy.equals(x.hierarchy);
    }

    public int hashCode() {
        return this.types.hashCode() + 3 * this.sets.hashCode() + 5 * this.relations.hashCode() + 7 * this.hierarchy.hashCode();
    }

    public boolean hasType(AlloyType type) {
        return this.types.contains(type);
    }

    public AlloyType hasType(String name) {
        return this.name2types.get(name);
    }

    public AlloySet hasSet(String name, AlloyType type) {
        for (AlloySet s : this.sets) {
            if (!s.getName().equals(name) || !s.getType().equals(type)) continue;
            return s;
        }
        return null;
    }

    public AlloyRelation hasRelation(String name, List<AlloyType> types) {
        for (AlloyRelation r : this.relations) {
            if (!r.getName().equals(name) || !r.getTypes().equals(types)) continue;
            return r;
        }
        return null;
    }

    public Set<AlloyType> getTypes() {
        return this.types;
    }

    public Set<AlloySet> getSets() {
        return this.sets;
    }

    public Set<AlloyRelation> getRelations() {
        return this.relations;
    }

    public Set<AlloyElement> getNonEmpty() {
        return this.nonempty;
    }
}

