/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public final class AlloyProjection {
    private final Map<AlloyType, AlloyAtom> map;

    public AlloyProjection(Map<AlloyType, AlloyAtom> map) {
        TreeMap<AlloyType, AlloyAtom> mymap = new TreeMap<AlloyType, AlloyAtom>();
        for (Map.Entry<AlloyType, AlloyAtom> e : map.entrySet()) {
            if (e.getKey() == null || e.getValue() == null) continue;
            mymap.put(e.getKey(), e.getValue());
        }
        this.map = Collections.unmodifiableMap(mymap);
    }

    public AlloyProjection() {
        this.map = Collections.unmodifiableMap(new TreeMap());
    }

    public Collection<AlloyType> getProjectedTypes() {
        return this.map.keySet();
    }

    public AlloyAtom getProjectedAtom(AlloyType type) {
        return this.map.get(type);
    }

    public String toString() {
        boolean first = true;
        Object ans = "Projection[";
        for (Map.Entry<AlloyType, AlloyAtom> e : this.map.entrySet()) {
            if (first) {
                first = false;
            } else {
                ans = (String)ans + ", ";
            }
            ans = (String)ans + e.getKey().getName() + ":" + e.getValue().getVizName(null, true);
        }
        return (String)ans + "]";
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyProjection)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.map.equals(((AlloyProjection)other).map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }
}

