/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import java.util.Collection;
import java.util.List;

public final class AlloyRelation
extends AlloyElement {
    public static final AlloyRelation EXTENDS = new AlloyRelation("extends", false, false, false, false, (List<AlloyType>)Util.asList((Object[])new AlloyType[]{AlloyType.UNIV, AlloyType.UNIV}));
    public static final AlloyRelation MEMBER = new AlloyRelation("member", false, false, false, false, (List<AlloyType>)Util.asList((Object[])new AlloyType[]{AlloyType.UNIV, AlloyType.UNIV}));
    public static final AlloyRelation IN = new AlloyRelation("in", false, false, false, false, (List<AlloyType>)Util.asList((Object[])new AlloyType[]{AlloyType.SET, AlloyType.UNIV}));
    public static final AlloyRelation EQ = new AlloyRelation("=", false, false, false, false, (List<AlloyType>)Util.asList((Object[])new AlloyType[]{AlloyType.SET, AlloyType.UNIV}));
    private final ConstList<AlloyType> types;
    public final boolean isPrivate;
    public final boolean isMeta;
    public final boolean isVar;
    public final boolean isSkolem;

    public AlloyRelation(String name, boolean isPrivate, boolean isMeta, boolean isVar, boolean isSkolem, List<AlloyType> types) {
        super(name);
        if (types == null || types.size() < 2) {
            throw new RuntimeException("An AlloyRelation object must have 2 or more types.");
        }
        this.types = ConstList.make(types);
        this.isPrivate = isPrivate;
        this.isMeta = isMeta;
        this.isVar = isVar;
        this.isSkolem = isSkolem;
    }

    public List<AlloyType> project(Collection<Integer> columns) {
        ConstList.TempList list = new ConstList.TempList(this.types.size());
        for (int i = 0; i < this.types.size(); ++i) {
            if (columns.contains(i)) continue;
            list.add((Object)((AlloyType)this.types.get(i)));
        }
        if (list.size() == this.types.size()) {
            return this.types;
        }
        return list.makeConst();
    }

    public List<AlloyType> getTypes() {
        return this.types;
    }

    public int getArity() {
        return this.types.size();
    }

    @Override
    public int compareTo(AlloyRelation other) {
        if (other == null) {
            return 1;
        }
        int n = Util.slashComparator.compare(this.getName(), other.getName());
        if (n != 0) {
            return n;
        }
        int arity = this.types.size();
        if (arity != other.types.size()) {
            return arity < other.types.size() ? -1 : 1;
        }
        for (int i = 0; i < arity; ++i) {
            n = ((AlloyType)this.types.get(i)).compareTo((AlloyType)other.types.get(i));
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    @Override
    public int compareTo(AlloyElement other) {
        if (!(other instanceof AlloyRelation)) {
            return 1;
        }
        return this.compareTo((AlloyRelation)other);
    }

    public String toString() {
        Object answer = "";
        boolean first = true;
        for (AlloyType type : this.getTypes()) {
            if (first) {
                first = false;
                answer = (String)answer + this.getName() + " :  ";
            } else {
                answer = (String)answer + " -> ";
            }
            answer = (String)answer + type.getName();
        }
        return answer;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyRelation)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AlloyRelation otherRelation = (AlloyRelation)other;
        return this.getName().equals(otherRelation.getName()) && this.types.equals(otherRelation.types);
    }

    public int hashCode() {
        return 5 * this.getName().hashCode() + 7 * this.types.hashCode();
    }
}

