/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyNodeElement;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloyType;

public final class AlloySet
extends AlloyNodeElement {
    private final AlloyType type;
    public final boolean isPrivate;
    public final boolean isMeta;
    public final boolean isVar;
    public final boolean isSkolem;
    public static final AlloySet ABSTRACT = new AlloySet("abstract", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet ONE = new AlloySet("one", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet LONE = new AlloySet("lone", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet SOME = new AlloySet("some", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet VAR = new AlloySet("var", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet ENUM = new AlloySet("enum", false, false, false, false, AlloyType.UNIV);
    public static final AlloySet ENUMMEM = new AlloySet("enum-member", false, false, false, false, AlloyType.UNIV);

    public AlloySet(String name, boolean isPrivate, boolean isMeta, boolean isVar, boolean isSkolem, AlloyType type) {
        super(name);
        this.type = type;
        this.isPrivate = isPrivate;
        this.isMeta = isMeta;
        this.isVar = isVar;
        this.isSkolem = isSkolem;
    }

    public AlloyType getType() {
        return this.type;
    }

    @Override
    public int compareTo(AlloySet other) {
        if (other == null) {
            return 1;
        }
        int n = Util.slashComparator.compare(this.getName(), other.getName());
        return n != 0 ? n : this.type.compareTo(other.type);
    }

    @Override
    public int compareTo(AlloyNodeElement other) {
        if (!(other instanceof AlloySet)) {
            return 1;
        }
        AlloySet x = (AlloySet)other;
        int n = Util.slashComparator.compare(this.getName(), x.getName());
        return n != 0 ? n : this.type.compareTo(x.type);
    }

    @Override
    public int compareTo(AlloyElement other) {
        if (other instanceof AlloyRelation) {
            return -1;
        }
        if (!(other instanceof AlloySet)) {
            return 1;
        }
        AlloySet x = (AlloySet)other;
        int n = Util.slashComparator.compare(this.getName(), x.getName());
        return n != 0 ? n : this.type.compareTo(x.type);
    }

    public String toString() {
        return this.getName() + " :  " + this.getType().getName();
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloySet)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        AlloySet otherSet = (AlloySet)other;
        return this.getName().equals(otherSet.getName()) && this.type.equals(otherSet.type);
    }

    public int hashCode() {
        return 5 * this.type.hashCode() + 7 * this.getName().hashCode();
    }
}

