/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class AlloyTuple
implements Comparable<AlloyTuple> {
    private final ConstList<AlloyAtom> atoms;

    public AlloyTuple(List<AlloyAtom> atoms) {
        if (atoms == null || atoms.size() < 2) {
            throw new RuntimeException("An AlloyTuple object must have 2 or more atoms.");
        }
        this.atoms = ConstList.make(atoms);
    }

    public AlloyTuple(AlloyAtom ... atoms) {
        if (atoms == null || atoms.length < 2) {
            throw new RuntimeException("An AlloyTuple object must have 2 or more atoms.");
        }
        this.atoms = Util.asList((Object[])atoms);
    }

    public ConstList<AlloyAtom> project(Collection<Integer> columns) {
        ConstList.TempList list = new ConstList.TempList(this.atoms.size());
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (columns.contains(i)) continue;
            list.add((Object)((AlloyAtom)this.atoms.get(i)));
        }
        if (list.size() == this.atoms.size()) {
            return this.atoms;
        }
        return list.makeConst();
    }

    public int getArity() {
        return this.atoms.size();
    }

    public List<AlloyAtom> getAtoms() {
        return this.atoms;
    }

    public AlloyAtom getStart() {
        return (AlloyAtom)this.atoms.get(0);
    }

    public AlloyAtom getEnd() {
        return (AlloyAtom)this.atoms.get(this.atoms.size() - 1);
    }

    public AlloyTuple reverse() {
        ArrayList<AlloyAtom> newlist = new ArrayList<AlloyAtom>(this.atoms.size());
        for (int i = this.atoms.size() - 1; i >= 0; --i) {
            newlist.add((AlloyAtom)this.atoms.get(i));
        }
        return new AlloyTuple(newlist);
    }

    public String toString() {
        Object s = "<";
        for (int i = 0; i < this.atoms.size(); ++i) {
            if (i != 0) {
                s = (String)s + ", ";
            }
            s = (String)s + String.valueOf(this.atoms.get(i));
        }
        return (String)s + ">";
    }

    @Override
    public int compareTo(AlloyTuple that) {
        if (that == null) {
            return 1;
        }
        if (this.atoms.size() < that.atoms.size()) {
            return -1;
        }
        if (this.atoms.size() > that.atoms.size()) {
            return 1;
        }
        for (int i = 0; i < this.atoms.size(); ++i) {
            int result = ((AlloyAtom)this.atoms.get(i)).compareTo((AlloyAtom)that.atoms.get(i));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof AlloyTuple)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        return this.atoms.equals(((AlloyTuple)other).atoms);
    }

    public int hashCode() {
        return this.atoms.hashCode();
    }
}

