/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.MagicUtil;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

final class MagicColor {
    private final VizState vizState;
    private static final List<ConstList<DotShape>> families;

    private MagicColor(VizState vizState) {
        this.vizState = vizState;
    }

    public static void magic(VizState vizState) {
        vizState.setNodePalette(DotPalette.MARTHA);
        MagicColor st = new MagicColor(vizState);
        st.nodeNames();
        st.nodeShape();
        st.nodeColour();
        st.skolemColour();
    }

    private void nodeColour() {
        Set<AlloyType> visibleUserTypes = MagicUtil.visibleUserTypes(this.vizState);
        Set<AlloyType> uniqueColourTypes = visibleUserTypes.size() <= 5 ? visibleUserTypes : MagicUtil.partiallyVisibleUserTopLevelTypes(this.vizState);
        int index = 0;
        for (AlloyType t : uniqueColourTypes) {
            this.vizState.nodeColor.put(t, DotColor.values()[index]);
            index = (index + 1) % DotColor.values().length;
        }
    }

    private void skolemColour() {
        Set<AlloySet> sets = this.vizState.getCurrentModel().getSets();
        for (AlloySet s : sets) {
            this.vizState.nodeStyle.put(s, DotStyle.BOLD);
            String label = this.vizState.label.get(s);
            int lastUnderscore = label.lastIndexOf(95);
            if (lastUnderscore >= 0) {
                label = label.substring(lastUnderscore + 1);
            }
            this.vizState.label.put(s, label);
        }
    }

    private void nodeShape() {
        LinkedHashSet<List> usedShapeFamilies = new LinkedHashSet<List>();
        Set<AlloyType> topLevelTypes = MagicUtil.partiallyVisibleUserTopLevelTypes(this.vizState);
        for (AlloyType t : topLevelTypes) {
            Set<AlloyType> subTypes = MagicUtil.visibleSubTypes(this.vizState, t);
            boolean isTvisible = MagicUtil.isActuallyVisible(this.vizState, t);
            int size = subTypes.size() + (isTvisible ? 1 : 0);
            boolean foundExactMatch = false;
            for (List list : families) {
                if (size != list.size() || usedShapeFamilies.contains(list)) continue;
                usedShapeFamilies.add(list);
                this.assignNodeShape(t, subTypes, isTvisible, list);
                foundExactMatch = true;
                break;
            }
            if (foundExactMatch) continue;
            List approxShapeFamily = null;
            int n = Integer.MAX_VALUE;
            for (List list : families) {
                int n2;
                int distance;
                if (size > list.size() || usedShapeFamilies.contains(list) || (distance = list.size() - size) >= n2) continue;
                approxShapeFamily = list;
                n2 = distance;
            }
            if (approxShapeFamily == null) continue;
            usedShapeFamilies.add(approxShapeFamily);
            this.assignNodeShape(t, subTypes, isTvisible, approxShapeFamily);
        }
    }

    private void assignNodeShape(AlloyType t, Set<AlloyType> subTypes, boolean isTvisible, List<DotShape> shapeFamily) {
        int index = 0;
        if (isTvisible) {
            DotShape shape = shapeFamily.get(index++);
            this.vizState.shape.put(t, shape);
        }
        for (AlloyType subt : subTypes) {
            DotShape shape = shapeFamily.get(index++);
            this.vizState.shape.put(subt, shape);
        }
    }

    private void nodeNames() {
        Set<AlloyType> visibleUserTypes = MagicUtil.visibleUserTypes(this.vizState);
        for (AlloyType t : visibleUserTypes) {
            MagicUtil.trimLabelBeforeLastSlash(this.vizState, t);
        }
        if (1 == visibleUserTypes.size()) {
            this.vizState.label.put(visibleUserTypes.iterator().next(), "");
        }
    }

    static {
        ConstList.TempList list = new ConstList.TempList();
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.BOX, DotShape.TRAPEZOID, DotShape.HOUSE}));
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.ELLIPSE, DotShape.EGG}));
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.HEXAGON, DotShape.OCTAGON, DotShape.DOUBLE_OCTAGON, DotShape.TRIPLE_OCTAGON}));
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.INV_TRIANGLE, DotShape.INV_HOUSE, DotShape.INV_TRAPEZOID}));
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.M_DIAMOND, DotShape.M_SQUARE, DotShape.M_CIRCLE}));
        list.add((Object)Util.asList((Object[])new DotShape[]{DotShape.PARALLELOGRAM, DotShape.DIAMOND}));
        families = list.makeConst();
    }
}

