/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.MagicUtil;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MagicLayout {
    private final VizState vizState;
    private Set<AlloyType> enumerationTypes = new LinkedHashSet<AlloyType>();
    private Set<AlloyType> singletonTypes = new LinkedHashSet<AlloyType>();
    private AlloyType projectionType = null;
    private Set<AlloyRelation> spineRelations = Collections.emptySet();
    private static final ConstList<String> LIKELY_PROJECTION_TYPE_NAMES = Util.asList((Object[])new String[]{"State", "TrainState", "Time", "Tick", "TimeStep"});

    private MagicLayout(VizState vizState) {
        this.vizState = vizState;
    }

    public static void magic(VizState vizState) {
        vizState.resetTheme();
        MagicLayout st = new MagicLayout(vizState);
        st.identifyEnumerationTypes();
        st.projection();
        st.nodeVisibility();
        st.spine();
        st.attributes();
        st.edgeLabels();
    }

    private void identifyEnumerationTypes() {
        AlloyModel model = this.vizState.getCurrentModel();
        Set<AlloyType> types = model.getTypes();
        for (AlloyType t : types) {
            if (this.enumerationTypes.contains(t)) continue;
            if (t.isOne) {
                this.singletonTypes.add(t);
            }
            if (t.isBuiltin || !t.isAbstract) continue;
            ConstList<AlloyType> subTypes = model.getSubTypes(t);
            int numberOfSingletonSubtypes = 0;
            for (AlloyType st : subTypes) {
                if (!st.isOne) continue;
                ++numberOfSingletonSubtypes;
                this.singletonTypes.add(st);
            }
            if (subTypes.size() != numberOfSingletonSubtypes) continue;
            this.enumerationTypes.add(t);
            this.enumerationTypes.addAll((Collection<AlloyType>)subTypes);
            for (AlloyType st : subTypes) {
                this.vizState.nodeVisible.put(st, null);
            }
            boolean visible = false;
            for (AlloyRelation r : model.getRelations()) {
                AlloyType sourceType = r.getTypes().get(0);
                if (!t.equals(sourceType) && !subTypes.contains(sourceType)) continue;
                visible = true;
                break;
            }
            this.vizState.nodeVisible.put(t, visible);
        }
    }

    private void projection() {
        if (this.projectionType == null && this.vizState.getProjectedTypes().isEmpty()) {
            AlloyModel model = this.vizState.getCurrentModel();
            LinkedHashMap<AlloyType, Integer> scores = new LinkedHashMap<AlloyType, Integer>();
            for (AlloyType t : model.getTypes()) {
                scores.put(t, 0);
                if (this.hasLikelyProjectionTypeName(t.getName())) {
                    scores.put(t, (Integer)scores.get(t) + 1);
                }
                for (AlloyRelation r : model.getRelations()) {
                    if (r.getArity() <= 2 || !r.getTypes().contains(t)) continue;
                    scores.put(t, (Integer)scores.get(t) + 1);
                }
            }
            int max = 0;
            LinkedHashSet<AlloyType> winners = new LinkedHashSet<AlloyType>();
            for (Map.Entry e : scores.entrySet()) {
                if ((Integer)e.getValue() == max) {
                    winners.add((AlloyType)e.getKey());
                }
                if ((Integer)e.getValue() <= max) continue;
                max = (Integer)e.getValue();
                winners.clear();
                winners.add((AlloyType)e.getKey());
            }
            if (max >= 2) {
                AlloyType winner;
                if (winners.size() > 1) {
                    // empty if block
                }
                this.projectionType = winner = (AlloyType)winners.iterator().next();
                this.vizState.project(this.projectionType);
            }
        }
    }

    private final boolean hasLikelyProjectionTypeName(String n) {
        for (String s : LIKELY_PROJECTION_TYPE_NAMES) {
            if (!n.startsWith(s) && !n.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void spine() {
        AlloyModel model = this.vizState.getCurrentModel();
        Set<AlloyRelation> relations = model.getRelations();
        if (!relations.isEmpty()) {
            LinkedHashSet<AlloyRelation> spines = new LinkedHashSet<AlloyRelation>();
            for (AlloyRelation r : relations) {
                if (r.getArity() != 2) continue;
                List<AlloyType> rtypes = r.getTypes();
                AlloyType targetType = rtypes.get(1);
                if (!this.enumerationTypes.contains(targetType)) {
                    spines.add(r);
                }
                if (!r.getName().equals("parent")) continue;
                this.vizState.layoutBack.put(r, true);
            }
            this.spineRelations = spines.isEmpty() ? relations : spines;
        }
        for (AlloyRelation r : relations) {
            this.vizState.constraint.put(r, false);
            this.vizState.edgeColor.put(r, DotColor.GRAY);
        }
        for (AlloyRelation s : this.spineRelations) {
            this.vizState.constraint.put(s, null);
            this.vizState.edgeColor.put(s, null);
        }
    }

    private void attributes() {
        AlloyModel model = this.vizState.getCurrentModel();
        for (AlloyRelation r : model.getRelations()) {
            AlloyType targetType;
            List<AlloyType> rTypes = r.getTypes();
            if (r.getArity() != 2 || rTypes.contains(this.projectionType) || this.spineRelations.contains(r) || !this.enumerationTypes.contains(targetType = rTypes.get(1))) continue;
            this.vizState.attribute.put(r, true);
            this.vizState.edgeVisible.put(r, false);
        }
    }

    private void edgeLabels() {
        AlloyModel model = this.vizState.getCurrentModel();
        int relationsAsEdges = 0;
        AlloyRelation visibleRelation = null;
        for (AlloyRelation r : model.getRelations()) {
            Boolean v = this.vizState.edgeVisible.get(r);
            if (v != null && !v.booleanValue()) continue;
            ++relationsAsEdges;
            visibleRelation = r;
            MagicUtil.trimLabelBeforeLastSlash(this.vizState, r);
        }
        if (1 == relationsAsEdges && visibleRelation.getArity() == 2) {
            this.vizState.label.put(visibleRelation, "");
        }
    }

    private void nodeVisibility() {
        AlloyModel model = this.vizState.getCurrentModel();
        Set<AlloyType> types = model.getTypes();
        for (AlloyType t : types) {
            if (t.isBuiltin || !MagicUtil.isActuallyVisible(this.vizState, t) || !t.getName().endsWith("/Ord")) continue;
            this.vizState.nodeVisible.put(t, false);
        }
        for (AlloySet s : model.getSets()) {
            if (!MagicUtil.isActuallyVisible(this.vizState, s) || !s.getName().endsWith("/Ord")) continue;
            this.vizState.nodeVisible.put(s, false);
        }
    }
}

