/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

final class MagicUtil {
    private MagicUtil() {
    }

    static void trimLabelBeforeLastSlash(VizState vizState, AlloyElement x) {
        vizState.label.put(x, MagicUtil.trimBeforeLastSlash(vizState.label.get(x)));
    }

    static String trimBeforeLastSlash(String label) {
        int lastSlash = label.lastIndexOf(47);
        if (lastSlash >= 0) {
            return label.substring(lastSlash + 1);
        }
        return label;
    }

    static boolean isActuallyVisible(VizState vizState, AlloyType t) {
        Boolean pV;
        if (t.isAbstract) {
            return false;
        }
        Boolean V = vizState.nodeVisible.get(t);
        if (V != null) {
            return V;
        }
        AlloyModel model = vizState.getCurrentModel();
        AlloyType parent = model.getSuperType(t);
        while (parent != null && (pV = vizState.nodeVisible.get(parent)) == null) {
            parent = model.getSuperType(parent);
        }
        if (parent == null) {
            return true;
        }
        return vizState.nodeVisible.get(parent);
    }

    static boolean isActuallyVisible(VizState vizState, AlloySet s) {
        Boolean V = vizState.nodeVisible.get(s);
        if (V != null) {
            return V;
        }
        return MagicUtil.isActuallyVisible(vizState, s.getType());
    }

    static Set<AlloyType> visibleUserTypes(VizState vizState) {
        LinkedHashSet<AlloyType> result = new LinkedHashSet<AlloyType>();
        AlloyModel model = vizState.getCurrentModel();
        for (AlloyType t : model.getTypes()) {
            if (t.isBuiltin || !MagicUtil.isActuallyVisible(vizState, t)) continue;
            result.add(t);
        }
        return Collections.unmodifiableSet(result);
    }

    static Set<AlloyType> topLevelTypes(VizState vizState) {
        LinkedHashSet<AlloyType> result = new LinkedHashSet<AlloyType>();
        AlloyModel model = vizState.getOriginalModel();
        for (AlloyType t : model.getTypes()) {
            if (!vizState.isTopLevel(t)) continue;
            result.add(t);
        }
        return Collections.unmodifiableSet(result);
    }

    static Set<AlloyType> partiallyVisibleUserTopLevelTypes(VizState vizState) {
        AlloyModel model = vizState.getOriginalModel();
        Set<AlloyType> visibleUserTypes = MagicUtil.visibleUserTypes(vizState);
        LinkedHashSet<AlloyType> result = new LinkedHashSet<AlloyType>();
        for (AlloyType t : visibleUserTypes) {
            if (!visibleUserTypes.contains(t)) continue;
            result.add(model.getTopmostSuperType(t));
        }
        return Collections.unmodifiableSet(result);
    }

    static Set<AlloyType> visibleSubTypes(VizState vizState, AlloyType type) {
        AlloyModel model = vizState.getCurrentModel();
        ConstList<AlloyType> subTypes = model.getSubTypes(type);
        Set<AlloyType> visibleUserTypes = MagicUtil.visibleUserTypes(vizState);
        LinkedHashSet<AlloyType> result = new LinkedHashSet<AlloyType>();
        for (AlloyType st : subTypes) {
            if (!visibleUserTypes.contains(st)) continue;
            result.add(st);
        }
        return Collections.unmodifiableSet(result);
    }
}

