/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ErrorFatal;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4graph.DotDirection;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4graph.Graph;
import edu.mit.csail.sdg.alloy4graph.GraphEdge;
import edu.mit.csail.sdg.alloy4graph.GraphNode;
import edu.mit.csail.sdg.alloy4graph.GraphViewer;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyInstance;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyProjection;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyTuple;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.StaticProjector;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class StaticGraphMaker {
    private final VizState view;
    private final AlloyInstance instance;
    private final AlloyModel model;
    private final Map<GraphEdge, AlloyTuple> edges = new LinkedHashMap<GraphEdge, AlloyTuple>();
    private final Map<GraphNode, AlloyAtom> nodes = new LinkedHashMap<GraphNode, AlloyAtom>();
    private final Map<AlloyAtom, GraphNode> atom2node = new LinkedHashMap<AlloyAtom, GraphNode>();
    private final Map<GraphNode, Set<String>> attribs = new LinkedHashMap<GraphNode, Set<String>>();
    private final Graph graph;
    private static final List<Color> colorsClassic = Util.asList((Object[])new Color[]{new Color(228, 26, 28), new Color(166, 86, 40), new Color(255, 127, 0), new Color(77, 175, 74), new Color(55, 126, 184), new Color(152, 78, 163)});
    private static final List<Color> colorsStandard = Util.asList((Object[])new Color[]{new Color(227, 26, 28), new Color(255, 127, 0), new Color(200, 123, 122), new Color(51, 160, 44), new Color(31, 120, 180)});
    private static final List<Color> colorsMartha = Util.asList((Object[])new Color[]{new Color(231, 138, 195), new Color(252, 141, 98), new Color(166, 216, 84), new Color(102, 194, 165), new Color(141, 160, 203)});
    private static final List<Color> colorsNeon = Util.asList((Object[])new Color[]{new Color(231, 41, 138), new Color(217, 95, 2), new Color(166, 118, 29), new Color(102, 166, 30), new Color(27, 158, 119), new Color(117, 112, 179)});
    private static final List<Color> colorsColorBlind = Util.asList((Object[])new Color[]{new Color(119, 170, 221), new Color(153, 221, 255), new Color(187, 204, 51), new Color(170, 170, 0), new Color(238, 136, 102), new Color(255, 170, 187), new Color(221, 221, 221)});

    public static JPanel produceGraph(JFrame parent, AlloyInstance instance, VizState view, AlloyProjection proj) throws ErrorFatal {
        view = new VizState(view);
        if (proj == null) {
            proj = new AlloyProjection();
        }
        Graph graph = new Graph((double)view.getFontSize() / 12.0);
        new StaticGraphMaker(graph, instance, view, proj);
        if (graph.nodes.size() == 0) {
            new GraphNode(graph, "", "Due to your theme settings, every atom is hidden.", "Please click Theme and adjust your settings.");
        }
        return new GraphViewer(parent, graph);
    }

    private List<Color> getColors(DotPalette palette) {
        List<Color> colors = palette == DotPalette.CLASSIC ? colorsClassic : (palette == DotPalette.STANDARD ? colorsStandard : (palette == DotPalette.MARTHA ? colorsMartha : (palette == DotPalette.TOL_LIGHT ? colorsColorBlind : colorsNeon)));
        return colors;
    }

    private StaticGraphMaker(Graph graph, AlloyInstance originalInstance, VizState view, AlloyProjection proj) throws ErrorFatal {
        Color cc;
        Object c;
        boolean hidePrivate = view.hidePrivate();
        boolean hideMeta = view.hideMeta();
        boolean hideSkolem = view.hideSkolem();
        TreeMap<AlloyElement, Color> magicColor = new TreeMap<AlloyElement, Color>();
        TreeMap<AlloyRelation, Integer> rels = new TreeMap<AlloyRelation, Integer>();
        this.graph = graph;
        this.view = view;
        this.instance = StaticProjector.project(originalInstance, proj);
        this.model = this.instance.model;
        for (AlloyRelation rel : this.model.getRelations()) {
            rels.put(rel, null);
        }
        List<Color> colors = this.getColors(view.getEdgePalette());
        int ci = 0;
        for (AlloyRelation alloyRelation : this.model.getRelations()) {
            c = view.edgeColor.resolve(alloyRelation);
            cc = c == DotColor.MAGIC ? colors.get(ci) : c.getColor(view.getEdgePalette());
            int count = hidePrivate && alloyRelation.isPrivate || hideSkolem && alloyRelation.isSkolem || view.edgeVisible.resolve(alloyRelation) == false ? 0 : this.edgesAsArcs(hidePrivate, hideMeta, hideSkolem, alloyRelation, colors.get(ci));
            rels.put(alloyRelation, count);
            magicColor.put(alloyRelation, cc);
            if (hidePrivate && alloyRelation.isPrivate || hideSkolem && alloyRelation.isSkolem || !view.edgeVisible.resolve(alloyRelation).booleanValue() || !this.model.getNonEmpty().contains(alloyRelation)) continue;
            ci = (ci + 1) % colors.size();
        }
        ci = 0;
        colors = this.getColors(view.getNodePalette());
        for (AlloyType alloyType : this.model.getTypes()) {
            c = view.nodeColor.resolve(alloyType);
            cc = c == DotColor.MAGIC ? colors.get(ci) : c.getColor(view.getEdgePalette());
            magicColor.put(alloyType, cc);
            if (hidePrivate && alloyType.isPrivate || !view.nodeVisible.resolve(alloyType).booleanValue() || !this.model.getNonEmpty().contains(alloyType)) continue;
            ci = (ci + 1) % colors.size();
        }
        for (AlloyAtom alloyAtom : this.instance.getAllAtoms()) {
            List<AlloySet> sets = this.instance.atom2sets(alloyAtom);
            boolean any = false;
            for (AlloySet s : sets) {
                if (hideSkolem && s.isSkolem) continue;
                any = true;
                if (!view.nodeVisible.resolve(s).booleanValue() || view.hideUnconnected.resolve(s).booleanValue()) continue;
                this.createNode(hidePrivate, hideMeta, hideSkolem, alloyAtom, (Color)magicColor.get(alloyAtom.getType()));
                break;
            }
            if (any || !view.nodeVisible.resolve(alloyAtom.getType()).booleanValue() || view.hideUnconnected.resolve(alloyAtom.getType()).booleanValue()) continue;
            this.createNode(hidePrivate, hideMeta, hideSkolem, alloyAtom, (Color)magicColor.get(alloyAtom.getType()));
        }
        for (AlloyRelation alloyRelation : this.model.getRelations()) {
            if (hidePrivate && alloyRelation.isPrivate || hideSkolem && alloyRelation.isSkolem || !view.attribute.resolve(alloyRelation).booleanValue()) continue;
            this.edgesAsAttribute(alloyRelation);
        }
        for (Map.Entry entry : this.attribs.entrySet()) {
            Set set = (Set)entry.getValue();
            if (set == null) continue;
            for (String s : set) {
                if (s.length() <= 0) continue;
                ((GraphNode)entry.getKey()).addLabel(s);
            }
        }
        for (Map.Entry entry : rels.entrySet()) {
            int n;
            c = (Color)magicColor.get(entry.getKey());
            if (c == null) {
                c = Color.BLACK;
            }
            if ((n = ((Integer)entry.getValue()).intValue()) > 0) {
                graph.addLegend((Comparable)entry.getKey(), ((AlloyRelation)entry.getKey()).getName() + ": " + n, (Color)c);
                continue;
            }
            graph.addLegend((Comparable)entry.getKey(), ((AlloyRelation)entry.getKey()).getName(), null);
        }
    }

    private GraphNode createNode(boolean hidePrivate, boolean hideMeta, boolean hideSkolem, AlloyAtom atom, Color magicColor) {
        GraphNode node = this.atom2node.get(atom);
        if (node != null) {
            DotColor color = this.view.nodeColor(atom, this.instance);
            if (color == DotColor.MAGIC && magicColor != null) {
                node.set(magicColor);
            }
            return node;
        }
        if (hidePrivate && atom.getType().isPrivate || hideMeta && atom.getType().isMeta || !this.view.nodeVisible(atom, this.instance)) {
            return null;
        }
        for (AlloySet set : this.instance.atom2sets(atom)) {
            if (!hidePrivate || !set.isPrivate) continue;
            return null;
        }
        DotColor color = this.view.nodeColor(atom, this.instance);
        DotStyle style = this.view.nodeStyle(atom, this.instance);
        DotShape shape = this.view.shape(atom, this.instance);
        String label = this.atomname(atom, false);
        node = new GraphNode(this.graph, atom, label).set(shape).set(style);
        if (color == DotColor.MAGIC && magicColor != null) {
            node.set(magicColor);
        } else {
            node.set(color.getColor(this.view.getNodePalette()));
        }
        Object setsLabel = "";
        boolean showLabelByDefault = this.view.showAsLabel.get(null);
        for (AlloySet set : this.instance.atom2sets(atom)) {
            Boolean showLabel;
            String x = this.view.label.get(set);
            if (x.length() == 0 || hideSkolem && set.isSkolem || ((showLabel = this.view.showAsLabel.get(set)) != null || !showLabelByDefault) && (showLabel == null || !showLabel.booleanValue())) continue;
            setsLabel = (String)setsLabel + (((String)setsLabel).length() > 0 ? ", " : "") + x;
        }
        if (((String)setsLabel).length() > 0) {
            Set<String> list = this.attribs.get(node);
            if (list == null) {
                list = new TreeSet<String>();
                this.attribs.put(node, list);
            }
            list.add("(" + (String)setsLabel + ")");
        }
        this.nodes.put(node, atom);
        this.atom2node.put(atom, node);
        return node;
    }

    private boolean createEdge(boolean hidePrivate, boolean hideMeta, boolean hideSkolem, AlloyRelation rel, AlloyTuple tuple, boolean bidirectional, Color magicColor) {
        if (hidePrivate && tuple.getStart().getType().isPrivate || hideMeta && tuple.getStart().getType().isMeta || !this.view.nodeVisible(tuple.getStart(), this.instance)) {
            return false;
        }
        if (hidePrivate && tuple.getEnd().getType().isPrivate || hideMeta && tuple.getEnd().getType().isMeta || !this.view.nodeVisible(tuple.getEnd(), this.instance)) {
            return false;
        }
        GraphNode start = this.createNode(hidePrivate, hideMeta, hideSkolem, tuple.getStart(), null);
        GraphNode end = this.createNode(hidePrivate, hideMeta, hideSkolem, tuple.getEnd(), null);
        if (start == null || end == null) {
            return false;
        }
        boolean layoutBack = this.view.layoutBack.resolve(rel);
        Object label = this.view.label.get(rel);
        if (tuple.getArity() > 2) {
            StringBuilder moreLabel = new StringBuilder();
            List<AlloyAtom> atoms = tuple.getAtoms();
            for (int i = 1; i < atoms.size() - 1; ++i) {
                if (i > 1) {
                    moreLabel.append(", ");
                }
                moreLabel.append(this.atomname(atoms.get(i), false));
            }
            if (((String)label).length() != 0) {
                label = (String)label + " [" + String.valueOf(moreLabel) + "]";
            }
        }
        DotDirection dir = bidirectional ? DotDirection.BOTH : (layoutBack ? DotDirection.BACK : DotDirection.FORWARD);
        DotStyle style = this.view.edgeStyle.resolve(rel);
        DotColor color = this.view.edgeColor.resolve(rel);
        int weight = this.view.weight.get(rel);
        GraphEdge e = new GraphEdge(layoutBack ? end : start, layoutBack ? start : end, tuple, (String)label, rel);
        if (color == DotColor.MAGIC && magicColor != null) {
            e.set(magicColor);
        } else {
            e.set(color.getColor(this.view.getEdgePalette()));
        }
        e.set(style);
        e.set(dir != DotDirection.FORWARD, dir != DotDirection.BACK);
        e.set(weight < 1 ? 1 : (weight > 100 ? 10000 : 100 * weight));
        this.edges.put(e, tuple);
        return true;
    }

    private int edgesAsArcs(boolean hidePrivate, boolean hideMeta, boolean hideSkolem, AlloyRelation rel, Color magicColor) {
        int count = 0;
        if (!this.view.mergeArrows.resolve(rel).booleanValue()) {
            for (AlloyTuple tuple : this.instance.relation2tuples(rel)) {
                if (!this.createEdge(hidePrivate, hideMeta, hideSkolem, rel, tuple, false, magicColor)) continue;
                ++count;
            }
            return count;
        }
        Set<AlloyTuple> tuples = this.instance.relation2tuples(rel);
        LinkedHashSet<AlloyTuple> ignore = new LinkedHashSet<AlloyTuple>();
        for (AlloyTuple tuple : tuples) {
            AlloyTuple reverse;
            if (ignore.contains(tuple)) continue;
            AlloyTuple alloyTuple = reverse = tuple.getArity() > 2 ? null : tuple.reverse();
            if (reverse != null && tuples.contains(reverse) && !reverse.equals(tuple)) {
                ignore.add(reverse);
                if (!this.createEdge(hidePrivate, hideMeta, hideSkolem, rel, tuple, true, magicColor)) continue;
                count += 2;
                continue;
            }
            if (!this.createEdge(hidePrivate, hideMeta, hideSkolem, rel, tuple, false, magicColor)) continue;
            ++count;
        }
        return count;
    }

    private void edgesAsAttribute(AlloyRelation rel) {
        LinkedHashMap<GraphNode, Object> map = new LinkedHashMap<GraphNode, Object>();
        for (AlloyTuple alloyTuple : this.instance.relation2tuples(rel)) {
            GraphNode start = this.atom2node.get(alloyTuple.getStart());
            if (start == null) continue;
            Object attr = "";
            List<AlloyAtom> atoms = alloyTuple.getAtoms();
            for (int i = 1; i < atoms.size(); ++i) {
                if (i > 1) {
                    attr = (String)attr + "->";
                }
                attr = (String)attr + this.atomname(atoms.get(i), true);
            }
            if (((String)attr).length() == 0) continue;
            String oldattr = (String)map.get(start);
            if (oldattr != null && oldattr.length() > 0) {
                attr = oldattr + ", " + (String)attr;
            }
            if (((String)attr).length() <= 0) continue;
            map.put(start, attr);
        }
        for (Map.Entry entry : map.entrySet()) {
            GraphNode node = (GraphNode)entry.getKey();
            Set<String> list = this.attribs.get(node);
            if (list == null) {
                list = new TreeSet<String>();
                this.attribs.put(node, list);
            }
            Object attr = (String)entry.getValue();
            if (this.view.label.get(rel).length() > 0) {
                attr = this.view.label.get(rel) + ": " + (String)attr;
            }
            list.add((String)attr);
        }
    }

    private String atomname(AlloyAtom atom, boolean showSets) {
        String label = atom.getVizName(this.view, this.view.number.resolve(atom.getType()));
        if (!showSets) {
            return label;
        }
        Object attr = "";
        boolean showInAttrByDefault = this.view.showAsAttr.get(null);
        for (AlloySet set : this.instance.atom2sets(atom)) {
            Boolean showAsAttr;
            String x = this.view.label.get(set);
            if (x.length() == 0 || ((showAsAttr = this.view.showAsAttr.get(set)) != null || !showInAttrByDefault) && (showAsAttr == null || !showAsAttr.booleanValue())) continue;
            attr = (String)attr + (((String)attr).length() > 0 ? ", " : "") + x;
        }
        if (label.length() == 0) {
            return ((String)attr).length() > 0 ? "(" + (String)attr + ")" : "";
        }
        return ((String)attr).length() > 0 ? label + " (" + (String)attr + ")" : label;
    }

    static String esc(String name) {
        if (name.indexOf(34) < 0) {
            return name;
        }
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '\"') {
                out.append('\\');
            }
            out.append(c);
        }
        return out.toString();
    }
}

