/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorFatal;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.SafeList;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4.XMLNode;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyInstance;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyTuple;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.ast.Expr;
import edu.mit.csail.sdg.ast.ExprVar;
import edu.mit.csail.sdg.ast.Sig;
import edu.mit.csail.sdg.translator.A4Solution;
import edu.mit.csail.sdg.translator.A4SolutionReader;
import edu.mit.csail.sdg.translator.A4Tuple;
import edu.mit.csail.sdg.translator.A4TupleSet;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StaticInstanceReader {
    private final AlloyInstance ans;
    private final List<Sig.PrimSig> toplevels = new ArrayList<Sig.PrimSig>();
    private final LinkedHashMap<Sig, AlloyType> sig2type = new LinkedHashMap();
    private final LinkedHashMap<Sig, AlloyAtom> sig2atom = new LinkedHashMap();
    private final LinkedHashSet<AlloyTuple> exts = new LinkedHashSet();
    private final LinkedHashSet<AlloyTuple> mems = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> absts = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> ones = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> lones = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> somes = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> vars = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> enums = new LinkedHashSet();
    private final LinkedHashSet<AlloyAtom> enummems = new LinkedHashSet();
    private final LinkedHashSet<AlloyTuple> ins = new LinkedHashSet();
    private final LinkedHashSet<AlloyTuple> eqs = new LinkedHashSet();
    private final Set<AlloySet> sets = new LinkedHashSet<AlloySet>();
    private final Map<AlloyRelation, Set<AlloyTuple>> rels = new LinkedHashMap<AlloyRelation, Set<AlloyTuple>>();
    private final Set<AlloyElement> nonempty_elems = new LinkedHashSet<AlloyElement>();
    private final Map<AlloyType, AlloyType> ts = new LinkedHashMap<AlloyType, AlloyType>();
    private final Map<AlloyAtom, Set<AlloySet>> atom2sets = new LinkedHashMap<AlloyAtom, Set<AlloySet>>();
    private final Map<String, AlloyAtom> string2atom = new LinkedHashMap<String, AlloyAtom>();

    private AlloyType makeType(String label, boolean isOne, boolean isAbstract, boolean isBuiltin, boolean isPrivate, boolean isMeta, boolean isEnum, boolean isVar) {
        label = Util.tailThis((String)label);
        while (true) {
            AlloyType ans = new AlloyType((String)label, isOne, isAbstract, isBuiltin, isPrivate, isMeta, isEnum, isVar);
            if (!this.sig2type.values().contains(ans)) {
                return ans;
            }
            label = (String)label + "'";
        }
    }

    private AlloySet makeSet(String label, boolean isPrivate, boolean isMeta, boolean isVar, boolean isSkolem, AlloyType type) {
        label = Util.tail((String)label);
        while (((String)label).equals(Sig.UNIV.label) || ((String)label).equals(Sig.SIGINT.label) || ((String)label).equals(Sig.SEQIDX.label) || ((String)label).equals(Sig.STRING.label)) {
            label = (String)label + "'";
        }
        AlloySet ans;
        while (this.sets.contains(ans = new AlloySet((String)label, isPrivate, isMeta, isVar, isSkolem, type))) {
            label = (String)label + "'";
        }
        return ans;
    }

    private AlloyRelation makeRel(String label, boolean isPrivate, boolean isMeta, boolean isVar, boolean isSkolem, List<AlloyType> types) {
        label = Util.tail((String)label);
        while (((String)label).equals(Sig.UNIV.label) || ((String)label).equals(Sig.SIGINT.label) || ((String)label).equals(Sig.SEQIDX.label) || ((String)label).equals(Sig.STRING.label)) {
            label = (String)label + "'";
        }
        AlloyRelation ans;
        while (this.rels.containsKey(ans = new AlloyRelation((String)label, isPrivate, isMeta, isVar, isSkolem, types))) {
            label = (String)label + "'";
        }
        return ans;
    }

    private AlloyType sig(Sig.PrimSig s) throws Err {
        if (s == Sig.NONE) {
            throw new ErrorFatal("Unexpected sig \"none\" encountered.");
        }
        AlloyType ans = this.sig2type.get(s);
        if (ans == null) {
            ans = this.makeType(s.label, s.isOne != null, s.isAbstract != null, false, s.isPrivate != null, s.isMeta != null, s.isEnum != null, s.isVariable != null);
            this.sig2type.put((Sig)s, ans);
            if (s.parent != Sig.UNIV) {
                this.ts.put(ans, this.sig(s.parent));
            }
        }
        return ans;
    }

    private AlloyType sigMETA(Sig.PrimSig s) throws Err {
        if (s == Sig.NONE) {
            throw new ErrorFatal("Unexpected sig \"none\" encountered.");
        }
        AlloyType type = this.sig2type.get(s);
        if (type != null) {
            return type;
        }
        type = s == Sig.UNIV ? AlloyType.UNIV : (s == Sig.SIGINT ? AlloyType.INT : (s == Sig.SEQIDX ? AlloyType.SEQINT : (s == Sig.STRING ? AlloyType.STRING : this.makeType(s.label, s.isOne != null, s.isAbstract != null, false, s.isPrivate != null, s.isMeta != null, s.isEnum != null, s.isVariable != null))));
        this.sig2type.put((Sig)s, type);
        AlloyAtom atom = new AlloyAtom(type, type == AlloyType.SEQINT ? Integer.MIN_VALUE : Integer.MAX_VALUE, s.label);
        this.atom2sets.put(atom, new LinkedHashSet());
        this.sig2atom.put((Sig)s, atom);
        if (s.parent != Sig.UNIV && s.parent != null) {
            this.ts.put(type, this.sigMETA(s.parent));
        }
        if (s.parent != null) {
            if (!s.isEnumMember()) {
                this.exts.add(new AlloyTuple(atom, this.sig2atom.get(s.parent)));
            } else {
                this.mems.add(new AlloyTuple(atom, this.sig2atom.get(s.parent)));
            }
        }
        if (s.isEnum != null) {
            this.enums.add(atom);
            this.atom2sets.get(atom).add(AlloySet.ENUM);
        } else if (s.isAbstract != null) {
            this.absts.add(atom);
            this.atom2sets.get(atom).add(AlloySet.ABSTRACT);
        }
        if (s.isEnumMember()) {
            this.enummems.add(atom);
            this.atom2sets.get(atom).add(AlloySet.ENUMMEM);
        } else if (s.isOne != null) {
            this.ones.add(atom);
            this.atom2sets.get(atom).add(AlloySet.ONE);
        }
        if (s.isLone != null) {
            this.lones.add(atom);
            this.atom2sets.get(atom).add(AlloySet.LONE);
        }
        if (s.isSome != null) {
            this.somes.add(atom);
            this.atom2sets.get(atom).add(AlloySet.SOME);
        }
        if (s.isVariable != null) {
            this.vars.add(atom);
            this.atom2sets.get(atom).add(AlloySet.VAR);
        }
        SafeList children = s == Sig.UNIV ? this.toplevels : s.children();
        for (Sig.PrimSig sub : children) {
            this.sigMETA(sub);
        }
        return type;
    }

    private void sigMETA(Sig.SubsetSig s) throws Err {
        AlloyType type = this.sig2type.get(s);
        if (type != null) {
            return;
        }
        type = this.makeType(s.label, s.isOne != null, s.isAbstract != null, false, s.isPrivate != null, s.isMeta != null, s.isEnum != null, s.isVariable != null);
        AlloyAtom atom = new AlloyAtom(type, Integer.MAX_VALUE, s.label);
        this.atom2sets.put(atom, new LinkedHashSet());
        this.sig2atom.put((Sig)s, atom);
        this.sig2type.put((Sig)s, type);
        this.ts.put(type, AlloyType.SET);
        for (Sig p : s.parents) {
            if (p instanceof Sig.SubsetSig) {
                this.sigMETA((Sig.SubsetSig)p);
            } else {
                this.sigMETA((Sig.PrimSig)p);
            }
            if (!s.exact) {
                this.ins.add(new AlloyTuple(atom, this.sig2atom.get(p)));
                continue;
            }
            this.eqs.add(new AlloyTuple(atom, this.sig2atom.get(p)));
        }
        if (s.isOne != null) {
            this.ones.add(atom);
            this.atom2sets.get(atom).add(AlloySet.ONE);
        }
        if (s.isLone != null) {
            this.lones.add(atom);
            this.atom2sets.get(atom).add(AlloySet.LONE);
        }
        if (s.isSome != null) {
            this.somes.add(atom);
            this.atom2sets.get(atom).add(AlloySet.SOME);
        }
        if (s.isVariable != null) {
            this.vars.add(atom);
            this.atom2sets.get(atom).add(AlloySet.VAR);
        }
    }

    private void atoms(A4Solution sol, Sig.PrimSig s, int state) throws Err {
        Sig.PrimSig sum = Sig.NONE;
        for (Object c : s.children()) {
            sum = sum.plus((Expr)c);
            this.atoms(sol, (Sig.PrimSig)c, state);
        }
        A4TupleSet ts = (A4TupleSet)sol.eval(s.minus((Expr)sum), state);
        for (A4Tuple z : ts) {
            int i;
            String atom = z.atom(0);
            int dollar = atom.lastIndexOf(36);
            try {
                i = Integer.parseInt(dollar >= 0 ? atom.substring(dollar + 1) : atom);
            }
            catch (NumberFormatException ex) {
                i = Integer.MAX_VALUE;
            }
            AlloyAtom at = new AlloyAtom(this.sig(s), ts.size() == 1 && s.isVariable == null ? Integer.MAX_VALUE : i, atom);
            this.atom2sets.put(at, new LinkedHashSet());
            this.string2atom.put(atom, at);
        }
        for (int i = 0; i < sol.getTraceLength(); ++i) {
            if (((A4TupleSet)sol.eval(s.minus((Expr)sum), i)).size() <= 0) continue;
            this.nonempty_elems.add(this.sig(s));
            break;
        }
    }

    private void setOrRel(A4Solution sol, String label, Expr expr, boolean isPrivate, boolean isMeta, boolean isVar, boolean isSkolem, int state) throws Err {
        block0: for (List ps : expr.type().fold()) {
            if (ps.size() == 1) {
                Sig.PrimSig t = (Sig.PrimSig)ps.get(0);
                AlloySet set = this.makeSet(label, isPrivate, isMeta, isVar, isSkolem, this.sig(t));
                this.sets.add(set);
                for (A4Tuple tp : (A4TupleSet)sol.eval(expr.intersect((Expr)t), state)) {
                    this.atom2sets.get(this.string2atom.get(tp.atom(0))).add(set);
                }
                for (int i = 0; i < sol.getTraceLength(); ++i) {
                    if (((A4TupleSet)sol.eval(expr.intersect((Expr)t), i)).size() <= 0) continue;
                    this.nonempty_elems.add(set);
                    continue block0;
                }
                continue;
            }
            Expr mask = null;
            ArrayList<AlloyType> types = new ArrayList<AlloyType>(ps.size());
            for (int i = 0; i < ps.size(); ++i) {
                types.add(this.sig((Sig.PrimSig)ps.get(i)));
                mask = mask == null ? (Expr)ps.get(i) : mask.product((Expr)ps.get(i));
            }
            AlloyRelation rel = this.makeRel(label, isPrivate, isMeta, isVar, isSkolem, types);
            LinkedHashSet<AlloyTuple> ts = new LinkedHashSet<AlloyTuple>();
            for (A4Tuple tp : (A4TupleSet)sol.eval(expr.intersect(mask), state)) {
                AlloyAtom[] atoms = new AlloyAtom[tp.arity()];
                for (int i = 0; i < tp.arity(); ++i) {
                    atoms[i] = this.string2atom.get(tp.atom(i));
                    if (atoms[i] != null) continue;
                    throw new ErrorFatal("Unexpected XML inconsistency: cannot resolve atom " + tp.atom(i));
                }
                ts.add(new AlloyTuple(atoms));
            }
            this.rels.put(rel, ts);
            for (int i = 0; i < sol.getTraceLength(); ++i) {
                if (((A4TupleSet)sol.eval(expr.intersect(mask), i)).size() <= 0) continue;
                this.nonempty_elems.add(rel);
                continue block0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private StaticInstanceReader(XMLNode root, int state) throws Err {
        XMLNode inst = null;
        for (XMLNode sub : root) {
            if (!sub.is("instance")) continue;
            inst = sub;
            break;
        }
        if (inst == null) {
            throw new ErrorSyntax("The XML file must contain an <instance> element.");
        }
        boolean isMeta = "yes".equals(inst.getAttribute("metamodel"));
        A4Solution sol = A4SolutionReader.read(new ArrayList(), (XMLNode)root);
        for (Sig sig : sol.getAllReachableSigs()) {
            if (!(sig instanceof Sig.PrimSig) || ((Sig.PrimSig)sig).parent != Sig.UNIV) continue;
            this.toplevels.add((Sig.PrimSig)sig);
        }
        if (!isMeta) {
            this.sig2type.put((Sig)Sig.UNIV, AlloyType.UNIV);
            this.sig2type.put((Sig)Sig.SIGINT, AlloyType.INT);
            this.sig2type.put((Sig)Sig.SEQIDX, AlloyType.SEQINT);
            this.sig2type.put((Sig)Sig.STRING, AlloyType.STRING);
            this.ts.put(AlloyType.SEQINT, AlloyType.INT);
            int n = sol.max();
            int maxseq = sol.getMaxSeq();
            for (int i = sol.min(); i <= n; ++i) {
                AlloyAtom at = new AlloyAtom(i >= 0 && i < maxseq ? AlloyType.SEQINT : AlloyType.INT, i, "" + i);
                this.atom2sets.put(at, new LinkedHashSet());
                this.string2atom.put("" + i, at);
            }
            for (Sig sig : sol.getAllReachableSigs()) {
                if (sig.builtin || !(sig instanceof Sig.PrimSig)) continue;
                this.sig((Sig.PrimSig)sig);
            }
            for (Sig sig : this.toplevels) {
                if (sig.builtin && sig != Sig.STRING) continue;
                this.atoms(sol, (Sig.PrimSig)sig, state);
            }
            for (Sig sig : sol.getAllReachableSigs()) {
                if (!(sig instanceof Sig.SubsetSig)) continue;
                this.setOrRel(sol, sig.label, (Expr)sig, sig.isPrivate != null, sig.isMeta != null, sig.isVariable != null, false, state);
            }
            for (Sig sig : sol.getAllReachableSigs()) {
                for (Sig.Field f : sig.getFields()) {
                    this.setOrRel(sol, f.label, (Expr)f, f.isPrivate != null, f.isMeta != null, f.isVariable != null, false, state);
                }
            }
            for (ExprVar exprVar : sol.getAllSkolems()) {
                this.setOrRel(sol, exprVar.label, (Expr)exprVar, false, false, false, true, state);
            }
        }
        if (isMeta) {
            Iterator it;
            void var7_19;
            this.sigMETA(Sig.UNIV);
            for (Sig sig : sol.getAllReachableSigs()) {
                if (!(sig instanceof Sig.SubsetSig)) continue;
                this.sigMETA((Sig.SubsetSig)sig);
            }
            for (Sig sig : sol.getAllReachableSigs()) {
                for (Sig.Field f : sig.getFields()) {
                    for (List list : f.type().fold()) {
                        ArrayList<AlloyType> types = new ArrayList<AlloyType>(list.size());
                        AlloyAtom[] tuple = new AlloyAtom[list.size()];
                        for (int i = 0; i < list.size(); ++i) {
                            types.add(this.sig((Sig.PrimSig)list.get(i)));
                            tuple[i] = this.sig2atom.get(list.get(i));
                        }
                        AlloyRelation rel = this.makeRel(f.label, f.isPrivate != null, false, f.isVariable != null, false, types);
                        this.rels.put(rel, Util.asSet((Object[])new AlloyTuple[]{new AlloyTuple(tuple)}));
                    }
                }
            }
            if (this.ins.size() > 0) {
                this.sig2type.put(null, AlloyType.SET);
                this.rels.put(AlloyRelation.IN, this.ins);
            }
            if (this.eqs.size() > 0) {
                this.sig2type.put(null, AlloyType.SET);
                this.rels.put(AlloyRelation.EQ, this.eqs);
            }
            if (this.absts.size() > 0) {
                this.sets.add(AlloySet.ABSTRACT);
            }
            if (this.ones.size() > 0) {
                this.sets.add(AlloySet.ONE);
            }
            if (this.lones.size() > 0) {
                this.sets.add(AlloySet.LONE);
            }
            if (this.somes.size() > 0) {
                this.sets.add(AlloySet.SOME);
            }
            if (this.vars.size() > 0) {
                this.sets.add(AlloySet.VAR);
            }
            if (this.enums.size() > 0) {
                this.sets.add(AlloySet.ENUM);
            }
            if (this.enummems.size() > 0) {
                this.sets.add(AlloySet.ENUMMEM);
            }
            AlloyAtom univAtom = this.sig2atom.get(Sig.UNIV);
            AlloyAtom alloyAtom = this.sig2atom.get(Sig.SIGINT);
            AlloyAtom seqAtom = this.sig2atom.get(Sig.SEQIDX);
            AlloyAtom strAtom = this.sig2atom.get(Sig.STRING);
            block14: for (Set set : this.rels.values()) {
                for (AlloyTuple at2 : set) {
                    if (!at2.getAtoms().contains(univAtom)) continue;
                    univAtom = null;
                    continue block14;
                }
            }
            block16: for (Set set : this.rels.values()) {
                for (AlloyTuple at : set) {
                    if (!at.getAtoms().contains(var7_19)) continue;
                    Object var7_20 = null;
                    continue block16;
                }
            }
            block18: for (Set set : this.rels.values()) {
                for (AlloyTuple at : set) {
                    if (!at.getAtoms().contains(seqAtom)) continue;
                    seqAtom = null;
                    continue block18;
                }
            }
            block20: for (Set set : this.rels.values()) {
                for (AlloyTuple at : set) {
                    if (!at.getAtoms().contains(strAtom)) continue;
                    strAtom = null;
                    continue block20;
                }
            }
            if (univAtom != null) {
                it = this.exts.iterator();
                while (it.hasNext()) {
                    AlloyTuple alloyTuple = (AlloyTuple)it.next();
                    if (alloyTuple.getStart() != univAtom && alloyTuple.getEnd() != univAtom) continue;
                    it.remove();
                }
                this.atom2sets.remove(univAtom);
            }
            if (strAtom != null) {
                it = this.exts.iterator();
                while (it.hasNext()) {
                    AlloyTuple alloyTuple = (AlloyTuple)it.next();
                    if (alloyTuple.getStart() != strAtom && alloyTuple.getEnd() != strAtom) continue;
                    it.remove();
                }
                this.atom2sets.remove(strAtom);
            }
            if (var7_19 != null && seqAtom != null) {
                it = this.exts.iterator();
                while (it.hasNext()) {
                    AlloyTuple alloyTuple = (AlloyTuple)it.next();
                    if (alloyTuple.getStart() != var7_19 && alloyTuple.getEnd() != var7_19 && alloyTuple.getStart() != seqAtom && alloyTuple.getEnd() != seqAtom) continue;
                    it.remove();
                }
                this.atom2sets.remove(var7_19);
                this.atom2sets.remove(seqAtom);
            }
            if (this.exts.size() > 0) {
                this.rels.put(AlloyRelation.EXTENDS, this.exts);
            }
            if (this.mems.size() > 0) {
                this.rels.put(AlloyRelation.MEMBER, this.mems);
            }
        }
        AlloyModel am = new AlloyModel(this.sig2type.values(), this.sets, this.rels.keySet(), this.nonempty_elems, this.ts);
        int n = Integer.valueOf(inst.getAttribute("tracelength"));
        int looplen = Integer.valueOf(inst.getAttribute("looplength"));
        this.ans = new AlloyInstance(sol, sol.getOriginalFilename(), sol.getOriginalCommand(), am, this.atom2sets, this.rels, isMeta, n, looplen);
    }

    public static AlloyInstance parseInstance(File file, int state) throws Err {
        try {
            return new StaticInstanceReader((XMLNode)new XMLNode((File)file), (int)state).ans;
        }
        catch (IOException ex) {
            throw new ErrorFatal("Error reading the XML file: " + String.valueOf(ex), (Throwable)ex);
        }
    }

    public static AlloyInstance parseInstance(Reader reader, int state) throws Err {
        try {
            return new StaticInstanceReader((XMLNode)new XMLNode((Reader)reader), (int)state).ans;
        }
        catch (IOException ex) {
            throw new ErrorFatal("Error reading the XML file: " + String.valueOf(ex), (Throwable)ex);
        }
    }
}

