/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyInstance;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyProjection;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyTuple;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class StaticProjector {
    private StaticProjector() {
    }

    public static AlloyModel project(AlloyModel unprojectedModel, Collection<AlloyType> typesToBeProjected) {
        return StaticProjector.project(unprojectedModel, typesToBeProjected, null);
    }

    private static AlloyModel project(AlloyModel unprojectedModel, Collection<AlloyType> typesToBeProjected, Map<AlloyRelation, List<Integer>> data) {
        LinkedHashSet<AlloyType> types = new LinkedHashSet<AlloyType>(unprojectedModel.getTypes());
        ArrayList<AlloySet> sets = new ArrayList<AlloySet>(unprojectedModel.getSets());
        ArrayList<AlloyRelation> relations = new ArrayList<AlloyRelation>();
        for (AlloyType type : typesToBeProjected) {
            types.remove(type);
            types.removeAll((Collection<?>)unprojectedModel.getSubTypes(type));
        }
        types.add(AlloyType.UNIV);
        for (AlloyRelation rel : unprojectedModel.getRelations()) {
            ArrayList<AlloyType> relTypes = new ArrayList<AlloyType>(rel.getTypes());
            ArrayList<Integer> indices = new ArrayList<Integer>();
            int currentIndex = 0;
            Iterator relTypesIter = relTypes.iterator();
            while (relTypesIter.hasNext()) {
                if (!types.contains(relTypesIter.next())) {
                    relTypesIter.remove();
                    indices.add(currentIndex);
                }
                ++currentIndex;
            }
            if (relTypes.size() > 1) {
                relations.add(new AlloyRelation(rel.getName(), rel.isPrivate, rel.isMeta, rel.isVar, rel.isSkolem, relTypes));
                if (data == null) continue;
                data.put(rel, indices);
                continue;
            }
            if (relTypes.size() != 1) continue;
            sets.add(new AlloySet(rel.getName(), rel.isPrivate, rel.isMeta, rel.isVar, rel.isSkolem, (AlloyType)relTypes.get(0)));
            if (data == null) continue;
            data.put(rel, indices);
        }
        Iterator setsIter = sets.iterator();
        while (setsIter.hasNext()) {
            AlloySet set = (AlloySet)setsIter.next();
            if (types.contains(set.getType())) continue;
            setsIter.remove();
        }
        return new AlloyModel(types, sets, relations, unprojectedModel);
    }

    public static AlloyInstance project(AlloyInstance oldInstance, AlloyProjection projection) {
        LinkedHashMap<AlloyRelation, List<Integer>> data = new LinkedHashMap<AlloyRelation, List<Integer>>();
        LinkedHashMap<AlloyAtom, Set<AlloySet>> atom2sets = new LinkedHashMap<AlloyAtom, Set<AlloySet>>();
        LinkedHashMap<AlloyRelation, Set<AlloyTuple>> rel2tuples = new LinkedHashMap<AlloyRelation, Set<AlloyTuple>>();
        AlloyModel newModel = StaticProjector.project(oldInstance.model, projection.getProjectedTypes(), data);
        for (AlloyAtom atom : oldInstance.getAllAtoms()) {
            atom2sets.put(atom, new LinkedHashSet<AlloySet>(oldInstance.atom2sets(atom)));
        }
        for (AlloyRelation r : oldInstance.model.getRelations()) {
            List list = (List)data.get(r);
            if (list == null) continue;
            block2: for (AlloyTuple oldTuple : oldInstance.relation2tuples(r)) {
                Set<Comparable<AlloyTuple>> answer;
                AlloyAtom a;
                for (Integer i : list) {
                    a = oldTuple.getAtoms().get(i);
                    AlloyType bt = r.getTypes().get(i);
                    if (a.equals(projection.getProjectedAtom(bt = oldInstance.model.getTopmostSuperType(bt)))) continue;
                    continue block2;
                }
                ConstList<AlloyAtom> newTuple = oldTuple.project(list);
                List<AlloyType> newObj = r.project(list);
                if (newObj.size() > 1 && newTuple.size() > 1) {
                    AlloyRelation r2 = new AlloyRelation(r.getName(), r.isPrivate, r.isMeta, r.isVar, r.isSkolem, newObj);
                    answer = (Set)rel2tuples.get(r2);
                    if (answer == null) {
                        answer = new LinkedHashSet();
                        rel2tuples.put(r2, answer);
                    }
                    answer.add(new AlloyTuple((List<AlloyAtom>)newTuple));
                    continue;
                }
                if (newObj.size() != 1 || newTuple.size() != 1) continue;
                a = (AlloyAtom)newTuple.get(0);
                answer = (LinkedHashSet<Comparable<AlloyTuple>>)atom2sets.get(a);
                if (answer == null) {
                    answer = new LinkedHashSet<Comparable<AlloyTuple>>();
                    atom2sets.put(a, answer);
                }
                answer.add(new AlloySet(r.getName(), r.isPrivate, r.isMeta, r.isVar, r.isSkolem, newObj.get(0)));
            }
        }
        return new AlloyInstance(oldInstance.originalA4, oldInstance.filename, oldInstance.commandname, newModel, atom2sets, rel2tuples, oldInstance.isMetamodel, -1, -1);
    }
}

