/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4.XMLNode;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4viz.AlloyNodeElement;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public final class StaticThemeReaderWriter {
    private StaticThemeReaderWriter() {
    }

    public static void readAlloy(String filename, VizState theme) throws IOException {
        File file = new File(filename);
        try {
            XMLNode elem = new XMLNode(file);
            for (XMLNode sub : elem.getChildren("view")) {
                StaticThemeReaderWriter.parseView(sub, theme);
            }
        }
        catch (Throwable e) {
            throw new IOException("The file \"" + file.getPath() + "\" is not a valid XML file, or an error occurred in reading.");
        }
    }

    public static void writeAlloy(String filename, VizState theme) throws IOException {
        PrintWriter bw = new PrintWriter(filename, "UTF-8");
        bw.write("<?xml version=\"1.0\"?>\n<alloy>\n\n");
        if (theme != null) {
            try {
                StaticThemeReaderWriter.writeView(bw, theme);
            }
            catch (IOException ex) {
                Util.close((Closeable)bw);
                throw new IOException("Error writing to the file \"" + filename + "\"");
            }
        }
        bw.write("\n</alloy>\n");
        if (!Util.close((Closeable)bw)) {
            throw new IOException("Error writing to the file \"" + filename + "\"");
        }
    }

    private static void parseView(XMLNode x, VizState now) {
        if (!x.is("view")) {
            return;
        }
        for (XMLNode xml : x) {
            if (!xml.is("projection")) continue;
            now.deprojectAll();
            for (AlloyType t : StaticThemeReaderWriter.parseProjectionList(now, xml)) {
                now.project(t);
            }
        }
        if (StaticThemeReaderWriter.has(x, "useOriginalAtomNames")) {
            now.useOriginalName(StaticThemeReaderWriter.getbool(x, "useOriginalAtomNames"));
        }
        if (StaticThemeReaderWriter.has(x, "hidePrivate")) {
            now.hidePrivate(StaticThemeReaderWriter.getbool(x, "hidePrivate"));
        }
        if (StaticThemeReaderWriter.has(x, "hideMeta")) {
            now.hideMeta(StaticThemeReaderWriter.getbool(x, "hideMeta"));
        }
        if (StaticThemeReaderWriter.has(x, "hideSkolem")) {
            now.hideSkolem(StaticThemeReaderWriter.getbool(x, "hideSkolem"));
        }
        if (StaticThemeReaderWriter.has(x, "fontsize")) {
            now.setFontSize(StaticThemeReaderWriter.getint(x, "fontsize"));
        }
        if (StaticThemeReaderWriter.has(x, "nodetheme")) {
            now.setNodePalette(StaticThemeReaderWriter.parseDotPalette(x, "nodetheme"));
        }
        if (StaticThemeReaderWriter.has(x, "edgetheme")) {
            now.setEdgePalette(StaticThemeReaderWriter.parseDotPalette(x, "edgetheme"));
        }
        for (XMLNode xml : x) {
            if (xml.is("defaultnode")) {
                StaticThemeReaderWriter.parseNodeViz(xml, now, null);
                continue;
            }
            if (xml.is("defaultedge")) {
                StaticThemeReaderWriter.parseEdgeViz(xml, now, null);
                continue;
            }
            if (xml.is("node")) {
                for (XMLNode sub : xml.getChildren("type")) {
                    AlloyType t = StaticThemeReaderWriter.parseAlloyType(now, sub);
                    if (t == null) continue;
                    StaticThemeReaderWriter.parseNodeViz(xml, now, t);
                }
                for (XMLNode sub : xml.getChildren("set")) {
                    AlloySet s = StaticThemeReaderWriter.parseAlloySet(now, sub);
                    if (s == null) continue;
                    StaticThemeReaderWriter.parseNodeViz(xml, now, s);
                }
                continue;
            }
            if (!xml.is("edge")) continue;
            for (XMLNode sub : xml.getChildren("relation")) {
                AlloyRelation r = StaticThemeReaderWriter.parseAlloyRelation(now, sub);
                if (r == null) continue;
                StaticThemeReaderWriter.parseEdgeViz(xml, now, r);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void writeView(PrintWriter out, VizState view) throws IOException {
        if (view == null) {
            return;
        }
        VizState defaultView = new VizState(view.getOriginalInstance());
        out.write("<view");
        StaticThemeReaderWriter.writeDotPalette(out, "nodetheme", view.getNodePalette(), defaultView.getNodePalette());
        StaticThemeReaderWriter.writeDotPalette(out, "edgetheme", view.getEdgePalette(), defaultView.getEdgePalette());
        if (view.useOriginalName() != defaultView.useOriginalName()) {
            out.write(" useOriginalAtomNames=\"");
            out.write(view.useOriginalName() ? "yes" : "no");
            out.write("\"");
        }
        if (view.hidePrivate() != defaultView.hidePrivate()) {
            out.write(" hidePrivate=\"");
            out.write(view.hidePrivate() ? "yes" : "no");
            out.write("\"");
        }
        if (view.hideMeta() != defaultView.hideMeta()) {
            out.write(" hideMeta=\"");
            out.write(view.hideMeta() ? "yes" : "no");
            out.write("\"");
        }
        if (view.hideSkolem() != defaultView.hideSkolem()) {
            out.write(" hideSkolem=\"");
            out.write(view.hideSkolem() ? "yes" : "no");
            out.write("\"");
        }
        if (view.getFontSize() != defaultView.getFontSize()) {
            out.write(" fontsize=\"" + view.getFontSize() + "\"");
        }
        out.write(">\n");
        if (view.getProjectedTypes().size() > 0) {
            StaticThemeReaderWriter.writeProjectionList(out, view.getProjectedTypes());
        }
        out.write("\n<defaultnode" + StaticThemeReaderWriter.writeNodeViz(view, defaultView, null));
        out.write("/>\n\n<defaultedge" + StaticThemeReaderWriter.writeEdgeViz(view, defaultView, null));
        out.write("/>\n");
        TreeSet<AlloyNodeElement> types = new TreeSet<AlloyNodeElement>();
        types.addAll(view.getOriginalModel().getTypes());
        types.addAll(view.getCurrentModel().getTypes());
        types.addAll(view.getOriginalModel().getSets());
        types.addAll(view.getCurrentModel().getSets());
        TreeMap viz2node = new TreeMap();
        for (AlloyNodeElement alloyNodeElement : types) {
            void var8_11;
            String str = StaticThemeReaderWriter.writeNodeViz(view, defaultView, alloyNodeElement);
            Set set = (Set)viz2node.get(str);
            if (set == null) {
                TreeSet treeSet = new TreeSet();
                viz2node.put(str, treeSet);
            }
            var8_11.add(alloyNodeElement);
        }
        for (Map.Entry entry : viz2node.entrySet()) {
            out.write("\n<node" + (String)entry.getKey() + ">\n");
            for (AlloyNodeElement alloyNodeElement : (Set)entry.getValue()) {
                if (alloyNodeElement instanceof AlloyType) {
                    StaticThemeReaderWriter.writeAlloyType(out, (AlloyType)alloyNodeElement);
                    continue;
                }
                if (!(alloyNodeElement instanceof AlloySet)) continue;
                StaticThemeReaderWriter.writeAlloySet(out, (AlloySet)alloyNodeElement);
            }
            out.write("</node>\n");
        }
        TreeSet<AlloyRelation> rels = new TreeSet<AlloyRelation>();
        rels.addAll(view.getOriginalModel().getRelations());
        rels.addAll(view.getCurrentModel().getRelations());
        TreeMap<String, TreeSet<AlloyRelation>> treeMap = new TreeMap<String, TreeSet<AlloyRelation>>();
        for (AlloyRelation alloyRelation : rels) {
            String str = StaticThemeReaderWriter.writeEdgeViz(view, defaultView, alloyRelation);
            if (str.length() == 0) continue;
            TreeSet<AlloyRelation> edges = (TreeSet<AlloyRelation>)treeMap.get(str);
            if (edges == null) {
                edges = new TreeSet<AlloyRelation>();
                treeMap.put(str, edges);
            }
            edges.add(alloyRelation);
        }
        for (Map.Entry entry : treeMap.entrySet()) {
            out.write("\n<edge" + (String)entry.getKey() + ">\n");
            for (AlloyRelation r : (Set)entry.getValue()) {
                StaticThemeReaderWriter.writeAlloyRelation(out, r);
            }
            out.write("</edge>\n");
        }
        out.write("\n</view>\n");
    }

    private static AlloyType parseAlloyType(VizState now, XMLNode x) {
        if (!x.is("type")) {
            return null;
        }
        String name = x.getAttribute("name");
        if (name.length() == 0) {
            return null;
        }
        return now.getCurrentModel().hasType(name);
    }

    private static void writeAlloyType(PrintWriter out, AlloyType x) throws IOException {
        if (x != null) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{"   <type name=\"", x.getName(), "\"/>\n"});
        }
    }

    private static AlloySet parseAlloySet(VizState now, XMLNode x) {
        if (!x.is("set")) {
            return null;
        }
        String name = x.getAttribute("name");
        String type = x.getAttribute("type");
        if (name.length() == 0 || type.length() == 0) {
            return null;
        }
        AlloyType t = now.getCurrentModel().hasType(type);
        if (t == null) {
            return null;
        }
        return now.getCurrentModel().hasSet(name, t);
    }

    private static void writeAlloySet(PrintWriter out, AlloySet x) throws IOException {
        if (x != null) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{"   <set name=\"", x.getName(), "\" type=\"", x.getType().getName(), "\"/>\n"});
        }
    }

    private static AlloyRelation parseAlloyRelation(VizState now, XMLNode x) {
        ArrayList<AlloyType> ans = new ArrayList<AlloyType>();
        if (!x.is("relation")) {
            return null;
        }
        String name = x.getAttribute("name");
        if (name.length() == 0) {
            return null;
        }
        for (XMLNode sub : x.getChildren("type")) {
            String typename = sub.getAttribute("name");
            if (typename.length() == 0) {
                return null;
            }
            AlloyType t = now.getCurrentModel().hasType(typename);
            if (t == null) {
                return null;
            }
            ans.add(t);
        }
        if (ans.size() < 2) {
            return null;
        }
        return now.getCurrentModel().hasRelation(name, ans);
    }

    private static void writeAlloyRelation(PrintWriter out, AlloyRelation x) throws IOException {
        if (x == null) {
            return;
        }
        Util.encodeXMLs((PrintWriter)out, (String[])new String[]{"   <relation name=\"", x.getName(), "\">"});
        for (AlloyType t : x.getTypes()) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" <type name=\"", t.getName(), "\"/>"});
        }
        out.write(" </relation>\n");
    }

    private static Set<AlloyType> parseProjectionList(VizState now, XMLNode x) {
        TreeSet<AlloyType> ans = new TreeSet<AlloyType>();
        if (x.is("projection")) {
            for (XMLNode sub : x.getChildren("type")) {
                AlloyType t;
                String name = sub.getAttribute("name");
                if (name.length() == 0 || (t = now.getOriginalModel().hasType(name)) == null) continue;
                ans.add(t);
            }
        }
        return ans;
    }

    private static void writeProjectionList(PrintWriter out, Set<AlloyType> types) throws IOException {
        if (types == null || types.size() == 0) {
            out.write("\n<projection/>\n");
            return;
        }
        out.write("\n<projection>");
        for (AlloyType t : types) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" <type name=\"", t.getName(), "\"/>"});
        }
        out.write(" </projection>\n");
    }

    private static void parseNodeViz(XMLNode xml, VizState view, AlloyNodeElement x) {
        if (StaticThemeReaderWriter.has(xml, "visible")) {
            view.nodeVisible.put(x, StaticThemeReaderWriter.getbool(xml, "visible"));
        }
        if (StaticThemeReaderWriter.has(xml, "hideunconnected")) {
            view.hideUnconnected.put(x, StaticThemeReaderWriter.getbool(xml, "hideunconnected"));
        }
        if (x == null || x instanceof AlloySet) {
            AlloySet s = (AlloySet)x;
            if (StaticThemeReaderWriter.has(xml, "showlabel")) {
                view.showAsLabel.put(s, StaticThemeReaderWriter.getbool(xml, "showlabel"));
            }
            if (StaticThemeReaderWriter.has(xml, "showinattr")) {
                view.showAsAttr.put(s, StaticThemeReaderWriter.getbool(xml, "showinattr"));
            }
        }
        if (x == null || x instanceof AlloyType) {
            AlloyType t = (AlloyType)x;
            if (StaticThemeReaderWriter.has(xml, "numberatoms")) {
                view.number.put(t, StaticThemeReaderWriter.getbool(xml, "numberatoms"));
            }
        }
        if (StaticThemeReaderWriter.has(xml, "style")) {
            view.nodeStyle.put(x, StaticThemeReaderWriter.parseDotStyle(xml));
        }
        if (StaticThemeReaderWriter.has(xml, "color")) {
            view.nodeColor.put(x, StaticThemeReaderWriter.parseDotColor(xml));
        }
        if (StaticThemeReaderWriter.has(xml, "shape")) {
            view.shape.put(x, StaticThemeReaderWriter.parseDotShape(xml));
        }
        if (StaticThemeReaderWriter.has(xml, "label")) {
            view.label.put(x, xml.getAttribute("label"));
        }
    }

    private static String writeNodeViz(VizState view, VizState defaultView, AlloyNodeElement x) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        StaticThemeReaderWriter.writeBool(out, "visible", view.nodeVisible.get(x), defaultView.nodeVisible.get(x));
        StaticThemeReaderWriter.writeBool(out, "hideunconnected", view.hideUnconnected.get(x), defaultView.hideUnconnected.get(x));
        if (x == null || x instanceof AlloySet) {
            AlloySet s = (AlloySet)x;
            StaticThemeReaderWriter.writeBool(out, "showlabel", view.showAsLabel.get(s), defaultView.showAsLabel.get(s));
            StaticThemeReaderWriter.writeBool(out, "showinattr", view.showAsAttr.get(s), defaultView.showAsAttr.get(s));
        }
        if (x == null || x instanceof AlloyType) {
            AlloyType t = (AlloyType)x;
            StaticThemeReaderWriter.writeBool(out, "numberatoms", view.number.get(t), defaultView.number.get(t));
        }
        StaticThemeReaderWriter.writeDotStyle(out, view.nodeStyle.get(x), defaultView.nodeStyle.get(x));
        StaticThemeReaderWriter.writeDotShape(out, view.shape.get(x), defaultView.shape.get(x));
        StaticThemeReaderWriter.writeDotColor(out, view.nodeColor.get(x), defaultView.nodeColor.get(x));
        if (x != null && !view.label.get(x).equals(defaultView.label.get(x))) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" label=\"", view.label.get(x), "\""});
        }
        if (out.checkError()) {
            throw new IOException("PrintWriter IO Exception!");
        }
        return sw.toString();
    }

    private static void parseEdgeViz(XMLNode xml, VizState view, AlloyRelation x) {
        if (StaticThemeReaderWriter.has(xml, "visible")) {
            view.edgeVisible.put(x, StaticThemeReaderWriter.getbool(xml, "visible"));
        }
        if (StaticThemeReaderWriter.has(xml, "attribute")) {
            view.attribute.put(x, StaticThemeReaderWriter.getbool(xml, "attribute"));
        }
        if (StaticThemeReaderWriter.has(xml, "merge")) {
            view.mergeArrows.put(x, StaticThemeReaderWriter.getbool(xml, "merge"));
        }
        if (StaticThemeReaderWriter.has(xml, "layout")) {
            view.layoutBack.put(x, StaticThemeReaderWriter.getbool(xml, "layout"));
        }
        if (StaticThemeReaderWriter.has(xml, "constraint")) {
            view.constraint.put(x, StaticThemeReaderWriter.getbool(xml, "constraint"));
        }
        if (StaticThemeReaderWriter.has(xml, "style")) {
            view.edgeStyle.put(x, StaticThemeReaderWriter.parseDotStyle(xml));
        }
        if (StaticThemeReaderWriter.has(xml, "color")) {
            view.edgeColor.put(x, StaticThemeReaderWriter.parseDotColor(xml));
        }
        if (StaticThemeReaderWriter.has(xml, "weight")) {
            view.weight.put(x, StaticThemeReaderWriter.getint(xml, "weight"));
        }
        if (StaticThemeReaderWriter.has(xml, "label")) {
            view.label.put(x, xml.getAttribute("label"));
        }
    }

    private static String writeEdgeViz(VizState view, VizState defaultView, AlloyRelation x) throws IOException {
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        StaticThemeReaderWriter.writeDotColor(out, view.edgeColor.get(x), defaultView.edgeColor.get(x));
        StaticThemeReaderWriter.writeDotStyle(out, view.edgeStyle.get(x), defaultView.edgeStyle.get(x));
        StaticThemeReaderWriter.writeBool(out, "visible", view.edgeVisible.get(x), defaultView.edgeVisible.get(x));
        StaticThemeReaderWriter.writeBool(out, "merge", view.mergeArrows.get(x), defaultView.mergeArrows.get(x));
        StaticThemeReaderWriter.writeBool(out, "layout", view.layoutBack.get(x), defaultView.layoutBack.get(x));
        StaticThemeReaderWriter.writeBool(out, "attribute", view.attribute.get(x), defaultView.attribute.get(x));
        StaticThemeReaderWriter.writeBool(out, "constraint", view.constraint.get(x), defaultView.constraint.get(x));
        if (view.weight.get(x) != defaultView.weight.get(x)) {
            out.write(" weight=\"" + view.weight.get(x) + "\"");
        }
        if (x != null && !view.label.get(x).equals(defaultView.label.get(x))) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" label=\"", view.label.get(x), "\""});
        }
        if (out.checkError()) {
            throw new IOException("PrintWriter IO Exception!");
        }
        return sw.toString();
    }

    private static DotPalette parseDotPalette(XMLNode x, String key) {
        return DotPalette.parse(x.getAttribute(key));
    }

    private static void writeDotPalette(PrintWriter out, String key, DotPalette value, DotPalette defaultValue) throws IOException {
        if (value != defaultValue) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" " + key + "=\"", value == null ? "inherit" : value.toString(), "\""});
        }
    }

    private static DotColor parseDotColor(XMLNode x) {
        return DotColor.parse(x.getAttribute("color"));
    }

    private static void writeDotColor(PrintWriter out, DotColor value, DotColor defaultValue) throws IOException {
        if (value != defaultValue) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" color=\"", value == null ? "inherit" : value.toString(), "\""});
        }
    }

    private static DotShape parseDotShape(XMLNode x) {
        return DotShape.parse(x.getAttribute("shape"));
    }

    private static void writeDotShape(PrintWriter out, DotShape value, DotShape defaultValue) throws IOException {
        if (value != defaultValue) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" shape=\"", value == null ? "inherit" : value.toString(), "\""});
        }
    }

    private static DotStyle parseDotStyle(XMLNode x) {
        return DotStyle.parse(x.getAttribute("style"));
    }

    private static void writeDotStyle(PrintWriter out, DotStyle value, DotStyle defaultValue) throws IOException {
        if (value != defaultValue) {
            Util.encodeXMLs((PrintWriter)out, (String[])new String[]{" style=\"", value == null ? "inherit" : value.toString(), "\""});
        }
    }

    private static Boolean getbool(XMLNode x, String attr) {
        String value = x.getAttribute(attr);
        if (value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("no") || value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static void writeBool(PrintWriter out, String key, Boolean value, Boolean defaultValue) throws IOException {
        if (value == null && defaultValue == null) {
            return;
        }
        if (value != null && defaultValue != null && value.booleanValue() == defaultValue.booleanValue()) {
            return;
        }
        out.write(32);
        out.write(key);
        if (value == null) {
            out.write("=\"inherit\"");
        } else {
            out.write(value != false ? "=\"yes\"" : "=\"no\"");
        }
    }

    private static boolean has(XMLNode x, String attr) {
        return x.getAttribute(attr, null) != null;
    }

    private static int getint(XMLNode x, String attr) {
        int i;
        String value = x.getAttribute(attr);
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            i = 0;
        }
        return i;
    }
}

