/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Listener;
import edu.mit.csail.sdg.alloy4.OurBorder;
import edu.mit.csail.sdg.alloy4.OurCheckbox;
import edu.mit.csail.sdg.alloy4.OurCombobox;
import edu.mit.csail.sdg.alloy4.OurTree;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyNodeElement;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.TreePath;

public final class VizCustomizationPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private static final Object ROOT = new Object();
    private static final Object GENERAL = new Object();
    private static final Object NODES = new Object();
    private static final Object EDGES = new Object();
    private final VizState vizState;
    private static final Color wcolor = new Color(0.9f, 0.9f, 0.9f);
    private final JPanel zoomPane;
    private final JSplitPane divider;
    private Object lastElement = null;

    public VizCustomizationPanel(JSplitPane divider, VizState vizState) {
        this.divider = divider;
        this.vizState = vizState;
        this.setBorder(null);
        this.setLayout(new BoxLayout(this, 1));
        this.zoomPane = new JPanel();
        this.zoomPane.setBorder((Border)new OurBorder(false, false, true, false));
        this.zoomPane.setLayout(new BoxLayout(this.zoomPane, 1));
        this.zoomPane.setAlignmentX(0.0f);
        this.zoomPane.setBackground(wcolor);
        this.remakeAll();
    }

    private void zoom(Object x) {
        this.lastElement = x;
        this.zoomPane.removeAll();
        if (x instanceof AlloyNodeElement) {
            this.makeNodeOptionsPanel(this.zoomPane, (AlloyNodeElement)x);
        } else if (x instanceof AlloyRelation) {
            this.makeEdgeOptionsPanel(this.zoomPane, (AlloyRelation)x);
        } else if (x == GENERAL) {
            this.createGeneralWidget(this.zoomPane);
        } else if (x == NODES) {
            this.createDefaultNodeWidget(this.zoomPane);
        } else if (x == EDGES) {
            this.createDefaultEdgeWidget(this.zoomPane);
        } else {
            this.zoomPane.add(OurUtil.makeH((Object[])new Object[]{wcolor, new JLabel(" "), null}));
            this.zoomPane.add(OurUtil.makeH((Object[])new Object[]{new Dimension(250, 200), wcolor, null}));
        }
        Dimension dim = this.zoomPane.getPreferredSize();
        if (this.divider != null && this.divider.getDividerLocation() < dim.width) {
            this.divider.setDividerLocation(dim.width);
        }
        if (this.divider != null && this.divider.getDividerLocation() > dim.width) {
            dim.width = this.divider.getDividerLocation();
        }
        dim.height = 150;
        this.zoomPane.setPreferredSize(dim);
        dim.width = 450;
        this.zoomPane.setMinimumSize(dim);
        this.zoomPane.repaint();
        this.validate();
    }

    public void remakeAll() {
        OurTree tree = new OurTree(12){
            private static final long serialVersionUID = 0L;
            private final AlloyModel old;
            private final AlloyModel now;
            private final boolean hidePrivate;
            private final boolean hideMeta;
            private final boolean hideSkolem;
            {
                this.old = VizCustomizationPanel.this.vizState.getOriginalModel();
                this.now = VizCustomizationPanel.this.vizState.getCurrentModel();
                this.hidePrivate = VizCustomizationPanel.this.vizState.hidePrivate();
                this.hideMeta = VizCustomizationPanel.this.vizState.hideMeta();
                this.hideSkolem = VizCustomizationPanel.this.vizState.hideSkolem();
                this.do_start();
                this.setRootVisible(false);
                this.setShowsRootHandles(false);
                this.listeners.add(new Listener(){

                    public Object do_action(Object sender, Listener.Event event) {
                        return null;
                    }

                    public Object do_action(Object sender, Listener.Event event, Object arg) {
                        VizCustomizationPanel.this.zoom(arg);
                        return null;
                    }
                });
            }

            public String convertValueToText(Object value, boolean sel, boolean expand, boolean leaf, int i, boolean focus) {
                if (value == GENERAL) {
                    return "<html><b>general graph settings</b></html>";
                }
                if (value == NODES) {
                    return "<html><b>types and sets</b></html>";
                }
                if (value == EDGES) {
                    return "<html><b>relations</b></html>";
                }
                if (value instanceof AlloyType) {
                    AlloyType x = (AlloyType)value;
                    if (VizCustomizationPanel.this.vizState.getCurrentModel().hasType(x)) {
                        return "<html><b>sig</b> " + VizCustomizationPanel.this.typename(x) + "</html>";
                    }
                    return "<html><b>sig</b> " + VizCustomizationPanel.this.typename(x) + " <font color=\"#808080\">(projected)</font></html>";
                }
                if (value instanceof AlloySet) {
                    return "<html><b>set</b> " + ((AlloySet)value).getName() + "</html>";
                }
                if (value instanceof AlloyRelation) {
                    return value.toString();
                }
                return "";
            }

            public List<?> do_ask(Object parent) {
                ArrayList<Object> ans;
                block5: {
                    block7: {
                        block6: {
                            block4: {
                                ans = new ArrayList<Object>();
                                if (parent != ROOT) break block4;
                                ans.add(GENERAL);
                                ans.add(NODES);
                                ans.add(EDGES);
                                break block5;
                            }
                            if (parent != NODES) break block6;
                            ans.add(AlloyType.UNIV);
                            break block5;
                        }
                        if (parent != EDGES) break block7;
                        for (AlloyRelation rel : VizCustomizationPanel.this.vizState.getCurrentModel().getRelations()) {
                            if (this.hidePrivate && rel.isPrivate || this.hideMeta && rel.isMeta || this.hideSkolem && rel.isSkolem) continue;
                            ans.add(rel);
                        }
                        break block5;
                    }
                    if (!(parent instanceof AlloyType)) break block5;
                    AlloyType type = (AlloyType)parent;
                    for (AlloySet s : this.now.getSets()) {
                        if (this.hidePrivate && s.isPrivate || this.hideMeta && s.isMeta || this.hideSkolem && s.isSkolem || !s.getType().equals(type)) continue;
                        ans.add(s);
                    }
                    if (!type.isEnum) {
                        for (AlloyType t : this.old.getDirectSubTypes(type)) {
                            if (this.hidePrivate && t.isPrivate || this.hideMeta && t.isMeta || !this.now.hasType(t) && !VizCustomizationPanel.this.vizState.canProject(t)) continue;
                            ans.add(t);
                        }
                    }
                }
                return ans;
            }

            public boolean do_isDouble(Object object) {
                return object == NODES || object == EDGES;
            }

            public Object do_root() {
                return ROOT;
            }
        };
        TreePath last = null;
        for (int i = 0; i < tree.getRowCount(); ++i) {
            tree.expandRow(i);
            if (this.lastElement == null || last != null || this.lastElement == (last = tree.getPathForRow(i)).getLastPathComponent()) continue;
            last = null;
        }
        if (last != null) {
            this.zoom(this.lastElement);
        } else {
            last = tree.getPathForRow(0);
            this.zoom(GENERAL);
        }
        tree.scrollPathToVisible(last);
        tree.setSelectionPath(last);
        JScrollPane scroll = OurUtil.scrollpane((Component)tree, (Object[])new Object[]{Color.BLACK, Color.WHITE, new OurBorder(false, false, false, Util.onMac())});
        scroll.setAlignmentX(0.0f);
        scroll.getVerticalScrollBar().setUnitIncrement(50);
        this.removeAll();
        this.add(this.zoomPane);
        this.add(scroll);
        this.validate();
    }

    private void makeNodeOptionsPanel(JPanel answer, final AlloyNodeElement elt) {
        final boolean enabled = !(elt instanceof AlloyType) || this.vizState.getCurrentModel().hasType((AlloyType)elt);
        answer.add(VizCustomizationPanel.makelabel(elt instanceof AlloyType ? " " + this.typename((AlloyType)elt) : " " + String.valueOf(elt)));
        final JTextField labelText = OurUtil.textfield((String)this.vizState.label.get(elt), (int)10, (Object[])new Object[0]);
        labelText.setMaximumSize(new Dimension(100, 25));
        labelText.addKeyListener(new KeyAdapter(){

            @Override
            public final void keyReleased(KeyEvent e) {
                VizCustomizationPanel.this.vizState.label.put(elt, labelText.getText());
            }
        });
        labelText.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                VizCustomizationPanel.this.vizState.label.put(elt, labelText.getText());
            }
        });
        labelText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                VizCustomizationPanel.this.vizState.label.put(elt, labelText.getText());
            }
        });
        AlloyModel model = this.vizState.getCurrentModel();
        final AlloyType elt2 = elt instanceof AlloyType ? model.getSuperType((AlloyType)elt) : (elt instanceof AlloySet ? ((AlloySet)elt).getType() : null);
        OurCombobox color = new OurCombobox(true, (Object[])DotColor.values(), 100, 35, (Object)this.vizState.nodeColor.get(elt)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                if (value == null) {
                    return "Inherit";
                }
                return ((DotColor)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                if (value == null) {
                    value = VizCustomizationPanel.this.vizState.nodeColor.resolve(elt2);
                }
                return value == null ? null : ((DotColor)((Object)value)).getIcon(VizCustomizationPanel.this.vizState.getNodePalette());
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.nodeColor.put(elt, (DotColor)((Object)value));
            }
        };
        OurCombobox shape = new OurCombobox(true, (Object[])DotShape.values(), 125, 35, (Object)this.vizState.shape.get(elt)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                if (value == null) {
                    return "Inherit";
                }
                return ((DotShape)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                if (value == null) {
                    value = VizCustomizationPanel.this.vizState.shape.resolve(elt2);
                }
                return value == null ? null : ((DotShape)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.shape.put(elt, (DotShape)((Object)value));
            }
        };
        OurCombobox style = new OurCombobox(true, (Object[])DotStyle.values(), 95, 35, (Object)this.vizState.nodeStyle.get(elt)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                if (value == null) {
                    return "Inherit";
                }
                return ((DotStyle)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                if (value == null) {
                    value = VizCustomizationPanel.this.vizState.nodeStyle.resolve(elt2);
                }
                return value == null ? null : ((DotStyle)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.nodeStyle.put(elt, (DotStyle)((Object)value));
            }
        };
        answer.add(OurUtil.makeH((Object[])new Object[]{10, labelText, wcolor, color, style, shape, 2, null}));
        if (elt instanceof AlloyType) {
            OurCheckbox vis = this.vizState.nodeVisible.pick(elt, "Show", "Display members as nodes");
            OurCheckbox con = this.vizState.hideUnconnected.pick(elt, "Hide unconnected nodes", "Hide nodes without arcs");
            OurCheckbox num = this.vizState.number.pick(elt, "Number nodes", "Attach atom number to node label as suffix");
            OurCheckbox proj = null;
            if (this.vizState.canProject((AlloyType)elt)) {
                proj = new OurCheckbox("Project over this sig", "Click here to " + (enabled ? "" : "un") + "project over this signature", enabled ? OurCheckbox.ALL_OFF : OurCheckbox.ALL_ON){
                    private static final long serialVersionUID = 0L;

                    public Icon do_action() {
                        if (enabled) {
                            VizCustomizationPanel.this.projectAlloyType((AlloyType)elt);
                        } else {
                            VizCustomizationPanel.this.deprojectAlloyType((AlloyType)elt);
                        }
                        VizCustomizationPanel.this.lastElement = elt;
                        return enabled ? ALL_ON : ALL_OFF;
                    }
                };
            }
            labelText.setEnabled(enabled && !this.vizState.useOriginalName());
            color.setEnabled(enabled);
            shape.setEnabled(enabled);
            style.setEnabled(enabled);
            vis.setEnabled(enabled);
            con.setEnabled(enabled);
            num.setEnabled(enabled && !this.vizState.useOriginalName());
            JPanel a = OurUtil.makeVR((Object[])new Object[]{wcolor, vis, num});
            JPanel b = proj != null ? OurUtil.makeVR((Object[])new Object[]{wcolor, con, proj}) : OurUtil.makeVR((Object[])new Object[]{wcolor, con});
            answer.add(OurUtil.makeHT((Object[])new Object[]{wcolor, 15, a, 15, b, 2, null}));
        } else {
            OurCheckbox vis = this.vizState.nodeVisible.pick(elt, "Show", "Include members of set as nodes");
            OurCheckbox attr = this.vizState.showAsAttr.pick(elt, "Show in relation attributes", "Show set membership in relation attributes");
            OurCheckbox lab = this.vizState.showAsLabel.pick(elt, "Show as labels", "Show membership in set by labeling nodes");
            OurCheckbox con = this.vizState.hideUnconnected.pick(elt, "Hide unconnected nodes", "Hide nodes without arcs");
            JPanel a = OurUtil.makeVR((Object[])new Object[]{wcolor, vis, lab});
            JPanel b = OurUtil.makeVR((Object[])new Object[]{wcolor, con, attr});
            answer.add(OurUtil.makeHT((Object[])new Object[]{wcolor, 15, a, 15, b, 2, null}));
        }
    }

    private void makeEdgeOptionsPanel(JPanel parent, final AlloyRelation rel) {
        final JTextField labelText = OurUtil.textfield((String)this.vizState.label.get(rel), (int)10, (Object[])new Object[0]);
        labelText.setMaximumSize(new Dimension(100, 25));
        labelText.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VizCustomizationPanel.this.vizState.label.put(rel, labelText.getText());
            }
        });
        labelText.addActionListener(new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent e) {
                VizCustomizationPanel.this.vizState.label.put(rel, labelText.getText());
            }
        });
        labelText.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                VizCustomizationPanel.this.vizState.label.put(rel, labelText.getText());
            }
        });
        JLabel weightLabel = OurUtil.label((String)"Weight:", (Object[])new Object[0]);
        final JSpinner weightSpinner = new JSpinner(new SpinnerNumberModel(this.vizState.weight.get(rel), 0, 999, 1));
        weightSpinner.setMaximumSize(weightSpinner.getPreferredSize());
        weightSpinner.setToolTipText("A higher weight will cause the edge to be shorter and straighter.");
        weightSpinner.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VizCustomizationPanel.this.vizState.weight.put(rel, (Integer)weightSpinner.getValue());
            }
        });
        weightSpinner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VizCustomizationPanel.this.vizState.weight.put(rel, (Integer)weightSpinner.getValue());
            }

            @Override
            public void mousePressed(MouseEvent e) {
                VizCustomizationPanel.this.vizState.weight.put(rel, (Integer)weightSpinner.getValue());
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                VizCustomizationPanel.this.vizState.weight.put(rel, (Integer)weightSpinner.getValue());
            }
        });
        weightSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VizCustomizationPanel.this.vizState.weight.put(rel, (Integer)weightSpinner.getValue());
            }
        });
        JPanel weightPanel = OurUtil.makeH((Object[])new Object[]{weightLabel, 5, weightSpinner});
        weightPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        weightPanel.setAlignmentY(0.5f);
        weightPanel.setToolTipText("A higher weight will cause the edge to be shorter and straighter.");
        OurCombobox color = new OurCombobox(true, DotColor.valuesWithout(DotColor.WHITE), 110, 35, (Object)this.vizState.edgeColor.get(rel)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return value == null ? "Inherit" : ((DotColor)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                if (value == null) {
                    value = VizCustomizationPanel.this.vizState.edgeColor.get(null);
                }
                return value == null ? null : ((DotColor)((Object)value)).getIcon(VizCustomizationPanel.this.vizState.getEdgePalette());
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.edgeColor.put(rel, (DotColor)((Object)value));
            }
        };
        OurCombobox style = new OurCombobox(true, (Object[])DotStyle.values(), 105, 35, (Object)this.vizState.edgeStyle.get(rel)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return value == null ? "Inherit" : ((DotStyle)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                if (value == null) {
                    value = VizCustomizationPanel.this.vizState.edgeStyle.get(null);
                }
                return value == null ? null : ((DotStyle)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.edgeStyle.put(rel, (DotStyle)((Object)value));
            }
        };
        OurCheckbox visible = this.vizState.edgeVisible.pick(rel, "Show as arcs", "Show relation as arcs");
        OurCheckbox attr = this.vizState.attribute.pick(rel, "Show as attribute", "Additionally display this relation as an attribute on the nodes' labels");
        OurCheckbox back = this.vizState.layoutBack.pick(rel, "Layout backwards", "Layout graph as if arcs were reversed");
        OurCheckbox merge = this.vizState.mergeArrows.pick(rel, "Merge arrows", "Merge opposing arrows between the same nodes as one bidirectional arrow");
        OurCheckbox constraint = this.vizState.constraint.pick(rel, "Influence layout", "Whether this edge influences the graph layout");
        JPanel panel1 = OurUtil.makeVR((Object[])new Object[]{wcolor, visible, attr, constraint});
        JPanel panel2 = OurUtil.makeVR((Object[])new Object[]{wcolor, back, merge});
        parent.add(VizCustomizationPanel.makelabel("<html>&nbsp;" + Util.encode((String)rel.toString()) + "</html>"));
        parent.add(OurUtil.makeH((Object[])new Object[]{10, labelText, wcolor, 5, color, 5, style, 3, weightPanel, 2, null}));
        parent.add(OurUtil.makeHT((Object[])new Object[]{wcolor, 10, panel1, 15, panel2, 2, null}));
    }

    private void createGeneralWidget(JPanel parent) {
        ConstList fontSizes = Util.asList((Object[])new Integer[]{9, 10, 11, 12, 14, 16, 18, 20, 22, 24, 26, 28, 32, 36, 40, 44, 48, 54, 60, 66, 72});
        JLabel nLabel = OurUtil.label((String)"Node Color Palette:", (Object[])new Object[0]);
        JLabel eLabel = OurUtil.label((String)"Edge Color Palette:", (Object[])new Object[0]);
        JLabel aLabel = OurUtil.label((String)"Use original atom names:", (Object[])new Object[0]);
        JLabel pLabel = OurUtil.label((String)"Hide private sigs/relations:", (Object[])new Object[0]);
        JLabel mLabel = OurUtil.label((String)"Hide meta sigs/relations:", (Object[])new Object[0]);
        JLabel sLabel = OurUtil.label((String)"Hide skolem sigs/relations:", (Object[])new Object[0]);
        JLabel fLabel = OurUtil.label((String)"Font Size:", (Object[])new Object[0]);
        OurCombobox fontSize = new OurCombobox(false, fontSizes.toArray(), 60, 32, this.vizState.getFontSize(), (List)fontSizes){
            private static final long serialVersionUID = 0L;
            final /* synthetic */ List val$fontSizes;
            {
                this.val$fontSizes = list;
                super(arg0, arg1, arg2, arg3, arg4);
            }

            public void do_changed(Object value) {
                if (this.val$fontSizes.contains(value)) {
                    VizCustomizationPanel.this.vizState.setFontSize((Integer)value);
                }
            }
        };
        OurCombobox nodepal = new OurCombobox(false, (Object[])DotPalette.values(), 100, 32, (Object)this.vizState.getNodePalette()){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotPalette)((Object)value)).getDisplayedText();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.setNodePalette((DotPalette)((Object)value));
            }
        };
        OurCombobox edgepal = new OurCombobox(false, (Object[])DotPalette.values(), 100, 32, (Object)this.vizState.getEdgePalette()){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotPalette)((Object)value)).getDisplayedText();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.setEdgePalette((DotPalette)((Object)value));
            }
        };
        OurCheckbox name = new OurCheckbox("", "Whether the visualizer should use the original atom names as-is.", this.vizState.useOriginalName() ? OurCheckbox.ON : OurCheckbox.OFF){
            private static final long serialVersionUID = 0L;

            public Icon do_action() {
                boolean x = VizCustomizationPanel.this.vizState.useOriginalName();
                VizCustomizationPanel.this.vizState.useOriginalName(!x);
                return !x ? ON : OFF;
            }
        };
        OurCheckbox priv = new OurCheckbox("", "Whether the visualizer should hide private sigs, sets, and relations by default.", this.vizState.hidePrivate() ? OurCheckbox.ON : OurCheckbox.OFF){
            private static final long serialVersionUID = 0L;

            public Icon do_action() {
                boolean x = VizCustomizationPanel.this.vizState.hidePrivate();
                VizCustomizationPanel.this.vizState.hidePrivate(!x);
                VizCustomizationPanel.this.remakeAll();
                return !x ? ON : OFF;
            }
        };
        OurCheckbox skol = new OurCheckbox("", "Whether the visualizer should hide skolemized sigs, sets, and relations by default.", this.vizState.hideSkolem() ? OurCheckbox.ON : OurCheckbox.OFF){
            private static final long serialVersionUID = 0L;

            public Icon do_action() {
                boolean x = VizCustomizationPanel.this.vizState.hideSkolem();
                VizCustomizationPanel.this.vizState.hideSkolem(!x);
                VizCustomizationPanel.this.remakeAll();
                return !x ? ON : OFF;
            }
        };
        OurCheckbox meta = new OurCheckbox("", "Whether the visualizer should hide meta sigs, sets, and relations by default.", this.vizState.hideMeta() ? OurCheckbox.ON : OurCheckbox.OFF){
            private static final long serialVersionUID = 0L;

            public Icon do_action() {
                boolean x = VizCustomizationPanel.this.vizState.hideMeta();
                VizCustomizationPanel.this.vizState.hideMeta(!x);
                VizCustomizationPanel.this.remakeAll();
                return !x ? ON : OFF;
            }
        };
        parent.add(VizCustomizationPanel.makelabel(" General Graph Settings:"));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, new Dimension(6, 6)}));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 25, nLabel, 5, nodepal, 8, aLabel, 5, name, 2, null}));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 25, eLabel, 5, edgepal, 8, fLabel, 5, fontSize, 2, null}));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 25, pLabel, 5, priv, 2, null}));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 25, mLabel, 5, meta, 2, null}));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 25, sLabel, 5, skol, 2, null}));
    }

    private void createDefaultNodeWidget(JPanel parent) {
        OurCombobox color = new OurCombobox(false, (Object[])DotColor.values(), 110, 35, (Object)this.vizState.nodeColor.get(null)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotColor)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                return ((DotColor)((Object)value)).getIcon(VizCustomizationPanel.this.vizState.getNodePalette());
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.nodeColor.put(null, (DotColor)((Object)value));
            }
        };
        OurCombobox shape = new OurCombobox(false, (Object[])DotShape.values(), 135, 35, (Object)this.vizState.shape.get(null)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotShape)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                return ((DotShape)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.shape.put(null, (DotShape)((Object)value));
            }
        };
        OurCombobox style = new OurCombobox(false, (Object[])DotStyle.values(), 110, 35, (Object)this.vizState.nodeStyle.get(null)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotStyle)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                return ((DotStyle)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.nodeStyle.put(null, (DotStyle)((Object)value));
            }
        };
        OurCheckbox vis = this.vizState.nodeVisible.pick("Show", "Show members of type as nodes");
        OurCheckbox hide = this.vizState.hideUnconnected.pick("Hide unconnected nodes", "Hide nodes without arcs");
        OurCheckbox num = this.vizState.number.pick("Number nodes", "Attach atom number to node label as suffix");
        OurCheckbox label = this.vizState.showAsLabel.pick("Show as labels", "Show members as labels");
        OurCheckbox attr = this.vizState.showAsAttr.pick("Show in relation attributes", "Show set membership of endpoints when relation attributes are enabled");
        parent.add(VizCustomizationPanel.makelabel(" Default Type and Set Settings:"));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 10, color, 7, style, 7, shape, 2, null}));
        JPanel a = OurUtil.makeVL((Object[])new Object[]{wcolor, vis, num, label});
        JPanel b = OurUtil.makeVL((Object[])new Object[]{wcolor, hide, attr});
        parent.add(OurUtil.makeHT((Object[])new Object[]{wcolor, 10, a, 10, b, 2, null}));
    }

    private void createDefaultEdgeWidget(JPanel parent) {
        OurCombobox colorComboE = new OurCombobox(false, DotColor.valuesWithout(DotColor.WHITE), 110, 35, (Object)this.vizState.edgeColor.get(null)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotColor)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                return ((DotColor)((Object)value)).getIcon(VizCustomizationPanel.this.vizState.getEdgePalette());
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.edgeColor.put(null, (DotColor)((Object)value));
            }
        };
        OurCombobox outlineComboE = new OurCombobox(false, (Object[])DotStyle.values(), 110, 35, (Object)this.vizState.edgeStyle.get(null)){
            private static final long serialVersionUID = 0L;

            public String do_getText(Object value) {
                return ((DotStyle)((Object)value)).getDisplayedText();
            }

            public Icon do_getIcon(Object value) {
                return ((DotStyle)((Object)value)).getIcon();
            }

            public void do_changed(Object value) {
                VizCustomizationPanel.this.vizState.edgeStyle.put(null, (DotStyle)((Object)value));
            }
        };
        OurCheckbox dispCBE = this.vizState.edgeVisible.pick("Show as arcs", "Show relations as arcs");
        OurCheckbox mergeCBE = this.vizState.mergeArrows.pick("Merge arrows", "Merge opposing arrows of the same relation");
        OurCheckbox constraintCBE = this.vizState.constraint.pick("Influence layout", "Whether this edge influences the graph layout");
        OurCheckbox attrCBE = this.vizState.attribute.pick("Show as attributes", "Show relations as attributes on nodes");
        OurCheckbox laybackCBE = this.vizState.layoutBack.pick("Layout backwards", "Layout graph as if arcs were reversed");
        parent.add(VizCustomizationPanel.makelabel(" Default Relation Settings:"));
        parent.add(OurUtil.makeH((Object[])new Object[]{wcolor, 10, colorComboE, 8, outlineComboE, 2, null}));
        JPanel a = OurUtil.makeVL((Object[])new Object[]{wcolor, dispCBE, attrCBE, constraintCBE, 10});
        JPanel b = OurUtil.makeVL((Object[])new Object[]{wcolor, laybackCBE, mergeCBE});
        parent.add(OurUtil.makeHT((Object[])new Object[]{wcolor, 10, a, 10, b, 2, null}));
    }

    private String typename(AlloyType type) {
        if (type.equals(AlloyType.UNIV)) {
            return "univ";
        }
        AlloyType sup = this.vizState.getOriginalModel().getSuperType(type);
        if (sup != null && !sup.equals(AlloyType.UNIV)) {
            return type.getName() + " extends " + sup.getName();
        }
        return type.getName();
    }

    private static JLabel makelabel(String label) {
        return OurUtil.label((String)label, (Object[])new Object[]{OurUtil.getVizFont().deriveFont(1)});
    }

    private void projectAlloyType(AlloyType type) {
        this.vizState.project(type);
        this.remakeAll();
    }

    private void deprojectAlloyType(AlloyType type) {
        this.vizState.deproject(type);
        this.remakeAll();
    }
}

