/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.A4Preferences;
import edu.mit.csail.sdg.alloy4.Computer;
import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.ConstSet;
import edu.mit.csail.sdg.alloy4.OurBorder;
import edu.mit.csail.sdg.alloy4.OurCheckbox;
import edu.mit.csail.sdg.alloy4.OurConsole;
import edu.mit.csail.sdg.alloy4.OurDialog;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4.Runner;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.alloy4graph.GraphViewer;
import edu.mit.csail.sdg.alloy4viz.AlloyInstance;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.MagicColor;
import edu.mit.csail.sdg.alloy4viz.MagicLayout;
import edu.mit.csail.sdg.alloy4viz.StaticInstanceReader;
import edu.mit.csail.sdg.alloy4viz.VizCustomizationPanel;
import edu.mit.csail.sdg.alloy4viz.VizGraphPanel;
import edu.mit.csail.sdg.alloy4viz.VizState;
import edu.mit.csail.sdg.alloy4viz.VizTree;
import edu.mit.csail.sdg.ast.Expr;
import edu.mit.csail.sdg.ast.ExprConstant;
import edu.mit.csail.sdg.ast.ExprVar;
import edu.mit.csail.sdg.ast.Sig;
import edu.mit.csail.sdg.translator.A4Solution;
import edu.mit.csail.sdg.translator.A4Tuple;
import edu.mit.csail.sdg.translator.A4TupleSet;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;

public final class VizGUI
implements ComponentListener {
    private static final Color background = new Color(0.9f, 0.9f, 0.9f);
    private static final Icon iconYes = OurUtil.loadIcon((String)"images/menu1.gif");
    private static final Icon iconNo = OurUtil.loadIcon((String)"images/menu0.gif");
    private final boolean standalone;
    private VisualizerMode currentMode = VisualizerMode.get();
    private final JFrame frame;
    private final JToolBar toolbar;
    private final JPopupMenu projectionPopup;
    private final JButton projectionButton;
    private final JButton openSettingsButton;
    private final JButton closeSettingsButton;
    private final JButton magicLayout;
    private final JButton loadSettingsButton;
    private final JButton saveSettingsButton;
    private final JButton saveAsSettingsButton;
    private final JButton resetSettingsButton;
    private final JButton updateSettingsButton;
    private final JButton openEvaluatorButton;
    private final JButton closeEvaluatorButton;
    private final JButton enumerateButton;
    private final JButton vizButton;
    private final JButton treeButton;
    private final JButton txtButton;
    private final JButton tableButton;
    private final JButton leftNavButton;
    private final JButton rightNavButton;
    private final JButton cnfgButton;
    private final JButton forkButton;
    private final JButton initButton;
    private final JButton pathButton;
    private final List<JButton> solutionButtons = new ArrayList<JButton>();
    private final JMenu thememenu;
    private final JMenu windowmenu;
    private final JMenuItem enumerateMenu;
    private final JMenuItem cnfgMenu;
    private final JMenuItem pathMenu;
    private final JMenuItem forkMenu;
    private final JMenuItem initMenu;
    private final JMenuItem rightNavMenu;
    private final JMenuItem leftNavMenu;
    private int fontSize = 12;
    private int settingsOpen = 0;
    private boolean seg_iteration = false;
    private List<VizState> myStates = new ArrayList<VizState>();
    private VizCustomizationPanel myCustomPanel = null;
    private OurConsole myEvaluatorPanel = null;
    private VizGraphPanel myGraphPanel = null;
    private JPanel mySplitTemporal = null;
    private final JSplitPane splitpane;
    private JComponent content = null;
    private int lastDividerPosition = 0;
    private final Computer evaluator;
    private final Computer enumerator;
    private final int statepanes;
    private String thmFileName = "";
    private String xmlFileName = "";
    private final List<String> xmlLoaded = new ArrayList<String>();
    private final List<String> thmLoaded = new ArrayList<String>();
    private Map<String, String> xml2title = new LinkedHashMap<String, String>();
    private static final A4Preferences.IntPref VizX = new A4Preferences.IntPref("VizX", 0, -1, 65535);
    private static final A4Preferences.IntPref VizY = new A4Preferences.IntPref("VizY", 0, -1, 65535);
    private static final A4Preferences.IntPref VizWidth = new A4Preferences.IntPref("VizWidth", 0, -1, 65535);
    private static final A4Preferences.IntPref VizHeight = new A4Preferences.IntPref("VizHeight", 0, -1, 65535);
    private static final A4Preferences.StringPref Theme0 = new A4Preferences.StringPref("Theme0");
    private static final A4Preferences.StringPref Theme1 = new A4Preferences.StringPref("Theme1");
    private static final A4Preferences.StringPref Theme2 = new A4Preferences.StringPref("Theme2");
    private static final A4Preferences.StringPref Theme3 = new A4Preferences.StringPref("Theme3");
    private boolean wrap = false;
    private int current = 0;
    private int lastParsed = -1;

    public List<VizState> getVizState() {
        return this.myStates;
    }

    public JSplitPane getPanel() {
        return this.splitpane;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public String getThemeFilename() {
        return this.thmFileName;
    }

    public String getXMLfilename() {
        return this.xmlFileName;
    }

    public ConstList<String> getInstances() {
        return ConstList.make(this.xmlLoaded);
    }

    public String getInstanceTitle(String xmlFileName) {
        String answer = this.xml2title.get(Util.canon((String)xmlFileName));
        return answer == null ? "(unknown)" : answer;
    }

    private void addDivider() {
        JPanel divider = OurUtil.makeH((Object[])new Object[]{new Dimension(1, 40), Color.LIGHT_GRAY});
        divider.setAlignmentY(0.5f);
        if (!Util.onMac()) {
            this.toolbar.add(OurUtil.makeH((Object[])new Object[]{5, background}));
        } else {
            this.toolbar.add(OurUtil.makeH((Object[])new Object[]{5}));
        }
        this.toolbar.add(divider);
        if (!Util.onMac()) {
            this.toolbar.add(OurUtil.makeH((Object[])new Object[]{5, background}));
        } else {
            this.toolbar.add(OurUtil.makeH((Object[])new Object[]{5}));
        }
    }

    private Runner wrapMe() {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            final String name = ex.getStackTrace()[1].getMethodName();
            Method[] methods = this.getClass().getDeclaredMethods();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                m = methods[i];
                break;
            }
            if (m == null) {
                throw new IllegalStateException("Missing method " + name);
            }
            final Method method = m;
            return new Runner(){
                private static final long serialVersionUID = 0L;

                public void run() {
                    try {
                        method.setAccessible(true);
                        method.invoke((Object)VizGUI.this, new Object[0]);
                    }
                    catch (Throwable ex2) {
                        IllegalArgumentException ex2 = new IllegalArgumentException("Failed call to " + name + "()", ex2);
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex2);
                    }
                }

                public void run(Object arg) {
                    this.run();
                }
            };
        }
    }

    private Runner wrapMe(final Object argument) {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            final String name = ex.getStackTrace()[1].getMethodName();
            Method[] methods = this.getClass().getDeclaredMethods();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                m = methods[i];
                break;
            }
            if (m == null) {
                throw new IllegalStateException("Missing method " + name);
            }
            final Method method = m;
            return new Runner(){
                private static final long serialVersionUID = 0L;

                public void run(Object arg) {
                    try {
                        method.setAccessible(true);
                        method.invoke((Object)VizGUI.this, arg);
                    }
                    catch (Throwable ex2) {
                        IllegalArgumentException ex2 = new IllegalArgumentException("Failed call to " + name + "(" + String.valueOf(arg) + ")", ex2);
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex2);
                    }
                }

                public void run() {
                    this.run(argument);
                }
            };
        }
    }

    public VizGUI(boolean standalone, String xmlFileName, JMenu windowmenu) {
        this(standalone, xmlFileName, windowmenu, null, null, 1);
    }

    public VizGUI(boolean standalone, String xmlFileName, JMenu windowmenu, Computer enumerator, Computer evaluator, int panes) {
        this(standalone, xmlFileName, windowmenu, enumerator, evaluator, true, panes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VizGUI(boolean standalone, String xmlFileName, JMenu windowmenu, Computer enumerator, Computer evaluator, boolean makeWindow, int panes) {
        int y;
        int x;
        int height;
        this.statepanes = panes == 0 ? 1 : panes;
        this.enumerator = enumerator;
        this.standalone = standalone;
        this.evaluator = evaluator;
        this.frame = makeWindow ? new JFrame("Alloy Visualizer") : null;
        int screenWidth = OurUtil.getScreenWidth();
        int screenHeight = OurUtil.getScreenHeight();
        int width = (Integer)VizWidth.get();
        if (width < 0) {
            width = screenWidth - 150;
        } else if (width < 100) {
            width = 100;
        }
        if (width > screenWidth) {
            width = screenWidth;
        }
        if ((height = ((Integer)VizHeight.get()).intValue()) < 0) {
            height = screenHeight - 150;
        } else if (height < 100) {
            height = 100;
        }
        if (height > screenHeight) {
            height = screenHeight;
        }
        if ((x = ((Integer)VizX.get()).intValue()) < 0 || x > screenWidth - 10) {
            x = 0;
        }
        if ((y = ((Integer)VizY.get()).intValue()) < 0 || y > screenHeight - 10) {
            y = 0;
        }
        JMenuBar mb = new JMenuBar();
        try {
            this.wrap = true;
            JMenu fileMenu = OurUtil.menu((JMenuBar)mb, (String)"&File", null);
            OurUtil.menuItem((JMenu)fileMenu, (String)"Open...", (Object[])new Object[]{Character.valueOf('O'), Character.valueOf('O'), this.doLoad()});
            JMenu exportMenu = OurUtil.menu(null, (String)"&Export To", null);
            OurUtil.menuItem((JMenu)exportMenu, (String)"Dot...", (Object[])new Object[]{Character.valueOf('D'), Character.valueOf('D'), this.doExportDot()});
            OurUtil.menuItem((JMenu)exportMenu, (String)"XML...", (Object[])new Object[]{Character.valueOf('X'), Character.valueOf('X'), this.doExportXml()});
            OurUtil.menuItem((JMenu)exportMenu, (String)"Predicate...", (Object[])new Object[]{Character.valueOf('P'), Character.valueOf('P'), this.doExportPred()});
            fileMenu.add(exportMenu);
            OurUtil.menuItem((JMenu)fileMenu, (String)"Close", (Object[])new Object[]{Character.valueOf('W'), Character.valueOf('W'), this.doClose()});
            if (standalone) {
                OurUtil.menuItem((JMenu)fileMenu, (String)"Quit", (Object[])new Object[]{Character.valueOf('Q'), Character.valueOf('Q'), this.doCloseAll()});
            } else {
                OurUtil.menuItem((JMenu)fileMenu, (String)"Close All", (char)'A', (Runnable)this.doCloseAll());
            }
            JMenu instanceMenu = OurUtil.menu((JMenuBar)mb, (String)"&Instance", null);
            this.enumerateMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show New Solution", (Object[])new Object[]{Character.valueOf('N'), Character.valueOf('N'), this.doNext()});
            this.cnfgMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show New Configuration", (Object[])new Object[]{Character.valueOf('C'), Character.valueOf('C'), this.doConfig()});
            this.pathMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show New Trace", (Object[])new Object[]{Character.valueOf('T'), Character.valueOf('T'), this.doPath()});
            this.initMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show New Initial State", (Object[])new Object[]{Character.valueOf('I'), Character.valueOf('I'), this.doInit()});
            this.forkMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show New Fork", (Object[])new Object[]{Character.valueOf('F'), Character.valueOf('F'), this.doFork()});
            this.leftNavMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show Previous State", (Object[])new Object[]{37, 37, this.doNavLeft()});
            this.rightNavMenu = OurUtil.menuItem((JMenu)instanceMenu, (String)"Show Next State", (Object[])new Object[]{39, 39, this.doNavRight()});
            this.thememenu = OurUtil.menu((JMenuBar)mb, (String)"&Theme", (Runnable)this.doRefreshTheme());
            if (standalone || windowmenu == null) {
                windowmenu = OurUtil.menu((JMenuBar)mb, (String)"&Window", (Runnable)this.doRefreshWindow());
            }
            this.windowmenu = windowmenu;
        }
        finally {
            this.wrap = false;
        }
        mb.add(windowmenu);
        this.thememenu.setEnabled(false);
        windowmenu.setEnabled(false);
        if (this.frame != null) {
            this.frame.setJMenuBar(mb);
        }
        this.projectionPopup = new JPopupMenu();
        this.projectionButton = new JButton("Projection: none");
        this.projectionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VizGUI.this.repopulateProjectionPopup();
                if (VizGUI.this.projectionPopup.getComponentCount() > 0) {
                    VizGUI.this.projectionPopup.show(VizGUI.this.projectionButton, 10, 10);
                }
            }
        });
        this.repopulateProjectionPopup();
        this.toolbar = new JToolBar();
        this.toolbar.setVisible(false);
        this.toolbar.setFloatable(false);
        this.toolbar.setBorder(null);
        if (!Util.onMac()) {
            this.toolbar.setBackground(background);
        }
        try {
            this.wrap = true;
            this.vizButton = this.makeSolutionButton("Viz", "Show Visualization", "images/24_graph.gif", (ActionListener)this.doShowViz());
            this.txtButton = this.makeSolutionButton("Txt", "Show the textual output for the Graph", "images/24_plaintext.gif", (ActionListener)this.doShowTxt());
            this.tableButton = this.makeSolutionButton("Table", "Show the table output for the Graph", "images/24_plaintext.gif", (ActionListener)this.doShowTable());
            this.treeButton = this.makeSolutionButton("Tree", "Show Tree", "images/24_texttree.gif", (ActionListener)this.doShowTree());
            if (this.frame != null) {
                this.addDivider();
            }
            this.closeSettingsButton = OurUtil.button((String)"Close", (String)"Close the theme customization panel", (String)"images/24_settings_close2.gif", (ActionListener)this.doCloseThemePanel());
            this.toolbar.add(this.closeSettingsButton);
            this.updateSettingsButton = OurUtil.button((String)"Apply", (String)"Apply the changes to the current theme", (String)"images/24_settings_apply2.gif", (ActionListener)this.doApply());
            this.toolbar.add(this.updateSettingsButton);
            this.openSettingsButton = OurUtil.button((String)"Theme", (String)"Open the theme customization panel", (String)"images/24_settings.gif", (ActionListener)this.doOpenThemePanel());
            this.toolbar.add(this.openSettingsButton);
            this.magicLayout = OurUtil.button((String)"Magic Layout", (String)"Automatic theme customization (will reset current theme)", (String)"images/24_settings_apply2.gif", (ActionListener)this.doMagicLayout());
            this.toolbar.add(this.magicLayout);
            this.openEvaluatorButton = OurUtil.button((String)"Evaluator", (String)"Open the evaluator", (String)"images/24_settings.gif", (ActionListener)this.doOpenEvalPanel());
            this.toolbar.add(this.openEvaluatorButton);
            this.closeEvaluatorButton = OurUtil.button((String)"Close Evaluator", (String)"Close the evaluator", (String)"images/24_settings_close2.gif", (ActionListener)this.doCloseEvalPanel());
            this.toolbar.add(this.closeEvaluatorButton);
            this.enumerateButton = OurUtil.button((String)"New", (String)"Show a new solution", (String)"images/24_history.gif", (ActionListener)this.doNext());
            this.toolbar.add(this.enumerateButton);
            this.cnfgButton = OurUtil.button((String)"New Config", (String)"Show a new configuration", (String)"images/24_history.gif", (ActionListener)this.doConfig());
            this.toolbar.add(this.cnfgButton);
            this.pathButton = OurUtil.button((String)"New Trace", (String)"Show a new trace", (String)"images/24_history.gif", (ActionListener)this.doPath());
            this.toolbar.add(this.pathButton);
            this.initButton = OurUtil.button((String)"New Init", (String)"Show a new initial state", (String)"images/24_history.gif", (ActionListener)this.doInit());
            this.toolbar.add(this.initButton);
            this.forkButton = OurUtil.button((String)"New Fork", (String)"Show a new fork", (String)"images/24_history.gif", (ActionListener)this.doFork());
            this.toolbar.add(this.forkButton);
            this.leftNavButton = OurUtil.button((String)new String(Character.toChars(8592)), (String)"Show the previous state", (String)"images/24_history.gif", (ActionListener)this.doNavLeft());
            this.toolbar.add(this.leftNavButton);
            this.rightNavButton = OurUtil.button((String)new String(Character.toChars(8594)), (String)"Show the next state", (String)"images/24_history.gif", (ActionListener)this.doNavRight());
            this.toolbar.add(this.rightNavButton);
            this.toolbar.add(this.projectionButton);
            this.loadSettingsButton = OurUtil.button((String)"Load", (String)"Load the theme customization from a theme file", (String)"images/24_open.gif", (ActionListener)this.doLoadTheme());
            this.toolbar.add(this.loadSettingsButton);
            this.saveSettingsButton = OurUtil.button((String)"Save", (String)"Save the current theme customization", (String)"images/24_save.gif", (ActionListener)this.doSaveTheme());
            this.toolbar.add(this.saveSettingsButton);
            this.saveAsSettingsButton = OurUtil.button((String)"Save As", (String)"Save the current theme customization as a new theme file", (String)"images/24_save.gif", (ActionListener)this.doSaveThemeAs());
            this.toolbar.add(this.saveAsSettingsButton);
            this.resetSettingsButton = OurUtil.button((String)"Reset", (String)"Reset the theme customization", (String)"images/24_settings_close2.gif", (ActionListener)this.doResetTheme());
            this.toolbar.add(this.resetSettingsButton);
        }
        finally {
            this.wrap = false;
        }
        this.settingsOpen = 0;
        this.splitpane = new JSplitPane(1);
        this.splitpane.setOneTouchExpandable(false);
        this.splitpane.setResizeWeight(0.0);
        this.splitpane.setContinuousLayout(true);
        this.splitpane.setBorder(null);
        ((BasicSplitPaneUI)this.splitpane.getUI()).getDivider().setBorder((Border)new OurBorder(false, true, false, false));
        if (this.frame != null) {
            this.frame.pack();
            if (!Util.onMac() && !Util.onWindows()) {
                if (x < 30) {
                    if (x < 0) {
                        x = 0;
                    }
                    width -= 30 - x;
                    x = 30;
                }
                if (y < 30) {
                    if (y < 0) {
                        y = 0;
                    }
                    height -= 30 - y;
                    y = 30;
                }
                if (width < 100) {
                    width = 100;
                }
                if (height < 100) {
                    height = 100;
                }
            }
            this.frame.setSize(width, height);
            this.frame.setLocation(x, y);
            this.frame.setDefaultCloseOperation(0);
            try {
                this.wrap = true;
                this.frame.addWindowListener((WindowListener)this.doClose());
            }
            finally {
                this.wrap = false;
            }
            this.frame.addComponentListener(this);
        }
        if (xmlFileName.length() > 0) {
            this.doLoadInstance(xmlFileName);
        }
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.componentMoved(e);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        if (this.frame != null) {
            VizWidth.set((Object)this.frame.getWidth());
            VizHeight.set((Object)this.frame.getHeight());
            VizX.set((Object)this.frame.getX());
            VizY.set((Object)this.frame.getY());
        }
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private void repopulateProjectionPopup() {
        int num = 0;
        Object label = "Projection: none";
        if (this.myStates.isEmpty()) {
            this.projectionButton.setEnabled(false);
            return;
        }
        this.projectionButton.setEnabled(true);
        this.projectionPopup.removeAll();
        VizState myState = this.myStates.get(0);
        ConstSet<AlloyType> projected = myState.getProjectedTypes();
        for (final AlloyType t : myState.getOriginalModel().getTypes()) {
            if (!myState.canProject(t)) continue;
            final boolean on = projected.contains(t);
            JMenuItem m = new JMenuItem(t.getName(), on ? OurCheckbox.ON : OurCheckbox.OFF);
            m.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (VizState myState : VizGUI.this.myStates) {
                        if (on) {
                            myState.deproject(t);
                            continue;
                        }
                        myState.project(t);
                    }
                    VizGUI.this.updateDisplay();
                }
            });
            this.projectionPopup.add(m);
            if (!on || ++num != 1) continue;
            label = "Projected over " + t.getName();
        }
        this.projectionButton.setText((String)(num > 1 ? "Projected over " + num + " sigs" : label));
    }

    private void updateDisplay() {
        int numPanes;
        if (this.myStates.isEmpty()) {
            return;
        }
        this.currentMode.set();
        for (JButton button : this.solutionButtons) {
            button.setEnabled(this.settingsOpen != 1);
        }
        switch (this.currentMode) {
            case Tree: {
                this.treeButton.setEnabled(false);
                break;
            }
            case TEXT: {
                this.txtButton.setEnabled(false);
                break;
            }
            case TABLE: {
                this.tableButton.setEnabled(false);
                break;
            }
            default: {
                this.vizButton.setEnabled(false);
            }
        }
        AlloyInstance oInst = this.myStates.get(0).getOriginalInstance();
        boolean isMeta = oInst.isMetamodel;
        boolean isTrace = oInst.originalA4.getMaxTrace() >= 0;
        boolean hasConfigs = oInst.originalA4.hasConfigs();
        this.vizButton.setVisible(this.frame != null);
        this.treeButton.setVisible(this.frame != null);
        this.txtButton.setVisible(this.frame != null);
        this.magicLayout.setVisible((this.settingsOpen == 0 || this.settingsOpen == 1) && this.currentMode == VisualizerMode.Viz);
        this.projectionButton.setVisible((this.settingsOpen == 0 || this.settingsOpen == 1) && this.currentMode == VisualizerMode.Viz);
        this.openSettingsButton.setVisible(this.settingsOpen == 0 && this.currentMode == VisualizerMode.Viz);
        this.loadSettingsButton.setVisible(this.frame == null && this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.saveSettingsButton.setVisible(this.frame == null && this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.saveAsSettingsButton.setVisible(this.frame == null && this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.resetSettingsButton.setVisible(this.frame == null && this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.closeSettingsButton.setVisible(this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.updateSettingsButton.setVisible(this.settingsOpen == 1 && this.currentMode == VisualizerMode.Viz);
        this.openEvaluatorButton.setVisible(!isMeta && this.settingsOpen == 0 && this.evaluator != null);
        this.closeEvaluatorButton.setVisible(!isMeta && this.settingsOpen == 2 && this.evaluator != null);
        this.enumerateMenu.setEnabled(!isMeta && this.settingsOpen == 0 && this.enumerator != null);
        this.enumerateMenu.setVisible(!isTrace);
        this.enumerateButton.setVisible(!isMeta && this.settingsOpen == 0 && this.enumerator != null && !isTrace);
        this.initMenu.setEnabled(!isMeta && this.settingsOpen == 0 && this.enumerator != null);
        this.initMenu.setVisible(isTrace);
        this.initButton.setVisible(!isMeta && this.settingsOpen == 0 && this.enumerator != null && isTrace);
        this.pathMenu.setEnabled(!isMeta && this.settingsOpen == 0 && this.enumerator != null && !this.seg_iteration);
        this.pathMenu.setVisible(isTrace);
        this.pathButton.setVisible(!isMeta && this.settingsOpen == 0 && this.enumerator != null && isTrace);
        this.pathButton.setEnabled(!this.seg_iteration);
        this.cnfgMenu.setEnabled(!isMeta && this.settingsOpen == 0 && this.enumerator != null && hasConfigs);
        this.cnfgMenu.setVisible(isTrace);
        this.cnfgButton.setVisible(!isMeta && this.settingsOpen == 0 && this.enumerator != null && isTrace);
        this.cnfgButton.setEnabled(hasConfigs);
        this.forkMenu.setEnabled(!isMeta && this.settingsOpen == 0 && this.enumerator != null);
        this.forkMenu.setVisible(isTrace);
        this.forkButton.setVisible(!isMeta && this.settingsOpen == 0 && this.enumerator != null && isTrace);
        this.leftNavButton.setVisible(!isMeta && isTrace);
        this.leftNavButton.setEnabled(this.current > 0);
        this.leftNavMenu.setEnabled(!isMeta && this.current > 0);
        this.leftNavMenu.setVisible(isTrace);
        this.leftNavButton.setText(new String(this.current > 0 ? Character.toChars(8592) : Character.toChars(8676)));
        this.rightNavButton.setVisible(!isMeta && isTrace);
        this.rightNavMenu.setEnabled(!isMeta);
        this.rightNavMenu.setVisible(isTrace);
        this.toolbar.setVisible(true);
        if (this.frame != null) {
            this.frame.setTitle(this.makeVizTitle());
        }
        int n = numPanes = isTrace && !isMeta ? this.statepanes : 1;
        if (this.current != this.lastParsed) {
            for (int i = 0; i < this.getVizState().size(); ++i) {
                File f = new File(this.getXMLfilename());
                try {
                    if (!f.exists()) {
                        throw new IOException("File " + this.getXMLfilename() + " does not exist.");
                    }
                    if (this.current + i < 0) {
                        this.getVizState().set(i, null);
                        continue;
                    }
                    AlloyInstance myInstance = StaticInstanceReader.parseInstance(f, this.current + i);
                    if (this.getVizState().get(i) != null) {
                        this.getVizState().get(i).loadInstance(myInstance);
                        continue;
                    }
                    this.getVizState().set(i, new VizState(this.getVizState().get(this.getVizState().size() - 1)));
                    this.getVizState().get(i).loadInstance(myInstance);
                    continue;
                }
                catch (Throwable e) {
                    OurDialog.alert((JFrame)this.frame, (Object)("Cannot read or parse Alloy instance: " + this.xmlFileName + "\n\nError: " + e.getMessage()));
                    this.doCloseAll();
                    return;
                }
            }
            this.lastParsed = this.current;
        }
        switch (this.currentMode) {
            case Tree: {
                final VizTree t = new VizTree(this.myStates.get((int)0).getOriginalInstance().originalA4, this.makeVizTitle(), this.fontSize, this.current);
                JScrollPane scroll = OurUtil.scrollpane((Component)((Object)t), (Object[])new Object[]{Color.BLACK, Color.WHITE, new OurBorder(true, false, true, false)});
                scroll.addFocusListener(new FocusListener(){

                    @Override
                    public final void focusGained(FocusEvent e) {
                        t.requestFocusInWindow();
                    }

                    @Override
                    public final void focusLost(FocusEvent e) {
                    }
                });
                this.content = scroll;
                break;
            }
            case TEXT: {
                List<String> textualOutput = IntStream.range(this.current, this.current + numPanes).mapToObj(x -> this.myStates.get((int)0).getOriginalInstance().originalA4.toString(x)).collect(Collectors.toList());
                this.content = this.getTextComponent(textualOutput, true);
                break;
            }
            case TABLE: {
                List<String> textualOutput = IntStream.range(this.current, this.current + numPanes).mapToObj(x -> this.myStates.get((int)0).getOriginalInstance().originalA4.format(x)).collect(Collectors.toList());
                this.content = this.getTextComponent(textualOutput, false);
                break;
            }
            default: {
                if (this.myGraphPanel == null || numPanes != this.myGraphPanel.numPanels()) {
                    this.myGraphPanel = new VizGraphPanel(this.frame, this.myStates, false);
                }
                this.myGraphPanel.seeDot(this.frame, false);
                this.myGraphPanel.remakeAll(this.frame);
                this.content = this.myGraphPanel;
            }
        }
        if (isTrace && !isMeta) {
            JComponent aux = this.content;
            JPanel tmpNavScrollPanel = new JPanel();
            tmpNavScrollPanel.setLayout(new BoxLayout(tmpNavScrollPanel, 3));
            tmpNavScrollPanel.add(this.traceGraph());
            Box instanceTopBox = Box.createVerticalBox();
            instanceTopBox.add(tmpNavScrollPanel);
            this.content = new JPanel(new BorderLayout());
            this.content.add((Component)instanceTopBox, "North");
            this.content.add((Component)aux, "Center");
            this.content.setVisible(true);
        }
        if (this.currentMode != VisualizerMode.Tree) {
            this.content.setFont(OurUtil.getVizFont().deriveFont((float)this.fontSize));
            this.content.invalidate();
            this.content.repaint();
            this.content.validate();
        }
        Box instanceTopBox = Box.createHorizontalBox();
        instanceTopBox.add(this.toolbar);
        JPanel instanceArea = new JPanel(new BorderLayout());
        instanceArea.add((Component)instanceTopBox, "North");
        instanceArea.add((Component)this.content, "Center");
        instanceArea.setVisible(true);
        if (!Util.onMac()) {
            instanceTopBox.setBackground(background);
            instanceArea.setBackground(background);
        }
        VizCustomizationPanel left = null;
        if (this.settingsOpen == 1) {
            if (this.myCustomPanel == null) {
                this.myCustomPanel = new VizCustomizationPanel(this.splitpane, this.myStates.get(0));
            } else {
                this.myCustomPanel.remakeAll();
            }
            left = this.myCustomPanel;
        } else if (this.settingsOpen > 1) {
            if (this.myEvaluatorPanel == null) {
                this.myEvaluatorPanel = new OurConsole(this.evaluator, true, new Object[]{"The ", true, "Alloy Evaluator ", false, "allows you to type in Alloy expressions and see their values.\nFor example, ", true, "univ", false, " shows the list of all atoms.\nIf inspecting a trace, evaluation is performed on the currently focused state (left-hand side).\n(You can press UP and DOWN to recall old inputs).\n"});
            }
            try {
                this.evaluator.compute((Object)new File(this.xmlFileName));
                this.myEvaluatorPanel.setCurrentState(this.current);
            }
            catch (Exception exception) {
                // empty catch block
            }
            left = this.myEvaluatorPanel;
            left.setBorder((Border)new OurBorder(false, false, false, false));
        }
        if (this.frame != null && this.frame.getContentPane() == this.splitpane) {
            this.lastDividerPosition = this.splitpane.getDividerLocation();
        }
        this.splitpane.setRightComponent(instanceArea);
        this.splitpane.setLeftComponent(left);
        if (left != null) {
            Dimension dim = left.getPreferredSize();
            if (this.lastDividerPosition < 50 && this.frame != null) {
                this.lastDividerPosition = this.frame.getWidth() / 2;
            }
            if (this.lastDividerPosition < dim.width) {
                this.lastDividerPosition = dim.width;
            }
            if (this.settingsOpen == 2 && this.lastDividerPosition > 400) {
                this.lastDividerPosition = 400;
            }
            this.splitpane.setDividerLocation(this.lastDividerPosition);
        }
        if (this.frame != null) {
            this.frame.setContentPane(this.splitpane);
        }
        if (this.settingsOpen != 2) {
            this.content.requestFocusInWindow();
        } else {
            this.myEvaluatorPanel.requestFocusInWindow();
        }
        this.repopulateProjectionPopup();
        if (this.frame != null) {
            this.frame.validate();
        } else {
            this.splitpane.validate();
        }
    }

    private JButton makeSolutionButton(String label, String toolTip, String image, ActionListener mode) {
        JButton button = OurUtil.button((String)label, (String)toolTip, (String)image, (ActionListener)mode);
        this.solutionButtons.add(button);
        this.toolbar.add(button);
        return button;
    }

    private String makeVizTitle() {
        int n;
        String filename = !this.myStates.isEmpty() ? this.myStates.get((int)0).getOriginalInstance().filename : "";
        String commandname = !this.myStates.isEmpty() ? this.myStates.get((int)0).getOriginalInstance().commandname : "";
        int i = filename.lastIndexOf(47);
        if (i >= 0) {
            filename = filename.substring(i + 1);
        }
        if ((i = filename.lastIndexOf(92)) >= 0) {
            filename = filename.substring(i + 1);
        }
        if ((n = filename.length()) > 4 && filename.substring(n - 4).equalsIgnoreCase(".als")) {
            filename = filename.substring(0, n - 4);
        }
        if (filename.length() > 0) {
            return "(" + filename + ") " + commandname;
        }
        return commandname;
    }

    private void addThemeHistory(String filename) {
        String name0 = (String)Theme0.get();
        String name1 = (String)Theme1.get();
        String name2 = (String)Theme2.get();
        if (name0.equals(filename)) {
            return;
        }
        Theme0.set((Object)filename);
        Theme1.set((Object)name0);
        if (name1.equals(filename)) {
            return;
        }
        Theme2.set((Object)name1);
        if (name2.equals(filename)) {
            return;
        }
        Theme3.set((Object)name2);
    }

    private JComponent getTextComponent(List<String> texts, boolean wrap) {
        JPanel diagramsScrollPanels = new JPanel();
        diagramsScrollPanels.setLayout(new BoxLayout(diagramsScrollPanels, 2));
        for (int i = 0; i < texts.size(); ++i) {
            JTextArea ta = OurUtil.textarea((String)texts.get(i), (int)10, (int)10, (boolean)false, (boolean)wrap, (Object[])new Object[0]);
            try {
                List<Object> dfs = new ArrayList();
                if (i != 0) {
                    dfs = VizGUI.findDiffs(texts.get(i - 1), texts.get(i), this.currentMode);
                }
                Highlighter highlighter = ta.getHighlighter();
                DefaultHighlighter.DefaultHighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
                for (Map.Entry df : dfs) {
                    highlighter.addHighlight((Integer)df.getKey(), (Integer)df.getKey() + (Integer)df.getValue(), painter);
                }
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            JScrollPane ans = new JScrollPane(ta, 20, 30){
                private static final long serialVersionUID = 0L;

                @Override
                public void setFont(Font font) {
                    super.setFont(font);
                }
            };
            ans.setBorder((Border)new OurBorder(true, false, true, false));
            String fontName = OurDialog.getProperFontName((String)"Lucida Console", (String[])new String[]{"Monospaced"});
            Font font = new Font(fontName, 0, this.fontSize);
            ans.setFont(font);
            ta.setFont(font);
            JScrollPane diagramScrollPanel = OurUtil.scrollpane((Component)ans, (Object[])new Object[]{new OurBorder(true, true, true, false)});
            diagramsScrollPanels.add(diagramScrollPanel);
        }
        return diagramsScrollPanels;
    }

    private static List<Map.Entry<Integer, Integer>> findDiffs(String s1, String s2, VisualizerMode currentMode) {
        ArrayList<Map.Entry<Integer, Integer>> res = new ArrayList<Map.Entry<Integer, Integer>>();
        String delim = currentMode == VisualizerMode.TABLE ? "\n\n" : "\n";
        HashSet<String> cs1 = new HashSet<String>(Arrays.asList(s1.split(delim)));
        HashSet<String> cs2 = new HashSet<String>(Arrays.asList(s2.split(delim)));
        for (String c : cs2) {
            if (cs1.contains(c)) continue;
            res.add(new AbstractMap.SimpleEntry<Integer, Integer>(s2.indexOf(c), c.length()));
        }
        return res;
    }

    public GraphViewer getViewer() {
        if (null == this.myGraphPanel) {
            return null;
        }
        return this.myGraphPanel.alloyGetViewer();
    }

    public void noNewInstance() {
        this.updateDisplay();
    }

    public void loadXML(String fileName, boolean forcefully) {
        this.loadXML(fileName, forcefully, this.current);
    }

    public void loadXML(String fileName, boolean forcefully, int state) {
        this.current = state;
        String xmlFileName = Util.canon((String)fileName);
        File f = new File(xmlFileName);
        if (!forcefully) {
            this.seg_iteration = false;
        }
        if (forcefully || !xmlFileName.equals(this.xmlFileName)) {
            try {
                if (!f.exists()) {
                    throw new IOException("File " + xmlFileName + " does not exist.");
                }
                for (int i = 0; i < this.statepanes; ++i) {
                    boolean isTrace;
                    if (i >= this.myStates.size()) {
                        AlloyInstance myInstance = StaticInstanceReader.parseInstance(f, state + i);
                        this.myStates.add(new VizState(myInstance));
                    } else {
                        VizState vstate = this.myStates.get(i);
                        AlloyInstance myInstance = StaticInstanceReader.parseInstance(f, state + i);
                        if (vstate == null) {
                            vstate = new VizState(myInstance);
                        } else {
                            vstate.loadInstance(myInstance);
                        }
                        this.myStates.set(i, vstate);
                    }
                    boolean isMeta = this.myStates.get((int)i).getOriginalInstance().isMetamodel;
                    boolean bl = isTrace = this.myStates.get((int)i).getOriginalInstance().originalA4.getMaxTrace() >= 0;
                    if (isTrace && !isMeta) continue;
                    this.myStates.retainAll(Arrays.asList(this.myStates.get(0)));
                    break;
                }
            }
            catch (Throwable e) {
                this.xmlLoaded.remove(fileName);
                this.xmlLoaded.remove(xmlFileName);
                OurDialog.alert((JFrame)this.frame, (Object)("Cannot read or parse Alloy instance: " + xmlFileName + "\n\nError: " + e.getMessage()));
                if (this.xmlLoaded.size() > 0) {
                    this.loadXML(this.xmlLoaded.get(this.xmlLoaded.size() - 1), false, state);
                    return;
                }
                this.doCloseAll();
                return;
            }
            this.repopulateProjectionPopup();
            this.xml2title.put(xmlFileName, this.makeVizTitle());
            this.xmlFileName = xmlFileName;
        }
        if (!this.xmlLoaded.contains(xmlFileName)) {
            this.xmlLoaded.add(xmlFileName);
        }
        if (this.myGraphPanel != null) {
            this.myGraphPanel.resetProjectionAtomCombos();
        }
        this.toolbar.setEnabled(true);
        this.settingsOpen = 0;
        this.thememenu.setEnabled(true);
        this.windowmenu.setEnabled(true);
        if (this.frame != null) {
            this.frame.setVisible(true);
            this.frame.setTitle("Alloy Visualizer " + Version.version() + " loading... Please wait...");
            OurUtil.show((JFrame)this.frame);
        }
        this.lastParsed = this.current;
        this.updateDisplay();
    }

    public boolean loadThemeFile(String filename) {
        if (this.myStates.isEmpty()) {
            return false;
        }
        filename = Util.canon((String)filename);
        try {
            for (VizState myState : this.myStates) {
                myState.loadPaletteXML(filename);
            }
        }
        catch (IOException ex) {
            OurDialog.alert((JFrame)this.frame, (Object)("Error: " + ex.getMessage()));
            return false;
        }
        this.repopulateProjectionPopup();
        if (this.myCustomPanel != null) {
            this.myCustomPanel.remakeAll();
        }
        if (this.myGraphPanel != null) {
            this.myGraphPanel.remakeAll(this.frame);
        }
        this.addThemeHistory(filename);
        this.thmFileName = filename;
        this.updateDisplay();
        return true;
    }

    public boolean saveThemeFile(String filename) {
        if (this.myStates.isEmpty()) {
            return false;
        }
        if (filename == null) {
            File file = OurDialog.askFile((Frame)this.frame, (boolean)false, null, (String)".thm", (String)".thm theme files");
            if (file == null) {
                return false;
            }
            if (file.exists() && !OurDialog.askOverwrite((JFrame)this.frame, (String)Util.canon((String)file.getPath()))) {
                return false;
            }
            Util.setCurrentDirectory((File)file.getParentFile());
            filename = file.getPath();
        }
        filename = Util.canon((String)filename);
        try {
            this.myStates.get(0).savePaletteXML(filename);
            filename = Util.canon((String)filename);
            this.addThemeHistory(filename);
        }
        catch (Throwable er) {
            OurDialog.alert((JFrame)this.frame, (Object)("Error saving the theme.\n\nError: " + er.getMessage()));
            return false;
        }
        this.thmFileName = filename;
        return true;
    }

    public void doSetFontSize(int fontSize) {
        this.fontSize = fontSize;
        if (!(this.content instanceof VizGraphPanel)) {
            this.updateDisplay();
        } else {
            this.content.setFont(OurUtil.getVizFont().deriveFont((float)fontSize));
        }
    }

    private Runner doLoad() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)true, null, (String)".xml", (String)".xml instance files");
        if (file == null) {
            return null;
        }
        Util.setCurrentDirectory((File)file.getParentFile());
        this.loadXML(file.getPath(), true, 0);
        return null;
    }

    private Runner doLoadInstance(String fileName) {
        if (!this.wrap) {
            this.loadXML(fileName, false);
        }
        return this.wrapMe(fileName);
    }

    private Runner doClose() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.xmlLoaded.remove(this.xmlFileName);
        if (this.xmlLoaded.size() > 0) {
            this.doLoadInstance(this.xmlLoaded.get(this.xmlLoaded.size() - 1));
            return null;
        }
        if (this.standalone) {
            System.exit(0);
        } else if (this.frame != null) {
            this.frame.setVisible(false);
        }
        return null;
    }

    private Runner doCloseAll() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.xmlLoaded.clear();
        this.xmlFileName = "";
        if (this.standalone) {
            System.exit(0);
        } else if (this.frame != null) {
            this.frame.setVisible(false);
        }
        return null;
    }

    private Runner doRefreshTheme() {
        if (this.wrap) {
            return this.wrapMe();
        }
        String defaultTheme = System.getProperty("alloy.theme0");
        this.thememenu.removeAll();
        try {
            this.wrap = true;
            OurUtil.menuItem((JMenu)this.thememenu, (String)"Load Theme...", (char)'L', (Runnable)this.doLoadTheme());
            if (defaultTheme != null && defaultTheme.length() > 0 && new File(defaultTheme).isDirectory()) {
                OurUtil.menuItem((JMenu)this.thememenu, (String)"Load Sample Theme...", (char)'B', (Runnable)this.doLoadSampleTheme());
            }
            OurUtil.menuItem((JMenu)this.thememenu, (String)"Save Theme", (char)'S', (Runnable)this.doSaveTheme());
            OurUtil.menuItem((JMenu)this.thememenu, (String)"Save Theme As...", (char)'A', (Runnable)this.doSaveThemeAs());
            OurUtil.menuItem((JMenu)this.thememenu, (String)"Reset Theme", (char)'R', (Runnable)this.doResetTheme());
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doLoadTheme() {
        if (this.wrap) {
            return this.wrapMe();
        }
        String defaultTheme = System.getProperty("alloy.theme0");
        if (defaultTheme == null) {
            defaultTheme = "";
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        for (VizState myState : this.myStates) {
            if (!myState.changedSinceLastSave()) continue;
            char opt = OurDialog.askSaveDiscardCancel((JFrame)this.frame, (String)"The current theme");
            if (opt == 'c') {
                return null;
            }
            if (opt != 's' || this.saveThemeFile(this.thmFileName.length() == 0 ? null : this.thmFileName)) continue;
            return null;
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)true, null, (String)".thm", (String)".thm theme files");
        if (file != null) {
            Util.setCurrentDirectory((File)file.getParentFile());
            this.loadThemeFile(file.getPath());
        }
        return null;
    }

    private Runner doLoadSampleTheme() {
        if (this.wrap) {
            return this.wrapMe();
        }
        String defaultTheme = System.getProperty("alloy.theme0");
        if (defaultTheme == null) {
            defaultTheme = "";
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        for (VizState myState : this.myStates) {
            if (!myState.changedSinceLastSave()) continue;
            char opt = OurDialog.askSaveDiscardCancel((JFrame)this.frame, (String)"The current theme");
            if (opt == 'c') {
                return null;
            }
            if (opt != 's' || this.saveThemeFile(this.thmFileName.length() == 0 ? null : this.thmFileName)) continue;
            return null;
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)true, (String)defaultTheme, (String)".thm", (String)".thm theme files");
        if (file != null) {
            this.loadThemeFile(file.getPath());
        }
        return null;
    }

    private Runner doSaveTheme() {
        if (!this.wrap) {
            this.saveThemeFile(this.thmFileName.length() == 0 ? null : this.thmFileName);
        }
        return this.wrapMe();
    }

    private Runner doSaveThemeAs() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)false, null, (String)".thm", (String)".thm theme files");
        if (file == null) {
            return null;
        }
        if (file.exists() && !OurDialog.askOverwrite((JFrame)this.frame, (String)Util.canon((String)file.getPath()))) {
            return null;
        }
        Util.setCurrentDirectory((File)file.getParentFile());
        this.saveThemeFile(file.getPath());
        return null;
    }

    private Runner doExportDot() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)false, null, (String)".dot", (String)".dot graph files");
        if (file == null) {
            return null;
        }
        if (file.exists() && !OurDialog.askOverwrite((JFrame)this.frame, (String)Util.canon((String)file.getPath()))) {
            return null;
        }
        Util.setCurrentDirectory((File)file.getParentFile());
        String filename = Util.canon((String)file.getPath());
        try {
            Util.writeAll((String)filename, (String)this.myGraphPanel.toDot(this.frame));
        }
        catch (Throwable er) {
            OurDialog.alert((JFrame)this.frame, (Object)("Error saving the theme.\n\nError: " + er.getMessage()));
        }
        return null;
    }

    private Runner doExportXml() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = OurDialog.askFile((Frame)this.frame, (boolean)false, null, (String)".xml", (String)".xml XML files");
        if (file == null) {
            return null;
        }
        if (file.exists() && !OurDialog.askOverwrite((JFrame)this.frame, (String)Util.canon((String)file.getPath()))) {
            return null;
        }
        Util.setCurrentDirectory((File)file.getParentFile());
        String filename = Util.canon((String)file.getPath());
        try {
            Util.writeAll((String)filename, (String)Util.readAll((String)this.xmlFileName));
        }
        catch (Throwable er) {
            OurDialog.alert((JFrame)this.frame, (Object)("Error saving XML instance.\n\nError: " + er.getMessage()));
        }
        return null;
    }

    private Expr tupleToExpr(A4TupleSet ts, Map<String, ExprVar> reifs) {
        Expr tupleset = null;
        for (A4Tuple t : ts) {
            Expr tuple = null;
            for (int ai = 0; ai < t.arity(); ++ai) {
                Expr atom = t.atom(ai).matches("-?\\d+") ? ExprConstant.makeNUMBER((int)Integer.valueOf(t.atom(ai))) : (Expr)reifs.computeIfAbsent("_" + t.atom(ai).replace("$", "").replace("/", "_"), k -> ExprVar.make(null, (String)k));
                tuple = tuple == null ? atom : tuple.product(atom);
            }
            tupleset = tupleset == null ? tuple : tupleset.plus(tuple);
        }
        if (tupleset == null) {
            tupleset = ExprConstant.EMPTYNESS;
            for (int ai = 0; ai < ts.arity() - 1; ++ai) {
                tupleset = tupleset.product(ExprConstant.EMPTYNESS);
            }
        }
        return tupleset;
    }

    /*
     * WARNING - void declaration
     */
    private Runner doExportPred() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        HashMap<String, ExprVar> reifs = new HashMap<String, ExprVar>();
        A4Solution inst = this.myStates.get((int)(this.myStates.size() - 1)).getOriginalInstance().originalA4;
        StringJoiner config = new StringJoiner("\n  ");
        config.add("// configuration");
        for (Sig s : inst.getAllReachableSigs()) {
            if (s.isPrivate == null && s.isVariable == null && !s.equals((Object)Sig.UNIV) && !s.equals((Object)Sig.NONE)) {
                Iterator ts = inst.eval(s);
                config.add(s.equal(this.tupleToExpr((A4TupleSet)ts, reifs)).toString());
            }
            for (Object f : s.getFields()) {
                if (((Sig.Field)f).isPrivate != null || ((Sig.Field)f).isVariable != null) continue;
                A4TupleSet a4TupleSet = inst.eval((Sig.Field)f);
                config.add(f.equal(this.tupleToExpr(a4TupleSet, reifs)).toString());
            }
        }
        ArrayList<CallSite> states = new ArrayList<CallSite>();
        if (inst.getMaxTrace() > 0) {
            for (int i = 0; i < inst.getTraceLength(); ++i) {
                StringJoiner state = new StringJoiner("\n  ");
                for (Sig sig : inst.getAllReachableSigs()) {
                    if (sig.isPrivate == null && (sig.isVariable != null || sig.equals((Object)Sig.UNIV))) {
                        Iterator ts = inst.eval(sig, i);
                        state.add(sig.equal(this.tupleToExpr((A4TupleSet)ts, reifs)).toString());
                    }
                    for (Sig.Field f : sig.getFields()) {
                        if (f.isPrivate != null || f.isVariable == null) continue;
                        A4TupleSet ts = inst.eval(f, i);
                        state.add(f.equal(this.tupleToExpr(ts, reifs)).toString());
                    }
                }
                states.add((CallSite)((Object)("{\n  // state " + i + "\n  " + state.toString() + "\n  }")));
            }
        } else {
            A4TupleSet ts = inst.eval((Sig)Sig.UNIV);
            config.add(Sig.UNIV.equal(this.tupleToExpr(ts, reifs)).toString());
        }
        StringBuilder sb = new StringBuilder();
        if (!reifs.isEmpty()) {
            void var8_17;
            sb.append("some disj ");
            StringJoiner sj = new StringJoiner(",");
            for (ExprVar exprVar : reifs.values()) {
                sj.add(exprVar.toString());
            }
            sb.append(sj.toString());
            sb.append(" : ");
            Sig.PrimSig unvs = Sig.UNIV;
            boolean bl = false;
            while (var8_17 < inst.getTraceLength() - 1) {
                unvs = Sig.UNIV.plus(unvs.prime());
                ++var8_17;
            }
            sb.append(unvs.toString());
        }
        sb.append(" {\n  ");
        sb.append(config.toString());
        sb.append("\n\n  ");
        StringJoiner statesj = new StringJoiner(";\n  ");
        for (String string : states) {
            statesj.add(string);
        }
        sb.append(statesj.toString());
        sb.append("\n\n");
        if (inst.getMaxTrace() >= 0) {
            int i;
            sb.append("  // enforce loop\n  ");
            for (i = 0; i < inst.getLoopState(); ++i) {
                sb.append("after ");
            }
            sb.append("always {\n");
            for (i = inst.getLoopState(); i < inst.getTraceLength(); ++i) {
                StringBuilder stringBuilder = new StringBuilder("");
                for (int j = inst.getLoopState(); j < inst.getTraceLength(); ++j) {
                    stringBuilder.append("after ");
                }
                stringBuilder.append("(");
                stringBuilder.append((String)states.get(i));
                stringBuilder.append(")");
                sb.append("  (" + (String)states.get(i) + ") implies " + stringBuilder.toString() + "\n");
            }
            sb.append("  }\n");
        }
        sb.append("}\n");
        OurDialog.showtext((String)"Instance as predicate", (String)sb.toString());
        return null;
    }

    private Runner doResetTheme() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        if (!OurDialog.yesno((JFrame)this.frame, (Object)"Are you sure you wish to clear all your customizations?", (String)"Yes, clear them", (String)"No, keep them")) {
            return null;
        }
        for (VizState myState : this.myStates) {
            myState.resetTheme();
        }
        this.repopulateProjectionPopup();
        if (this.myCustomPanel != null) {
            this.myCustomPanel.remakeAll();
        }
        if (this.myGraphPanel != null) {
            this.myGraphPanel.remakeAll(this.frame);
        }
        this.thmFileName = "";
        this.updateDisplay();
        return null;
    }

    private Runner doMagicLayout() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        if (!OurDialog.yesno((JFrame)this.frame, (Object)"This will clear your original customizations. Are you sure?", (String)"Yes, clear them", (String)"No, keep them")) {
            return null;
        }
        for (VizState myState : this.myStates) {
            myState.resetTheme();
            try {
                MagicLayout.magic(myState);
                MagicColor.magic(myState);
            }
            catch (Throwable throwable) {}
        }
        this.repopulateProjectionPopup();
        if (this.myCustomPanel != null) {
            this.myCustomPanel.remakeAll();
        }
        if (this.myGraphPanel != null) {
            this.myGraphPanel.remakeAll(this.frame);
        }
        this.updateDisplay();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runner doRefreshWindow() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.windowmenu.removeAll();
        try {
            this.wrap = true;
            for (String f : this.getInstances()) {
                JMenuItem it = new JMenuItem("Instance: " + this.getInstanceTitle(f), null);
                it.setIcon(f.equals(this.getXMLfilename()) ? iconYes : iconNo);
                it.addActionListener((ActionListener)this.doLoadInstance(f));
                this.windowmenu.add(it);
            }
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    public void addMinMaxActions(JMenu menu) {
        try {
            this.wrap = true;
            OurUtil.menuItem((JMenu)menu, (String)"Minimize", (Object[])new Object[]{Character.valueOf('M'), this.doMinimize(), iconNo});
            OurUtil.menuItem((JMenu)menu, (String)"Zoom", (Object[])new Object[]{this.doZoom(), iconNo});
        }
        finally {
            this.wrap = false;
        }
    }

    private Runner doMinimize() {
        if (!this.wrap && this.frame != null) {
            OurUtil.minimize((JFrame)this.frame);
        }
        return this.wrapMe();
    }

    private Runner doZoom() {
        if (!this.wrap && this.frame != null) {
            OurUtil.zoom((JFrame)this.frame);
        }
        return this.wrapMe();
    }

    private Runner doNavLeft() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.current > 0) {
            --this.current;
            this.updateDisplay();
        }
        return null;
    }

    private Runner doNavRight() {
        if (this.wrap) {
            return this.wrapMe();
        }
        int lst = this.getVizState().get((int)0).getOriginalInstance().originalA4.getTraceLength();
        int lop = this.getVizState().get((int)0).getOriginalInstance().originalA4.getLoopState();
        int lmx = this.current + 1 + this.getVizState().size() > lst ? this.current + 1 + this.getVizState().size() : lst;
        int lox = lmx - (lst - lop);
        this.current = this.normalize(this.current + 1, lmx, lox);
        this.updateDisplay();
        return null;
    }

    private Runner doNext() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.settingsOpen != 0) {
            return null;
        }
        if (this.xmlFileName.length() == 0) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since no instance is currently loaded.");
        } else if (this.enumerator == null) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since the analysis engine is not loaded with the visualizer.");
        } else {
            try {
                this.enumerator.compute((Object)new String[]{this.xmlFileName, "-3"});
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)this.frame, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Runner doConfig() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.settingsOpen != 0) {
            return null;
        }
        if (this.xmlFileName.length() == 0) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since no instance is currently loaded.");
        } else if (this.enumerator == null) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since the analysis engine is not loaded with the visualizer.");
        } else {
            try {
                this.seg_iteration = false;
                this.enumerator.compute((Object)new String[]{this.xmlFileName, "-1"});
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)this.frame, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Runner doPath() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.settingsOpen != 0) {
            return null;
        }
        if (this.xmlFileName.length() == 0) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since no instance is currently loaded.");
        } else if (this.enumerator == null) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since the analysis engine is not loaded with the visualizer.");
        } else {
            try {
                this.seg_iteration = false;
                this.enumerator.compute((Object)new String[]{this.xmlFileName, "-2"});
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)this.frame, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Runner doFork() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.settingsOpen != 0) {
            return null;
        }
        if (this.xmlFileName.length() == 0) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since no instance is currently loaded.");
        } else if (this.enumerator == null) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since the analysis engine is not loaded with the visualizer.");
        } else {
            try {
                this.seg_iteration = true;
                this.enumerator.compute((Object)new String[]{this.xmlFileName, "" + (this.current + 1)});
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)this.frame, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Runner doInit() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.settingsOpen != 0) {
            return null;
        }
        if (this.xmlFileName.length() == 0) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since no instance is currently loaded.");
        } else if (this.enumerator == null) {
            OurDialog.alert((JFrame)this.frame, (Object)"Cannot display the next solution since the analysis engine is not loaded with the visualizer.");
        } else {
            try {
                this.seg_iteration = true;
                this.enumerator.compute((Object)new String[]{this.xmlFileName, "0"});
            }
            catch (Throwable ex) {
                OurDialog.alert((JFrame)this.frame, (Object)ex.getMessage());
            }
        }
        return null;
    }

    private Runner doApply() {
        if (!this.myStates.isEmpty()) {
            for (int i = 1; i < this.myStates.size(); ++i) {
                VizState old = this.myStates.get(1);
                this.myStates.set(i, new VizState(this.myStates.get(0)));
                this.myStates.get(i).loadInstance(old.getOriginalInstance());
            }
        }
        if (!this.wrap) {
            this.updateDisplay();
        }
        return this.wrapMe();
    }

    private Runner doOpenThemePanel() {
        if (!this.wrap) {
            this.settingsOpen = 1;
            this.updateDisplay();
        }
        return this.wrapMe();
    }

    private Runner doCloseThemePanel() {
        if (!this.wrap) {
            this.settingsOpen = 0;
            this.updateDisplay();
        }
        return this.wrapMe();
    }

    private Runner doOpenEvalPanel() {
        if (!this.wrap) {
            this.settingsOpen = 2;
            this.updateDisplay();
        }
        return this.wrapMe();
    }

    private Runner doCloseEvalPanel() {
        if (!this.wrap) {
            this.settingsOpen = 0;
            this.updateDisplay();
        }
        return this.wrapMe();
    }

    public Runner doShowViz() {
        if (!this.wrap) {
            this.currentMode = VisualizerMode.Viz;
            this.updateDisplay();
            return null;
        }
        return this.wrapMe();
    }

    public Runner doShowTree() {
        if (!this.wrap) {
            this.currentMode = VisualizerMode.Tree;
            this.updateDisplay();
            return null;
        }
        return this.wrapMe();
    }

    public Runner doShowTxt() {
        if (!this.wrap) {
            this.currentMode = VisualizerMode.TEXT;
            this.updateDisplay();
            return null;
        }
        return this.wrapMe();
    }

    public Runner doShowTable() {
        if (!this.wrap) {
            this.currentMode = VisualizerMode.TABLE;
            this.updateDisplay();
            return null;
        }
        return this.wrapMe();
    }

    private JPanel traceGraph() {
        final ArrayList states = new ArrayList();
        JPanel trace = new JPanel(){
            int heighti = 50;

            @Override
            public void paintComponent(Graphics g) {
                states.clear();
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                int radius = 12;
                int dist = 45;
                int offsety = 2 + this.heighti / 2;
                int offsetx = this.getWidth() / 2 + (dist - 2 * radius) / 2 - dist * (VizGUI.this.current + 1);
                int lst = VizGUI.this.getVizState().get((int)(VizGUI.this.getVizState().size() - 1)).getOriginalInstance().tracelen;
                int lol = VizGUI.this.getVizState().get((int)(VizGUI.this.getVizState().size() - 1)).getOriginalInstance().looplen;
                int lop = lst - lol;
                int lmx = VizGUI.this.current + VizGUI.this.getVizState().size() > lst ? VizGUI.this.current + VizGUI.this.getVizState().size() : lst;
                int lox = lmx - (lst - lop);
                Ellipse2D.Double loop = null;
                Ellipse2D.Double last = null;
                for (int i = 0; i < lmx; ++i) {
                    g2.setStroke(new BasicStroke(2.0f));
                    Ellipse2D.Double circl = new Ellipse2D.Double(i * dist + offsetx, offsety - radius, 2.0 * (double)radius, 2.0 * (double)radius);
                    if (i == lmx - 1) {
                        last = circl;
                    }
                    if (i == lox) {
                        loop = circl;
                    }
                    Color tmp = g2.getColor();
                    int max = VizGUI.this.normalize(VizGUI.this.current + VizGUI.this.getVizState().size() - 1, lmx, lox);
                    int min = VizGUI.this.normalize(VizGUI.this.current, lmx, lox);
                    if (min <= max && i >= min && i <= max || min > max && (i >= min || i <= max && i >= lox)) {
                        g2.setColor(new Color(255, 255, 255));
                    } else {
                        g2.setColor(new Color(120, 120, 120));
                    }
                    g2.fill(circl);
                    g2.setColor(tmp);
                    g2.draw(circl);
                    FontMetrics mets = g2.getFontMetrics();
                    String lbl = "" + VizGUI.this.normalize(i, lst, lop);
                    g2.drawString(lbl, i * dist + radius + offsetx - mets.stringWidth(lbl) / 2, offsety + mets.getAscent() / 2);
                    states.add(circl);
                    g2.setStroke(new BasicStroke(1.0f));
                    g2.setColor(new Color(0, 0, 0));
                }
                Polygon arrowHead = new Polygon();
                arrowHead.addPoint(0, 4);
                arrowHead.addPoint(-4, -4);
                arrowHead.addPoint(4, -4);
                for (int i = 0; i < lmx - 1; ++i) {
                    Path2D.Double path = new Path2D.Double();
                    ((Path2D)path).moveTo(((Ellipse2D)states.get(i)).getMaxX(), ((Ellipse2D)states.get(i)).getCenterY());
                    ((Path2D)path).lineTo(((Ellipse2D)states.get(i + 1)).getMinX(), ((Ellipse2D)states.get(i + 1)).getCenterY());
                    g2.draw(path);
                    AffineTransform tx = new AffineTransform();
                    tx.setToIdentity();
                    double angle = Math.atan2(0.0, 1.0);
                    tx.translate(((Ellipse2D)states.get(i + 1)).getMinX(), ((Ellipse2D)states.get(i + 1)).getCenterY());
                    tx.rotate(angle - 1.5707963267948966);
                    g2.fill(tx.createTransformedShape(arrowHead));
                }
                Path2D.Double path = new Path2D.Double();
                ((Path2D)path).moveTo(((Ellipse2D)states.get(states.size() - 1)).getCenterX(), ((Ellipse2D)states.get(states.size() - 1)).getMinY());
                ((Path2D)path).curveTo(last.getCenterX() - 25.0, 0.0, loop.getCenterX() + 25.0, 0.0, loop.getCenterX(), loop.getMinY());
                g2.draw(path);
                AffineTransform tx = new AffineTransform();
                tx.setToIdentity();
                double angle = Math.atan2(loop.getMinY(), -dist / 2);
                tx.translate(loop.getCenterX(), loop.getMinY());
                tx.rotate(angle - 1.5707963267948966);
                g2.fill(tx.createTransformedShape(arrowHead));
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(Integer.MAX_VALUE, this.heighti);
            }
        };
        trace.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                for (int i = 0; i < states.size(); ++i) {
                    if (e.getButton() != 1 || !((Ellipse2D)states.get(i)).contains(e.getX(), e.getY())) continue;
                    VizGUI.this.current = i;
                    VizGUI.this.updateDisplay();
                    break;
                }
            }
        });
        return trace;
    }

    private int normalize(int idx, int length, int loop) {
        int lln = length - loop;
        return idx > loop ? (idx - loop) % lln + loop : idx;
    }

    private static enum VisualizerMode {
        Viz("graphviz"),
        TEXT("txt"),
        TABLE("table"),
        Tree("tree");

        private final String id;

        private VisualizerMode(String id) {
            this.id = id;
        }

        private static VisualizerMode parse(String id) {
            for (VisualizerMode vm : VisualizerMode.values()) {
                if (!vm.id.equals(id)) continue;
                return vm;
            }
            return Viz;
        }

        public void set() {
            Preferences.userNodeForPackage(Util.class).put("VisualizerMode", this.id);
        }

        public static VisualizerMode get() {
            return VisualizerMode.parse(Preferences.userNodeForPackage(Util.class).get("VisualizerMode", ""));
        }
    }
}

