/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.OurBorder;
import edu.mit.csail.sdg.alloy4.OurCombobox;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4graph.GraphViewer;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyProjection;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.VizState;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public final class VizGraphPanel
extends JPanel {
    private static final long serialVersionUID = 0L;
    private final List<VizState> vizState;
    private boolean seeDot = false;
    private List<GraphViewer> viewer = null;
    private final List<JScrollPane> diagramScrollPanels = new ArrayList<JScrollPane>();
    private final List<JPanel> graphPanels = new ArrayList<JPanel>();
    private final JPanel navPanel;
    private final JSplitPane split;
    private AlloyProjection currentProjection = null;
    private final Map<AlloyType, TypePanel> type2panel = new TreeMap<AlloyType, TypePanel>();

    public VizGraphPanel(JFrame parent, List<VizState> vizState, boolean seeDot) {
        EmptyBorder b = new EmptyBorder(0, 0, 0, 0);
        OurUtil.make((JComponent)this, (Object[])new Object[]{Color.BLACK, Color.WHITE, b});
        this.seeDot = seeDot;
        this.vizState = vizState;
        this.setLayout(new GridLayout());
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.navPanel = new JPanel();
        JScrollPane navscroll = OurUtil.scrollpane((Component)this.navPanel, (Object[])new Object[0]);
        navscroll.setMinimumSize(new Dimension(0, 0));
        JPanel diagramsScrollPanels = new JPanel();
        diagramsScrollPanels.setLayout(new BoxLayout(diagramsScrollPanels, 2));
        for (int i = 0; i < vizState.size(); ++i) {
            JScrollPane diagramScrollPanel = this.createGraphPanel(i);
            this.diagramScrollPanels.add(diagramScrollPanel);
            diagramsScrollPanels.add(diagramScrollPanel);
            diagramScrollPanel.setPreferredSize(new Dimension(0, 0));
        }
        this.split = OurUtil.splitpane((int)0, (Component)diagramsScrollPanels, (Component)navscroll, (int)0);
        this.split.setResizeWeight(1.0);
        this.split.setDividerSize(0);
        this.add(this.split);
        this.remakeAll(parent);
    }

    private JScrollPane createGraphPanel(final int i) {
        EmptyBorder b = new EmptyBorder(0, 0, 0, 0);
        final JPanel graphPanel = (JPanel)OurUtil.make((JComponent)new JPanel(), (Object[])new Object[]{Color.BLACK, Color.WHITE, b});
        this.graphPanels.add(graphPanel);
        graphPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent ev) {
                if (VizGraphPanel.this.viewer.size() <= i) {
                    return;
                }
                if (!(ev.getButton() == 3 || ev.getButton() == 1 && ev.isControlDown())) {
                    return;
                }
                if (graphPanel.contains(ev.getX(), ev.getY())) {
                    VizGraphPanel.this.viewer.get(i).alloyPopup(graphPanel, ev.getX(), ev.getY());
                }
            }
        });
        final JScrollPane diagramScrollPanel = OurUtil.scrollpane((Component)graphPanel, (Object[])new Object[]{new OurBorder(true, true, true, false)});
        diagramScrollPanel.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                diagramScrollPanel.invalidate();
                diagramScrollPanel.repaint();
                diagramScrollPanel.validate();
            }
        });
        diagramScrollPanel.getHorizontalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(AdjustmentEvent e) {
                diagramScrollPanel.invalidate();
                diagramScrollPanel.repaint();
                diagramScrollPanel.validate();
            }
        });
        return diagramScrollPanel;
    }

    public void remakeAll(JFrame parent) {
        LinkedHashMap<AlloyType, AlloyAtom> map = new LinkedHashMap<AlloyType, AlloyAtom>();
        this.navPanel.removeAll();
        for (AlloyType type : this.vizState.get(this.vizState.size() - 1).getProjectedTypes()) {
            List<AlloyAtom> atoms = this.vizState.get(this.vizState.size() - 1).getOriginalInstance().type2atoms(type);
            TypePanel tp = this.type2panel.get(type);
            if (tp != null && tp.getAlloyAtom() != null && !atoms.contains(tp.getAlloyAtom())) {
                tp = null;
            }
            if (tp != null && tp.getAlloyAtom() == null && atoms.size() > 0) {
                tp = null;
            }
            if (tp != null && !tp.upToDate(type, atoms)) {
                tp = null;
            }
            if (tp == null) {
                tp = new TypePanel(parent, type, atoms, null);
                this.type2panel.put(type, tp);
            }
            this.navPanel.add(tp);
            map.put(tp.getAlloyType(), tp.getAlloyAtom());
        }
        this.currentProjection = new AlloyProjection(map);
        List<GraphViewer> prevsv = this.viewer;
        this.viewer = new ArrayList<GraphViewer>(this.vizState.size());
        for (int i = 0; i < this.vizState.size(); ++i) {
            JPanel graph = this.vizState.get(i).getGraph(parent, this.currentProjection);
            if (this.seeDot && graph instanceof GraphViewer) {
                this.viewer = null;
                JTextArea txt = OurUtil.textarea((String)graph.toString(), (int)10, (int)10, (boolean)false, (boolean)true, (Object[])new Object[]{this.getFont()});
                this.diagramScrollPanels.get(i).setViewportView(txt);
                continue;
            }
            if (graph instanceof GraphViewer) {
                this.viewer.add((GraphViewer)graph);
                if (prevsv != null && i <= prevsv.size()) {
                    this.viewer.get(i).setScale(((GraphViewer)graph).getScale());
                }
            } else {
                this.viewer = null;
            }
            this.graphPanels.get(i).removeAll();
            this.graphPanels.get(i).add(graph);
            this.graphPanels.get(i).setBackground(Color.WHITE);
            this.diagramScrollPanels.get(i).setViewportView(this.graphPanels.get(i));
            this.diagramScrollPanels.get(i).invalidate();
            this.diagramScrollPanels.get(i).repaint();
            this.diagramScrollPanels.get(i).validate();
        }
        this.split.setDividerLocation(this.split.getSize().height - this.split.getInsets().bottom - this.split.getDividerSize() - this.split.getRightComponent().getPreferredSize().height);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.diagramScrollPanels != null) {
            for (JScrollPane diagramScrollPanel : this.diagramScrollPanels) {
                diagramScrollPanel.getViewport().getView().setFont(font);
            }
        }
    }

    public void seeDot(JFrame parent, boolean yesOrNo) {
        if (this.seeDot == yesOrNo) {
            return;
        }
        this.seeDot = yesOrNo;
        this.remakeAll(parent);
    }

    public String toDot(JFrame parent) {
        return this.vizState.get(0).getGraph(parent, this.currentProjection).toString();
    }

    public GraphViewer alloyGetViewer() {
        return this.viewer.get(0);
    }

    public void resetProjectionAtomCombos() {
        for (Map.Entry<AlloyType, TypePanel> e : this.type2panel.entrySet()) {
            if (e.getValue().atomCombo == null) continue;
            e.getValue().atomCombo.setSelectedIndex(0);
        }
    }

    public int numPanels() {
        return this.graphPanels.size();
    }

    final class TypePanel
    extends JPanel {
        private static final long serialVersionUID = 0L;
        private final AlloyType type;
        private final List<AlloyAtom> atoms;
        private final String[] atomnames;
        private final JComboBox atomCombo;

        private boolean upToDate(AlloyType type, List<AlloyAtom> atoms) {
            if (!this.type.equals(type)) {
                return false;
            }
            atoms = new ArrayList<AlloyAtom>(atoms);
            Collections.sort(atoms);
            if (!this.atoms.equals(atoms)) {
                return false;
            }
            for (int i = 0; i < this.atoms.size(); ++i) {
                String n = this.atoms.get(i).getVizName(VizGraphPanel.this.vizState.get(0), true);
                if (this.atomnames[i].equals(n)) continue;
                return false;
            }
            return true;
        }

        private TypePanel(final JFrame parent, AlloyType type, List<AlloyAtom> atoms, AlloyAtom initialValue) {
            int idealWidth;
            Object[] objectArray;
            int initialIndex = 0;
            this.type = type;
            atoms = new ArrayList<AlloyAtom>(atoms);
            Collections.sort(atoms);
            this.atoms = ConstList.make(atoms);
            this.setLayout(new BoxLayout(this, 0));
            this.setBorder(null);
            this.atomnames = new String[this.atoms.size()];
            for (int i = 0; i < this.atoms.size(); ++i) {
                this.atomnames[i] = this.atoms.get(i).getVizName(VizGraphPanel.this.vizState.get(0), true);
                if (!this.atoms.get(i).equals(initialValue)) continue;
                initialIndex = i;
            }
            final JButton left = new JButton("<<");
            this.add(left);
            this.add(Box.createRigidArea(new Dimension(2, 2)));
            if (this.atomnames.length < 1) {
                String[] stringArray = new String[1];
                objectArray = stringArray;
                stringArray[0] = " ";
            } else {
                objectArray = this.atomnames;
            }
            this.atomCombo = new OurCombobox(objectArray);
            this.add(this.atomCombo);
            this.add(Box.createRigidArea(new Dimension(2, 2)));
            final JButton right = new JButton(">>");
            this.add(right);
            left.setVerticalAlignment(0);
            right.setVerticalAlignment(0);
            Dimension dim = this.atomCombo.getPreferredSize();
            int n = idealWidth = Util.onMac() ? 120 : 80;
            if (dim.width < idealWidth) {
                dim.width = idealWidth + 20;
                this.atomCombo.setMinimumSize(dim);
                this.atomCombo.setPreferredSize(dim);
            }
            left.setEnabled(initialIndex > 0);
            right.setEnabled(initialIndex < this.atomnames.length - 1);
            this.atomCombo.setSelectedIndex(initialIndex);
            if (Util.onMac()) {
                this.atomCombo.setBorder(BorderFactory.createEmptyBorder(4, 1, 0, 1));
            }
            left.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    int curIndex = TypePanel.this.atomCombo.getSelectedIndex();
                    if (curIndex > 0) {
                        TypePanel.this.atomCombo.setSelectedIndex(curIndex - 1);
                    }
                }
            });
            right.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    int curIndex = TypePanel.this.atomCombo.getSelectedIndex();
                    if (curIndex < TypePanel.this.atomCombo.getItemCount() - 1) {
                        TypePanel.this.atomCombo.setSelectedIndex(curIndex + 1);
                    }
                }
            });
            this.atomCombo.addActionListener(new ActionListener(){

                @Override
                public final void actionPerformed(ActionEvent e) {
                    left.setEnabled(TypePanel.this.atomCombo.getSelectedIndex() > 0);
                    right.setEnabled(TypePanel.this.atomCombo.getSelectedIndex() < TypePanel.this.atomnames.length - 1);
                    VizGraphPanel.this.remakeAll(parent);
                    VizGraphPanel.this.getParent().invalidate();
                    VizGraphPanel.this.getParent().repaint();
                }
            });
        }

        public List<AlloyAtom> getAlloyAtoms() {
            return this.atoms;
        }

        public AlloyAtom getAlloyAtom() {
            int i = this.atomCombo.getSelectedIndex();
            if (i >= 0 && i < this.atoms.size()) {
                return this.atoms.get(i);
            }
            return null;
        }

        public AlloyType getAlloyType() {
            return this.type;
        }
    }
}

