/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.ConstSet;
import edu.mit.csail.sdg.alloy4.MailBug;
import edu.mit.csail.sdg.alloy4.OurCheckbox;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4graph.DotColor;
import edu.mit.csail.sdg.alloy4graph.DotPalette;
import edu.mit.csail.sdg.alloy4graph.DotShape;
import edu.mit.csail.sdg.alloy4graph.DotStyle;
import edu.mit.csail.sdg.alloy4viz.AlloyAtom;
import edu.mit.csail.sdg.alloy4viz.AlloyElement;
import edu.mit.csail.sdg.alloy4viz.AlloyInstance;
import edu.mit.csail.sdg.alloy4viz.AlloyModel;
import edu.mit.csail.sdg.alloy4viz.AlloyProjection;
import edu.mit.csail.sdg.alloy4viz.AlloyRelation;
import edu.mit.csail.sdg.alloy4viz.AlloySet;
import edu.mit.csail.sdg.alloy4viz.AlloyType;
import edu.mit.csail.sdg.alloy4viz.StaticGraphMaker;
import edu.mit.csail.sdg.alloy4viz.StaticProjector;
import edu.mit.csail.sdg.alloy4viz.StaticThemeReaderWriter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public final class VizState {
    private LinkedHashMap<AlloyProjection, JPanel> cache = new LinkedHashMap();
    private boolean changedSinceLastSave = false;
    private AlloyInstance originalInstance;
    private AlloyModel currentModel;
    private Set<AlloyType> projectedTypes = new TreeSet<AlloyType>();
    private boolean useOriginalNames = false;
    private boolean hidePrivate = false;
    private boolean hideMeta = true;
    private boolean hideSkolem = false;
    private int fontSize = 12;
    private DotPalette nodePalette;
    private DotPalette edgePalette;
    public final MInt weight = new MInt();
    public final MString label = new MString();
    public final MMap<DotColor> nodeColor = new MMap();
    public final MMap<DotColor> edgeColor = new MMap();
    public final MMap<DotStyle> nodeStyle = new MMap();
    public final MMap<DotStyle> edgeStyle = new MMap();
    public final MMap<DotShape> shape = new MMap();
    public final MMap<Boolean> attribute = new MMap<Boolean>(true, false);
    public final MMap<Boolean> mergeArrows = new MMap<Boolean>(true, false);
    public final MMap<Boolean> constraint = new MMap<Boolean>(true, false);
    public final MMap<Boolean> layoutBack = new MMap<Boolean>(true, false);
    public final MMap<Boolean> edgeVisible = new MMap<Boolean>(true, false);
    public final MMap<Boolean> nodeVisible = new MMap<Boolean>(true, false);
    public final MMap<Boolean> number = new MMap<Boolean>(true, false);
    public final MMap<Boolean> hideUnconnected = new MMap<Boolean>(true, false);
    public final MMap<Boolean> showAsAttr = new MMap<Boolean>(true, false);
    public final MMap<Boolean> showAsLabel = new MMap<Boolean>(true, false);

    public VizState(AlloyInstance originalInstance) {
        this.originalInstance = originalInstance;
        this.currentModel = originalInstance.model;
        this.resetTheme();
        this.loadInstance(originalInstance);
    }

    public VizState(VizState old) {
        this.originalInstance = old.originalInstance;
        this.currentModel = old.currentModel;
        this.projectedTypes = new TreeSet<AlloyType>(old.projectedTypes);
        this.useOriginalNames = old.useOriginalNames;
        this.hidePrivate = old.hidePrivate;
        this.hideMeta = old.hideMeta;
        this.hideSkolem = old.hideSkolem;
        this.fontSize = old.fontSize;
        this.nodePalette = old.nodePalette;
        this.edgePalette = old.edgePalette;
        this.nodeColor.putAll(old.nodeColor);
        this.nodeStyle.putAll(old.nodeStyle);
        this.nodeVisible.putAll(old.nodeVisible);
        this.label.putAll(old.label);
        this.number.putAll(old.number);
        this.hideUnconnected.putAll(old.hideUnconnected);
        this.showAsAttr.putAll(old.showAsAttr);
        this.showAsLabel.putAll(old.showAsLabel);
        this.shape.putAll(old.shape);
        this.weight.putAll(old.weight);
        this.attribute.putAll(old.attribute);
        this.mergeArrows.putAll(old.mergeArrows);
        this.constraint.putAll(old.constraint);
        this.layoutBack.putAll(old.layoutBack);
        this.edgeColor.putAll(old.edgeColor);
        this.edgeStyle.putAll(old.edgeStyle);
        this.edgeVisible.putAll(old.edgeVisible);
        this.changedSinceLastSave = false;
        this.applyDefaultVar();
    }

    public void resetTheme() {
        this.currentModel = this.originalInstance.model;
        this.projectedTypes.clear();
        this.useOriginalNames = false;
        this.hidePrivate = true;
        this.hideMeta = true;
        this.fontSize = 12;
        this.nodePalette = DotPalette.CLASSIC;
        this.edgePalette = DotPalette.CLASSIC;
        this.nodeColor.clear();
        this.nodeColor.put(null, DotColor.WHITE);
        this.nodeStyle.clear();
        this.nodeStyle.put(null, DotStyle.SOLID);
        this.nodeVisible.clear();
        this.nodeVisible.put(null, true);
        this.label.clear();
        this.label.put(null, "");
        this.number.clear();
        this.number.put(null, true);
        this.hideUnconnected.clear();
        this.hideUnconnected.put(null, false);
        this.showAsAttr.clear();
        this.showAsAttr.put(null, false);
        this.showAsLabel.clear();
        this.showAsLabel.put(null, true);
        this.shape.clear();
        this.shape.put(null, DotShape.ELLIPSE);
        this.weight.clear();
        this.weight.put(null, 0);
        this.attribute.clear();
        this.attribute.put(null, false);
        this.mergeArrows.clear();
        this.mergeArrows.put(null, true);
        this.constraint.clear();
        this.constraint.put(null, true);
        this.layoutBack.clear();
        this.layoutBack.put(null, false);
        this.edgeColor.clear();
        this.edgeColor.put(null, DotColor.MAGIC);
        this.edgeStyle.clear();
        this.edgeStyle.put(null, DotStyle.SOLID);
        this.edgeVisible.clear();
        this.edgeVisible.put(null, true);
        AlloyType sigint = AlloyType.INT;
        this.label.put(sigint, "");
        this.number.put(sigint, true);
        this.hideUnconnected.put(sigint, true);
        AlloyType seqidx = AlloyType.SEQINT;
        this.label.put(seqidx, "");
        this.number.put(seqidx, true);
        this.hideUnconnected.put(seqidx, true);
        AlloyType set = AlloyType.SET;
        AlloySet some = AlloySet.SOME;
        AlloySet one = AlloySet.ONE;
        AlloySet lone = AlloySet.LONE;
        AlloySet var = AlloySet.VAR;
        AlloyRelation ext = AlloyRelation.EXTENDS;
        AlloyRelation in = AlloyRelation.IN;
        AlloyRelation eq = AlloyRelation.EQ;
        AlloyRelation mem = AlloyRelation.MEMBER;
        this.shape.put(null, DotShape.BOX);
        this.nodeColor.put(null, DotColor.YELLOW);
        this.nodeStyle.put(null, DotStyle.SOLID);
        this.nodeStyle.put(var, DotStyle.DASHED);
        this.shape.put(set, DotShape.ELLIPSE);
        this.nodeColor.put(set, DotColor.BLUE);
        this.label.put(set, "");
        this.edgeColor.put(ext, DotColor.BLACK);
        this.weight.put(ext, 100);
        this.layoutBack.put(ext, true);
        this.edgeColor.put(mem, DotColor.BLACK);
        this.weight.put(mem, 100);
        this.layoutBack.put(mem, true);
        this.edgeColor.put(in, DotColor.BLACK);
        this.weight.put(in, 100);
        this.layoutBack.put(in, true);
        this.edgeColor.put(eq, DotColor.BLACK);
        this.weight.put(eq, 100);
        this.layoutBack.put(eq, true);
        for (AlloyRelation r : this.currentModel.getRelations()) {
            if (this.edgeStyle.get(r) != null || !r.isVar) continue;
            this.edgeStyle.put(r, DotStyle.DASHED);
        }
        this.cache.clear();
        this.changedSinceLastSave = false;
    }

    void applyDefaultVar() {
        for (AlloyType alloyType : this.currentModel.getTypes()) {
            if (this.nodeStyle.get(alloyType) != null || !alloyType.isVar || this.currentModel.getSuperType((AlloyType)alloyType).isVar || this.nodeStyle.get(this.currentModel.getSuperType(alloyType)) != null) continue;
            this.nodeStyle.put(alloyType, DotStyle.DASHED);
        }
        for (AlloyRelation alloyRelation : this.currentModel.getRelations()) {
            if (this.edgeStyle.get(alloyRelation) != null || !alloyRelation.isVar) continue;
            this.edgeStyle.put(alloyRelation, DotStyle.DASHED);
        }
        for (AlloySet alloySet : this.currentModel.getSets()) {
            if (this.nodeStyle.get(alloySet) != null || !alloySet.isVar || alloySet.getType().isVar || this.nodeStyle.get(alloySet.getType()) != null) continue;
            this.nodeStyle.put(alloySet, DotStyle.DASHED);
        }
    }

    public void loadInstance(AlloyInstance unprojectedInstance) {
        this.originalInstance = unprojectedInstance;
        for (AlloyType t : this.getProjectedTypes()) {
            if (unprojectedInstance.model.hasType(t)) continue;
            this.projectedTypes.remove(t);
        }
        this.currentModel = StaticProjector.project(unprojectedInstance.model, this.projectedTypes);
        this.cache.clear();
    }

    public void loadPaletteXML(String filename) throws IOException {
        this.resetTheme();
        StaticThemeReaderWriter.readAlloy(filename, this);
        this.cache.clear();
        this.changedSinceLastSave = false;
    }

    public void savePaletteXML(String filename) throws IOException {
        StaticThemeReaderWriter.writeAlloy(filename, this);
        this.changedSinceLastSave = false;
    }

    public JPanel getGraph(JFrame parent, AlloyProjection projectionChoice) {
        JPanel ans = this.cache.get(projectionChoice);
        if (ans != null) {
            return ans;
        }
        AlloyInstance inst = this.originalInstance;
        try {
            ans = StaticGraphMaker.produceGraph(parent, inst, this, projectionChoice);
            this.cache.put(projectionChoice, ans);
        }
        catch (Throwable ex) {
            String msg = "An error has occurred: " + String.valueOf(ex) + "\n\nStackTrace:\n" + MailBug.dump((Throwable)ex) + "\n";
            JScrollPane scroll = OurUtil.scrollpane((Component)OurUtil.textarea((String)msg, (int)0, (int)0, (boolean)false, (boolean)false, (Object[])new Object[0]), (Object[])new Object[0]);
            ans = new JPanel();
            ans.setLayout(new BorderLayout());
            ans.add((Component)scroll, "Center");
            ans.setBackground(Color.WHITE);
        }
        ans.setBorder(null);
        return ans;
    }

    public boolean changedSinceLastSave() {
        return this.changedSinceLastSave;
    }

    private void change() {
        this.changedSinceLastSave = true;
        this.cache.clear();
    }

    private void changeIf(Object oldValue, Object newValue) {
        if (oldValue == null ? newValue == null : oldValue.equals(newValue)) {
            return;
        }
        this.change();
    }

    private AlloyType parent(AlloyElement x, AlloyModel model) {
        if (x instanceof AlloySet) {
            return ((AlloySet)x).getType();
        }
        if (x instanceof AlloyType) {
            return model.getSuperType((AlloyType)x);
        }
        return null;
    }

    public AlloyInstance getOriginalInstance() {
        return this.originalInstance;
    }

    public AlloyModel getOriginalModel() {
        return this.originalInstance.model;
    }

    public AlloyModel getCurrentModel() {
        return this.currentModel;
    }

    public ConstSet<AlloyType> getProjectedTypes() {
        return ConstSet.make(this.projectedTypes);
    }

    public boolean canProject(AlloyType type) {
        return this.isTopLevel(type) && !type.isVar;
    }

    public boolean isTopLevel(AlloyType type) {
        return AlloyType.UNIV.equals(this.originalInstance.model.getSuperType(type));
    }

    public void project(AlloyType type) {
        if (this.canProject(type) && this.projectedTypes.add(type)) {
            this.currentModel = StaticProjector.project(this.originalInstance.model, this.projectedTypes);
            this.change();
        }
    }

    public void deproject(AlloyType type) {
        if (this.projectedTypes.remove(type)) {
            this.currentModel = StaticProjector.project(this.originalInstance.model, this.projectedTypes);
            this.change();
        }
    }

    public void deprojectAll() {
        if (this.projectedTypes.size() > 0) {
            this.projectedTypes.clear();
            this.currentModel = StaticProjector.project(this.originalInstance.model, this.projectedTypes);
            this.change();
        }
    }

    public boolean useOriginalName() {
        return this.useOriginalNames;
    }

    public void useOriginalName(Boolean newValue) {
        if (newValue != null && this.useOriginalNames != newValue) {
            this.change();
            this.useOriginalNames = newValue;
        }
    }

    public boolean hidePrivate() {
        return this.hidePrivate;
    }

    public void hidePrivate(Boolean newValue) {
        if (newValue != null && this.hidePrivate != newValue) {
            this.change();
            this.hidePrivate = newValue;
        }
    }

    public boolean hideMeta() {
        return this.hideMeta;
    }

    public void hideMeta(Boolean newValue) {
        if (newValue != null && this.hideMeta != newValue) {
            this.change();
            this.hideMeta = newValue;
        }
    }

    public boolean hideSkolem() {
        return this.hideSkolem;
    }

    public void hideSkolem(Boolean newValue) {
        if (newValue != null && this.hideSkolem != newValue) {
            this.change();
            this.hideSkolem = newValue;
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int n) {
        if (this.fontSize != n && this.fontSize > 0) {
            this.change();
            this.fontSize = n;
        }
    }

    public DotPalette getNodePalette() {
        return this.nodePalette;
    }

    public void setNodePalette(DotPalette x) {
        if (this.nodePalette != x && x != null) {
            this.change();
            this.nodePalette = x;
        }
    }

    public DotPalette getEdgePalette() {
        return this.edgePalette;
    }

    public void setEdgePalette(DotPalette x) {
        if (this.edgePalette != x && x != null) {
            this.change();
            this.edgePalette = x;
        }
    }

    public DotColor nodeColor(AlloyAtom a, AlloyInstance i) {
        for (AlloySet s : i.atom2sets(a)) {
            DotColor v = this.nodeColor.get(s);
            if (v == null || this.hideSkolem && s.isSkolem) continue;
            return v;
        }
        return this.nodeColor.resolve(a.getType());
    }

    public DotStyle nodeStyle(AlloyAtom a, AlloyInstance i) {
        for (AlloySet s : i.atom2sets(a)) {
            DotStyle v = this.nodeStyle.get(s);
            if (v == null || this.hideSkolem && s.isSkolem) continue;
            return v;
        }
        return this.nodeStyle.resolve(a.getType());
    }

    public DotShape shape(AlloyAtom a, AlloyInstance i) {
        for (AlloySet s : i.atom2sets(a)) {
            DotShape v = this.shape.get(s);
            if (v == null || this.hideSkolem && s.isSkolem) continue;
            return v;
        }
        return this.shape.resolve(a.getType());
    }

    public boolean nodeVisible(AlloyAtom a, AlloyInstance i) {
        boolean any = false;
        for (AlloySet s : i.atom2sets(a)) {
            if (this.hideSkolem && s.isSkolem) continue;
            any = true;
            if (!this.nodeVisible.resolve(s).booleanValue()) continue;
            return true;
        }
        if (any) {
            return false;
        }
        return this.nodeVisible.resolve(a.getType());
    }

    public final class MInt {
        private final LinkedHashMap<AlloyElement, Integer> map = new LinkedHashMap();

        private MInt() {
        }

        private void clear() {
            this.map.clear();
            VizState.this.change();
        }

        private void putAll(MInt x) {
            this.map.putAll(x.map);
            VizState.this.change();
        }

        public int get(AlloyElement x) {
            Integer ans = this.map.get(x);
            if (ans == null) {
                return 0;
            }
            return ans;
        }

        public void put(AlloyElement x, Integer v) {
            if (v == null || v < 0) {
                v = 0;
            }
            VizState.this.changeIf(this.map.put(x, v), v);
        }
    }

    public final class MString {
        private final LinkedHashMap<AlloyElement, String> map = new LinkedHashMap();

        private MString() {
        }

        private void clear() {
            this.map.clear();
            VizState.this.change();
        }

        private void putAll(MString x) {
            this.map.putAll(x.map);
            VizState.this.change();
        }

        public String get(AlloyElement x) {
            String ans = this.map.get(x);
            if (ans == null) {
                ans = x.getName().trim();
            }
            return ans;
        }

        public void put(AlloyElement x, String v) {
            if (x == null && v == null) {
                v = "";
            }
            if (x != null && x.getName().equals(v)) {
                v = null;
            }
            VizState.this.changeIf(this.map.put(x, v), v);
        }
    }

    public final class MMap<T> {
        private final LinkedHashMap<AlloyElement, T> map = new LinkedHashMap();
        private final T onValue;
        private final T offValue;

        private MMap() {
            this.onValue = null;
            this.offValue = null;
        }

        private MMap(T on, T off) {
            this.onValue = on;
            this.offValue = off;
        }

        private void clear() {
            this.map.clear();
            VizState.this.change();
        }

        private void putAll(MMap<T> x) {
            this.map.putAll(x.map);
            VizState.this.change();
        }

        public T get(AlloyElement obj) {
            return this.map.get(obj);
        }

        public T resolve(AlloyElement obj) {
            AlloyModel m = VizState.this.currentModel;
            AlloyElement x = obj;
            T v;
            while ((v = this.map.get(x)) == null) {
                x = VizState.this.parent(x, m);
            }
            return v;
        }

        public void put(AlloyElement obj, T value) {
            if (obj == null && value == null) {
                return;
            }
            T old = this.map.put(obj, value);
            if (old == null && value != null || old != null && !old.equals(value)) {
                VizState.this.change();
            }
        }

        OurCheckbox pick(String label, String tooltip) {
            return new OurCheckbox(label, tooltip, Boolean.TRUE.equals(this.get(null)) ? OurCheckbox.ON : OurCheckbox.OFF){
                private static final long serialVersionUID = 0L;

                public Icon do_action() {
                    Object old = MMap.this.get(null);
                    boolean ans = old != null && old.equals(MMap.this.onValue);
                    MMap.this.put(null, ans ? MMap.this.offValue : MMap.this.onValue);
                    return ans ? OFF : ON;
                }
            };
        }

        OurCheckbox pick(final AlloyElement obj, String label, String tooltip) {
            T a = this.get(obj);
            T b = this.resolve(obj);
            Icon icon = a == null ? (Boolean.TRUE.equals(b) ? OurCheckbox.INH_ON : OurCheckbox.INH_OFF) : (Boolean.TRUE.equals(a) ? OurCheckbox.ALL_ON : OurCheckbox.ALL_OFF);
            return new OurCheckbox(label, tooltip, icon){
                private static final long serialVersionUID = 0L;

                public Icon do_action() {
                    Object a = MMap.this.get(obj);
                    a = a == null ? MMap.this.onValue : (a.equals(MMap.this.onValue) ? MMap.this.offValue : null);
                    MMap.this.put(obj, a);
                    return a == null ? (Boolean.TRUE.equals(MMap.this.resolve(obj)) ? INH_ON : INH_OFF) : (Boolean.TRUE.equals(a) ? ALL_ON : ALL_OFF);
                }
            };
        }
    }
}

