/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4viz;

import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.OurTree;
import edu.mit.csail.sdg.alloy4.Pair;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.ast.Expr;
import edu.mit.csail.sdg.ast.ExprHasName;
import edu.mit.csail.sdg.ast.ExprVar;
import edu.mit.csail.sdg.ast.Sig;
import edu.mit.csail.sdg.translator.A4Solution;
import edu.mit.csail.sdg.translator.A4Tuple;
import edu.mit.csail.sdg.translator.A4TupleSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class VizTree
extends OurTree {
    private static final long serialVersionUID = 0L;
    private final boolean onWindows;
    private final String title;
    private final A4Solution instance;
    private final List<Object> toplevel;
    private final int state;

    public String convertValueToText(Object val, boolean selected, boolean expanded, boolean leaf, int row, boolean focus) {
        String c = ">";
        if (this.onWindows) {
            String string = c = selected ? " style=\"color:#ffffff;\">" : " style=\"color:#000000;\">";
        }
        if (val instanceof A4Solution) {
            return "<html> <b" + c + Util.encode((String)(this.title == null ? "" : this.title)) + "</b></html>";
        }
        if (val instanceof Sig) {
            String label = ((Sig)val).label;
            label = Util.tailThis((String)label);
            return "<html> <b" + c + "sig " + Util.encode((String)label) + "</b></html>";
        }
        if (val instanceof ExprVar) {
            return "<html> <b" + c + "set " + Util.encode((String)((ExprVar)val).label) + "</b></html>";
        }
        if (val instanceof String) {
            return "<html> <span" + c + Util.encode((String)((String)val)) + "</span></html>";
        }
        if (val instanceof Pair) {
            return "<html> <b" + c + "field " + Util.encode((String)((ExprHasName)((Pair)val).b).label) + "</b></html>";
        }
        if (val instanceof A4Tuple) {
            StringBuilder sb = new StringBuilder("<html> <span" + c);
            A4Tuple tp = (A4Tuple)val;
            for (int i = 1; i < tp.arity(); ++i) {
                if (i > 1) {
                    sb.append(" -> ");
                }
                sb.append(Util.encode((String)tp.atom(i)));
            }
            sb.append("</span></html>");
            return sb.toString();
        }
        return "";
    }

    public Object do_root() {
        return this.instance;
    }

    public List<?> do_ask(Object parent) {
        ArrayList<String> ans = new ArrayList<String>();
        try {
            if (parent instanceof A4Solution) {
                return this.toplevel;
            }
            if (parent instanceof Sig || parent instanceof ExprVar) {
                A4TupleSet ts = (A4TupleSet)this.instance.eval((Expr)parent, this.state);
                for (A4Tuple t : ts) {
                    ans.add(t.atom(0));
                }
            } else if (parent instanceof String) {
                String atom = (String)parent;
                for (Sig s : this.instance.getAllReachableSigs()) {
                    block4: for (Sig.Field f : s.getFields()) {
                        for (A4Tuple t : this.instance.eval(f, this.state)) {
                            if (!t.atom(0).equals(atom)) continue;
                            ans.add((String)new Pair((Object)atom, (Object)f));
                            continue block4;
                        }
                    }
                }
                block6: for (ExprVar f : this.instance.getAllSkolems()) {
                    if (f.type().arity() <= 1) continue;
                    for (A4Tuple t : (A4TupleSet)this.instance.eval((Expr)f, this.state)) {
                        if (!t.atom(0).equals(atom)) continue;
                        ans.add((String)new Pair((Object)atom, (Object)f));
                        continue block6;
                    }
                }
            } else if (parent instanceof Pair) {
                Pair p = (Pair)parent;
                ExprHasName rel = (ExprHasName)p.b;
                String atom = (String)p.a;
                for (A4Tuple tuple : (A4TupleSet)this.instance.eval((Expr)rel, this.state)) {
                    if (!tuple.atom(0).equals(atom)) continue;
                    if (tuple.arity() == 2) {
                        ans.add(tuple.atom(1));
                        continue;
                    }
                    ans.add((String)tuple);
                }
            } else if (parent instanceof A4Tuple) {
                A4Tuple tp = (A4Tuple)parent;
                for (int i = 1; i < tp.arity(); ++i) {
                    if (ans.contains(tp.atom(i))) continue;
                    ans.add(tp.atom(i));
                }
                return ans;
            }
            Collections.sort(ans, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    String t2;
                    String t1;
                    if (a instanceof Pair) {
                        t1 = ((ExprHasName)((Pair)a).b).label;
                        t2 = ((ExprHasName)((Pair)b).b).label;
                    } else {
                        t1 = a.toString();
                        t2 = b.toString();
                    }
                    int i = t1.compareToIgnoreCase(t2);
                    if (i != 0) {
                        return i;
                    }
                    return t1.compareTo(t2);
                }
            });
            return ans;
        }
        catch (Err er) {
            return ans;
        }
    }

    public VizTree(A4Solution instance, String title, int fontSize, int state) {
        super(fontSize);
        this.instance = instance;
        this.title = title;
        this.onWindows = Util.onWindows();
        this.state = state;
        ArrayList<Object> toplevel = new ArrayList<Object>();
        for (Sig s : instance.getAllReachableSigs()) {
            if (s == Sig.UNIV || s == Sig.SEQIDX || s == Sig.NONE) continue;
            toplevel.add(s);
        }
        for (ExprVar v : instance.getAllSkolems()) {
            if (v.type().arity() != 1 || !v.label.startsWith("$")) continue;
            toplevel.add(v);
        }
        Collections.sort(toplevel, new Comparator<Object>(){

            @Override
            public int compare(Object a, Object b) {
                String t2;
                String t1;
                if (a instanceof Sig) {
                    t1 = ((Sig)a).label;
                    if (b instanceof ExprVar) {
                        return -1;
                    }
                    t2 = ((Sig)b).label;
                } else {
                    t1 = ((ExprVar)a).label;
                    if (b instanceof Sig) {
                        return 1;
                    }
                    t2 = ((ExprVar)b).label;
                }
                return Util.slashComparator.compare(t1, t2);
            }
        });
        this.toplevel = Collections.unmodifiableList(toplevel);
        this.do_start();
    }
}

