/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4whole;

import aQute.libg.glob.Glob;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;

public class FindReplace {
    final JFrame frame;
    final Function<Integer, Optional<JTextPane>> pane;
    final Consumer<JTextPane> select;
    final FindReplaceDialog dialog;
    String find = "";
    String replace = "";
    boolean caseSensitive = false;
    boolean wholeWord = false;
    boolean active;

    public FindReplace(JFrame frame, Function<Integer, Optional<JTextPane>> currentPane, Consumer<JTextPane> select) {
        this.frame = frame;
        this.pane = currentPane;
        this.select = select;
        this.dialog = new FindReplaceDialog(frame);
    }

    public void find() {
        JTextPane textPane = this.pane.apply(0).get();
        String selectedText = textPane.getSelectedText();
        if (selectedText != null) {
            this.dialog.findField.setText(selectedText);
        }
        this.active = true;
        int x = this.frame.getX() + (this.frame.getWidth() - this.dialog.getWidth()) / 2;
        int y = this.frame.getY() + (this.frame.getHeight() - this.dialog.getHeight()) / 2;
        this.dialog.setLocation(x, y);
        this.dialog.setVisible(true);
    }

    public void findNext() {
        this.dialog.find();
    }

    private Action make(final Consumer<ActionEvent> action) {
        return new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                action.accept(e);
            }
        };
    }

    public class FindReplaceDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        final JTextField findField;
        final JTextField replaceField;
        final JCheckBox smartCaseCheckBox;
        final JCheckBox wrapSearchCheckBox;
        final JCheckBox wholeWordCheckBox;
        final JCheckBox allPanesCheckBox;
        final JButton findButton;
        final JButton replaceButton;
        final JButton replaceAllButton;
        final JButton closeButton;
        final JPanel panel;
        final JLabel messageField;
        final JButton replaceFindButton;
        final JCheckBox backwardCheckBox;

        FindReplaceDialog(Window window) {
            super(window);
            this.panel = new JPanel(new GridBagLayout());
            this.add(this.panel);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.fill = 2;
            constraints.anchor = 17;
            constraints.insets = new Insets(5, 5, 5, 5);
            constraints.weightx = 1.0;
            int columns = 5;
            int row = 0;
            JLabel findLabel = new JLabel("Find:");
            constraints.gridx = 0;
            constraints.gridy = row;
            this.panel.add((Component)findLabel, constraints);
            this.findField = new JTextField(20);
            constraints.gridx = 1;
            constraints.gridy = row++;
            constraints.gridwidth = columns - 1;
            this.panel.add((Component)this.findField, constraints);
            JLabel replaceLabel = new JLabel("Replace:");
            constraints.gridx = 0;
            constraints.gridy = row;
            this.panel.add((Component)replaceLabel, constraints);
            this.replaceField = new JTextField(20);
            constraints.gridx = 1;
            constraints.gridy = row++;
            constraints.gridwidth = columns - 1;
            this.panel.add((Component)this.replaceField, constraints);
            this.smartCaseCheckBox = new JCheckBox("Smart Case");
            constraints.gridx = 0;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.smartCaseCheckBox, constraints);
            this.wrapSearchCheckBox = new JCheckBox("Wrap Search");
            constraints.gridx = 1;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.wrapSearchCheckBox, constraints);
            this.wholeWordCheckBox = new JCheckBox("Whole Word");
            constraints.gridx = 2;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.wholeWordCheckBox, constraints);
            this.allPanesCheckBox = new JCheckBox("All tabs");
            constraints.gridx = 3;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.allPanesCheckBox, constraints);
            this.backwardCheckBox = new JCheckBox("Backward");
            constraints.gridx = 4;
            constraints.gridy = row++;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.backwardCheckBox, constraints);
            this.findButton = new JButton("Find");
            constraints.gridx = 0;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.findButton, constraints);
            this.replaceFindButton = new JButton("Replace>Find");
            constraints.gridx = 1;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.replaceFindButton, constraints);
            this.replaceButton = new JButton("Replace");
            constraints.gridx = 2;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.replaceButton, constraints);
            this.replaceAllButton = new JButton("Replace All");
            constraints.gridx = 3;
            constraints.gridy = row;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.replaceAllButton, constraints);
            this.closeButton = new JButton("Close");
            constraints.gridx = 4;
            constraints.gridy = row++;
            constraints.gridwidth = 1;
            this.panel.add((Component)this.closeButton, constraints);
            this.messageField = new JLabel();
            this.messageField.setText(" ");
            constraints.gridx = 0;
            constraints.gridy = row;
            constraints.gridwidth = 4;
            constraints.gridheight = 2;
            this.panel.add((Component)this.messageField, constraints);
            this.findButton.setEnabled(true);
            this.replaceFindButton.setEnabled(false);
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
            this.wrapSearchCheckBox.setSelected(true);
            this.smartCaseCheckBox.setSelected(true);
            this.findField.addActionListener(e -> this.find());
            this.replaceField.addActionListener(e -> {
                if (this.find()) {
                    this.replace();
                }
            });
            this.findButton.addActionListener(e -> this.find());
            this.replaceButton.addActionListener(e -> this.replace());
            this.replaceFindButton.addActionListener(e -> this.replaceFind());
            this.replaceAllButton.addActionListener(e -> this.replaceAll());
            this.closeButton.addActionListener(e -> {
                this.setVisible(false);
                FindReplace.this.active = false;
            });
            int modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            InputMap inputMap = this.panel.getInputMap(2);
            inputMap.put(KeyStroke.getKeyStroke(70, modifier), "find");
            inputMap.put(KeyStroke.getKeyStroke(70, 64 + modifier), "find.reversed");
            inputMap.put(KeyStroke.getKeyStroke(71, modifier), "find");
            inputMap.put(KeyStroke.getKeyStroke(71, 64 + modifier), "find.reversed");
            this.panel.getActionMap().put("find", FindReplace.this.make(e -> this.find()));
            this.panel.getActionMap().put("find.reversed", FindReplace.this.make(e -> this.find(true)));
            this.setTitle("Find/Replace Text");
            this.setDefaultCloseOperation(2);
            this.pack();
            this.setAlwaysOnTop(false);
        }

        boolean find() {
            return this.find(this.backwardCheckBox.isSelected());
        }

        boolean find(boolean reversed) {
            this.messageField.setText("");
            CharSequence findText = this.findField.getText();
            JTextPane firstPane = FindReplace.this.pane.apply(0).orElse(null);
            ArrayList<Search> l = new ArrayList<Search>();
            l.add(new Search(firstPane, firstPane.getSelectionEnd(), -1, reversed));
            if (this.allPanesCheckBox.isSelected()) {
                JTextPane textPane;
                int tab = 1;
                while ((textPane = (JTextPane)FindReplace.this.pane.apply(tab).orElse(null)) != null) {
                    l.add(new Search(textPane, 0, -1, reversed));
                    ++tab;
                }
            }
            l.add(new Search(firstPane, 0, reversed ? firstPane.getSelectionStart() : -1, reversed));
            if (reversed) {
                Collections.reverse(l);
                findText = new ReverseString(findText);
            }
            Pattern pattern = this.getPattern(findText);
            for (Search search : l) {
                Point d = search.find(pattern);
                if (d == null) continue;
                JTextPane pane = search.source;
                this.foundMatch(pane, d.x, d.y);
                return true;
            }
            return this.missedMatch("Reached end of text, text not found");
        }

        private boolean missedMatch(String message) {
            this.replaceButton.setEnabled(false);
            this.replaceAllButton.setEnabled(false);
            this.replaceFindButton.setEnabled(false);
            Toolkit.getDefaultToolkit().beep();
            this.messageField.setText(message);
            return false;
        }

        private boolean foundMatch(JTextPane textPane, int start, int end) {
            textPane.setSelectionStart(start);
            textPane.setSelectionEnd(end);
            FindReplace.this.select.accept(textPane);
            this.replaceButton.setEnabled(true);
            this.replaceAllButton.setEnabled(true);
            this.replaceFindButton.setEnabled(true);
            return true;
        }

        private Pattern getPattern(CharSequence target) {
            int flags = 8;
            if (this.smartCaseCheckBox.isSelected() && this.allLowerCase((CharSequence)target)) {
                flags |= 2;
            }
            if (this.wholeWordCheckBox.isSelected()) {
                target = "\\b" + String.valueOf(target) + "\\b";
            }
            String glob = Glob.toPattern((String)target.toString(), (int)flags).toString();
            String RELUCTANT_WILDCARD = ".*?";
            glob = glob.replaceAll("(?<!\\\\)\\.\\*", RELUCTANT_WILDCARD);
            System.out.println(glob);
            return Pattern.compile(glob, flags);
        }

        private boolean allLowerCase(CharSequence target) {
            for (int i = 0; i < target.length(); ++i) {
                if (!Character.isUpperCase(target.charAt(i))) continue;
                return false;
            }
            return true;
        }

        private boolean replace() {
            int endIndex;
            JTextPane textPane = FindReplace.this.pane.apply(0).orElseThrow(() -> new IllegalStateException("Should always have at least one pane"));
            String findText = this.findField.getText();
            String replaceText = this.replaceField.getText();
            String currentText = textPane.getText();
            int startIndex = textPane.getSelectionStart();
            if (startIndex != (endIndex = textPane.getSelectionEnd())) {
                String selectedText = currentText.substring(startIndex, endIndex);
                Matcher m = this.getPattern(findText).matcher(selectedText);
                if (m.lookingAt()) {
                    textPane.replaceSelection(this.replace(m, replaceText));
                    return true;
                }
                Toolkit.getDefaultToolkit().beep();
                this.messageField.setText("Selected text does not match the text to find.");
            } else {
                Toolkit.getDefaultToolkit().beep();
                this.messageField.setText("No text selected.");
            }
            return false;
        }

        private void replaceFind() {
            if (this.replace()) {
                this.find();
            }
        }

        private void replaceAll() {
            int tab = 0;
            int occurrences = 0;
            JTextPane textPane = this.getPane(tab);
            do {
                String findText = this.findField.getText();
                String replaceText = this.replaceField.getText();
                String currentText = textPane.getText();
                Matcher m = this.getPattern(findText).matcher(currentText);
                StringBuffer sb = new StringBuffer();
                while (m.find()) {
                    m.appendReplacement(sb, this.replace(m, replaceText));
                    ++occurrences;
                }
                m.appendTail(sb);
                textPane.setText(sb.toString());
                textPane = this.getPane(++tab);
            } while (this.allPanesCheckBox.isSelected() && textPane != null);
            this.messageField.setText("Replaced " + occurrences + " occurrences in " + tab + " tabs");
        }

        private JTextPane getPane(int tab) {
            return FindReplace.this.pane.apply(tab).orElse(null);
        }

        private String replace(Matcher m, String replaceText) {
            StringBuffer sb = new StringBuffer(replaceText);
            for (int i = 0; i < sb.length() - 1; ++i) {
                char c = sb.charAt(i);
                if (c == '\\' && sb.charAt(i + 1) == '$') {
                    i += 2;
                    continue;
                }
                if (c != '$' || !Character.isDigit(sb.charAt(i + 1))) continue;
                int index = sb.charAt(i + 1) - 48;
                if (m.groupCount() < index) continue;
                sb.delete(i, i + 2);
                String group = m.group(index);
                if (group == null) continue;
                sb.insert(i, group);
                i += group.length() - 1;
            }
            return sb.toString();
        }
    }

    static class Search {
        final JTextPane source;
        final boolean reverse;
        public int start;
        public int end;

        Search(JTextPane source, int start, int end, boolean reverse) {
            this.source = source;
            this.start = start;
            this.end = end;
            this.reverse = reverse;
        }

        public Point find(Pattern pattern) {
            CharSequence domain;
            Matcher matcher;
            String text = this.source.getText();
            if (this.end < 0) {
                this.end = text.length();
            }
            if ((matcher = pattern.matcher(domain = this.reverse ? new ReverseString(text, this.start, this.end) : text.subSequence(this.start, this.end))).find()) {
                int xstart = matcher.start() + this.start;
                int xend = matcher.end() + this.start;
                if (this.reverse) {
                    xstart = this.end - matcher.end();
                    xend = this.end - matcher.start();
                }
                return new Point(xstart, xend);
            }
            return null;
        }
    }

    static class ReverseString
    implements CharSequence {
        final CharSequence source;
        final int start;
        final int end;

        public ReverseString(CharSequence source, int start, int end) {
            this.source = source;
            this.start = start;
            this.end = end;
        }

        public ReverseString(CharSequence source) {
            this.source = source;
            this.start = 0;
            this.end = source.length();
        }

        @Override
        public int length() {
            return this.end - this.start;
        }

        @Override
        public char charAt(int index) {
            return this.source.charAt(this.translate(index));
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new ReverseString(this.source, this.translate(end) + 1, this.translate(start) + 1);
        }

        public int translate(int n) {
            return this.end - 1 - n;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder(this.source.subSequence(this.start, this.end));
            sb.reverse();
            return sb.toString();
        }
    }
}

