/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4whole;

import edu.mit.csail.sdg.alloy4.A4Preferences;
import edu.mit.csail.sdg.alloy4.OurBorder;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4whole.SwingLogPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.BoundedRangeModel;
import javax.swing.ComboBoxModel;
import javax.swing.Icon;
import javax.swing.InputVerifier;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import kodkod.engine.satlab.SATFactory;

public class PreferencesDialog
extends JFrame {
    private static final long serialVersionUID = 5577892964740788892L;
    private JTabbedPane tab;
    private final Map<A4Preferences.Pref<?>, JComponent> pref2comp = new HashMap();
    private final SwingLogPanel log;

    @Deprecated
    public PreferencesDialog(SwingLogPanel log, String binary) {
        this(log);
    }

    public PreferencesDialog(SwingLogPanel log) {
        this.log = log;
        if (log != null) {
            List solvers = SATFactory.getSolvers();
            A4Preferences.Solver.setChoices((Iterable)solvers, (Object[])new SATFactory[]{SATFactory.DEFAULT});
            log.log("Available solvers on " + System.getProperty("os.name") + ":" + System.getProperty("os.arch") + "\n");
            solvers.forEach(s -> log.log(s.toString() + "\n"));
        }
        this.initUI();
    }

    protected final void initUI() {
        this.tab = new JTabbedPane();
        this.tab.addTab("Editor", this.initEditorPane());
        this.tab.addTab("Solver", this.initSolverPane());
        this.tab.addTab("Miscellaneous", this.initMiscPane());
        this.add(this.tab);
        this.setTitle("Alloy Preferences");
        this.pack();
        this.setSize(this.getSize().width + 5, this.getSize().height + 5);
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
    }

    protected Component initEditorPane() {
        JPanel p = OurUtil.makeGrid((int)2, (GridBagConstraints)this.gbc().make(), (Container[])new Container[]{this.mkCombo((A4Preferences.ChoicePref)A4Preferences.FontName), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.FontSize), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.TabSize)});
        this.addToGrid(p, this.mkCheckBox(A4Preferences.SyntaxDisabled), this.gbc().pos(0, 3).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.AntiAlias), this.gbc().pos(0, 4).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.LineNumbers), this.gbc().pos(0, 5).gridwidth(2));
        return this.makeTabPane(p);
    }

    protected Component initSolverPane() {
        JPanel p = OurUtil.makeGrid((int)2, (GridBagConstraints)this.gbc().make(), (Container[])new Container[]{this.mkCombo((A4Preferences.ChoicePref)A4Preferences.Solver), this.mkSlider((A4Preferences.ChoicePref)A4Preferences.SkolemDepth), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.Unrolls), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.CoreGranularity), this.mkSlider((A4Preferences.ChoicePref)A4Preferences.CoreMinimization), this.mkSlider(A4Preferences.DecomposePref)});
        int r = 6;
        this.addToGrid(p, this.mkCheckBox(A4Preferences.NoOverflow), this.gbc().pos(0, r++).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.ImplicitThis), this.gbc().pos(0, r++).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.InferPartialInstance), this.gbc().pos(0, r++).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.RecordKodkod), this.gbc().pos(0, r++).gridwidth(2));
        A4Preferences.Solver.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean enableCore = ((SATFactory)A4Preferences.Solver.get()).prover();
                PreferencesDialog.this.pref2comp.get(A4Preferences.CoreGranularity).setEnabled(enableCore);
                PreferencesDialog.this.pref2comp.get(A4Preferences.CoreMinimization).setEnabled(enableCore);
            }
        });
        return this.makeTabPane(p);
    }

    protected Component initMiscPane() {
        JPanel p = OurUtil.makeGrid((int)2, (GridBagConstraints)this.gbc().make(), (Container[])new Container[]{this.mkCombo((A4Preferences.ChoicePref)A4Preferences.SubMemory), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.SubStack), this.mkCombo(A4Preferences.VerbosityPref), this.mkCombo((A4Preferences.ChoicePref)A4Preferences.LAF)});
        int r = 4;
        this.addToGrid(p, this.mkCheckBox(A4Preferences.Welcome), this.gbc().pos(0, r++).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.WarningNonfatal), this.gbc().pos(0, r++).gridwidth(2));
        this.addToGrid(p, this.mkCheckBox(A4Preferences.AutoVisualize), this.gbc().pos(0, r++).gridwidth(2));
        return this.makeTabPane(p);
    }

    protected JCheckBox mkCheckBox(final A4Preferences.BooleanPref pref) {
        final JCheckBox cb = this.make(new JCheckBox((Action)pref.getTitleAction()));
        this.pref2comp.put((A4Preferences.Pref<?>)pref, cb);
        ChangeListener ctrl = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                cb.setSelected((Boolean)pref.get());
            }
        };
        pref.addChangeListener(ctrl);
        ctrl.stateChanged(null);
        return cb;
    }

    protected <T> JPanel mkSlider(final A4Preferences.ChoicePref<T> pref) {
        final JSlider sl = this.make(new JSlider(this.mkBoundedRangeModel(pref)));
        this.pref2comp.put((A4Preferences.Pref<?>)pref, sl);
        sl.setMajorTickSpacing(1);
        sl.setMinorTickSpacing(1);
        sl.setPaintTicks(true);
        sl.setPaintLabels(true);
        sl.setSnapToTicks(true);
        sl.setLabelTable(this.mkDict(pref));
        pref.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                sl.setLabelTable(PreferencesDialog.this.mkDict(pref));
            }
        });
        sl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        sl.updateUI();
                    }
                });
            }
        });
        return OurUtil.makeH((Object[])new Object[]{pref.title + ": ", sl});
    }

    private <T> Hashtable<Integer, JLabel> mkDict(A4Preferences.ChoicePref<T> pref) {
        Hashtable<Integer, JLabel> dict = new Hashtable<Integer, JLabel>();
        int sel = pref.getSelectedIndex();
        for (int i = 0; i < pref.validChoices().size(); ++i) {
            JLabel label = this.makeLabel(pref.renderValueShort(pref.validChoices().get(i)));
            if (i == sel) {
                Font font = label.getFont();
                label = (JLabel)OurUtil.make((JComponent)label, (Object[])new Object[]{new Font(font.getName(), 1, font.getSize())});
            }
            dict.put(i, label);
        }
        return dict;
    }

    protected JPanel mkSpinner(A4Preferences.IntPref pref) {
        JSpinner jsp = new JSpinner(this.mkSpinnerModelFor(pref));
        return OurUtil.makeH((Object[])new Object[]{pref.title + ": ", jsp});
    }

    protected JPanel mkEditor(final A4Preferences.IntPref pref) {
        final JTextField jtf = new JTextField(((Integer)pref.get()).toString());
        jtf.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                try {
                    JTextField src = (JTextField)input;
                    Integer.parseInt(src.getText());
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        });
        jtf.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (c < '0' || c > '9') {
                    e.consume();
                }
            }
        });
        jtf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updatePref();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updatePref();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.updatePref();
            }

            private void updatePref() {
                String val = jtf.getText();
                try {
                    pref.set((Object)Integer.parseInt(val));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        return OurUtil.makeH((Object[])new Object[]{pref.title + ": ", jtf});
    }

    protected <T> JPanel mkCombo(final A4Preferences.ChoicePref<T> pref) {
        JComboBox<Object> cb = this.make(new JComboBox(this.mkComboBoxModelFor(pref)));
        this.pref2comp.put((A4Preferences.Pref<?>)pref, cb);
        cb.setRenderer(new CBRenderer(){

            @Override
            protected Object render(Object value) {
                return pref.renderValueShort(value);
            }
        });
        return OurUtil.makeH((Object[])new Object[]{pref.title + ": ", cb});
    }

    protected <T> Component[] mkComboArr(A4Preferences.ChoicePref<T> pref) {
        return this.mkCombo(pref).getComponents();
    }

    private SpinnerModel mkSpinnerModelFor(A4Preferences.IntPref pref) {
        return new MyIntSpinnerModel(pref);
    }

    private <T> ComboBoxModel mkComboBoxModelFor(A4Preferences.ChoicePref<T> pref) {
        return new CBModel<T>(pref);
    }

    private <T> BoundedRangeModel mkBoundedRangeModel(A4Preferences.ChoicePref<T> pref) {
        return new BRModel<T>(pref);
    }

    private <T extends JComponent> T make(T comp) {
        return (T)OurUtil.make(comp, (Object[])new Object[0]);
    }

    private JLabel makeLabel(Object obj) {
        return (JLabel)OurUtil.make((JComponent)new JLabel(obj.toString()), (Object[])new Object[0]);
    }

    private Component makeTabPane(JPanel pane) {
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)pane, this.gbc().pos(0, 0).fill(1).insets(new Insets(5, 5, 5, 5)).anchor(11).make());
        p.add((Component)new JLabel(), this.gbc().pos(0, 1).weighty(1).fill(1).make());
        JPanel ans = (JPanel)OurUtil.make((JComponent)p, (Object[])new Object[]{new OurBorder(true, true, true, true)});
        return ans;
    }

    private void addToGrid(JPanel p, Component c, OurUtil.GridBagConstraintsBuilder cstr) {
        p.add(c, cstr.make());
    }

    private OurUtil.GridBagConstraintsBuilder gbc() {
        OurUtil.GridBagConstraintsBuilder ans = new OurUtil.GridBagConstraintsBuilder();
        ans.anchor(17).insets(new Insets(3, 3, 3, 3)).ipads(3, 3).fill(1);
        return ans;
    }

    public void addChangeListener(ChangeListener l, A4Preferences.Pref<?> ... prefs) {
        for (A4Preferences.Pref<?> pref : prefs) {
            pref.addChangeListener(l);
        }
    }

    public static Action decorateWithLogging(final SwingLogPanel log, final A4Preferences.Pref<?> pref, final Action action) {
        if (log == null) {
            return action;
        }
        return new AbstractAction((String)action.getValue("Name"), (Icon)action.getValue("SmallIcon")){
            private static final long serialVersionUID = -2790668001235140089L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Object oldVal = pref.get();
                action.actionPerformed(e);
                Object newVal = pref.get();
                if (!newVal.equals(oldVal)) {
                    PreferencesDialog.logPrefChanged(log, pref);
                }
            }
        };
    }

    public static void logPrefChanged(SwingLogPanel log, A4Preferences.Pref<?> pref) {
        if (log == null) {
            return;
        }
        log.log("Option ");
        log.logBold(pref.title);
        log.log(" changed to ");
        log.logBold(String.valueOf(pref.get()) + "\n");
        log.flush();
    }

    public static void logOnChange(final SwingLogPanel log, A4Preferences.Pref<?> ... prefs) {
        if (log == null) {
            return;
        }
        for (final A4Preferences.Pref<?> pref : prefs) {
            pref.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PreferencesDialog.logPrefChanged(log, pref);
                }
            });
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PreferencesDialog sd = new PreferencesDialog(null, null);
                sd.setDefaultCloseOperation(3);
                sd.setVisible(true);
            }
        });
    }

    private static class MyIntSpinnerModel
    extends AbstractSpinnerModel {
        private final A4Preferences.IntPref pref;

        public MyIntSpinnerModel(A4Preferences.IntPref pref) {
            this.pref = pref;
            this.pref.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.fireStateChanged();
                }
            });
        }

        @Override
        public Object getValue() {
            return this.pref.get();
        }

        @Override
        public void setValue(Object value) {
            this.pref.set((Object)((Integer)value));
        }

        @Override
        public Object getNextValue() {
            return Math.min(this.pref.max, (Integer)this.pref.get() + 1);
        }

        @Override
        public Object getPreviousValue() {
            return Math.max(this.pref.min, (Integer)this.pref.get() - 1);
        }
    }

    private static class CBModel<T>
    extends AbstractListModel
    implements ComboBoxModel {
        private final A4Preferences.ChoicePref<T> pref;

        public CBModel(final A4Preferences.ChoicePref<T> pref) {
            this.pref = pref;
            this.pref.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    this.fireContentsChanged(pref, -1, -1);
                }
            });
        }

        @Override
        public int getSize() {
            return this.pref.validChoices().size();
        }

        @Override
        public Object getElementAt(int index) {
            return this.pref.validChoices().get(index);
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.pref.set(anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.pref.get();
        }
    }

    private static class BRModel<T>
    implements BoundedRangeModel {
        private final A4Preferences.ChoicePref<T> pref;

        public BRModel(A4Preferences.ChoicePref<T> pref) {
            this.pref = pref;
        }

        @Override
        public int getMinimum() {
            return 0;
        }

        @Override
        public int getMaximum() {
            return this.pref.validChoices().size() - 1;
        }

        @Override
        public int getValue() {
            return this.pref.getSelectedIndex();
        }

        @Override
        public int getExtent() {
            return 0;
        }

        @Override
        public void setValueIsAdjusting(boolean b) {
        }

        @Override
        public boolean getValueIsAdjusting() {
            return false;
        }

        @Override
        public void setRangeProperties(int value, int extent, int min, int max, boolean adjusting) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addChangeListener(ChangeListener x) {
            this.pref.addChangeListener(x);
        }

        @Override
        public void removeChangeListener(ChangeListener x) {
            this.pref.removeChangeListener(x);
        }

        @Override
        public void setValue(int n) {
            if (n >= this.getMinimum() && n <= this.getMaximum()) {
                this.pref.setSelectedIndex(n);
            }
        }

        @Override
        public void setExtent(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMinimum(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMaximum(int n) {
            throw new UnsupportedOperationException();
        }
    }

    private abstract class CBRenderer
    extends BasicComboBoxRenderer {
        private CBRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return super.getListCellRendererComponent((JList<?>)list, this.render(value), index, isSelected, cellHasFocus);
        }

        protected abstract Object render(Object var1);
    }
}

