/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4whole;

import aQute.lib.io.IO;
import edu.mit.csail.sdg.alloy4.A4Preferences;
import edu.mit.csail.sdg.alloy4.A4Reporter;
import edu.mit.csail.sdg.alloy4.Computer;
import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorFatal;
import edu.mit.csail.sdg.alloy4.ErrorType;
import edu.mit.csail.sdg.alloy4.Listener;
import edu.mit.csail.sdg.alloy4.MailBug;
import edu.mit.csail.sdg.alloy4.OurAntiAlias;
import edu.mit.csail.sdg.alloy4.OurBorder;
import edu.mit.csail.sdg.alloy4.OurCombobox;
import edu.mit.csail.sdg.alloy4.OurDialog;
import edu.mit.csail.sdg.alloy4.OurSyntaxWidget;
import edu.mit.csail.sdg.alloy4.OurTabbedSyntaxWidget;
import edu.mit.csail.sdg.alloy4.OurTree;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4.Pair;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.Runner;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.alloy4.WorkerEngine;
import edu.mit.csail.sdg.alloy4.XMLNode;
import edu.mit.csail.sdg.alloy4viz.VizGUI;
import edu.mit.csail.sdg.alloy4whole.FindReplace;
import edu.mit.csail.sdg.alloy4whole.PreferencesDialog;
import edu.mit.csail.sdg.alloy4whole.SimpleReporter;
import edu.mit.csail.sdg.alloy4whole.SwingLogPanel;
import edu.mit.csail.sdg.ast.Browsable;
import edu.mit.csail.sdg.ast.Command;
import edu.mit.csail.sdg.ast.Expr;
import edu.mit.csail.sdg.ast.ExprVar;
import edu.mit.csail.sdg.ast.Module;
import edu.mit.csail.sdg.ast.Sig;
import edu.mit.csail.sdg.parser.CompModule;
import edu.mit.csail.sdg.parser.CompUtil;
import edu.mit.csail.sdg.sim.SimInstance;
import edu.mit.csail.sdg.sim.SimTuple;
import edu.mit.csail.sdg.sim.SimTupleset;
import edu.mit.csail.sdg.translator.A4Options;
import edu.mit.csail.sdg.translator.A4Solution;
import edu.mit.csail.sdg.translator.A4SolutionReader;
import edu.mit.csail.sdg.translator.A4Tuple;
import edu.mit.csail.sdg.translator.A4TupleSet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowListener;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import kodkod.engine.fol2sat.HigherOrderDeclException;
import kodkod.engine.satlab.SATFactory;
import org.alloytools.alloy.core.AlloyCore;

public final class SimpleGUI
implements ComponentListener,
Listener {
    static final Pattern TYPED_P = Pattern.compile("([A-Z]{3,6}):");
    private JFrame frame;
    private VizGUI viz;
    private JMenu filemenu;
    private JMenu editmenu;
    private JMenu runmenu;
    private JMenu optmenu;
    private JMenu windowmenu;
    private JMenu windowmenu2;
    private JMenu helpmenu;
    private JToolBar toolbar;
    private JButton runbutton;
    private JButton stopbutton;
    private JButton showbutton;
    private JSplitPane splitpane;
    private JLabel status;
    private boolean lastFocusIsOnEditor = true;
    private OurTabbedSyntaxWidget text;
    private SwingLogPanel log;
    private JScrollPane logpane;
    final FindReplace findReplace;
    private static final Icon iconYes;
    private static final Icon iconNo;
    private static final String fs;
    private static final Color background;
    private int subrunningTask = 0;
    private int subMemoryNow = 0;
    private int subStackNow = 0;
    private List<Command> commands = null;
    private int latestCommand = 0;
    private int latestAlloyVersion = -1;
    private String latestAlloyVersionName = "unknown";
    private String latestInstance = "";
    private String latestAutoInstance = "";
    private boolean wrap = false;
    private PreferencesDialog prefDialog;
    private static String alloyHome;
    final Color supCoreColor = new Color(0.95f, 0.1f, 0.1f);
    final Color coreColor = new Color(0.9f, 0.4f, 0.4f);
    final Color subCoreColor = new Color(0.9f, 0.7f, 0.7f);
    private final Computer enumerator = new Computer(){

        public String compute(Object input) {
            String[] arg = (String[])input;
            OurUtil.show((JFrame)SimpleGUI.this.frame);
            if (WorkerEngine.isBusy()) {
                throw new RuntimeException("Alloy4 is currently executing a SAT solver command. Please wait until that command has finished.");
            }
            SimpleReporter.SimpleCallback1 cb = new SimpleReporter.SimpleCallback1(SimpleGUI.this, SimpleGUI.this.viz, SimpleGUI.this.log, ((A4Preferences.Verbosity)A4Preferences.VerbosityPref.get()).ordinal(), SimpleGUI.this.latestAlloyVersionName, SimpleGUI.this.latestAlloyVersion);
            SimpleReporter.SimpleTask2 task = new SimpleReporter.SimpleTask2();
            task.filename = arg[0];
            task.index = Integer.valueOf(arg[1]);
            try {
                if (AlloyCore.isDebug()) {
                    WorkerEngine.runLocally((WorkerEngine.WorkerTask)task, (WorkerEngine.WorkerCallback)cb);
                } else {
                    WorkerEngine.run((WorkerEngine.WorkerTask)task, (int)((Integer)A4Preferences.SubMemory.get()), (int)((Integer)A4Preferences.SubStack.get()), (String)"", (WorkerEngine.WorkerCallback)cb);
                }
            }
            catch (Throwable ex) {
                WorkerEngine.stop();
                SimpleGUI.this.log.logBold("Fatal Error: Solver failed due to unknown reason.\nOne possible cause is that, in the Options menu, your specified\nmemory size is larger than the amount allowed by your OS.\nAlso, please make sure \"java\" is in your program path.\n");
                SimpleGUI.this.log.logDivider();
                SimpleGUI.this.log.flush();
                SimpleGUI.this.doStop(2);
                return arg[0];
            }
            SimpleGUI.this.subrunningTask = task.index < 1 ? 2 : 3;
            SimpleGUI.this.runmenu.setEnabled(false);
            SimpleGUI.this.runbutton.setVisible(false);
            SimpleGUI.this.showbutton.setEnabled(false);
            SimpleGUI.this.stopbutton.setVisible(true);
            return arg[0];
        }
    };
    private static Computer evaluator;

    public JFrame getFrame() {
        return this.frame;
    }

    private void addHistory(String filename) {
        String name0 = (String)A4Preferences.Model0.get();
        String name1 = (String)A4Preferences.Model1.get();
        String name2 = (String)A4Preferences.Model2.get();
        if (name0.equals(filename)) {
            return;
        }
        A4Preferences.Model0.set((Object)filename);
        A4Preferences.Model1.set((Object)name0);
        if (name1.equals(filename)) {
            return;
        }
        A4Preferences.Model2.set((Object)name1);
        if (name2.equals(filename)) {
            return;
        }
        A4Preferences.Model3.set((Object)name2);
    }

    private Runner notifyFocusGained() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.lastFocusIsOnEditor = true;
        return null;
    }

    void notifyFocusLost() {
        this.lastFocusIsOnEditor = false;
    }

    private Runner notifyChange() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.commands = null;
        if (this.text == null) {
            return null;
        }
        OurSyntaxWidget t = this.text.get();
        if (Util.onMac()) {
            this.frame.getRootPane().putClientProperty("windowModified", t.modified());
        }
        if (t.isFile()) {
            this.frame.setTitle(t.getFilename());
        } else {
            this.frame.setTitle("Alloy Analyzer " + Version.getShortversion());
        }
        this.toolbar.setBorder((Border)new OurBorder(false, false, this.text.count() <= 1, false));
        int c = t.getCaret();
        int y = t.getLineOfOffset(c) + 1;
        int x = c - t.getLineStartOffset(y - 1) + 1;
        this.status.setText("<html>&nbsp; Line " + y + ", Column " + x + (t.modified() ? " <b style=\"color:#B43333;\">[modified]</b></html>" : "</html>"));
        return null;
    }

    public static String slightlyShorterFilename(String name) {
        if (name.toLowerCase(Locale.US).endsWith(".als")) {
            int i = name.lastIndexOf(47);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.lastIndexOf(92)) >= 0) {
                name = name.substring(i + 1);
            }
            return name.substring(0, name.length() - 4);
        }
        if (name.toLowerCase(Locale.US).endsWith(".xml")) {
            int i = name.lastIndexOf(47);
            if (i > 0) {
                i = name.lastIndexOf(47, i - 1);
            }
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.lastIndexOf(92)) > 0) {
                i = name.lastIndexOf(92, i - 1);
            }
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            return name.substring(0, name.length() - 4);
        }
        return name;
    }

    private void copyFromJAR() {
        String platformBinary = SimpleGUI.alloyHome(this.frame) + fs + "binary";
        System.setProperty("alloy.binary", platformBinary);
        try {
            new File(platformBinary).mkdirs();
            Util.writeAll((String)(platformBinary + fs + "tmp.cnf"), (String)"p cnf 3 1\n1 0\n");
        }
        catch (Err err) {
            // empty catch block
        }
        Util.copy((JFrame)this.frame, (boolean)false, (boolean)true, (String)SimpleGUI.alloyHome(this.frame), (String[])new String[]{"models/book/appendixA/addressBook1.als", "models/book/appendixA/addressBook2.als", "models/book/appendixA/barbers.als", "models/book/appendixA/closure.als", "models/book/appendixA/distribution.als", "models/book/appendixA/phones.als", "models/book/appendixA/prison.als", "models/book/appendixA/properties.als", "models/book/appendixA/ring.als", "models/book/appendixA/spanning.als", "models/book/appendixA/tree.als", "models/book/appendixA/tube.als", "models/book/appendixA/undirected.als", "models/book/appendixE/hotel.thm", "models/book/appendixE/p300-hotel.als", "models/book/appendixE/p303-hotel.als", "models/book/appendixE/p306-hotel.als", "models/book/chapter2/addressBook1a.als", "models/book/chapter2/addressBook1b.als", "models/book/chapter2/addressBook1c.als", "models/book/chapter2/addressBook1d.als", "models/book/chapter2/addressBook1e.als", "models/book/chapter2/addressBook1f.als", "models/book/chapter2/addressBook1g.als", "models/book/chapter2/addressBook1h.als", "models/book/chapter2/addressBook2a.als", "models/book/chapter2/addressBook2b.als", "models/book/chapter2/addressBook2c.als", "models/book/chapter2/addressBook2d.als", "models/book/chapter2/addressBook2e.als", "models/book/chapter2/addressBook3a.als", "models/book/chapter2/addressBook3b.als", "models/book/chapter2/addressBook3c.als", "models/book/chapter2/addressBook3d.als", "models/book/chapter2/theme.thm", "models/book/chapter4/filesystem.als", "models/book/chapter4/grandpa1.als", "models/book/chapter4/grandpa2.als", "models/book/chapter4/grandpa3.als", "models/book/chapter4/lights.als", "models/book/chapter5/addressBook.als", "models/book/chapter5/lists.als", "models/book/chapter5/sets1.als", "models/book/chapter5/sets2.als", "models/book/chapter6/hotel.thm", "models/book/chapter6/hotel1.als", "models/book/chapter6/hotel2.als", "models/book/chapter6/hotel3.als", "models/book/chapter6/hotel4.als", "models/book/chapter6/mediaAssets.als", "models/book/chapter6/memory/abstractMemory.als", "models/book/chapter6/memory/cacheMemory.als", "models/book/chapter6/memory/checkCache.als", "models/book/chapter6/memory/checkFixedSize.als", "models/book/chapter6/memory/fixedSizeMemory.als", "models/book/chapter6/memory/fixedSizeMemory_H.als", "models/book/chapter6/ringElection.thm", "models/book/chapter6/ringElection1.als", "models/book/chapter6/ringElection2.als", "models/examples/algorithms/dijkstra.als", "models/examples/algorithms/dijkstra.thm", "models/examples/algorithms/messaging.als", "models/examples/algorithms/messaging.thm", "models/examples/algorithms/opt_spantree.als", "models/examples/algorithms/opt_spantree.thm", "models/examples/algorithms/peterson.als", "models/examples/algorithms/ringlead.als", "models/examples/algorithms/ringlead.thm", "models/examples/algorithms/s_ringlead.als", "models/examples/algorithms/stable_mutex_ring.als", "models/examples/algorithms/stable_mutex_ring.thm", "models/examples/algorithms/stable_orient_ring.als", "models/examples/algorithms/stable_orient_ring.thm", "models/examples/algorithms/stable_ringlead.als", "models/examples/algorithms/stable_ringlead.thm", "models/examples/case_studies/INSLabel.als", "models/examples/case_studies/chord.als", "models/examples/case_studies/chord2.als", "models/examples/case_studies/chordbugmodel.als", "models/examples/case_studies/com.als", "models/examples/case_studies/firewire.als", "models/examples/case_studies/firewire.thm", "models/examples/case_studies/ins.als", "models/examples/case_studies/iolus.als", "models/examples/case_studies/sync.als", "models/examples/case_studies/syncimpl.als", "models/examples/puzzles/farmer.als", "models/examples/puzzles/farmer.thm", "models/examples/puzzles/handshake.als", "models/examples/puzzles/handshake.thm", "models/examples/puzzles/hanoi.als", "models/examples/puzzles/hanoi.thm", "models/examples/systems/file_system.als", "models/examples/systems/file_system.thm", "models/examples/systems/javatypes_soundness.als", "models/examples/systems/lists.als", "models/examples/systems/lists.thm", "models/examples/systems/marksweepgc.als", "models/examples/systems/views.als", "models/examples/toys/birthday.als", "models/examples/toys/birthday.thm", "models/examples/toys/ceilingsAndFloors.als", "models/examples/toys/ceilingsAndFloors.thm", "models/examples/toys/genealogy.als", "models/examples/toys/genealogy.thm", "models/examples/toys/grandpa.als", "models/examples/toys/grandpa.thm", "models/examples/toys/javatypes.als", "models/examples/toys/life.als", "models/examples/toys/life.thm", "models/examples/toys/numbering.als", "models/examples/toys/railway.als", "models/examples/toys/railway.thm", "models/examples/toys/trivial.als", "models/examples/tutorial/farmer.als", "models/util/boolean.als", "models/util/graph.als", "models/util/integer.als", "models/util/natural.als", "models/util/ordering.als", "models/util/relation.als", "models/util/seqrel.als", "models/util/sequence.als", "models/util/sequniv.als", "models/util/ternary.als", "models/util/time.als", "models/examples/temporal/buffer.als", "models/examples/temporal/leader.als", "models/examples/temporal/leader_events.als", "models/examples/temporal/trash.als"});
        System.setProperty("alloy.theme0", SimpleGUI.alloyHome(this.frame) + fs + "models");
        System.setProperty("alloy.home", SimpleGUI.alloyHome(this.frame));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.componentMoved(e);
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        A4Preferences.AnalyzerWidth.set((Object)this.frame.getWidth());
        A4Preferences.AnalyzerHeight.set((Object)this.frame.getHeight());
        A4Preferences.AnalyzerX.set((Object)this.frame.getX());
        A4Preferences.AnalyzerY.set((Object)this.frame.getY());
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private Runner wrapMe() {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            final String name = ex.getStackTrace()[1].getMethodName();
            Method[] methods = this.getClass().getDeclaredMethods();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                m = methods[i];
                break;
            }
            final Method method = m;
            return new Runner(){
                private static final long serialVersionUID = 0L;

                public void run() {
                    try {
                        method.setAccessible(true);
                        method.invoke((Object)SimpleGUI.this, new Object[0]);
                    }
                    catch (Throwable ex2) {
                        IllegalArgumentException ex2 = new IllegalArgumentException("Failed call to " + name + "()", ex2);
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex2);
                    }
                }

                public void run(Object arg) {
                    this.run();
                }
            };
        }
    }

    private Runner wrapMe(final Object argument) {
        try {
            throw new Exception();
        }
        catch (Exception ex) {
            final String name = ex.getStackTrace()[1].getMethodName();
            Method[] methods = this.getClass().getDeclaredMethods();
            Method m = null;
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                m = methods[i];
                break;
            }
            final Method method = m;
            return new Runner(){
                private static final long serialVersionUID = 0L;

                public void run(Object arg) {
                    try {
                        method.setAccessible(true);
                        method.invoke((Object)SimpleGUI.this, arg);
                    }
                    catch (Throwable ex2) {
                        IllegalArgumentException ex2 = new IllegalArgumentException("Failed call to " + name + "(" + String.valueOf(arg) + ")", ex2);
                        Thread.getDefaultUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), ex2);
                    }
                }

                public void run() {
                    this.run(argument);
                }
            };
        }
    }

    public static synchronized String alloyHome(JFrame parent) {
        String username;
        if (alloyHome != null) {
            return alloyHome;
        }
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null || temp.length() == 0) {
            OurDialog.fatal((JFrame)parent, (Object)"Error. JVM need to specify a temporary directory using java.io.tmpdir property.");
        }
        File tempfile = new File(temp + File.separatorChar + "alloy-tmp-" + ((username = System.getProperty("user.name")) == null ? "" : username));
        tempfile.mkdirs();
        String ans = Util.canon((String)tempfile.getPath());
        if (!tempfile.isDirectory()) {
            OurDialog.fatal((JFrame)parent, (Object)("Error. Cannot create the temporary directory " + ans));
        }
        if (!Util.onWindows()) {
            String[] args = new String[]{"chmod", "700", ans};
            try {
                Runtime.getRuntime().exec(args).waitFor();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        alloyHome = ans;
        return alloyHome;
    }

    public static String maketemp(JFrame parent) {
        int i;
        String dest;
        File f;
        Random r = new Random(new Date().getTime());
        do {
            i = r.nextInt(1000000);
        } while (!(f = new File(dest = SimpleGUI.alloyHome(parent) + File.separatorChar + "tmp" + File.separatorChar + i)).mkdirs());
        f.deleteOnExit();
        return Util.canon((String)dest);
    }

    private static long computeTemporarySpaceUsed(JFrame parent) {
        long ans = SimpleGUI.iterateTemp(parent, null, false);
        if (ans < 0L) {
            return -1L;
        }
        return ans;
    }

    private static void clearTemporarySpace(JFrame parent) {
        SimpleGUI.iterateTemp(parent, null, true);
        String temp = System.getProperty("java.io.tmpdir");
        if (temp == null || temp.length() == 0) {
            return;
        }
        String username = System.getProperty("user.name");
        if (username == null) {
            username = "";
        }
        for (int i = 1; i < 40; ++i) {
            SimpleGUI.iterateTemp(parent, temp + File.separatorChar + "alloy4tmp" + i + "-" + username, true);
        }
    }

    private static long iterateTemp(JFrame parent, String filename, boolean delete) {
        File x;
        long ans = 0L;
        if (filename == null) {
            filename = SimpleGUI.alloyHome(parent) + File.separatorChar + "tmp";
        }
        if ((x = new File((String)filename)).isDirectory()) {
            for (String subfile : x.list()) {
                long tmp = SimpleGUI.iterateTemp(parent, (String)filename + File.separatorChar + subfile, delete);
                if (ans < 0L) continue;
                ans += tmp;
            }
        } else if (x.isFile()) {
            long tmp = x.length();
            if (ans >= 0L) {
                ans += tmp;
            }
        }
        if (delete) {
            x.delete();
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runner doRefreshFile() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            this.wrap = true;
            this.filemenu.removeAll();
            OurUtil.menuItem((JMenu)this.filemenu, (String)"New", (Object[])new Object[]{Character.valueOf('N'), Character.valueOf('N'), this.doNew()});
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Open...", (Object[])new Object[]{Character.valueOf('O'), Character.valueOf('O'), this.doOpen()});
            if (!Util.onMac()) {
                OurUtil.menuItem((JMenu)this.filemenu, (String)"Open Sample Models...", (Object[])new Object[]{18, Character.valueOf('O'), this.doBuiltin()});
            } else {
                OurUtil.menuItem((JMenu)this.filemenu, (String)"Open Sample Models...", (Object[])new Object[]{this.doBuiltin()});
            }
            JMenu recentmenu = new JMenu("Open Recent");
            this.filemenu.add(recentmenu);
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Reload all", (Object[])new Object[]{Character.valueOf('R'), Character.valueOf('R'), this.doReloadAll()});
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Save", (Object[])new Object[]{Character.valueOf('S'), Character.valueOf('S'), this.doSave()});
            if (Util.onMac()) {
                OurUtil.menuItem((JMenu)this.filemenu, (String)"Save As...", (Object[])new Object[]{16, Character.valueOf('S'), this.doSaveAs()});
            } else {
                OurUtil.menuItem((JMenu)this.filemenu, (String)"Save As...", (char)'A', (Runnable)this.doSaveAs());
            }
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Close", (Object[])new Object[]{Character.valueOf('W'), Character.valueOf('W'), this.doClose()});
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Clear Temporary Directory", (Object[])new Object[]{this.doClearTemp()});
            OurUtil.menuItem((JMenu)this.filemenu, (String)"Quit", (Object[])new Object[]{Character.valueOf('Q'), Util.onMac() ? -1 : 81, this.doQuit()});
            boolean found = false;
            for (A4Preferences.StringPref p : new A4Preferences.StringPref[]{A4Preferences.Model0, A4Preferences.Model1, A4Preferences.Model2, A4Preferences.Model3}) {
                String name = (String)p.get();
                if (name.length() <= 0) continue;
                found = true;
                OurUtil.menuItem((JMenu)recentmenu, (String)name, (Object[])new Object[]{this.doOpenFile(name)});
            }
            recentmenu.addSeparator();
            OurUtil.menuItem((JMenu)recentmenu, (String)"Clear Menu", (Object[])new Object[]{this.doClearRecent()});
            recentmenu.setEnabled(found);
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doNew() {
        if (!this.wrap) {
            this.text.newtab(null);
            this.notifyChange();
            this.doShow();
        }
        return this.wrapMe();
    }

    private Runner doOpen() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = this.getFile(null);
        if (file != null) {
            Util.setCurrentDirectory((File)file.getParentFile());
            this.doOpenFile(file.getPath());
        }
        return null;
    }

    private Runner doBuiltin() {
        if (this.wrap) {
            return this.wrapMe();
        }
        File file = this.getFile(SimpleGUI.alloyHome(this.frame) + fs + "models");
        if (file != null) {
            this.doOpenFile(file.getPath());
        }
        return null;
    }

    private File getFile(String home) {
        File file = OurDialog.askFile((Frame)this.frame, (boolean)true, (String)home, (String[])new String[]{".als", ".md", "*"}, (String)"Alloy (.als) or Markdown (.md) files");
        return file;
    }

    private Runner doReloadAll() {
        if (!this.wrap) {
            this.text.reloadAll();
        }
        return this.wrapMe();
    }

    private Runner doClearRecent() {
        if (!this.wrap) {
            A4Preferences.Model0.set((Object)"");
            A4Preferences.Model1.set((Object)"");
            A4Preferences.Model2.set((Object)"");
            A4Preferences.Model3.set((Object)"");
        }
        return this.wrapMe();
    }

    private Runner doSave() {
        if (!this.wrap) {
            String ans = this.text.save(false);
            if (ans == null) {
                return null;
            }
            this.notifyChange();
            this.addHistory(ans);
            this.log.clearError();
        }
        return this.wrapMe();
    }

    private Runner doSaveAs() {
        if (!this.wrap) {
            String ans = this.text.save(true);
            if (ans == null) {
                return null;
            }
            this.notifyChange();
            this.addHistory(ans);
            this.log.clearError();
        }
        return this.wrapMe();
    }

    private Runner doClearTemp() {
        if (!this.wrap) {
            SimpleGUI.clearTemporarySpace(this.frame);
            this.copyFromJAR();
            this.log.logBold("Temporary directory has been cleared.\n\n");
            this.log.logDivider();
            this.log.flush();
        }
        return this.wrapMe();
    }

    private Runner doClose() {
        if (!this.wrap) {
            this.text.close();
        }
        return this.wrapMe();
    }

    public Runner doQuit() {
        if (!this.wrap && this.text.closeAll()) {
            try {
                WorkerEngine.stop();
            }
            finally {
                System.exit(0);
            }
        }
        return this.wrapMe();
    }

    private Runner doRefreshEdit() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            this.wrap = true;
            boolean canUndo = this.text.get().canUndo();
            boolean canRedo = this.text.get().canRedo();
            this.editmenu.removeAll();
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Undo", (Object[])new Object[]{Character.valueOf('Z'), Character.valueOf('Z'), this.doUndo(), canUndo});
            if (Util.onMac()) {
                OurUtil.menuItem((JMenu)this.editmenu, (String)"Redo", (Object[])new Object[]{16, Character.valueOf('Z'), this.doRedo(), canRedo});
            } else {
                OurUtil.menuItem((JMenu)this.editmenu, (String)"Redo", (Object[])new Object[]{Character.valueOf('Y'), Character.valueOf('Y'), this.doRedo(), canRedo});
            }
            this.editmenu.addSeparator();
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Cut", (Object[])new Object[]{Character.valueOf('X'), Character.valueOf('X'), this.doCut()});
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Copy", (Object[])new Object[]{Character.valueOf('C'), Character.valueOf('C'), this.doCopy()});
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Paste", (Object[])new Object[]{Character.valueOf('V'), Character.valueOf('V'), this.doPaste()});
            this.editmenu.addSeparator();
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Go To...", (Object[])new Object[]{Character.valueOf('T'), Character.valueOf('T'), this.doGoto()});
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Previous File", (Object[])new Object[]{33, 33, this.doGotoPrevFile(), this.text.count() > 1});
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Next File", (Object[])new Object[]{34, 34, this.doGotoNextFile(), this.text.count() > 1});
            this.editmenu.addSeparator();
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Select All", (char)'A', () -> this.text.get().getTextPane().selectAll());
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Expand Selection", (char)'D', () -> this.text.get().doExpandSelection());
            this.editmenu.addSeparator();
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Find/Replace...", (char)'F', this.findReplace::find);
            OurUtil.menuItem((JMenu)this.editmenu, (String)"Find Next", (char)'G', this.findReplace::findNext);
            if (!Util.onMac()) {
                this.editmenu.addSeparator();
                OurUtil.menuItem((JMenu)this.editmenu, (String)"Preferences", (Object[])new Object[]{Character.valueOf('P'), Character.valueOf('P'), this.doPreferences()});
            }
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doUndo() {
        if (!this.wrap) {
            this.text.get().undo();
        }
        return this.wrapMe();
    }

    private Runner doRedo() {
        if (!this.wrap) {
            this.text.get().redo();
        }
        return this.wrapMe();
    }

    private Runner doCopy() {
        if (!this.wrap) {
            if (this.lastFocusIsOnEditor) {
                this.text.get().copy();
            } else {
                this.log.copy();
            }
        }
        return this.wrapMe();
    }

    private Runner doCut() {
        if (!this.wrap && this.lastFocusIsOnEditor) {
            this.text.get().cut();
        }
        return this.wrapMe();
    }

    private Runner doPaste() {
        if (!this.wrap && this.lastFocusIsOnEditor) {
            this.text.get().paste();
        }
        return this.wrapMe();
    }

    public Runner doPreferences() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.prefDialog.setVisible(true);
        return null;
    }

    private Runner doLookAndFeel() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            if ("Native".equals(A4Preferences.LAF.get())) {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            if (this.frame != null) {
                SwingUtilities.updateComponentTreeUI(this.frame);
                SwingUtilities.updateComponentTreeUI(this.prefDialog);
                SwingUtilities.updateComponentTreeUI(this.viz.getFrame());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Runner doGoto() {
        JTextField x;
        if (this.wrap) {
            return this.wrapMe();
        }
        JTextField y = OurUtil.textfield((String)"", (int)10, (Object[])new Object[0]);
        if (!OurDialog.getInput((JFrame)this.frame, (String)"Go To", (Object[])new Object[]{"Line Number:", y, "Column Number (optional):", x = OurUtil.textfield((String)"", (int)10, (Object[])new Object[0])})) {
            return null;
        }
        try {
            int caret;
            OurSyntaxWidget t = this.text.get();
            int xx = 1;
            int yy = Integer.parseInt(y.getText());
            int lineCount = t.getLineCount();
            if (yy < 1) {
                return null;
            }
            if (yy > lineCount) {
                this.log.logRed("This file only has " + lineCount + " line(s).");
                return null;
            }
            if (x.getText().length() != 0) {
                xx = Integer.parseInt(x.getText());
            }
            if (xx < 1) {
                this.log.logRed("If the column number is specified, it must be 1 or greater.");
                return null;
            }
            int len = (yy == lineCount ? t.getText().length() + 1 : t.getLineStartOffset(yy)) - (caret = t.getLineStartOffset(yy - 1));
            if (xx > len) {
                xx = len;
            }
            if (xx < 1) {
                xx = 1;
            }
            t.moveCaret(caret + xx - 1, caret + xx - 1);
            t.requestFocusInWindow();
        }
        catch (NumberFormatException ex) {
            this.log.logRed("The number must be 1 or greater.");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private Runner doGotoPrevFile() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.text.prev();
        return null;
    }

    private Runner doGotoNextFile() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.text.next();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runner doRefreshRun() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            this.wrap = true;
            this.runmenu.removeAll();
            OurUtil.menuItem((JMenu)this.runmenu, (String)"Execute Latest Command", (Object[])new Object[]{Character.valueOf('E'), Character.valueOf('E'), this.doExecuteLatest()});
            this.runmenu.add(new JSeparator());
            OurUtil.menuItem((JMenu)this.runmenu, (String)"Show Latest Instance", (Object[])new Object[]{Character.valueOf('L'), Character.valueOf('L'), this.doShowLatest(), this.latestInstance.length() > 0});
            OurUtil.menuItem((JMenu)this.runmenu, (String)"Show Metamodel", (Object[])new Object[]{Character.valueOf('M'), Character.valueOf('M'), this.doShowMetaModel()});
            if (Version.experimental) {
                OurUtil.menuItem((JMenu)this.runmenu, (String)"Show Parse Tree", (char)'P', (Runnable)this.doShowParseTree());
            }
        }
        finally {
            this.wrap = false;
        }
        ConstList cp = this.commands;
        if (cp == null) {
            try {
                String source = this.text.get().getText();
                cp = CompUtil.parseOneModule_fromString((String)source);
            }
            catch (Err e) {
                this.commands = null;
                this.runmenu.getItem(0).setEnabled(false);
                this.runmenu.getItem(3).setEnabled(false);
                this.text.shade(new Pos(this.text.get().getFilename(), e.pos.x, e.pos.y, e.pos.x2, e.pos.y2));
                if (AlloyCore.isDebug() && A4Preferences.VerbosityPref.get() == A4Preferences.Verbosity.FULLDEBUG) {
                    this.log.logRed("Fatal Exception!" + e.dump() + "\n\n");
                } else {
                    this.log.logRed(e.toString() + "\n\n");
                }
                return null;
            }
            catch (Throwable e) {
                this.commands = null;
                this.runmenu.getItem(0).setEnabled(false);
                this.runmenu.getItem(3).setEnabled(false);
                this.log.logRed("Cannot parse the model.\n" + e.toString() + "\n\n");
                return null;
            }
            this.commands = cp;
        }
        this.text.clearShade();
        this.log.clearError();
        if (cp == null) {
            this.runmenu.getItem(0).setEnabled(false);
            this.runmenu.getItem(3).setEnabled(false);
            return null;
        }
        if (cp.size() == 0) {
            this.runmenu.getItem(0).setEnabled(false);
            return null;
        }
        if (this.latestCommand >= cp.size()) {
            this.latestCommand = cp.size() - 1;
        }
        this.runmenu.remove(0);
        try {
            this.wrap = true;
            for (int i = 0; i < cp.size(); ++i) {
                JMenuItem menuItem = new JMenuItem(((Command)cp.get(i)).toString(), null);
                menuItem.addActionListener((ActionListener)this.doRun(i));
                if (i == this.latestCommand) {
                    menuItem.setMnemonic(69);
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                }
                this.runmenu.add((Component)menuItem, i);
            }
            if (cp.size() > 1) {
                JMenuItem menuItem = new JMenuItem("Execute All", null);
                int mnemonic = Util.onMac() ? 85 : 65;
                menuItem.setMnemonic(mnemonic);
                menuItem.setAccelerator(KeyStroke.getKeyStroke(mnemonic, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
                menuItem.addActionListener((ActionListener)this.doRun(-1));
                this.runmenu.add((Component)menuItem, 0);
                this.runmenu.add((Component)new JSeparator(), 1);
            }
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doRun(Integer commandIndex) {
        if (this.wrap) {
            return this.wrapMe(commandIndex);
        }
        int index = commandIndex;
        if (WorkerEngine.isBusy()) {
            return null;
        }
        this.subrunningTask = index == -2 ? 1 : 0;
        this.latestAutoInstance = "";
        if (index >= 0) {
            this.latestCommand = index;
        }
        if (index == -1 && this.commands != null) {
            this.latestCommand = this.commands.size() - 1;
            if (this.latestCommand < 0) {
                this.latestCommand = 0;
            }
        }
        this.doRefreshRun();
        OurUtil.enableAll((JMenu)this.runmenu);
        if (this.commands == null) {
            return null;
        }
        if (this.commands.size() == 0 && index != -2 && index != -3) {
            this.log.logRed("There are no commands to execute.\n\n");
            return null;
        }
        int i = index;
        if (i >= this.commands.size()) {
            i = this.commands.size() - 1;
        }
        SimpleReporter.SimpleCallback1 cb = new SimpleReporter.SimpleCallback1(this, null, this.log, ((A4Preferences.Verbosity)A4Preferences.VerbosityPref.get()).ordinal(), this.latestAlloyVersionName, this.latestAlloyVersion);
        SimpleReporter.SimpleTask1 task = new SimpleReporter.SimpleTask1();
        A4Options opt = new A4Options();
        opt.tempDirectory = SimpleGUI.alloyHome(this.frame) + fs + "tmp";
        opt.solverDirectory = SimpleGUI.alloyHome(this.frame) + fs + "binary";
        opt.recordKodkod = (Boolean)A4Preferences.RecordKodkod.get();
        opt.noOverflow = (Boolean)A4Preferences.NoOverflow.get();
        opt.unrolls = Version.experimental ? (Integer)A4Preferences.Unrolls.get() : -1;
        opt.skolemDepth = (Integer)A4Preferences.SkolemDepth.get();
        opt.coreMinimization = (Integer)A4Preferences.CoreMinimization.get();
        opt.inferPartialInstance = (Boolean)A4Preferences.InferPartialInstance.get();
        opt.coreGranularity = (Integer)A4Preferences.CoreGranularity.get();
        opt.decompose_mode = ((A4Preferences.Decompose)A4Preferences.DecomposePref.get()).ordinal();
        opt.originalFilename = Util.canon((String)this.text.get().getFilename());
        opt.solver = (SATFactory)A4Preferences.Solver.get();
        task.bundleIndex = i;
        task.bundleWarningNonFatal = (Boolean)A4Preferences.WarningNonfatal.get();
        task.map = this.text.takeSnapshot();
        task.options = opt.dup();
        task.resolutionMode = Version.experimental && (Boolean)A4Preferences.ImplicitThis.get() != false ? 2 : 1;
        task.tempdir = SimpleGUI.maketemp(this.frame);
        try {
            this.runmenu.setEnabled(false);
            this.runbutton.setVisible(false);
            this.showbutton.setEnabled(false);
            this.stopbutton.setVisible(true);
            int newmem = (Integer)A4Preferences.SubMemory.get();
            int newstack = (Integer)A4Preferences.SubStack.get();
            if (newmem != this.subMemoryNow || newstack != this.subStackNow) {
                WorkerEngine.stop();
            }
            if (AlloyCore.isDebug()) {
                WorkerEngine.runLocally((WorkerEngine.WorkerTask)task, (WorkerEngine.WorkerCallback)cb);
            } else {
                WorkerEngine.run((WorkerEngine.WorkerTask)task, (int)newmem, (int)newstack, (String)"", (WorkerEngine.WorkerCallback)cb);
            }
            this.subMemoryNow = newmem;
            this.subStackNow = newstack;
        }
        catch (Throwable ex) {
            WorkerEngine.stop();
            this.log.logBold("Fatal Error: Solver failed due to unknown reason.\nOne possible cause is that, in the Options menu, your specified\nmemory size is larger than the amount allowed by your OS.\nAlso, please make sure \"java\" is in your program path.\n");
            this.log.logDivider();
            this.log.flush();
            this.doStop(2);
        }
        return null;
    }

    Runner doStop(Integer how) {
        if (this.wrap) {
            return this.wrapMe(how);
        }
        int h = how;
        if (h != 0) {
            if (h == 2 && WorkerEngine.isBusy()) {
                WorkerEngine.stop();
                this.log.logBold("\nSolving Stopped.\n");
                this.log.logDivider();
            }
            WorkerEngine.stop();
        }
        this.runmenu.setEnabled(true);
        this.runbutton.setVisible(true);
        this.showbutton.setEnabled(true);
        this.stopbutton.setVisible(false);
        if (this.latestAutoInstance.length() > 0) {
            String f = this.latestAutoInstance;
            this.latestAutoInstance = "";
            if (this.subrunningTask == 2) {
                this.viz.loadXML(f, true, 0);
            } else if (this.subrunningTask == 3) {
                this.viz.loadXML(f, true);
            } else if (((Boolean)A4Preferences.AutoVisualize.get()).booleanValue() || this.subrunningTask == 1) {
                this.doVisualize(f);
            }
        } else {
            this.viz.noNewInstance();
        }
        return null;
    }

    private Runner doExecuteLatest() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.doRefreshRun();
        OurUtil.enableAll((JMenu)this.runmenu);
        if (this.commands == null) {
            return null;
        }
        int n = this.commands.size();
        if (n <= 0) {
            this.log.logRed("There are no commands to execute.\n\n");
            return null;
        }
        if (this.latestCommand >= n) {
            this.latestCommand = n - 1;
        }
        if (this.latestCommand < 0) {
            this.latestCommand = 0;
        }
        return this.doRun(this.latestCommand);
    }

    private Runner doShowParseTree() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.doRefreshRun();
        OurUtil.enableAll((JMenu)this.runmenu);
        if (this.commands != null) {
            CompModule world = null;
            try {
                int resolutionMode = Version.experimental && (Boolean)A4Preferences.ImplicitThis.get() != false ? 2 : 1;
                A4Options opt = new A4Options();
                opt.tempDirectory = SimpleGUI.alloyHome(this.frame) + fs + "tmp";
                opt.solverDirectory = SimpleGUI.alloyHome(this.frame) + fs + "binary";
                opt.originalFilename = Util.canon((String)this.text.get().getFilename());
                world = CompUtil.parseEverything_fromFile((A4Reporter)A4Reporter.NOP, (Map)this.text.takeSnapshot(), (String)opt.originalFilename, (int)resolutionMode);
            }
            catch (Err er) {
                this.text.shade(er.pos);
                this.log.logRed(er.toString() + "\n\n");
                return null;
            }
            world.showAsTree((Listener)this);
        }
        return null;
    }

    private Runner doShowMetaModel() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.doRefreshRun();
        OurUtil.enableAll((JMenu)this.runmenu);
        if (this.commands != null) {
            this.doRun(-2);
        }
        return null;
    }

    private Runner doShowLatest() {
        if (this.wrap) {
            return this.wrapMe();
        }
        if (this.latestInstance.length() == 0) {
            this.log.logRed("No previous instances are available for viewing.\n\n");
        } else {
            this.doVisualize(this.latestInstance);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Runner doRefreshWindow(Boolean isViz) {
        if (this.wrap) {
            return this.wrapMe(isViz);
        }
        try {
            JMenuItem it;
            this.wrap = true;
            JMenu w = isViz != false ? this.windowmenu2 : this.windowmenu;
            w.removeAll();
            if (isViz.booleanValue()) {
                this.viz.addMinMaxActions(w);
            } else {
                OurUtil.menuItem((JMenu)w, (String)"Minimize", (Object[])new Object[]{Character.valueOf('M'), this.doMinimize(), iconNo});
                OurUtil.menuItem((JMenu)w, (String)"Zoom", (Object[])new Object[]{this.doZoom(), iconNo});
            }
            w.addSeparator();
            int i = 0;
            for (String f : this.text.getFilenames()) {
                it = new JMenuItem("Model: " + SimpleGUI.slightlyShorterFilename(f) + (this.text.modified(i) ? " *" : ""), null);
                it.setIcon(f.equals(this.text.get().getFilename()) && isViz == false ? iconYes : iconNo);
                it.addActionListener((ActionListener)(f.equals(this.text.get().getFilename()) ? this.doShow() : this.doOpenFile(f)));
                w.add(it);
                ++i;
            }
            if (this.viz != null) {
                for (String f : this.viz.getInstances()) {
                    it = new JMenuItem("Instance: " + this.viz.getInstanceTitle(f), null);
                    it.setIcon(isViz != false && f.equals(this.viz.getXMLfilename()) ? iconYes : iconNo);
                    it.addActionListener((ActionListener)this.doVisualize(f));
                    w.add(it);
                }
            }
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doMinimize() {
        if (this.wrap) {
            return this.wrapMe();
        }
        OurUtil.minimize((JFrame)this.frame);
        return null;
    }

    private Runner doZoom() {
        if (this.wrap) {
            return this.wrapMe();
        }
        OurUtil.zoom((JFrame)this.frame);
        return null;
    }

    private Runner doShow() {
        if (this.wrap) {
            return this.wrapMe();
        }
        OurUtil.show((JFrame)this.frame);
        this.text.get().requestFocusInWindow();
        return null;
    }

    private Runner doRefreshOption() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            this.wrap = true;
            this.optmenu.removeAll();
            this.addToMenu(this.optmenu, A4Preferences.Welcome);
            this.optmenu.addSeparator();
            this.addToMenu(this.optmenu, A4Preferences.WarningNonfatal);
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.SubMemory, A4Preferences.SubStack, A4Preferences.VerbosityPref});
            this.optmenu.addSeparator();
            this.addToMenu(this.optmenu, A4Preferences.SyntaxDisabled);
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.FontSize});
            OurUtil.menuItem((JMenu)this.optmenu, (String)("Font: " + (String)A4Preferences.FontName.get() + "..."), (Object[])new Object[]{this.doOptFontname()});
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.TabSize});
            if (Util.onMac() || Util.onWindows()) {
                OurUtil.menuItem((JMenu)this.optmenu, (String)"Use anti-aliasing: Yes", (Object[])new Object[]{false});
            } else {
                this.addToMenu(this.optmenu, A4Preferences.AntiAlias);
            }
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.LAF});
            this.addToMenu(this.optmenu, A4Preferences.LineNumbers);
            this.optmenu.addSeparator();
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.Solver});
            this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.SkolemDepth});
            JMenu cmMenu = this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.CoreMinimization});
            cmMenu.setEnabled(((SATFactory)A4Preferences.Solver.get()).prover());
            JMenu cgMenu = this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.CoreGranularity});
            cgMenu.setEnabled(((SATFactory)A4Preferences.Solver.get()).prover());
            this.addToMenu(this.optmenu, A4Preferences.AutoVisualize, A4Preferences.RecordKodkod);
            if (Version.experimental) {
                this.addToMenu(this.optmenu, new A4Preferences.ChoicePref[]{A4Preferences.Unrolls});
                this.addToMenu(this.optmenu, A4Preferences.DecomposePref);
                this.addToMenu(this.optmenu, A4Preferences.ImplicitThis, A4Preferences.NoOverflow, A4Preferences.InferPartialInstance);
            }
        }
        finally {
            this.wrap = false;
        }
        return null;
    }

    private Runner doOptFontname() {
        if (this.wrap) {
            return this.wrapMe();
        }
        int size = (Integer)A4Preferences.FontSize.get();
        String f = OurDialog.askFont((JFrame)this.frame);
        if (f.length() > 0) {
            A4Preferences.FontName.set((Object)f);
            this.text.setFont(f, size, ((Integer)A4Preferences.TabSize.get()).intValue());
            this.status.setFont(new Font(f, 0, size));
            this.log.setFontName(f);
        }
        return null;
    }

    private Runner doOptRefreshFont() {
        if (this.wrap) {
            return this.wrapMe();
        }
        String f = (String)A4Preferences.FontName.get();
        int n = (Integer)A4Preferences.FontSize.get();
        this.text.setFont(f, n, ((Integer)A4Preferences.TabSize.get()).intValue());
        this.status.setFont(new Font(f, 0, n));
        this.log.setFontSize(n);
        this.viz.doSetFontSize(n);
        return null;
    }

    private Runner doOptRefreshLineNumbers() {
        if (this.wrap) {
            return this.wrapMe();
        }
        this.text.enableLineNumbers(((Boolean)A4Preferences.LineNumbers.get()).booleanValue());
        return null;
    }

    private Runner doOptAntiAlias() {
        if (!this.wrap) {
            OurAntiAlias.enableAntiAlias((boolean)((Boolean)A4Preferences.AntiAlias.get()));
        }
        return this.wrapMe();
    }

    private Runner doOptSyntaxHighlighting() {
        if (!this.wrap) {
            this.text.enableSyntax((Boolean)A4Preferences.SyntaxDisabled.get() == false);
        }
        return this.wrapMe();
    }

    public Runner doAbout() {
        if (this.wrap) {
            return this.wrapMe();
        }
        HTMLEditorKit kit = new HTMLEditorKit();
        StyleSheet styleSheet = kit.getStyleSheet();
        styleSheet.addRule("body {color:#000; font-family:Verdana, Trebuchet MS,Geneva, sans-serif; font-size: 10px; margin: 4px; }");
        styleSheet.addRule("h1 {color: blue;}");
        styleSheet.addRule("h2 {color: #ff0000;}");
        styleSheet.addRule("pre {font : 10px monaco; color : black; background-color: #C0C0C0; padding: 4px; margin: 4px; }");
        styleSheet.addRule("th {text-align:left;}");
        JTextPane ta = new JTextPane();
        ta.setEditorKit(kit);
        ta.setContentType("text/html");
        ta.setBackground(null);
        ta.setBorder(null);
        ta.setFont(new JLabel().getFont());
        ta.setText("<html><h1>Alloy Analyzer " + Version.getShortversion() + "</h1><br/><html><tr><th>Project Lead</th><td>Daniel Jackson</td></tr><tr><th>Chief Developer</th><td>Aleksandar Milicevic</td></tr><tr><th>Kodkod Engine</th><td>Emina Torlak</td></tr><tr><th>Open Source</th><td>Peter Kriens</td></tr></table><br/><p>For more information about Alloy, <a href='http://alloytools.org'>http://alloytools.org</a></p><p>Questions and comments about Alloy are welcome at the community forum:</p><p>Alloy Community Forum: <a href='https://groups.google.com/forum/#!forum/alloytools'>https://groups.google.com/forum/#!forum/alloytools</a></p><p>Alloy experts also respond to <a href='https://stackoverflow.com/questions/tagged/alloy'>https://stackoverflow.com</a> questions tagged <code>alloy</code>.</p><p>Major contributions to earlier versions of Alloy were made by: Julien Brunel, David<br/>Chemouil, Alcino Cunha, Nuno Macedo, Denis Kuperberg, Eduardo Pessoa, Tiago Guimar\u00e3es<br/>(Electrum); Felix Chang (v4); Jonathan Edwards, Eunsuk Kang, Joe Near, Robert Seater,<br/>Derek Rayside, Greg Dennis, Ilya Shlyakhter, Mana Taghdiri, Mandana Vaziri, Sarfraz<br/>Khurshid (v3); Manu Sridharan (v2); Edmond Lau, Vincent Yeung, Sam Daitch, Andrew Yip,<br/>Jongmin Baek, Ning Song, Arturo Arizpe, Li-kuo (Brian) Lin, Joseph Cohen, Jesse Pavel,<br/>Ian Schechter, Uriel Schafer (v1).</p><p>The development of Alloy was funded by part by the National Science Foundation under<br/>Grant Nos. 0325283, 0541183, 0438897 and 0707612; by the Air Force Research Laboratory<br/>(AFRL/IF) and the Disruptive Technology Office (DTO) in the National Intelligence<br/>Community Information Assurance Research (NICIAR) Program; and by the Nokia<br/>Corporation as part of a collaboration between Nokia Research and MIT CSAIL.</p><br/><pre>Build Date: " + Version.buildDate() + "<br/>Git Commit: " + Version.commit + "</pre>");
        ta.setEditable(false);
        ta.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                try {
                    Desktop.getDesktop().browse(e.getURL().toURI());
                }
                catch (IOException | URISyntaxException exception) {
                    // empty catch block
                }
            }
        });
        OurDialog.showmsg((String)("About Alloy Analyzer " + Version.version()), (Object[])new Object[]{ta});
        return null;
    }

    private Runner doHelp() {
        if (this.wrap) {
            return this.wrapMe();
        }
        try {
            int w = OurUtil.getScreenWidth();
            int h = OurUtil.getScreenHeight();
            final JFrame frame = new JFrame();
            JEditorPane html1 = new JEditorPane("text/html", "");
            final JEditorPane html2 = new JEditorPane("text/html", "");
            HTMLDocument doc1 = (HTMLDocument)html1.getDocument();
            doc1.setAsynchronousLoadPriority(-1);
            HTMLDocument doc2 = (HTMLDocument)html2.getDocument();
            doc2.setAsynchronousLoadPriority(-1);
            html1.setPage(this.getClass().getResource("/help/Nav.html"));
            html2.setPage(this.getClass().getResource("/help/index.html"));
            HyperlinkListener hl = new HyperlinkListener(){

                @Override
                public final void hyperlinkUpdate(HyperlinkEvent e) {
                    try {
                        if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                            return;
                        }
                        if (e.getURL().getPath().endsWith("quit.htm")) {
                            frame.dispose();
                            return;
                        }
                        HTMLDocument doc = (HTMLDocument)html2.getDocument();
                        doc.setAsynchronousLoadPriority(-1);
                        html2.setPage(e.getURL());
                        html2.requestFocusInWindow();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
            html1.setEditable(false);
            html1.setBorder(new EmptyBorder(3, 3, 3, 3));
            html1.addHyperlinkListener(hl);
            html2.setEditable(false);
            html2.setBorder(new EmptyBorder(3, 3, 3, 3));
            html2.addHyperlinkListener(hl);
            JScrollPane scroll1 = OurUtil.scrollpane((Component)html1, (Object[])new Object[0]);
            JScrollPane scroll2 = OurUtil.scrollpane((Component)html2, (Object[])new Object[0]);
            JSplitPane split = OurUtil.splitpane((int)1, (Component)scroll1, (Component)scroll2, (int)150);
            split.setResizeWeight(0.0);
            frame.setTitle("Alloy Analyzer Online Guide");
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)split, "Center");
            frame.pack();
            frame.setSize(w - w / 10, h - h / 10);
            frame.setLocation(w / 20, h / 20);
            frame.setDefaultCloseOperation(2);
            frame.setVisible(true);
            html2.requestFocusInWindow();
        }
        finally {
            return null;
        }
    }

    private Runner doLicense() {
        String alloytxt;
        if (this.wrap) {
            return this.wrapMe();
        }
        final String JAR = Util.jarPrefix();
        try {
            alloytxt = Util.readAll((String)(JAR + "LICENSES" + File.separator + "Alloy.txt"));
        }
        catch (IOException ex) {
            return null;
        }
        final JTextArea text = OurUtil.textarea((String)alloytxt, (int)15, (int)85, (boolean)false, (boolean)false, (Object[])new Object[]{new EmptyBorder(2, 2, 2, 2), new Font("Monospaced", 0, 12)});
        JScrollPane scroll = OurUtil.scrollpane((Component)text, (Object[])new Object[]{new LineBorder(Color.DARK_GRAY, 1)});
        OurCombobox combo = new OurCombobox(new String[]{"Alloy", "Kodkod", "JavaCup", "SAT4J", "ZChaff", "MiniSat"}){
            private static final long serialVersionUID = 0L;

            public void do_changed(Object value) {
                if (value instanceof String) {
                    try {
                        String content = Util.readAll((String)(JAR + "LICENSES" + File.separator + String.valueOf(value) + ".txt"));
                        text.setText(content);
                    }
                    catch (IOException ex) {
                        text.setText("Sorry: an error has occurred in displaying the license file.");
                    }
                }
                text.setCaretPosition(0);
            }
        };
        OurDialog.showmsg((String)"Copyright Notices", (Object[])new Object[]{"The source code for the Alloy Analyzer is available under the MIT license.", " ", "The Alloy Analyzer utilizes several third-party packages whose code may", "be distributed under a different license. We are extremely grateful to", "the authors of these packages for making their source code freely available.", " ", OurUtil.makeH((Object[])new Object[]{null, "See the copyright notice for: ", combo, null}), " ", scroll});
        return null;
    }

    void doSetLatest(String arg) {
        this.latestInstance = arg;
        this.latestAutoInstance = arg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Runner doVisualize(String arg) {
        String filename;
        block17: {
            Pair hCore;
            if (this.wrap) {
                return this.wrapMe(arg);
            }
            if (!TYPED_P.matcher((CharSequence)arg).lookingAt()) {
                arg = "XML: " + (String)arg;
            }
            this.text.clearShade();
            if (((String)arg).startsWith("MSG: ")) {
                OurDialog.showtext((String)"Detailed Message", (String)((String)arg).substring(5));
            }
            if (!((String)arg).startsWith("CORE: ")) break block17;
            filename = Util.canon((String)((String)arg).substring(6));
            FileInputStream is = null;
            ObjectInputStream ois = null;
            try {
                is = new FileInputStream(filename);
                ois = new ObjectInputStream(is);
                hCore = (Pair)ois.readObject();
            }
            catch (Throwable ex) {
                Runner runner;
                try {
                    this.log.logRed("Error reading or parsing the core \"" + filename + "\"\n");
                    runner = null;
                }
                catch (Throwable throwable) {
                    Util.close(ois);
                    Util.close((Closeable)is);
                    throw throwable;
                }
                Util.close((Closeable)ois);
                Util.close((Closeable)is);
                return runner;
            }
            Util.close((Closeable)ois);
            Util.close((Closeable)is);
            this.text.clearShade();
            this.text.shade((Iterable)hCore.b, this.subCoreColor, false);
            this.text.shade((Iterable)hCore.a, this.coreColor, false);
            this.text.shade((Iterable)hCore.b, this.subCoreColor, false);
            this.text.shade((Iterable)hCore.a, this.coreColor, false);
        }
        if (((String)arg).startsWith("POS: ")) {
            Scanner s = new Scanner(((String)arg).substring(5));
            int x1 = s.nextInt();
            int y1 = s.nextInt();
            int x2 = s.nextInt();
            int y2 = s.nextInt();
            String f = s.nextLine();
            if (f.length() > 0 && f.charAt(0) == ' ') {
                f = f.substring(1);
            }
            Pos p = new Pos(Util.canon((String)f), x1, y1, x2, y2);
            this.text.shade(p);
        }
        if (((String)arg).startsWith("CNF: ") || ((String)arg).startsWith("file:")) {
            filename = Util.canon((String)((String)arg).substring(5));
            try {
                String text = Util.readAll((String)filename);
                OurDialog.showtext((String)"Text Viewer", (String)text);
            }
            catch (IOException ex) {
                this.log.logRed("Error reading the file \"" + filename + "\"\n");
            }
        } else if (((String)arg).startsWith("XML: ")) {
            this.viz.loadXML(Util.canon((String)((String)arg).substring(5)), false, 0);
        } else {
            try {
                Desktop desktop = Desktop.getDesktop();
                URI oURL = new URI((String)arg);
                desktop.browse(oURL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Runner doOpenFile(String arg) {
        if (this.wrap) {
            return this.wrapMe(arg);
        }
        String f = Util.canon((String)arg);
        if (!this.text.newtab(f)) {
            return null;
        }
        if (this.text.get().isFile()) {
            this.addHistory(f);
        }
        this.doShow();
        this.text.get().requestFocusInWindow();
        this.log.clearError();
        return null;
    }

    private static SimTupleset convert(Object object) throws Err {
        if (!(object instanceof A4TupleSet)) {
            throw new ErrorFatal("Unexpected type error: expecting an A4TupleSet.");
        }
        A4TupleSet s = (A4TupleSet)object;
        if (s.size() == 0) {
            return SimTupleset.EMPTY;
        }
        ArrayList<SimTuple> list = new ArrayList<SimTuple>(s.size());
        int arity = s.arity();
        for (A4Tuple t : s) {
            String[] array = new String[arity];
            for (int i = 0; i < t.arity(); ++i) {
                array[i] = t.atom(i);
            }
            list.add(SimTuple.make((String[])array));
        }
        return SimTupleset.make(list);
    }

    public static SimInstance convert(Module root, A4Solution ans) throws Err {
        SimInstance ct = new SimInstance(root, ans.getBitwidth(), ans.getMaxSeq());
        for (Sig s : ans.getAllReachableSigs()) {
            if (!s.builtin) {
                ct.init(s, SimpleGUI.convert(ans.eval(s)));
            }
            for (Sig.Field f : s.getFields()) {
                if (f.defined) continue;
                ct.init(f, SimpleGUI.convert(ans.eval(f)));
            }
        }
        for (ExprVar a : ans.getAllAtoms()) {
            ct.init(a, SimpleGUI.convert(ans.eval((Expr)a)));
        }
        for (ExprVar a : ans.getAllSkolems()) {
            ct.init(a, SimpleGUI.convert(ans.eval((Expr)a)));
        }
        return ct;
    }

    public static void main(final String[] args) throws Exception {
        ArrayList<String> remainingArgs = new ArrayList<String>();
        if (args.length > 0) {
            boolean help = false;
            boolean quit = false;
            String[] stringArray = args;
            int n = stringArray.length;
            block20: for (int i = 0; i < n; ++i) {
                String cmd;
                switch (cmd = stringArray[i]) {
                    case "--worker": 
                    case "-w": {
                        WorkerEngine.main((String[])args);
                        continue block20;
                    }
                    case "--version": 
                    case "-v": {
                        System.out.println(Version.version());
                        continue block20;
                    }
                    case "--help": 
                    case "-h": 
                    case "-?": {
                        help = true;
                        continue block20;
                    }
                    case "--debug": 
                    case "-d": {
                        System.setProperty("debug", "yes");
                        continue block20;
                    }
                    case "--quit": 
                    case "-q": {
                        quit = true;
                        continue block20;
                    }
                    default: {
                        if (cmd.endsWith(".als")) {
                            remainingArgs.add(cmd);
                            continue block20;
                        }
                        System.out.println("Unknown cmd " + cmd);
                        help = true;
                    }
                }
            }
            if (help) {
                System.out.println("Usage: alloy [options] file ...\n  //  -d/--debug                  set debug mode\n  -h/--help                   show this help\n  -q/--quit                   do not continue with GUI\n  -v/--version                show version\n");
            }
            if (quit) {
                return;
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new SimpleGUI(args);
            }
        });
    }

    SimpleGUI(String[] args) {
        String gravity;
        int y;
        int x;
        int height;
        UIManager.put("ToolTip.font", new FontUIResource("Courier New", 0, 14));
        if (Util.onMac() || Util.onWindows()) {
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "Alloy");
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "true");
            System.setProperty("com.apple.mrj.application.live-resize", "true");
            System.setProperty("com.apple.macos.useScreenMenuBar", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        this.doLookAndFeel();
        int screenWidth = OurUtil.getScreenWidth();
        int screenHeight = OurUtil.getScreenHeight();
        int width = (Integer)A4Preferences.AnalyzerWidth.get();
        if (width <= 0) {
            width = screenWidth / 10 * 8;
        } else if (width < 100) {
            width = 100;
        }
        if (width > screenWidth) {
            width = screenWidth;
        }
        if ((height = ((Integer)A4Preferences.AnalyzerHeight.get()).intValue()) <= 0) {
            height = screenHeight / 10 * 8;
        } else if (height < 100) {
            height = 100;
        }
        if (height > screenHeight) {
            height = screenHeight;
        }
        if ((x = ((Integer)A4Preferences.AnalyzerX.get()).intValue()) < 0) {
            x = screenWidth / 10;
        }
        if (x > screenWidth - 100) {
            x = screenWidth - 100;
        }
        if ((y = ((Integer)A4Preferences.AnalyzerY.get()).intValue()) < 0) {
            y = screenHeight / 10;
        }
        if (y > screenHeight - 100) {
            y = screenHeight - 100;
        }
        JFrame frame = new JFrame("Alloy Analyzer");
        frame.setDefaultCloseOperation(0);
        frame.pack();
        if (!(Util.onMac() || Util.onWindows() || (gravity = System.getenv("_JAVA_AWT_WM_STATIC_GRAVITY")) != null && gravity.length() != 0)) {
            if (x < 30) {
                if (x < 0) {
                    x = 0;
                }
                width -= 30 - x;
                x = 30;
            }
            if (y < 30) {
                if (y < 0) {
                    y = 0;
                }
                height -= 30 - y;
                y = 30;
            }
        }
        this.findReplace = new FindReplace(frame, n -> this.text.selectModulo(n.intValue()).map(w -> w.getTextPane()), pane -> this.text.select(pane));
        if (width < 500) {
            width = 500;
        }
        if (height < 500) {
            height = 500;
        }
        frame.setSize(width, height);
        frame.setLocation(x, y);
        frame.setVisible(true);
        frame.setTitle("Alloy Analyzer " + Version.version() + " loading... please wait...");
        int windowWidth = width;
        if (Util.onMac()) {
            frame.getRootPane().putClientProperty("apple.awt.fullscreenable", true);
        }
        this.frame = frame;
        this.finishInit(args, windowWidth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInit(String[] args, int width) {
        try {
            this.wrap = true;
            this.frame.addWindowListener((WindowListener)this.doQuit());
        }
        finally {
            this.wrap = false;
        }
        this.frame.addComponentListener(this);
        int fontSize = (Integer)A4Preferences.FontSize.get();
        String fontName = OurDialog.getProperFontName((String)((String)A4Preferences.FontName.get()), (String[])new String[]{"Courier New", "Lucidia", "Courier", "Monospaced"});
        A4Preferences.FontName.set((Object)fontName);
        this.copyFromJAR();
        JMenuBar bar = new JMenuBar();
        try {
            this.wrap = true;
            this.filemenu = OurUtil.menu((JMenuBar)bar, (String)"&File", (Runnable)this.doRefreshFile());
            this.editmenu = OurUtil.menu((JMenuBar)bar, (String)"&Edit", (Runnable)this.doRefreshEdit());
            this.runmenu = OurUtil.menu((JMenuBar)bar, (String)"E&xecute", (Runnable)this.doRefreshRun());
            this.optmenu = OurUtil.menu((JMenuBar)bar, (String)"&Options", (Runnable)this.doRefreshOption());
            this.windowmenu = OurUtil.menu((JMenuBar)bar, (String)"&Window", (Runnable)this.doRefreshWindow(false));
            this.windowmenu2 = OurUtil.menu(null, (String)"&Window", (Runnable)this.doRefreshWindow(true));
            this.helpmenu = OurUtil.menu((JMenuBar)bar, (String)"&Help", null);
            OurUtil.menuItem((JMenu)this.helpmenu, (String)"About Alloy...", (char)'A', (Runnable)this.doAbout());
            OurUtil.menuItem((JMenu)this.helpmenu, (String)"Quick Guide", (char)'Q', (Runnable)this.doHelp());
            OurUtil.menuItem((JMenu)this.helpmenu, (String)"See the Copyright Notices...", (char)'L', (Runnable)this.doLicense());
        }
        finally {
            this.wrap = false;
        }
        this.viz = new VizGUI(false, "", this.windowmenu2, this.enumerator, evaluator, 2);
        this.viz.doSetFontSize((Integer)A4Preferences.FontSize.get());
        try {
            this.wrap = true;
            this.toolbar = new JToolBar();
            this.toolbar.setFloatable(false);
            if (!Util.onMac()) {
                this.toolbar.setBackground(background);
            }
            this.toolbar.add(OurUtil.button((String)"New", (String)"Starts a new blank model", (String)"images/24_new.gif", (ActionListener)this.doNew()));
            this.toolbar.add(OurUtil.button((String)"Open", (String)"Opens an existing model", (String)"images/24_open.gif", (ActionListener)this.doOpen()));
            this.toolbar.add(OurUtil.button((String)"Reload", (String)"Reload all the models from disk", (String)"images/24_reload.gif", (ActionListener)this.doReloadAll()));
            this.toolbar.add(OurUtil.button((String)"Save", (String)"Saves the current model", (String)"images/24_save.gif", (ActionListener)this.doSave()));
            this.runbutton = OurUtil.button((String)"Execute", (String)"Executes the latest command", (String)"images/24_execute.gif", (ActionListener)this.doExecuteLatest());
            this.toolbar.add(this.runbutton);
            this.stopbutton = OurUtil.button((String)"Stop", (String)"Stops the current analysis", (String)"images/24_execute_abort2.gif", (ActionListener)this.doStop(2));
            this.toolbar.add(this.stopbutton);
            this.stopbutton.setVisible(false);
            this.showbutton = OurUtil.button((String)"Show", (String)"Shows the latest instance", (String)"images/24_graph.gif", (ActionListener)this.doShowLatest());
            this.toolbar.add(this.showbutton);
            this.toolbar.add(Box.createHorizontalGlue());
            this.toolbar.setBorder((Border)new OurBorder(false, false, false, false));
        }
        finally {
            this.wrap = false;
        }
        OurAntiAlias.enableAntiAlias((boolean)((Boolean)A4Preferences.AntiAlias.get()));
        this.logpane = OurUtil.scrollpane(null, (Object[])new Object[0]);
        this.log = new SwingLogPanel(this.logpane, fontName, fontSize, background, Color.BLACK, new Color(0.7f, 0.2f, 0.2f), this);
        PreferencesDialog.logOnChange(this.log, A4Preferences.allUserPrefs().toArray(new A4Preferences.Pref[0]));
        this.text = new OurTabbedSyntaxWidget(fontName, fontSize, ((Integer)A4Preferences.TabSize.get()).intValue(), ((Boolean)A4Preferences.LineNumbers.get()).booleanValue(), this.frame);
        this.text.listeners.add((Listener)this);
        this.text.enableSyntax((Boolean)A4Preferences.SyntaxDisabled.get() == false);
        Container all = this.frame.getContentPane();
        all.setLayout(new BorderLayout());
        all.removeAll();
        JPanel lefthalf = new JPanel();
        lefthalf.setLayout(new BorderLayout());
        lefthalf.add((Component)this.toolbar, "North");
        this.text.addTo((JComponent)lefthalf, (Object)"Center");
        this.splitpane = OurUtil.splitpane((int)1, (Component)lefthalf, (Component)this.logpane, (int)(width / 2));
        this.splitpane.setResizeWeight(0.5);
        this.status = (JLabel)OurUtil.make((JComponent)OurAntiAlias.label((String)" ", (Object[])new Object[0]), (Object[])new Object[]{new Font(fontName, 0, fontSize), Color.BLACK, background});
        this.status.setBorder((Border)new OurBorder(true, false, false, false));
        all.add((Component)this.splitpane, "Center");
        all.add((Component)this.status, "South");
        this.log.logBold("Alloy Analyzer ");
        this.log.logLink("[what is new]", "https://alloytools.org/alloy6.html");
        this.log.log(" ");
        this.log.logLink("[spec]", "https://alloytools.org/spec.html");
        this.log.log(" " + Version.getShortversion() + " built " + Version.buildDate());
        if (AlloyCore.isDebug()) {
            this.log.log(" [in debug mode]");
        }
        this.log.log("\n\n");
        this.prefDialog = new PreferencesDialog(this.log);
        this.prefDialog.setDefaultCloseOperation(2);
        try {
            this.wrap = true;
            this.prefDialog.addChangeListener(SimpleGUI.wrapToChangeListener(this.doOptRefreshFont()), new A4Preferences.Pref[]{A4Preferences.FontName, A4Preferences.FontSize, A4Preferences.TabSize});
            this.prefDialog.addChangeListener(SimpleGUI.wrapToChangeListener(this.doOptAntiAlias()), new A4Preferences.Pref[]{A4Preferences.AntiAlias});
            this.prefDialog.addChangeListener(SimpleGUI.wrapToChangeListener(this.doOptSyntaxHighlighting()), new A4Preferences.Pref[]{A4Preferences.SyntaxDisabled});
            this.prefDialog.addChangeListener(SimpleGUI.wrapToChangeListener(this.doLookAndFeel()), new A4Preferences.Pref[]{A4Preferences.LAF});
            this.prefDialog.addChangeListener(SimpleGUI.wrapToChangeListener(this.doOptRefreshLineNumbers()), new A4Preferences.Pref[]{A4Preferences.LineNumbers});
        }
        finally {
            this.wrap = false;
        }
        long space = SimpleGUI.computeTemporarySpaceUsed(this.frame);
        if (space < 0L || space >= 20495360L) {
            if (space < 0L) {
                this.log.logBold("Warning: Alloy4's temporary directory has exceeded 1024M.\n");
            } else {
                this.log.logBold("Warning: Alloy4's temporary directory now uses " + space / 1024768L + "M.\n");
            }
            this.log.log("To clear the temporary directory,\ngo to the File menu and click \"Clear Temporary Directory\"\n");
            this.log.logDivider();
            this.log.flush();
        }
        this.doRefreshFile();
        OurUtil.enableAll((JMenu)this.filemenu);
        this.doRefreshEdit();
        OurUtil.enableAll((JMenu)this.editmenu);
        this.doRefreshRun();
        OurUtil.enableAll((JMenu)this.runmenu);
        this.doRefreshOption();
        this.doRefreshWindow(false);
        OurUtil.enableAll((JMenu)this.windowmenu);
        this.frame.setJMenuBar(bar);
        for (String f : args) {
            File file = IO.getFile((String)f);
            if (!file.isFile()) continue;
            this.doOpenFile(file.getPath());
        }
        this.notifyChange();
        this.text.get().requestFocusInWindow();
        if (!AlloyCore.isDebug() && ((Boolean)A4Preferences.Welcome.get()).booleanValue()) {
            JCheckBox again = new JCheckBox("Show this message every time you start the Alloy Analyzer");
            again.setSelected(true);
            OurDialog.showmsg((String)"Welcome", (Object[])new Object[]{"Thank you for using the Alloy Analyzer " + Version.version(), " ", "Version 4 of the Alloy Analyzer is a complete rewrite,", "offering improvements in robustness, performance and usability.", "Models written in Alloy 3 will require some small alterations to run in Alloy 4.", " ", "Here are some quick tips:", " ", "* Function calls now use [ ] instead of ( )", "  For more details, please see http://alloy.mit.edu/alloy4/quickguide/", " ", "* The Execute button always executes the latest command.", "  To choose which command to execute, go to the Execute menu.", " ", "* The Alloy Analyzer comes with a variety of sample models.", "  To see them, go to the File menu and click Open Sample Models.", " ", again});
            this.doShow();
            A4Preferences.Welcome.set((Object)again.isSelected());
        }
        final long now = System.currentTimeMillis();
        final Timer t = new Timer(800, null);
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int n = MailBug.latestBuildNumber();
                if (System.currentTimeMillis() - now >= 3000L || (long)n <= Version.buildNumber()) {
                    t.stop();
                    return;
                }
                SimpleGUI.this.latestAlloyVersion = n;
                SimpleGUI.this.latestAlloyVersionName = MailBug.latestBuildName();
                SimpleGUI.this.log.logBold("An updated version of the Alloy Analyzer has been released.\n");
                SimpleGUI.this.log.log("Please visit alloy.mit.edu to download the latest version:\nVersion " + SimpleGUI.this.latestAlloyVersionName + "\n");
                SimpleGUI.this.log.logDivider();
                SimpleGUI.this.log.flush();
                t.stop();
            }
        });
        t.start();
    }

    public Object do_action(Object sender, Listener.Event e) {
        if (sender instanceof OurTabbedSyntaxWidget) {
            switch (e) {
                case FOCUSED: {
                    this.notifyFocusGained();
                    break;
                }
                case STATUS_CHANGE: {
                    this.notifyChange();
                    break;
                }
            }
        }
        return true;
    }

    public Object do_action(Object sender, Listener.Event e, Object arg) {
        if (sender instanceof OurTree && e == Listener.Event.CLICK && arg instanceof Browsable) {
            Pos p = ((Browsable)arg).pos();
            if (p == Pos.UNKNOWN) {
                p = ((Browsable)arg).span();
            }
            this.text.shade(p);
        }
        return true;
    }

    private void addToMenu(JMenu parent, A4Preferences.BooleanPref ... prefs) {
        for (A4Preferences.BooleanPref pref : prefs) {
            A4Preferences.BooleanAction action = pref.getTitleAction();
            Object name = action.getValue("Name");
            OurUtil.menuItem((JMenu)parent, (String)(String.valueOf(name) + ": " + ((Boolean)pref.get() != false ? "Yes" : "No")), (Object[])new Object[]{action});
        }
    }

    private JMenu addToMenu(JMenu parent, A4Preferences.ChoicePref ... prefs) {
        JMenu last = null;
        for (A4Preferences.ChoicePref pref : prefs) {
            last = new JMenu(pref.title + ": " + String.valueOf(pref.renderValueShort(pref.get())));
            this.addSubmenuItems(last, pref);
            parent.add(last);
        }
        return last;
    }

    private void addSubmenuItems(JMenu parent, A4Preferences.ChoicePref pref) {
        Object selected = pref.get();
        for (Object item : pref.validChoices()) {
            Action action = pref.getAction(item);
            JMenuItem submenu = OurUtil.menuItem((JMenu)parent, (String)pref.renderValueLong(item).toString(), (Object[])new Object[]{action, item == selected ? iconYes : iconNo});
            if (!(item instanceof SATFactory)) continue;
            SATFactory i = (SATFactory)item;
            i.getDescription().ifPresent(d -> submenu.setToolTipText((String)d));
        }
    }

    private static ChangeListener wrapToChangeListener(final Runner r) {
        assert (r != null);
        return new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                r.run();
            }
        };
    }

    static {
        try {
            GraphicsEnvironment.getLocalGraphicsEnvironment();
        }
        catch (Throwable ex) {
            System.err.println("Unable to start the graphical environment.");
            System.err.println("If you're on Mac OS X:");
            System.err.println("   Please make sure you are running as the current local user.");
            System.err.println("If you're on Linux or FreeBSD:");
            System.err.println("   Please make sure your X Windows is configured.");
            System.err.println("   You can verify this by typing \"xhost\"; it should not give an error message.");
            System.err.flush();
            System.exit(1);
        }
        iconYes = OurUtil.loadIcon((String)"images/menu1.gif");
        iconNo = OurUtil.loadIcon((String)"images/menu0.gif");
        fs = File.separator;
        background = new Color(0.9f, 0.9f, 0.9f);
        alloyHome = null;
        evaluator = new Computer(){
            private String filename = null;

            public final Object compute(Object input) throws Exception {
                if (input instanceof File) {
                    this.filename = ((File)input).getAbsolutePath();
                    return "";
                }
                if (!(input instanceof String[])) {
                    return "";
                }
                String[] strs = (String[])input;
                if (strs[0].trim().length() == 0) {
                    return "";
                }
                CompModule root = null;
                A4Solution ans = null;
                try {
                    LinkedHashMap<String, String> fc = new LinkedHashMap<String, String>();
                    XMLNode x = new XMLNode(new File(this.filename));
                    if (!x.is("alloy")) {
                        throw new Exception();
                    }
                    String mainname = null;
                    for (XMLNode sub : x) {
                        if (!sub.is("instance")) continue;
                        mainname = sub.getAttribute("filename");
                        break;
                    }
                    if (mainname == null) {
                        throw new Exception();
                    }
                    for (XMLNode sub : x) {
                        if (!sub.is("source")) continue;
                        String name = sub.getAttribute("filename");
                        String content = sub.getAttribute("content");
                        fc.put(name, content);
                    }
                    root = CompUtil.parseEverything_fromFile((A4Reporter)A4Reporter.NOP, fc, (String)mainname, (int)(Version.experimental && (Boolean)A4Preferences.ImplicitThis.get() != false ? 2 : 1));
                    ans = A4SolutionReader.read((Iterable)root.getAllReachableSigs(), (XMLNode)x);
                    for (ExprVar a : ans.getAllAtoms()) {
                        root.addGlobal(a.label, (Expr)a);
                    }
                    for (ExprVar a : ans.getAllSkolems()) {
                        root.addGlobal(a.label, (Expr)a);
                    }
                }
                catch (Throwable ex) {
                    throw new ErrorFatal("Failed to read or parse the XML file.");
                }
                try {
                    SimInstance simInst;
                    Expr e = CompUtil.parseOneExpression_fromString((Module)root, (String)strs[0]);
                    if (AlloyCore.isDebug() && A4Preferences.VerbosityPref.get() == A4Preferences.Verbosity.FULLDEBUG && (simInst = SimpleGUI.convert((Module)root, ans)).wasOverflow()) {
                        return simInst.visitThis(e).toString() + " (OF)";
                    }
                    return ans.eval(e, Integer.valueOf(strs[1]).intValue()).toString();
                }
                catch (HigherOrderDeclException ex) {
                    throw new ErrorType("Higher-order quantification is not allowed in the evaluator.");
                }
            }
        };
    }
}

