/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4whole;

import edu.mit.csail.sdg.alloy4.A4Reporter;
import edu.mit.csail.sdg.alloy4.ConstList;
import edu.mit.csail.sdg.alloy4.ConstMap;
import edu.mit.csail.sdg.alloy4.Err;
import edu.mit.csail.sdg.alloy4.ErrorAPI;
import edu.mit.csail.sdg.alloy4.ErrorSyntax;
import edu.mit.csail.sdg.alloy4.ErrorType;
import edu.mit.csail.sdg.alloy4.ErrorWarning;
import edu.mit.csail.sdg.alloy4.MailBug;
import edu.mit.csail.sdg.alloy4.OurDialog;
import edu.mit.csail.sdg.alloy4.Pair;
import edu.mit.csail.sdg.alloy4.Pos;
import edu.mit.csail.sdg.alloy4.Util;
import edu.mit.csail.sdg.alloy4.Version;
import edu.mit.csail.sdg.alloy4.WorkerEngine;
import edu.mit.csail.sdg.alloy4.XMLNode;
import edu.mit.csail.sdg.alloy4viz.StaticInstanceReader;
import edu.mit.csail.sdg.alloy4viz.VizGUI;
import edu.mit.csail.sdg.alloy4whole.SimpleGUI;
import edu.mit.csail.sdg.alloy4whole.SwingLogPanel;
import edu.mit.csail.sdg.ast.Command;
import edu.mit.csail.sdg.ast.Module;
import edu.mit.csail.sdg.ast.Sig;
import edu.mit.csail.sdg.parser.CompModule;
import edu.mit.csail.sdg.parser.CompUtil;
import edu.mit.csail.sdg.translator.A4Options;
import edu.mit.csail.sdg.translator.A4Solution;
import edu.mit.csail.sdg.translator.A4SolutionReader;
import edu.mit.csail.sdg.translator.A4SolutionWriter;
import edu.mit.csail.sdg.translator.TranslateAlloyToKodkod;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.alloytools.alloy.core.AlloyCore;

public final class SimpleReporter
extends A4Reporter {
    private final WorkerEngine.WorkerCallback cb;
    private final boolean recordKodkod;
    private long lastTime = 0L;
    private long startTime = 0L;
    private int startStep = -1;
    private int seenStep = -1;
    private int primaryVars = 0;
    private int clauses = 0;
    private int totalVars = 0;
    private int startCount = 0;
    private long minimized = 0L;
    private int minimizedBefore;
    private int minimizedAfter;
    private String tempfile = null;
    private static final Set<String> latestKodkods = new LinkedHashSet<String>();
    private static A4Solution latestKodkod = null;
    private static Module latestModule = null;
    private static ConstMap<String, String> latestKodkodSRC = null;
    private static String latestKodkodXML = null;
    private static String latestMetamodelXML = null;
    private int warn = 0;

    private void cb(Serializable ... objs) {
        this.cb.callback((Object)objs);
    }

    public void resultCNF(String filename) {
        this.cb(new Serializable[]{"resultCNF", filename});
    }

    public void warning(ErrorWarning ex) {
        ++this.warn;
        this.cb(new Serializable[]{"warning", ex});
    }

    public void scope(String msg) {
        this.cb(new Serializable[]{"scope", msg});
    }

    public void bound(String msg) {
        this.cb(new Serializable[]{"bound", msg});
    }

    public void debug(String msg) {
        this.cb(new Serializable[]{"debug", msg.trim()});
    }

    public void translate(String solver, int bitwidth, int maxseq, int mintrace, int maxtrace, int skolemDepth, int symmetry, String strat) {
        this.startTime = System.currentTimeMillis();
        this.startCount = 0;
        this.startStep = -1;
        this.seenStep = -1;
        this.cb(new Serializable[]{"translate", "Solver=" + solver + (String)(maxtrace < 1 ? "" : " Steps=" + mintrace + ".." + maxtrace) + " Bitwidth=" + bitwidth + " MaxSeq=" + maxseq + (String)(skolemDepth == 0 ? "" : " SkolemDepth=" + skolemDepth) + " Symmetry=" + (String)(symmetry > 0 ? "" + symmetry : "OFF") + " Mode=" + strat + "\n"});
    }

    public void actualScopes(Iterable<Sig> sigs, Map<Sig.PrimSig, Integer> scopes, Set<Sig> exacts) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Sig s : sigs) {
            if (s.builtin || s.isSubset != null) continue;
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            if (exacts.contains(s)) {
                sb.append("exactly " + String.valueOf(scopes.get(s)) + " " + Util.tailThis((String)s.label));
                continue;
            }
            if (scopes.keySet().contains(s)) {
                sb.append(String.valueOf(scopes.get(s)) + " " + Util.tailThis((String)s.label));
                continue;
            }
            sb.append(Util.tailThis((String)s.label) + "????");
        }
        this.cb(new Serializable[]{"scopes", "Actual scopes: " + sb.toString() + "\n"});
    }

    public void solve(int step, int pv, int tv, int cl) {
        this.minimized = 0L;
        if (this.startStep < 0) {
            this.startStep = step;
        }
        if (this.startStep == step) {
            ++this.startCount;
        }
        this.seenStep = Math.max(this.seenStep, step);
        this.primaryVars += pv;
        this.totalVars += tv;
        this.clauses += cl;
        StringBuilder sb = new StringBuilder();
        if (this.startCount > 1) {
            sb.append(this.startCount + " configs. ");
        }
        if (this.seenStep > 0) {
            sb.append(this.startStep + ".." + this.seenStep + " steps. ");
        }
        if (this.totalVars >= 0) {
            sb.append(this.totalVars + " vars. ");
        }
        if (this.primaryVars >= 0) {
            sb.append(this.primaryVars + " primary vars. ");
        }
        if (this.clauses > 0) {
            sb.append(this.clauses + " clauses. ");
        }
        if (sb.length() == 0) {
            sb.append("No translation information available. ");
        }
        sb.append(System.currentTimeMillis() - this.startTime + "ms.\n");
        this.cb(new Serializable[]{"solve", sb.toString()});
        this.lastTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultSAT(Object command, long solvingTime, Object solution) {
        if (!(solution instanceof A4Solution) || !(command instanceof Command)) {
            return;
        }
        A4Solution sol = (A4Solution)solution;
        Command cmd = (Command)command;
        String formula = this.recordKodkod ? sol.debugExtractKInput() : "";
        String filename = this.tempfile + ".xml";
        Class<SimpleReporter> clazz = SimpleReporter.class;
        synchronized (SimpleReporter.class) {
            try {
                this.cb(new Serializable[]{"R3", "   Writing the XML file..."});
                if (latestModule != null) {
                    SimpleReporter.writeXML(this, latestModule, filename, sol, latestKodkodSRC);
                }
            }
            catch (Throwable ex) {
                this.cb(new Serializable[]{"bold", "\n" + ex.toString().trim() + "\nStackTrace:\n" + MailBug.dump((Throwable)ex).trim() + "\n"});
                // ** MonitorExit[var9_8] (shouldn't be in output)
                return;
            }
            latestKodkods.clear();
            latestKodkods.add(sol.toString());
            latestKodkod = sol;
            latestKodkodXML = filename;
            // ** MonitorExit[var9_8] (shouldn't be in output)
            Object formulafilename = "";
            if (formula.length() > 0 && this.tempfile != null) {
                formulafilename = this.tempfile + ".java";
                try {
                    Util.writeAll((String)formulafilename, (String)formula);
                    formulafilename = "CNF: " + (String)formulafilename;
                }
                catch (Throwable ex) {
                    formulafilename = "";
                }
            }
            this.cb(new Serializable[]{"sat", Boolean.valueOf(cmd.check), Integer.valueOf(cmd.expects), filename, formulafilename, Long.valueOf(System.currentTimeMillis() - this.lastTime)});
            return;
        }
    }

    public void minimizing(Object command, int before) {
        if (!(command instanceof Command)) {
            return;
        }
        Command cmd = (Command)command;
        this.minimized = System.currentTimeMillis();
        this.cb(new Serializable[]{"minimizing", Boolean.valueOf(cmd.check), Integer.valueOf(cmd.expects), Integer.valueOf(before), Long.valueOf(this.minimized - this.lastTime)});
    }

    public void minimized(Object command, int before, int after) {
        this.minimizedBefore = before;
        this.minimizedAfter = after;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultUNSAT(Object command, long solvingTime, Object solution) {
        if (!(solution instanceof A4Solution) || !(command instanceof Command)) {
            return;
        }
        A4Solution sol = (A4Solution)solution;
        Command cmd = (Command)command;
        String originalFormula = this.recordKodkod ? sol.debugExtractKInput() : "";
        Object corefilename = "";
        Object formulafilename = "";
        if (originalFormula.length() > 0 && this.tempfile != null) {
            formulafilename = this.tempfile + ".java";
            try {
                Util.writeAll((String)formulafilename, (String)originalFormula);
                formulafilename = "CNF: " + (String)formulafilename;
            }
            catch (Throwable ex) {
                formulafilename = "";
            }
        }
        Pair core = sol.highLevelCore();
        if ((((Set)core.a).size() > 0 || ((Set)core.b).size() > 0) && this.tempfile != null) {
            corefilename = this.tempfile + ".core";
            FileOutputStream fs = null;
            ObjectOutputStream os = null;
            try {
                fs = new FileOutputStream((String)corefilename);
                os = new ObjectOutputStream(fs);
                os.writeObject(core);
                os.writeObject(sol.lowLevelCore());
                corefilename = "CORE: " + (String)corefilename;
            }
            catch (Throwable ex) {
                try {
                    corefilename = "";
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Util.close(os);
                    Util.close((Closeable)fs);
                }
            }
            Util.close((Closeable)os);
            Util.close((Closeable)fs);
        }
        if (this.minimized == 0L) {
            this.cb(new Serializable[]{"unsat", Boolean.valueOf(cmd.check), Integer.valueOf(cmd.expects), Long.valueOf(System.currentTimeMillis() - this.lastTime), formulafilename});
        } else {
            this.cb(new Serializable[]{"unsat", Boolean.valueOf(cmd.check), Integer.valueOf(cmd.expects), Long.valueOf(this.minimized - this.lastTime), formulafilename, corefilename, Integer.valueOf(this.minimizedBefore), Integer.valueOf(this.minimizedAfter), Long.valueOf(System.currentTimeMillis() - this.minimized)});
        }
    }

    private SimpleReporter(WorkerEngine.WorkerCallback cb, boolean recordKodkod) {
        this.cb = cb;
        this.recordKodkod = recordKodkod;
    }

    private static void writeXML(A4Reporter rep, Module mod, String filename, A4Solution sol, Map<String, String> sources) throws Exception {
        sol.writeXML(rep, filename, (Iterable)mod.getAllReachableUserDefinedFunc(), sources);
        if (AlloyCore.isDebug()) {
            SimpleReporter.validate(filename);
        }
    }

    private static void validate(String filename) throws Exception {
        A4SolutionReader.read(new ArrayList(), (XMLNode)new XMLNode(new File(filename))).toString();
        StaticInstanceReader.parseInstance(new File(filename), 0);
    }

    public static final class SimpleTask1
    implements WorkerEngine.WorkerTask {
        private static final long serialVersionUID = 0L;
        public A4Options options;
        public String tempdir;
        public boolean bundleWarningNonFatal;
        public int bundleIndex;
        public int resolutionMode;
        public Map<String, String> map;

        public void cb(WorkerEngine.WorkerCallback out, Object ... objs) throws IOException {
            out.callback((Object)objs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run(WorkerEngine.WorkerCallback out) throws Exception {
            Exception exc;
            SimpleReporter rep;
            block28: {
                boolean transformer = false;
                this.cb(out, "S2", "Starting the solver...\n\n");
                rep = new SimpleReporter(out, this.options.recordKodkod);
                CompModule world = CompUtil.parseEverything_fromFile((A4Reporter)rep, this.map, (String)this.options.originalFilename, (int)this.resolutionMode);
                ConstList sigs = world.getAllReachableSigs();
                ConstList cmds = world.getAllCommands();
                this.cb(out, "warnings", this.bundleWarningNonFatal);
                if (rep.warn > 0 && !this.bundleWarningNonFatal) {
                    return;
                }
                ArrayList<Object> result = new ArrayList<Object>(cmds.size());
                exc = null;
                if (this.bundleIndex == -2) {
                    String outf = this.tempdir + File.separatorChar + "m.xml";
                    this.cb(out, "S2", "Generating the metamodel...\n");
                    of = new PrintWriter(outf, "UTF-8");
                    Util.encodeXMLs((PrintWriter)of, (String[])new String[]{"\n<alloy builddate=\"", Version.buildDate(), "\">\n\n"});
                    A4SolutionWriter.writeMetamodel((List)ConstList.make((Iterable)sigs), (String)this.options.originalFilename, (PrintWriter)of);
                    Util.encodeXMLs((PrintWriter)of, (String[])new String[]{"\n</alloy>"});
                    Util.close((Closeable)of);
                    if (AlloyCore.isDebug()) {
                        SimpleReporter.validate(outf);
                    }
                    this.cb(out, "metamodel", outf);
                    Class<SimpleReporter> clazz = SimpleReporter.class;
                    // MONITORENTER : edu.mit.csail.sdg.alloy4whole.SimpleReporter.class
                    latestMetamodelXML = outf;
                    // MONITOREXIT : clazz
                } else {
                    for (int i = 0; i < cmds.size(); ++i) {
                        if (this.bundleIndex >= 0 && i != this.bundleIndex) continue;
                        of = SimpleReporter.class;
                        // MONITORENTER : edu.mit.csail.sdg.alloy4whole.SimpleReporter.class
                        latestModule = world;
                        latestKodkodSRC = ConstMap.make(this.map);
                        // MONITOREXIT : of
                        String tempXML = this.tempdir + File.separatorChar + i + ".cnf.xml";
                        String tempCNF = this.tempdir + File.separatorChar + i + ".cnf";
                        Command cmd = (Command)cmds.get(i);
                        rep.tempfile = tempCNF;
                        this.cb(out, "bold", "Executing \"" + String.valueOf(cmd) + "\"\n");
                        A4Solution ai = null;
                        try {
                            ai = TranslateAlloyToKodkod.execute_commandFromBook((A4Reporter)rep, (Iterable)world.getAllReachableSigs(), (Command)cmd, (A4Options)this.options);
                        }
                        catch (Exception e1) {
                            exc = e1;
                        }
                        if (ai == null) {
                            result.add(null);
                            continue;
                        }
                        if (ai.satisfiable()) {
                            result.add(tempXML);
                            continue;
                        }
                        if (((Set)ai.highLevelCore().a).size() > 0) {
                            result.add(tempCNF + ".core");
                            continue;
                        }
                        transformer |= ai.opt.solver.isTransformer();
                        result.add("");
                    }
                }
                new File(this.tempdir).delete();
                if (transformer || result.size() <= 1) break block28;
                rep.cb(new Serializable[]{"bold", result.size() + " commands were executed. The results are:\n"});
                for (int i = 0; i < result.size(); ++i) {
                    StringBuilder sb;
                    block30: {
                        Command r;
                        block31: {
                            block29: {
                                r = (Command)world.getAllCommands().get(i);
                                if (result.get(i) == null) continue;
                                sb = new StringBuilder();
                                if (!((String)result.get(i)).endsWith(".xml")) break block29;
                                rep.cb(new Serializable[]{"", "   #" + (i + 1) + ": "});
                                rep.cb(new Serializable[]{"link", r.check ? "Counterexample found. " : "Instance found. ", "XML: " + (String)result.get(i)});
                                sb.append(r.label + (r.check ? " is invalid" : " is consistent"));
                                if (r.expects == 0) {
                                    sb.append(", contrary to expectation");
                                    break block30;
                                } else if (r.expects == 1) {
                                    sb.append(", as expected");
                                }
                                break block30;
                            }
                            if (!((String)result.get(i)).endsWith(".core")) break block31;
                            rep.cb(new Serializable[]{"", "   #" + (i + 1) + ": "});
                            rep.cb(new Serializable[]{"link", r.check ? "No counterexample found. " : "No instance found. ", "CORE: " + (String)result.get(i)});
                            sb.append(r.label + (r.check ? " may be valid" : " may be inconsistent"));
                            if (r.expects == 1) {
                                sb.append(", contrary to expectation");
                                break block30;
                            } else if (r.expects == 0) {
                                sb.append(", as expected");
                            }
                            break block30;
                        }
                        if (r.check) {
                            sb.append("   #" + (i + 1) + ": No counterexample found. " + r.label + " may be valid");
                        } else {
                            sb.append("   #" + (i + 1) + ": No instance found. " + r.label + " may be inconsistent");
                        }
                        if (r.expects == 1) {
                            sb.append(", contrary to expectation");
                        } else if (r.expects == 0) {
                            sb.append(", as expected");
                        }
                    }
                    sb.append(".\n");
                    rep.cb(new Serializable[]{"", sb.toString()});
                }
                rep.cb(new Serializable[]{"", "\n"});
            }
            if (rep.warn > 1) {
                rep.cb(new Serializable[]{"bold", "Note: There were " + rep.warn + " compilation warnings.\n"});
            }
            if (rep.warn == 1) {
                rep.cb(new Serializable[]{"bold", "Note: There was 1 compilation warning. Please scroll up to see it.\n"});
            }
            if (exc == null) return;
            throw exc;
        }
    }

    public static final class SimpleTask2
    implements WorkerEngine.WorkerTask {
        private static final long serialVersionUID = 0L;
        public int index = -1;
        public String filename = "";
        public transient WorkerEngine.WorkerCallback out = null;

        private void cb(Object ... objs) throws Exception {
            this.out.callback((Object)objs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run(WorkerEngine.WorkerCallback out) throws Exception {
            this.out = out;
            this.cb("S2", "Enumerating...\n");
            Class<SimpleReporter> clazz = SimpleReporter.class;
            // MONITORENTER : edu.mit.csail.sdg.alloy4whole.SimpleReporter.class
            if (latestMetamodelXML != null && latestMetamodelXML.equals(this.filename)) {
                this.cb("pop", "You cannot enumerate a metamodel.\n");
                // MONITOREXIT : clazz
                return;
            }
            if (latestKodkodXML == null || !latestKodkodXML.equals(this.filename)) {
                this.cb("pop", "You can only enumerate the solutions of the most-recently-solved command.");
                // MONITOREXIT : clazz
                return;
            }
            if (latestKodkod == null || latestModule == null || latestKodkodSRC == null) {
                this.cb("pop", "Error: the SAT solver that generated the instance has exited,\nso we cannot enumerate unless you re-solve that command.\n");
                // MONITOREXIT : clazz
                return;
            }
            A4Solution sol = latestKodkod;
            Module mod = latestModule;
            // MONITOREXIT : clazz
            if (!sol.satisfiable()) {
                this.cb("pop", "Error: This command is unsatisfiable,\nso there are no solutions to enumerate.");
                return;
            }
            if (!sol.isIncremental()) {
                this.cb("pop", "Error: This solution was not generated by an incremental SAT solver.\nCurrently only MiniSat and SAT4J are supported.");
                return;
            }
            int tries = 0;
            while (true) {
                try {
                    sol = sol.fork(this.index);
                }
                catch (ErrorAPI e) {
                    this.cb("pop", e.getMessage());
                    return;
                }
                if (!sol.satisfiable()) {
                    this.cb("pop", "There are no more satisfying instances.\n\nNote: due to symmetry breaking and other optimizations,\nsome equivalent solutions may have been omitted.");
                    return;
                }
                String toString = sol.toString();
                Class<SimpleReporter> clazz2 = SimpleReporter.class;
                // MONITORENTER : edu.mit.csail.sdg.alloy4whole.SimpleReporter.class
                if (latestKodkods.add(toString) || tries >= 100) break;
                ++tries;
                // MONITOREXIT : clazz2
            }
            SimpleReporter.writeXML(null, mod, this.filename, sol, latestKodkodSRC);
            latestKodkod = sol;
            // MONITOREXIT : clazz2
            this.cb("declare", this.filename);
        }
    }

    public static final class SimpleCallback1
    implements WorkerEngine.WorkerCallback {
        private final SimpleGUI gui;
        private final VizGUI viz;
        private final SwingLogPanel span;
        private final Set<ErrorWarning> warnings = new HashSet<ErrorWarning>();
        private final List<String> results = new ArrayList<String>();
        private int len2 = 0;
        private int len3 = 0;
        private int len4 = 0;
        private int verbosity = 0;
        private final String latestName;
        private final int latestVersion;

        public SimpleCallback1(SimpleGUI gui, VizGUI viz, SwingLogPanel span, int verbosity, String latestName, int latestVersion) {
            this.gui = gui;
            this.viz = viz;
            this.span = span;
            this.verbosity = verbosity;
            this.latestName = latestName;
            this.latestVersion = latestVersion;
            this.len2 = this.len3 = span.getLength();
        }

        public void done() {
            if (this.viz != null) {
                this.span.setLength(this.len2);
            } else {
                this.span.logDivider();
            }
            this.span.flush();
            this.gui.doStop(0);
        }

        public void fail() {
            this.span.logBold("\nAn error has occurred!\n");
            this.span.logDivider();
            this.span.flush();
            this.gui.doStop(1);
        }

        public void callback(Object msg) {
            ErrorWarning e;
            Throwable ex;
            if (msg == null) {
                this.span.logBold("Done\n");
                this.span.flush();
                return;
            }
            if (msg instanceof String) {
                this.span.logBold(((String)msg).trim() + "\n");
                this.span.flush();
                return;
            }
            if (msg instanceof Throwable) {
                for (ex = (Throwable)msg; ex != null; ex = ex.getCause()) {
                    if (ex instanceof OutOfMemoryError) {
                        this.span.logBold("\nFatal Error: the solver ran out of memory!\nTry simplifying your model or reducing the scope,\nor increase memory under the Options menu.\n");
                        return;
                    }
                    if (!(ex instanceof StackOverflowError)) continue;
                    this.span.logBold("\nFatal Error: the solver ran out of stack space!\nTry simplifying your model or reducing the scope,\nor increase stack under the Options menu.\n");
                    return;
                }
            }
            if (msg instanceof Err) {
                ex = (Err)((Object)msg);
                String text = "fatal";
                boolean fatal = false;
                if (ex instanceof ErrorSyntax) {
                    text = "syntax";
                } else if (ex instanceof ErrorType) {
                    text = "type";
                } else {
                    fatal = true;
                }
                if (((Err)ex).pos == Pos.UNKNOWN) {
                    this.span.logBold("A " + text + " error has occurred:  ");
                } else {
                    this.span.logLink("A " + text + " error has occurred:  ", "POS: " + ((Err)ex).pos.x + " " + ((Err)ex).pos.y + " " + ((Err)ex).pos.x2 + " " + ((Err)ex).pos.y2 + " " + ((Err)ex).pos.filename);
                }
                if (this.verbosity > 2) {
                    this.span.log("(see the ");
                    this.span.logLink("stacktrace", "MSG: " + ex.dump());
                    this.span.log(")\n");
                } else {
                    this.span.log("\n");
                }
                this.span.logIndented(((Err)ex).msg.trim());
                this.span.log("\n");
                if (fatal && (long)this.latestVersion > Version.buildNumber()) {
                    this.span.logBold("\nNote: You are running Alloy build#" + Version.buildNumber() + ",\nbut the most recent is Alloy build#" + this.latestVersion + ":\n( version " + this.latestName + " )\nPlease try to upgrade to the newest version,\nas the problem may have been fixed already.\n");
                }
                this.span.flush();
                if (!fatal) {
                    this.gui.doVisualize("POS: " + ((Err)ex).pos.x + " " + ((Err)ex).pos.y + " " + ((Err)ex).pos.x2 + " " + ((Err)ex).pos.y2 + " " + ((Err)ex).pos.filename);
                }
                return;
            }
            if (msg instanceof Throwable) {
                ex = (Throwable)msg;
                this.span.logBold(ex.toString().trim() + "\n");
                this.span.flush();
                return;
            }
            if (!(msg instanceof Object[])) {
                return;
            }
            Object[] array = (Object[])msg;
            if (array[0].equals("pop")) {
                this.span.setLength(this.len2);
                String x = (String)array[1];
                if (this.viz != null && x.length() > 0) {
                    OurDialog.alert((JFrame)this.gui.getFrame(), (Object)x);
                }
            }
            if (array[0].equals("declare")) {
                this.gui.doSetLatest((String)array[1]);
            }
            if (array[0].equals("S2")) {
                this.len3 = this.len2 = this.span.getLength();
                this.span.logBold(String.valueOf(array[1]));
            }
            if (array[0].equals("R3")) {
                this.span.setLength(this.len3);
                this.span.log(String.valueOf(array[1]));
            }
            if (array[0].equals("link")) {
                this.span.logLink((String)array[1], (String)array[2]);
            }
            if (array[0].equals("bold")) {
                this.span.logBold(String.valueOf(array[1]));
            }
            if (array[0].equals("")) {
                this.span.log(String.valueOf(array[1]));
            }
            if (array[0].equals("scope") && this.verbosity > 0) {
                this.span.log("   " + String.valueOf(array[1]));
            }
            if (array[0].equals("bound") && this.verbosity > 1) {
                this.span.log("   " + String.valueOf(array[1]));
            }
            if (array[0].equals("resultCNF")) {
                this.results.add(null);
                this.span.setLength(this.len3);
                this.span.log("   File written to ");
                String linkDestination = "CNF: " + String.valueOf(array[1]);
                this.span.logLink(array[1].toString(), linkDestination);
                this.span.log("\n\n");
                this.gui.doSetLatest(linkDestination);
            }
            if (array[0].equals("debug") && this.verbosity > 2) {
                this.span.log("   " + String.valueOf(array[1]) + "\n");
                this.len3 = this.len4 = this.span.getLength();
                this.len2 = this.len4;
            }
            if (array[0].equals("scopes")) {
                this.span.log("   " + String.valueOf(array[1]));
                this.len3 = this.len4 = this.span.getLength();
            }
            if (array[0].equals("translate")) {
                this.span.log("   " + String.valueOf(array[1]));
                this.len3 = this.len4 = this.span.getLength();
                this.span.logBold("   Generating CNF...\n");
            }
            if (array[0].equals("solve")) {
                this.span.setLength(this.len4);
                this.span.log("   " + String.valueOf(array[1]));
                this.len3 = this.span.getLength();
                this.span.logBold("   Solving...\n");
            }
            if (array[0].equals("warnings")) {
                if (this.warnings.size() == 0) {
                    this.span.setLength(this.len2);
                } else if (this.warnings.size() > 1) {
                    this.span.logBold("Note: There were " + this.warnings.size() + " compilation warnings. Please scroll up to see them.\n\n");
                } else {
                    this.span.logBold("Note: There was 1 compilation warning. Please scroll up to see them.\n\n");
                }
                if (this.warnings.size() > 0 && Boolean.FALSE.equals(array[1])) {
                    e = this.warnings.iterator().next().pos;
                    this.gui.doVisualize("POS: " + e.x + " " + e.y + " " + e.x2 + " " + e.y2 + " " + e.filename);
                    this.span.logBold("Warnings often indicate errors in the model.\nSome warnings can affect the soundness of the analysis.\nTo proceed despite the warnings, go to the Options menu.\n");
                }
            }
            if (array[0].equals("warning")) {
                e = (ErrorWarning)array[1];
                if (!this.warnings.add(e)) {
                    return;
                }
                Pos p = e.pos;
                this.span.logLink("Warning #" + this.warnings.size(), "POS: " + p.x + " " + p.y + " " + p.x2 + " " + p.y2 + " " + p.filename);
                this.span.log("\n");
                this.span.logIndented(e.msg.trim());
                this.span.log("\n\n");
            }
            if (array[0].equals("sat")) {
                boolean chk = Boolean.TRUE.equals(array[1]);
                int expects = (Integer)array[2];
                String filename = (String)array[3];
                String formula = (String)array[4];
                this.results.add(filename);
                new File(filename).deleteOnExit();
                this.gui.doSetLatest(filename);
                this.span.setLength(this.len3);
                this.span.log("   ");
                this.span.logLink(chk ? "Counterexample" : "Instance", "XML: " + filename);
                this.span.log(" found. ");
                this.span.logLink(chk ? "Assertion" : "Predicate", formula);
                this.span.log(chk ? " is invalid" : " is consistent");
                if (expects == 0) {
                    this.span.log(", contrary to expectation");
                } else if (expects == 1) {
                    this.span.log(", as expected");
                }
                this.span.log(". " + String.valueOf(array[5]) + "ms.\n\n");
            }
            if (array[0].equals("metamodel")) {
                String outf = (String)array[1];
                this.span.setLength(this.len2);
                new File(outf).deleteOnExit();
                this.gui.doSetLatest(outf);
                this.span.logLink("Metamodel", "XML: " + outf);
                this.span.log(" successfully generated.\n\n");
            }
            if (array[0].equals("minimizing")) {
                boolean chk = Boolean.TRUE.equals(array[1]);
                int expects = (Integer)array[2];
                this.span.setLength(this.len3);
                this.span.log(chk ? "   No counterexample found." : "   No instance found.");
                if (chk) {
                    this.span.log(" Assertion may be valid");
                } else {
                    this.span.log(" Predicate may be inconsistent");
                }
                if (expects == 1) {
                    this.span.log(", contrary to expectation");
                } else if (expects == 0) {
                    this.span.log(", as expected");
                }
                this.span.log(". " + String.valueOf(array[4]) + "ms.\n");
                this.span.logBold("   Minimizing the unsat core of " + String.valueOf(array[3]) + " entries...\n");
            }
            if (array[0].equals("unsat")) {
                boolean chk = Boolean.TRUE.equals(array[1]);
                int expects = (Integer)array[2];
                String formula = (String)array[4];
                this.span.setLength(this.len3);
                this.span.log(chk ? "   No counterexample found. " : "   No instance found. ");
                this.span.logLink(chk ? "Assertion" : "Predicate", formula);
                this.span.log(chk ? " may be valid" : " may be inconsistent");
                if (expects == 1) {
                    this.span.log(", contrary to expectation");
                } else if (expects == 0) {
                    this.span.log(", as expected");
                }
                if (array.length == 5) {
                    this.span.log(". " + String.valueOf(array[3]) + "ms.\n\n");
                    this.span.flush();
                    return;
                }
                String core = (String)array[5];
                int mbefore = (Integer)array[6];
                int mafter = (Integer)array[7];
                this.span.log(". " + String.valueOf(array[3]) + "ms.\n");
                if (core.length() == 0) {
                    this.results.add("");
                    this.span.log("   No unsat core is available in this case. " + String.valueOf(array[8]) + "ms.\n\n");
                    this.span.flush();
                    return;
                }
                this.results.add(core);
                new File(core).deleteOnExit();
                this.span.log("   ");
                this.span.logLink("Core", core);
                if (mbefore <= mafter) {
                    this.span.log(" contains " + mafter + " top-level formulas. " + String.valueOf(array[8]) + "ms.\n\n");
                } else {
                    this.span.log(" reduced from " + mbefore + " to " + mafter + " top-level formulas. " + String.valueOf(array[8]) + "ms.\n\n");
                }
            }
            this.span.flush();
        }
    }
}

