/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.csail.sdg.alloy4whole;

import edu.mit.csail.sdg.alloy4.OurAntiAlias;
import edu.mit.csail.sdg.alloy4.OurUtil;
import edu.mit.csail.sdg.alloy4whole.SimpleGUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

final class SwingLogPanel {
    private final List<String> batch = new ArrayList<String>();
    private JTextPane log;
    private final Style styleRegular;
    private final Style styleBold;
    private final Style styleRed;
    private final List<JLabel> links = new ArrayList<JLabel>();
    private final SimpleGUI handler;
    private int lastSize = 0;
    private String fontName;
    private int fontSize;
    private static final Color linkColor = new Color(0.3f, 0.3f, 0.9f);
    private static final Color hoverColor = new Color(0.9f, 0.3f, 0.3f);
    private static final ViewFactory defaultFactory = new StyledEditorKit().getViewFactory();

    private static void linewrap(StringBuilder sb, String msg) {
        StringTokenizer tokenizer = new StringTokenizer(msg, "\r\n\t ");
        int max = 60;
        int now = 0;
        while (tokenizer.hasMoreTokens()) {
            String x = tokenizer.nextToken();
            if (now + 1 + x.length() > 60) {
                if (now > 0) {
                    sb.append('\n');
                }
                sb.append(x);
                now = x.length();
                continue;
            }
            if (now > 0) {
                ++now;
                sb.append(' ');
            }
            sb.append(x);
            now += x.length();
        }
    }

    public SwingLogPanel(JScrollPane parent, String fontName, int fontSize, Color background, Color regular, Color red, final SimpleGUI handler) {
        this.handler = handler;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.log = (JTextPane)OurUtil.make((JComponent)OurAntiAlias.pane(null, (Object[])new Object[0]), (Object[])new Object[]{Color.BLACK, background, new EmptyBorder(1, 1, 1, 1), new Font(fontName, 0, fontSize)});
        this.log.setEditorKit(new StyledEditorKit(){
            private static final long serialVersionUID = 0L;

            @Override
            public final ViewFactory getViewFactory() {
                return new ViewFactory(){

                    @Override
                    public final View create(Element x) {
                        if (!"section".equals(x.getName())) {
                            return defaultFactory.create(x);
                        }
                        return new BoxView(x, 1){

                            @Override
                            public final float getMinimumSpan(int axis) {
                                return super.getPreferredSpan(axis);
                            }

                            @Override
                            public final void layout(int width, int height) {
                                int x = 0;
                                int dec = 20;
                                int w = 30000 + dec;
                                while (x++ < 10) {
                                    try {
                                        super.layout(w - (int)Math.pow(2.0, x - 1) * dec, height);
                                        break;
                                    }
                                    catch (Exception exception) {
                                    }
                                }
                            }
                        };
                    }
                };
            }
        });
        this.log.setEditable(false);
        this.log.addFocusListener(new FocusListener(){

            @Override
            public final void focusGained(FocusEvent e) {
                if (handler != null) {
                    handler.notifyFocusLost();
                }
            }

            @Override
            public final void focusLost(FocusEvent e) {
            }
        });
        StyledDocument doc = this.log.getStyledDocument();
        this.styleRegular = doc.addStyle("regular", null);
        StyleConstants.setFontFamily(this.styleRegular, fontName);
        StyleConstants.setFontSize(this.styleRegular, fontSize);
        StyleConstants.setForeground(this.styleRegular, regular);
        this.styleBold = doc.addStyle("bold", this.styleRegular);
        StyleConstants.setBold(this.styleBold, true);
        this.styleRed = doc.addStyle("red", this.styleBold);
        StyleConstants.setForeground(this.styleRed, red);
        parent.setViewportView(this.log);
        parent.setBackground(background);
    }

    public void logDivider() {
        if (this.log == null) {
            return;
        }
        this.clearError();
        StyledDocument doc = this.log.getStyledDocument();
        Style dividerStyle = doc.addStyle("bar", this.styleRegular);
        JPanel jpanel = new JPanel();
        jpanel.setBackground(Color.LIGHT_GRAY);
        jpanel.setPreferredSize(new Dimension(300, 1));
        StyleConstants.setComponent(dividerStyle, jpanel);
        this.reallyLog(".", dividerStyle);
        this.reallyLog("\n\n", this.styleRegular);
        this.log.setCaretPosition(doc.getLength());
        this.lastSize = doc.getLength();
    }

    public void logLink(String link, final String linkDestination) {
        if (this.log == null || link.length() == 0) {
            return;
        }
        if (linkDestination == null || linkDestination.length() == 0) {
            this.log(link);
            return;
        }
        this.clearError();
        StyledDocument doc = this.log.getStyledDocument();
        Style linkStyle = doc.addStyle("link", this.styleRegular);
        final JLabel label = (JLabel)OurUtil.make((JComponent)OurAntiAlias.label((String)link, (Object[])new Object[0]), (Object[])new Object[]{new Font(this.fontName, 1, this.fontSize), linkColor});
        label.setAlignmentY(0.8f);
        label.setMaximumSize(label.getPreferredSize());
        label.addMouseListener(new MouseListener(){

            @Override
            public final void mousePressed(MouseEvent e) {
                if (SwingLogPanel.this.handler != null) {
                    SwingLogPanel.this.handler.doVisualize(linkDestination);
                }
            }

            @Override
            public final void mouseClicked(MouseEvent e) {
            }

            @Override
            public final void mouseReleased(MouseEvent e) {
            }

            @Override
            public final void mouseEntered(MouseEvent e) {
                label.setForeground(hoverColor);
            }

            @Override
            public final void mouseExited(MouseEvent e) {
                label.setForeground(linkColor);
            }
        });
        StyleConstants.setComponent(linkStyle, label);
        this.links.add(label);
        this.reallyLog(".", linkStyle);
        this.log.setCaretPosition(doc.getLength());
        this.lastSize = doc.getLength();
    }

    public void log(String msg) {
        if (this.log != null && msg.length() > 0) {
            this.batch.add(msg);
        }
    }

    public void logBold(String msg) {
        if (msg.length() > 0) {
            this.clearError();
            this.reallyLog(msg, this.styleBold);
        }
    }

    private void reallyLog(String text, Style style) {
        if (this.log == null || text.length() == 0) {
            return;
        }
        int i = text.lastIndexOf(10);
        int j = text.lastIndexOf(13);
        if (i >= 0 && i < j) {
            i = j;
        }
        StyledDocument doc = this.log.getStyledDocument();
        try {
            if (i < 0) {
                doc.insertString(doc.getLength(), text, style);
            } else {
                doc.insertString(doc.getLength(), text.substring(0, i + 1), style);
                this.log.setCaretPosition(doc.getLength());
                if (i < text.length() - 1) {
                    doc.insertString(doc.getLength(), text.substring(i + 1), style);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (style != this.styleRed) {
            this.lastSize = doc.getLength();
        }
    }

    public void logRed(String msg) {
        if (this.log == null || msg == null || msg.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        while (msg.length() > 0) {
            int i = msg.indexOf(10);
            if (i >= 0) {
                SwingLogPanel.linewrap(sb, msg.substring(0, i));
                sb.append('\n');
                msg = msg.substring(i + 1);
                continue;
            }
            SwingLogPanel.linewrap(sb, msg);
            break;
        }
        this.clearError();
        this.reallyLog(sb.toString(), this.styleRed);
    }

    public void logIndented(String msg) {
        if (this.log == null || msg.length() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        while (msg.length() > 0) {
            int i = msg.indexOf(10);
            if (i >= 0) {
                SwingLogPanel.linewrap(sb, msg.substring(0, i));
                sb.append('\n');
                msg = msg.substring(i + 1);
                continue;
            }
            SwingLogPanel.linewrap(sb, msg);
            break;
        }
        this.clearError();
        this.reallyLog(sb.toString(), this.styleRegular);
    }

    public void setFontName(String fontName) {
        if (this.log == null) {
            return;
        }
        this.fontName = fontName;
        this.log.setFont(new Font(fontName, 0, this.fontSize));
        StyleConstants.setFontFamily(this.styleRegular, fontName);
        StyleConstants.setFontFamily(this.styleBold, fontName);
        StyleConstants.setFontFamily(this.styleRed, fontName);
        StyleConstants.setFontSize(this.styleRegular, this.fontSize);
        StyleConstants.setFontSize(this.styleBold, this.fontSize);
        StyleConstants.setFontSize(this.styleRed, this.fontSize);
        StyledDocument doc = this.log.getStyledDocument();
        Style temp = doc.addStyle("temp", null);
        StyleConstants.setFontFamily(temp, fontName);
        StyleConstants.setFontSize(temp, this.fontSize);
        doc.setCharacterAttributes(0, doc.getLength(), temp, false);
        Font newFont = new Font(fontName, 1, this.fontSize);
        for (JLabel link : this.links) {
            link.setFont(newFont);
        }
    }

    public void setFontSize(int fontSize) {
        if (this.log == null) {
            return;
        }
        this.fontSize = fontSize;
        this.setFontName(this.fontName);
    }

    public void setBackground(Color background) {
        if (this.log == null) {
            return;
        }
        this.log.setBackground(background);
    }

    int getLength() {
        if (this.log == null) {
            return 0;
        }
        this.clearError();
        return this.log.getStyledDocument().getLength();
    }

    void setLength(int newLength) {
        if (this.log == null) {
            return;
        }
        this.clearError();
        StyledDocument doc = this.log.getStyledDocument();
        int n = doc.getLength();
        if (n <= newLength) {
            return;
        }
        try {
            doc.remove(newLength, n - newLength);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (this.lastSize > doc.getLength()) {
            this.lastSize = doc.getLength();
        }
    }

    public void copy() {
        if (this.log == null) {
            return;
        }
        this.log.copy();
    }

    public void clearError() {
        if (this.log == null) {
            return;
        }
        StyledDocument doc = this.log.getStyledDocument();
        int n = doc.getLength();
        if (n > this.lastSize) {
            try {
                doc.remove(this.lastSize, n - this.lastSize);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (this.batch.size() > 0) {
            for (String msg : this.batch) {
                this.reallyLog(msg, this.styleRegular);
            }
            this.batch.clear();
        }
    }

    public void flush() {
        if (this.log == null) {
            return;
        }
        if (this.batch.size() > 0) {
            this.clearError();
        }
    }
}

