/*
 * Decompiled with CFR 0.152.
 */
package alluxio.checker;

import alluxio.checker.CheckerUtils;
import java.io.BufferedReader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class MapReduceIntegrationChecker {
    private static final String FAIL_TO_FIND_CLASS_MESSAGE = "Please distribute the Alluxio client jar on the classpath of the application across different nodes.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Running-Hadoop-MapReduce-on-Alluxio.html\n";
    private static final String FAIL_TO_FIND_FS_MESSAGE = "Please check the fs.alluxio.impl and fs.AbstractFileSystem.alluxio.impl properties in core-site.xml file of your Hadoop installation.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Running-Hadoop-MapReduce-on-Alluxio.html\n";
    private static final String TEST_FAILED_MESSAGE = "***** Integration test failed. *****\n";
    private static final String TEST_PASSED_MESSAGE = "***** Integration test passed. *****\n";
    private Path mOutputFilePath;
    private FileSystem mFileSystem;

    private void createHdfsFilesystem(Configuration conf) throws Exception {
        this.mFileSystem = FileSystem.get((URI)URI.create(conf.get("fs.defaultFS")), (Configuration)conf);
        this.mOutputFilePath = new Path("./MapReduceOutputFile");
        if (this.mFileSystem.exists(this.mOutputFilePath)) {
            this.mFileSystem.delete(this.mOutputFilePath, true);
        }
    }

    private CheckerUtils.Status generateReport() throws Exception {
        Object object;
        FileStatus[] outputFileStatus = this.mFileSystem.listStatus(this.mOutputFilePath, path -> path.getName().startsWith("part-"));
        HashMap<CheckerUtils.Status, List<String>> resultMap = new HashMap<CheckerUtils.Status, List<String>>();
        for (int i = 0; i < outputFileStatus.length; ++i) {
            Path curOutputFilePath = outputFileStatus[i].getPath();
            BufferedReader curOutputFileReader = new BufferedReader(new InputStreamReader((InputStream)this.mFileSystem.open(curOutputFilePath)));
            object = null;
            try {
                String nextLine = "";
                while ((nextLine = curOutputFileReader.readLine()) != null) {
                    int sep = nextLine.indexOf("\t");
                    CheckerUtils.Status curStatus = CheckerUtils.Status.valueOf(nextLine.substring(0, sep).trim());
                    String curAddresses = nextLine.substring(sep + 1).trim();
                    List addresses = resultMap.getOrDefault((Object)curStatus, new ArrayList());
                    addresses.add(curAddresses);
                    resultMap.put(curStatus, addresses);
                }
                continue;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (curOutputFileReader != null) {
                    if (object != null) {
                        try {
                            curOutputFileReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        curOutputFileReader.close();
                    }
                }
            }
        }
        try (PrintWriter reportWriter = CheckerUtils.initReportFile();){
            CheckerUtils.Status resultStatus = CheckerUtils.printNodesResults(resultMap, reportWriter);
            switch (resultStatus) {
                case FAIL_TO_FIND_CLASS: {
                    reportWriter.println(FAIL_TO_FIND_CLASS_MESSAGE);
                    reportWriter.println(TEST_FAILED_MESSAGE);
                    break;
                }
                case FAIL_TO_FIND_FS: {
                    reportWriter.println(FAIL_TO_FIND_FS_MESSAGE);
                    reportWriter.println(TEST_FAILED_MESSAGE);
                    break;
                }
                default: {
                    reportWriter.println(TEST_PASSED_MESSAGE);
                }
            }
            reportWriter.flush();
            object = resultStatus;
            return object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int run(String[] args) throws Exception {
        Configuration conf = new Configuration();
        String numMaps = new GenericOptionsParser(conf, args).getRemainingArgs()[0];
        conf.set("mapreduce.job.maps", numMaps);
        this.createHdfsFilesystem(conf);
        Job job = Job.getInstance((Configuration)conf, (String)"MapReduceIntegrationChecker");
        job.setJarByClass(MapReduceIntegrationChecker.class);
        job.setMapperClass(CheckerMapper.class);
        job.setCombinerClass(CheckerReducer.class);
        job.setReducerClass(CheckerReducer.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(Text.class);
        job.setInputFormatClass(EmptyInputFormat.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)this.mOutputFilePath);
        try {
            if (!job.waitForCompletion(true)) {
                int n = 1;
                return n;
            }
            CheckerUtils.Status resultStatus = this.generateReport();
            int n = resultStatus.equals((Object)CheckerUtils.Status.SUCCESS) ? 0 : (resultStatus.equals((Object)CheckerUtils.Status.FAIL_TO_FIND_CLASS) ? 2 : 1);
            return n;
        }
        finally {
            if (this.mFileSystem.exists(this.mOutputFilePath)) {
                this.mFileSystem.delete(this.mOutputFilePath, true);
            }
            this.mFileSystem.close();
        }
    }

    public static void main(String[] args) throws Exception {
        MapReduceIntegrationChecker checker = new MapReduceIntegrationChecker();
        System.exit(checker.run(args));
    }

    protected static class CheckerReducer
    extends Reducer<Text, Text, Text, Text> {
        protected CheckerReducer() {
        }

        protected void reduce(Text key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            HashSet<String> addressSet = new HashSet<String>();
            for (Text val : values) {
                addressSet.add(val.toString());
            }
            context.write((Object)key, (Object)new Text(String.join((CharSequence)" ", addressSet)));
        }
    }

    protected static class CheckerMapper
    extends Mapper<Object, Object, Text, Text> {
        protected CheckerMapper() {
        }

        protected void map(Object ignoredKey, Object ignoredValue, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)new Text(CheckerUtils.performIntegrationChecks().toString()), (Object)new Text(CheckerUtils.getLocalAddress()));
        }
    }

    static class EmptyInputFormat
    extends InputFormat<Object, Object> {
        public static boolean sCreateDone = false;

        EmptyInputFormat() {
        }

        public RecordReader<Object, Object> createRecordReader(InputSplit split, TaskAttemptContext context) {
            return new EmptyRecordReader();
        }

        public List<InputSplit> getSplits(JobContext job) {
            int numSplits = job.getConfiguration().getInt("mapreduce.job.maps", 10);
            ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
            for (int split = 0; split < numSplits; ++split) {
                splits.add(new EmptyInputSplit());
            }
            return splits;
        }

        static class EmptyRecordReader
        extends RecordReader<Object, Object> {
            public void initialize(InputSplit split, TaskAttemptContext context) {
            }

            public void close() {
            }

            public Object getCurrentKey() {
                return new Object();
            }

            public Object getCurrentValue() {
                return new Object();
            }

            public float getProgress() {
                if (sCreateDone) {
                    return 1.0f;
                }
                return 0.0f;
            }

            public boolean nextKeyValue() {
                if (sCreateDone) {
                    return false;
                }
                sCreateDone = true;
                return true;
            }
        }

        static class EmptyInputSplit
        extends InputSplit
        implements Writable {
            public long getLength() throws IOException {
                return 0L;
            }

            public String[] getLocations() throws IOException {
                return new String[0];
            }

            public void readFields(DataInput in) throws IOException {
            }

            public void write(DataOutput out) throws IOException {
            }
        }
    }
}

