/*
 * Decompiled with CFR 0.152.
 */
package alluxio.checker;

import alluxio.Configuration;
import alluxio.PropertyKey;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CheckerUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CheckerUtils.class);

    private CheckerUtils() {
    }

    public static PrintWriter initReportFile() throws Exception {
        File file = new File("./IntegrationReport.txt");
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fileWriter = new FileWriter(file.getAbsoluteFile(), true);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        PrintWriter reportWriter = new PrintWriter(bufferedWriter);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yy HH:mm:ss");
        Date date = new Date();
        reportWriter.printf("%n%n%n***** The integration checker ran at %s. *****%n%n", df.format(date));
        return reportWriter;
    }

    public static Status performIntegrationChecks() {
        try {
            Class.forName("alluxio.AlluxioURI");
            Class.forName("alluxio.client.file.BaseFileSystem");
            Class.forName("alluxio.hadoop.AlluxioFileSystem");
        }
        catch (ClassNotFoundException e) {
            LOG.error("Failed to find Alluxio classes on classpath", (Throwable)e);
            return Status.FAIL_TO_FIND_CLASS;
        }
        try {
            FileSystem.getFileSystemClass((String)"alluxio", (org.apache.hadoop.conf.Configuration)new org.apache.hadoop.conf.Configuration());
        }
        catch (Exception e) {
            LOG.error("Failed to find Alluxio filesystem", (Throwable)e);
            return Status.FAIL_TO_FIND_FS;
        }
        return Status.SUCCESS;
    }

    public static boolean supportAlluxioHA(PrintWriter reportWriter) {
        if (Configuration.getBoolean((PropertyKey)PropertyKey.ZOOKEEPER_ENABLED)) {
            reportWriter.println("Alluixo is running in high availability mode.\n");
            if (!Configuration.isSet((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS)) {
                reportWriter.println("Please set Zookeeper address to support Alluxio high availability mode.\n");
                return false;
            }
            reportWriter.printf("Zookeeper address is: %s.%n", Configuration.get((PropertyKey)PropertyKey.ZOOKEEPER_ADDRESS));
        }
        return true;
    }

    public static String getLocalAddress() {
        String address;
        try {
            address = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            LOG.warn("Cannot get local address of current node.");
            address = "unknown address";
        }
        return address;
    }

    public static Status printNodesResults(Map<Status, List<String>> map, PrintWriter reportWriter) {
        boolean canFindClass = true;
        boolean canFindFS = true;
        block4: for (Map.Entry<Status, List<String>> entry : map.entrySet()) {
            String nodeAddresses = String.join((CharSequence)" ", (Iterable<? extends CharSequence>)entry.getValue());
            switch (entry.getKey()) {
                case FAIL_TO_FIND_CLASS: {
                    canFindClass = false;
                    reportWriter.printf("Nodes of IP addresses: %s cannot recognize Alluxio classes.%n%n", nodeAddresses);
                    continue block4;
                }
                case FAIL_TO_FIND_FS: {
                    canFindFS = false;
                    reportWriter.printf("Nodes of IP addresses: %s cannot recognize Alluxio filesystem.%n%n", nodeAddresses);
                    continue block4;
                }
            }
            reportWriter.printf("Nodes of IP addresses: %s can recognize Alluxio filesystem.%n%n", nodeAddresses);
        }
        return canFindClass ? (canFindFS ? Status.SUCCESS : Status.FAIL_TO_FIND_FS) : Status.FAIL_TO_FIND_CLASS;
    }

    public static enum Status {
        FAIL_TO_FIND_CLASS,
        FAIL_TO_FIND_FS,
        FAIL_TO_SUPPORT_HA,
        SUCCESS;

    }
}

