/*
 * Decompiled with CFR 0.152.
 */
package alluxio.checker;

import alluxio.checker.CheckerUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function2;
import org.apache.spark.api.java.function.PairFunction;
import scala.Tuple2;

public class SparkIntegrationChecker
implements scala.Serializable {
    private static final long serialVersionUID = 1106074873546987859L;
    private static final String FAIL_TO_FIND_CLASS_MESSAGE = "Please check the spark.driver.extraClassPath and spark.executor.extraClassPath properties in ${SPARK_HOME}/conf/spark-defaults.conf.\n\nIf Alluxio client jar path has been set correctly, please check whether the Alluxio client jar has been distributed on the classpath of all Spark cluster nodes.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Running-Spark-on-Alluxio.html\n";
    private static final String FAIL_TO_FIND_FS_MESSAGE = "Please check the fs.alluxio.impl property in ${SPARK_HOME}/conf/core-site.xml.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Debugging-Guide.html#q-why-do-i-see-exceptions-like-no-filesystem-for-scheme-alluxio\n";
    private static final String FAIL_TO_SUPPORT_HA_MESSAGE = "Please check the alluxio.zookeeper.address property in ${SPARK_HOME}/conf/core-site.xml\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Running-Spark-on-Alluxio.html\n";
    private static final String TEST_FAILED_MESSAGE = "***** Integration test failed. *****";
    private static final String TEST_PASSED_MESSAGE = "***** Integration test passed. *****";
    @Parameter(names={"--partitions"}, description="The user defined partition number")
    private int mPartitions = 10;
    private List<Tuple2<CheckerUtils.Status, String>> mSparkJobResult = null;

    private CheckerUtils.Status run(JavaSparkContext sc, PrintWriter reportWriter) {
        CheckerUtils.Status driverStatus = CheckerUtils.performIntegrationChecks();
        String driverAddress = sc.getConf().get("spark.driver.host");
        switch (driverStatus) {
            case FAIL_TO_FIND_CLASS: {
                reportWriter.printf("Spark driver: %s failed to recognize Alluxio classes.%n%n", driverAddress);
                return driverStatus;
            }
            case FAIL_TO_FIND_FS: {
                reportWriter.printf("Spark driver: %s failed to recognize Alluxio filesystem.%n%n", driverAddress);
                return driverStatus;
            }
        }
        reportWriter.printf("Spark driver: %s can recognize Alluxio filesystem.%n%n", driverAddress);
        if (!CheckerUtils.supportAlluxioHA(reportWriter)) {
            return CheckerUtils.Status.FAIL_TO_SUPPORT_HA;
        }
        return this.runSparkJob(sc, reportWriter);
    }

    private CheckerUtils.Status runSparkJob(JavaSparkContext sc, PrintWriter reportWriter) {
        List nums = IntStream.rangeClosed(1, this.mPartitions).boxed().collect(Collectors.toList());
        JavaRDD dataSet = sc.parallelize(nums, this.mPartitions);
        JavaPairRDD extractedStatus = dataSet.mapToPair((PairFunction & Serializable)s -> new Tuple2((Object)CheckerUtils.performIntegrationChecks(), (Object)CheckerUtils.getLocalAddress()));
        JavaPairRDD mergeStatus = extractedStatus.reduceByKey((Function2 & Serializable)(a, b) -> a.contains((CharSequence)b) ? a : (b.contains((CharSequence)a) ? b : a + " " + b), this.mPartitions < 10 ? 1 : this.mPartitions / 10);
        this.mSparkJobResult = mergeStatus.collect();
        HashMap<CheckerUtils.Status, List<String>> resultMap = new HashMap<CheckerUtils.Status, List<String>>();
        for (Tuple2<CheckerUtils.Status, String> op : this.mSparkJobResult) {
            List addresses = resultMap.getOrDefault(op._1, new ArrayList());
            addresses.add(op._2);
            resultMap.put((CheckerUtils.Status)((Object)op._1), addresses);
        }
        return CheckerUtils.printNodesResults(resultMap, reportWriter);
    }

    private void printConfigInfo(SparkConf conf, PrintWriter reportWriter) {
        if (conf.contains("spark.master")) {
            reportWriter.printf("Spark master is: %s.%n%n", conf.get("spark.master"));
        }
        if (conf.contains("spark.submit.deployMode")) {
            reportWriter.printf("spark-submit deploy mode is: %s.%n%n", conf.get("spark.submit.deployMode"));
        }
        if (conf.contains("spark.driver.extraClassPath")) {
            reportWriter.printf("spark.driver.extraClassPath includes jar paths: %s.%n%n", conf.get("spark.driver.extraClassPath"));
        }
        if (conf.contains("spark.executor.extraClassPath")) {
            reportWriter.printf("spark.executor.extraClassPath includes jar paths: %s.%n%n", conf.get("spark.executor.extraClassPath"));
        }
    }

    private void printResultInfo(CheckerUtils.Status resultStatus, PrintWriter reportWriter) {
        switch (resultStatus) {
            case FAIL_TO_FIND_CLASS: {
                reportWriter.println(FAIL_TO_FIND_CLASS_MESSAGE);
                reportWriter.println(TEST_FAILED_MESSAGE);
                break;
            }
            case FAIL_TO_FIND_FS: {
                reportWriter.println(FAIL_TO_FIND_FS_MESSAGE);
                reportWriter.println(TEST_FAILED_MESSAGE);
                break;
            }
            case FAIL_TO_SUPPORT_HA: {
                reportWriter.println(FAIL_TO_SUPPORT_HA_MESSAGE);
                reportWriter.println(TEST_FAILED_MESSAGE);
                break;
            }
            default: {
                reportWriter.println(TEST_PASSED_MESSAGE);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        SparkIntegrationChecker checker = new SparkIntegrationChecker();
        JCommander jCommander = new JCommander((Object)checker, args);
        jCommander.setProgramName("SparkIntegrationChecker");
        try (PrintWriter reportWriter = CheckerUtils.initReportFile();){
            SparkConf conf = new SparkConf().setAppName(SparkIntegrationChecker.class.getName());
            JavaSparkContext sc = new JavaSparkContext(conf);
            checker.printConfigInfo(conf, reportWriter);
            CheckerUtils.Status resultStatus = checker.run(sc, reportWriter);
            checker.printResultInfo(resultStatus, reportWriter);
            reportWriter.flush();
            System.exit(resultStatus.equals((Object)CheckerUtils.Status.SUCCESS) ? 0 : 1);
        }
    }
}

