/*
 * Decompiled with CFR 0.152.
 */
package alluxio.checker;

import alluxio.checker.CheckerUtils;
import com.beust.jcommander.IStringConverter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
public class HiveIntegrationChecker {
    private static final Logger LOG = LoggerFactory.getLogger(HiveIntegrationChecker.class);
    private static final String FAIL_TO_FIND_CLASS_MESSAGE = "Please set HIVE_AUX_JARS_PATH either in shell or in conf/hive-env.sh before starting hiveserver2.\n\nPlease distribute the Alluxio client jar on the HIVE_AUX_JARS_PATH of all Hive nodes.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Running-Hive-with-Alluxio.html\n";
    private static final String FAIL_TO_FIND_FS_MESSAGE = "Please check the fs.alluxio.impl property in core-site.xml file of your Hadoop installation.\n\nFor details, please refer to: https://www.alluxio.org/docs/master/en/Debugging-Guide.html\n";
    private static final String TEST_FAILED_MESSAGE = "***** Integration test failed. *****\n";
    private static final String TEST_PASSED_MESSAGE = "***** Integration test passed. *****\n";
    @Parameter(names={"-alluxioUrl"}, description="the alluxio cluster url in the form alluxio://master_hostname:port")
    private String mAlluxioURL = "";
    @Parameter(names={"-mode"}, description="dfs means Alluxio is configured as Hive default filesystem, location means Alluxio is used as a location of Hive tables other than Hive default filesystem.", converter=ModeConverter.class)
    private Mode mUserMode = Mode.LOCATION;
    @Parameter(names={"-hiveUrl", "-hiveurl"}, description="a Hive connection url in the form jdbc:subprotocol:subname", required=true)
    private String mHiveURL;
    @Parameter(names={"-user"}, description="the Hive user on whose behalf the connection is being made")
    private String mHiveUserName = System.getProperty("user.name");
    @Parameter(names={"-password"}, description="the Hive user's password")
    private String mHiveUserPassword = "";

    private int run(PrintWriter reportWriter) {
        try (Connection con = DriverManager.getConnection(this.mHiveURL, this.mHiveUserName, this.mHiveUserPassword);){
            String tableName = "AlluxioTestTable";
            String sql = String.format("drop table if exists %s", tableName);
            try (PreparedStatement dropTablePS = con.prepareStatement(sql);){
                dropTablePS.execute();
            }
            if (this.mUserMode.equals((Object)Mode.DEFAULT_FILESYSTEM)) {
                this.createTableInHiveDFS(con, tableName);
            } else {
                this.createTableInAlluxio(con, tableName);
            }
            sql = String.format("INSERT INTO %s VALUES ('You passed ', 'Hive Test!')", tableName);
            var7_10 = null;
            try (PreparedStatement loadTablePS = con.prepareStatement(sql);){
                loadTablePS.executeUpdate();
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
            sql = String.format("describe %s", tableName);
            var7_10 = null;
            try (PreparedStatement describeTablePS = con.prepareStatement(sql);){
                describeTablePS.execute();
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
            sql = String.format("select * from %s", tableName);
            reportWriter.println("Running " + sql);
            var7_10 = null;
            try (PreparedStatement selectTablePS = con.prepareStatement(sql);
                 ResultSet resultSet = selectTablePS.executeQuery();){
                reportWriter.println("Result should be \"You passed Hive test!\" ");
                reportWriter.println("Checker result is: ");
                while (resultSet.next()) {
                    reportWriter.println(resultSet.getString(1) + resultSet.getString(2));
                }
            }
            catch (Throwable throwable) {
                var7_10 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            this.printExceptionReport(e, reportWriter);
            return 1;
        }
        reportWriter.println("\nCongratulations, you have configured Hive with Alluxio correctly!\n");
        reportWriter.println(TEST_PASSED_MESSAGE);
        return 0;
    }

    private void createTableInHiveDFS(Connection con, String tableName) throws Exception {
        String sql = String.format("CREATE TABLE %s (ROW1 STRING, ROW2 STRING) ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' STORED AS TEXTFILE", tableName);
        try (PreparedStatement createTablePS = con.prepareStatement(sql);){
            createTablePS.execute();
        }
    }

    private void createTableInAlluxio(Connection con, String tableName) throws Exception {
        String sql = String.format("CREATE TABLE %s (ROW1 STRING, ROW2 STRING) ROW FORMAT DELIMITED FIELDS TERMINATED BY '|' LOCATION '%s/alluxioTestFolder/'", tableName, this.mAlluxioURL);
        try (PreparedStatement createTablePS = con.prepareStatement(sql);){
            createTablePS.execute();
        }
    }

    private void printExceptionReport(Exception exception, PrintWriter reportWriter) {
        String exceptionStr = exception.toString();
        if (exceptionStr.contains("Could not open client transport with JDBC Uri")) {
            exception.printStackTrace(reportWriter);
            reportWriter.printf("Could not open client transport with JDBC Uri: %s%n", this.mHiveURL);
            reportWriter.println("Please modify your Hive Url and rerun the checker.");
        } else if (exceptionStr.contains("Class alluxio.hadoop.FileSystem not found")) {
            reportWriter.println(FAIL_TO_FIND_CLASS_MESSAGE);
        } else if (exceptionStr.contains("No FileSystem for scheme \"alluxio\"") || exceptionStr.contains("No FileSystem for scheme: alluxio")) {
            reportWriter.println(FAIL_TO_FIND_FS_MESSAGE);
        } else {
            reportWriter.println("Please fix the following error and rerun the Hive Integration Checker.\n");
            exception.printStackTrace(reportWriter);
        }
        reportWriter.println(TEST_FAILED_MESSAGE);
    }

    public static void main(String[] args) throws Exception {
        HiveIntegrationChecker checker = new HiveIntegrationChecker();
        JCommander jCommander = new JCommander((Object)checker, args);
        jCommander.setProgramName("HiveIntegrationChecker");
        try (PrintWriter reportWriter = CheckerUtils.initReportFile();){
            int result = checker.run(reportWriter);
            reportWriter.flush();
            System.exit(result);
        }
    }

    public static enum Mode {
        DEFAULT_FILESYSTEM,
        LOCATION;

    }

    public static class ModeConverter
    implements IStringConverter<Mode> {
        public Mode convert(String value) {
            switch (value) {
                case "dfs": {
                    return Mode.DEFAULT_FILESYSTEM;
                }
                case "location": {
                    return Mode.LOCATION;
                }
            }
            throw new ParameterException("-mode USER_MODE, USER_MODE is dfs or location, your USER_MODE is invalid");
        }
    }
}

