/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.RuntimeConstants;
import alluxio.cli.CliUtils;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import alluxio.util.CommonUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JournalCrashTest {
    private static final int EXIT_FAILED = 1;
    private static final int EXIT_SUCCESS = 0;
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private static CreateFileOptions sCreateFileOptions = null;
    private static List<ClientThread> sClientThreadList = null;
    private static int sCreateDeleteClientNum;
    private static int sCreateFileClientNum;
    private static int sCreateRenameClientNum;
    private static long sMaxAliveTimeMs;
    private static String sTestDir;
    private static FileSystem sFileSystem;
    private static long sTotalTimeMs;

    private JournalCrashTest() {
    }

    private static boolean checkStatus() throws Exception {
        for (ClientThread clientThread : sClientThreadList) {
            ClientOpType opType = clientThread.getOpType();
            String workDir = clientThread.getWorkDir();
            int successNum = clientThread.getSuccessNum();
            LOG.info("Expected Status: OpType[{}] WorkDir[{}] SuccessNum[{}].", new Object[]{opType, workDir, successNum});
            for (int s = 0; s < successNum; ++s) {
                AlluxioURI checkURI = new AlluxioURI(workDir + s);
                if (ClientOpType.CREATE_FILE == opType) {
                    if (sFileSystem.exists(checkURI)) continue;
                    LOG.error("File not exist for create test. Check failed! File: {}", (Object)checkURI);
                    return false;
                }
                if (ClientOpType.CREATE_DELETE_FILE == opType) {
                    if (!sFileSystem.exists(checkURI)) continue;
                    LOG.error("File exists for create/delete test. Check failed! File: {}", (Object)checkURI);
                    return false;
                }
                if (ClientOpType.CREATE_RENAME_FILE != opType || sFileSystem.exists(new AlluxioURI(checkURI + "-rename"))) continue;
                LOG.error("File not exist for create/rename test. Check failed! File: {}-rename", (Object)checkURI);
                return false;
            }
        }
        return true;
    }

    private static void killMaster() {
        String[] killMasterCommand = new String[]{"/usr/bin/env", "bash", "-c", "for pid in `ps -Aww -o pid,command | grep -i \"[j]ava\" | grep \"alluxio.master.AlluxioMaster\" | awk '{print $1}'`; do kill -9 \"$pid\"; done"};
        try {
            Runtime.getRuntime().exec(killMasterCommand).waitFor();
            CommonUtils.sleepMs((Logger)LOG, (long)1000L);
        }
        catch (Exception e) {
            LOG.error("Error when killing Master", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        if (!JournalCrashTest.parseInputArgs(args)) {
            System.exit(1);
        }
        System.out.println("Stop the current Alluxio cluster...");
        JournalCrashTest.stopCluster();
        sCreateFileOptions = CreateFileOptions.defaults().setWriteType(WriteType.NONE);
        if (System.getProperty("alluxio.master.retry") == null) {
            System.setProperty("alluxio.master.retry", "10");
        }
        System.out.println("Start Journal Crash Test...");
        long startTimeMs = System.currentTimeMillis();
        boolean ret = true;
        JournalCrashTest.startMaster();
        int rounds = 0;
        while (System.currentTimeMillis() - startTimeMs < sTotalTimeMs) {
            long aliveTimeMs = (long)(Math.random() * (double)sMaxAliveTimeMs) + 100L;
            LOG.info("Round {}: Planning Master Alive Time {}ms.", (Object)(++rounds), (Object)aliveTimeMs);
            System.out.println("Round " + rounds + " : Launch Clients...");
            sFileSystem = FileSystem.Factory.get();
            try {
                sFileSystem.delete(new AlluxioURI(sTestDir));
            }
            catch (Exception e) {
                // empty catch block
            }
            JournalCrashTest.setupClientThreads();
            for (Thread thread : sClientThreadList) {
                thread.start();
            }
            CommonUtils.sleepMs((Logger)LOG, (long)aliveTimeMs);
            System.out.println("Round " + rounds + " : Crash Master...");
            JournalCrashTest.killMaster();
            for (ClientThread clientThread : sClientThreadList) {
                clientThread.setIsStopped(true);
            }
            for (Thread thread : sClientThreadList) {
                try {
                    thread.join();
                }
                catch (InterruptedException e) {
                    LOG.error("Error when waiting thread", (Throwable)e);
                }
            }
            System.out.println("Round " + rounds + " : Check Status...");
            JournalCrashTest.startMaster();
            boolean checkSuccess = false;
            try {
                checkSuccess = JournalCrashTest.checkStatus();
            }
            catch (Exception exception) {
                LOG.error("Failed to check status", (Throwable)exception);
            }
            CliUtils.printPassInfo(checkSuccess);
            ret &= checkSuccess;
        }
        JournalCrashTest.stopCluster();
        System.exit(ret ? 0 : 1);
    }

    private static boolean parseInputArgs(String[] args) {
        Options options = new Options();
        options.addOption("help", false, "Show help for this test");
        options.addOption("maxAlive", true, "The maximum time a master should ever be alive during the test, in seconds");
        options.addOption("totalTime", true, "The total time to run this test, in seconds. This value should be greater than [maxAlive]");
        options.addOption("creates", true, "Number of Client Threads to request create operations");
        options.addOption("deletes", true, "Number of Client Threads to request create/delete operations");
        options.addOption("renames", true, "Number of Client Threads to request create/rename operations");
        options.addOption("testDir", true, "Test Directory on Alluxio");
        BasicParser parser = new BasicParser();
        CommandLine cmd = null;
        boolean ret = true;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.error("Failed to parse input args", (Throwable)e);
            ret = false;
        }
        if (ret && !cmd.hasOption("help")) {
            sMaxAliveTimeMs = 1000L * Long.parseLong(cmd.getOptionValue("maxAlive", "5"));
            sTotalTimeMs = 1000L * Long.parseLong(cmd.getOptionValue("totalTime", "20"));
            sCreateFileClientNum = Integer.parseInt(cmd.getOptionValue("creates", "2"));
            sCreateDeleteClientNum = Integer.parseInt(cmd.getOptionValue("deletes", "2"));
            sCreateRenameClientNum = Integer.parseInt(cmd.getOptionValue("renames", "2"));
            sTestDir = cmd.getOptionValue("testDir", "/default_tests_files");
        } else {
            ret = false;
            new HelpFormatter().printHelp(String.format("java -cp %s %s", RuntimeConstants.ALLUXIO_JAR, JournalCrashTest.class.getCanonicalName()), "Test the Master Journal System in a crash scenario", options, "e.g. options '-maxAlive 5 -totalTime 20 -creates 2 -deletes 2 -renames 2'will launch total 6 clients connecting to the Master and the Masterwill crash randomly with the max alive time 5 seconds.", true);
        }
        return ret;
    }

    private static void setupClientThreads() {
        ClientThread thread;
        int i;
        sClientThreadList = new ArrayList<ClientThread>();
        for (i = 0; i < sCreateFileClientNum; ++i) {
            thread = new ClientThread(sTestDir + "/createFile" + i + "/", ClientOpType.CREATE_FILE);
            sClientThreadList.add(thread);
        }
        for (i = 0; i < sCreateDeleteClientNum; ++i) {
            thread = new ClientThread(sTestDir + "/createDelete" + i + "/", ClientOpType.CREATE_DELETE_FILE);
            sClientThreadList.add(thread);
        }
        for (i = 0; i < sCreateRenameClientNum; ++i) {
            thread = new ClientThread(sTestDir + "/createRename" + i + "/", ClientOpType.CREATE_RENAME_FILE);
            sClientThreadList.add(thread);
        }
    }

    private static void startMaster() {
        String startMasterCommand = Configuration.createServerConf().get("alluxio.home") + "/bin/alluxio-start.sh master";
        try {
            Runtime.getRuntime().exec(startMasterCommand).waitFor();
            CommonUtils.sleepMs((Logger)LOG, (long)1000L);
        }
        catch (Exception e) {
            LOG.error("Error when starting Master", (Throwable)e);
        }
    }

    private static void stopCluster() {
        String stopClusterCommand = Configuration.createServerConf().get("alluxio.home") + "/bin/alluxio-stop.sh all";
        try {
            Runtime.getRuntime().exec(stopClusterCommand).waitFor();
            CommonUtils.sleepMs((Logger)LOG, (long)1000L);
        }
        catch (Exception e) {
            LOG.error("Error when stop Alluxio cluster", (Throwable)e);
        }
    }

    static {
        sFileSystem = null;
    }

    static class ClientThread
    extends Thread {
        private final ClientOpType mOpType;
        private final String mWorkDir;
        private boolean mIsStopped = false;
        private int mSuccessNum = 0;

        public ClientThread(String workDir, ClientOpType opType) {
            this.mOpType = opType;
            this.mWorkDir = workDir;
        }

        public ClientOpType getOpType() {
            return this.mOpType;
        }

        public int getSuccessNum() {
            return this.mSuccessNum;
        }

        public String getWorkDir() {
            return this.mWorkDir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                block17: {
                    ClientThread clientThread = this;
                    synchronized (clientThread) {
                        if (this.mIsStopped) {
                            break;
                        }
                    }
                    try {
                        AlluxioURI testURI = new AlluxioURI(this.mWorkDir + this.mSuccessNum);
                        if (ClientOpType.CREATE_FILE == this.mOpType) {
                            sFileSystem.createFile(testURI, sCreateFileOptions).close();
                            break block17;
                        }
                        if (ClientOpType.CREATE_DELETE_FILE == this.mOpType) {
                            try {
                                sFileSystem.createFile(testURI, sCreateFileOptions).close();
                            }
                            catch (AlluxioException e) {
                                if (!(e instanceof FileAlreadyExistsException)) {
                                    throw e;
                                }
                            }
                            catch (Exception e) {
                                throw e;
                            }
                            sFileSystem.delete(testURI);
                            break block17;
                        }
                        if (ClientOpType.CREATE_RENAME_FILE != this.mOpType) break block17;
                        try {
                            sFileSystem.createFile(testURI, sCreateFileOptions).close();
                        }
                        catch (AlluxioException e) {
                            if (!(e instanceof FileAlreadyExistsException)) {
                                throw e;
                            }
                        }
                        catch (Exception e) {
                            throw e;
                        }
                        sFileSystem.rename(testURI, new AlluxioURI(testURI + "-rename"));
                    }
                    catch (Exception e) {
                        continue;
                    }
                }
                ++this.mSuccessNum;
                CommonUtils.sleepMs((long)100L);
            }
        }

        public synchronized void setIsStopped(boolean isStopped) {
            this.mIsStopped = isStopped;
        }
    }

    static enum ClientOpType {
        CREATE_FILE,
        CREATE_DELETE_FILE,
        CREATE_RENAME_FILE;

    }
}

