/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.RuntimeConstants;
import alluxio.cli.CliUtils;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.DeleteOptions;
import alluxio.examples.BasicNonByteBufferOperations;
import alluxio.examples.BasicOperations;
import java.util.Arrays;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class TestRunner {
    private static final List<ReadType> READ_TYPES = Arrays.asList(ReadType.CACHE_PROMOTE, ReadType.CACHE, ReadType.NO_CACHE);
    private static final List<WriteType> WRITE_TYPES = Arrays.asList(WriteType.MUST_CACHE, WriteType.CACHE_THROUGH, WriteType.THROUGH, WriteType.ASYNC_THROUGH);
    public static final String TEST_PATH = "/default_tests_files";

    private TestRunner() {
    }

    private static void usage() {
        System.out.println("Usage:");
        System.out.println("(1) To run a predefined set of read/write tests:");
        System.out.println(String.format("java -cp %s %s <master address>", RuntimeConstants.ALLUXIO_JAR, TestRunner.class.getCanonicalName()));
        System.out.println("(2) To run a single test:");
        System.out.println(String.format("java -cp %s %s <master address> <%s> <%s> <%s>", RuntimeConstants.ALLUXIO_JAR, TestRunner.class.getCanonicalName(), OperationType.class.getSimpleName(), ReadType.class.getSimpleName(), WriteType.class.getSimpleName()));
        System.out.println(String.format("\t <%s>: one of %s", OperationType.class.getSimpleName(), Arrays.toString((Object[])OperationType.values())));
        System.out.println(String.format("\t <%s>: one of %s", ReadType.class.getSimpleName(), READ_TYPES));
        System.out.println(String.format("\t <%s>: one of %s", WriteType.class.getSimpleName(), WRITE_TYPES));
    }

    public static void main(String[] args) throws Exception {
        int ret;
        if (args.length != 1 && args.length != 4) {
            TestRunner.usage();
            System.exit(-1);
        }
        AlluxioURI masterLocation = new AlluxioURI(args[0]);
        AlluxioURI testDir = new AlluxioURI(TEST_PATH);
        FileSystem fs = FileSystem.Factory.get();
        if (fs.exists(testDir)) {
            fs.delete(testDir, DeleteOptions.defaults().setRecursive(true));
        }
        if (args.length == 1) {
            ret = TestRunner.runTests(masterLocation);
        } else {
            OperationType optType = OperationType.valueOf(args[1]);
            ReadType readType = ReadType.valueOf((String)args[2]);
            WriteType writeType = WriteType.valueOf((String)args[3]);
            ret = TestRunner.runTest(masterLocation, optType, readType, writeType);
        }
        System.exit(ret);
    }

    private static int runTests(AlluxioURI masterLocation) {
        int failed = 0;
        for (ReadType readType : READ_TYPES) {
            for (WriteType writeType : WRITE_TYPES) {
                for (OperationType opType : OperationType.values()) {
                    System.out.println(String.format("runTest %s %s %s", new Object[]{opType, readType, writeType}));
                    failed += TestRunner.runTest(masterLocation, opType, readType, writeType);
                }
            }
        }
        if (failed > 0) {
            System.out.println("Number of failed tests: " + failed);
        }
        return failed;
    }

    private static int runTest(AlluxioURI masterLocation, OperationType opType, ReadType readType, WriteType writeType) {
        AlluxioURI filePath = new AlluxioURI(String.format("%s/%s_%s_%s", new Object[]{TEST_PATH, opType, readType, writeType}));
        boolean result = true;
        switch (opType) {
            case Basic: {
                result = CliUtils.runExample(new BasicOperations(masterLocation, filePath, readType, writeType));
                break;
            }
            case BasicNonByteBuffer: {
                result = CliUtils.runExample(new BasicNonByteBufferOperations(masterLocation, filePath, readType, writeType, true, 20));
                break;
            }
            default: {
                System.out.println("Unrecognized operation type " + (Object)((Object)opType));
            }
        }
        return result ? 0 : 1;
    }

    static enum OperationType {
        Basic,
        BasicNonByteBuffer;

    }
}

