/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.ClientContext;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.options.CreateFileOptions;
import alluxio.client.file.options.OpenFileOptions;
import alluxio.exception.AlluxioException;
import alluxio.exception.FileAlreadyExistsException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.Callable;

public final class BasicNonByteBufferOperations
implements Callable<Boolean> {
    private final AlluxioURI mMasterLocation;
    private final AlluxioURI mFilePath;
    private final ReadType mReadType;
    private final WriteType mWriteType;
    private final boolean mDeleteIfExists;
    private final int mLength;

    public BasicNonByteBufferOperations(AlluxioURI masterLocation, AlluxioURI filePath, ReadType readType, WriteType writeType, boolean deleteIfExists, int length) {
        this.mMasterLocation = masterLocation;
        this.mFilePath = filePath;
        this.mWriteType = writeType;
        this.mReadType = readType;
        this.mDeleteIfExists = deleteIfExists;
        this.mLength = length;
    }

    @Override
    public Boolean call() throws Exception {
        ClientContext.getConf().set("alluxio.master.hostname", this.mMasterLocation.getHost());
        ClientContext.getConf().set("alluxio.master.port", Integer.toString(this.mMasterLocation.getPort()));
        ClientContext.init();
        FileSystem alluxioClient = FileSystem.Factory.get();
        this.write(alluxioClient);
        return this.read(alluxioClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(FileSystem alluxioClient) throws IOException, AlluxioException {
        FileOutStream fileOutStream = this.createFile(alluxioClient, this.mFilePath, this.mDeleteIfExists);
        try (DataOutputStream os = new DataOutputStream((OutputStream)fileOutStream);){
            os.writeInt(this.mLength);
            for (int i = 0; i < this.mLength; ++i) {
                os.writeInt(i);
            }
        }
    }

    private FileOutStream createFile(FileSystem fileSystem, AlluxioURI filePath, boolean deleteIfExists) throws IOException, AlluxioException {
        CreateFileOptions options = CreateFileOptions.defaults().setWriteType(this.mWriteType);
        if (!fileSystem.exists(filePath)) {
            return fileSystem.createFile(filePath, options);
        }
        if (deleteIfExists) {
            fileSystem.delete(filePath);
            return fileSystem.createFile(filePath, options);
        }
        throw new FileAlreadyExistsException("File exists and deleteIfExists is false");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean read(FileSystem alluxioClient) throws IOException, AlluxioException {
        OpenFileOptions options = OpenFileOptions.defaults().setReadType(this.mReadType);
        try (DataInputStream input = new DataInputStream((InputStream)alluxioClient.openFile(this.mFilePath, options));){
            int length = input.readInt();
            for (int i = 0; i < length; ++i) {
                if (input.readInt() == i) continue;
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }
}

