/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.RuntimeConstants;
import alluxio.cli.CliUtils;
import alluxio.client.ClientContext;
import alluxio.client.keyvalue.KeyValuePair;
import alluxio.client.keyvalue.KeyValueStoreReader;
import alluxio.client.keyvalue.KeyValueStoreWriter;
import alluxio.client.keyvalue.KeyValueSystem;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyValueStoreOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger((String)"alluxio.logger.type");
    private final int mPartitionLength = 0x100000;
    private final int mValueLength = 524288;
    private final int mNumKeyValuePairs = 10;
    private AlluxioURI mStoreUri;
    private Map<ByteBuffer, ByteBuffer> mKeyValuePairs = new HashMap<ByteBuffer, ByteBuffer>();

    public KeyValueStoreOperations(AlluxioURI storeUri) throws Exception {
        this.mStoreUri = storeUri;
    }

    @Override
    public Boolean call() throws Exception {
        Configuration conf = ClientContext.getConf();
        conf.set("alluxio.keyvalue.enabled", String.valueOf(true));
        conf.set("alluxio.keyvalue.partition.size.bytes.max", String.valueOf(0x100000));
        KeyValueSystem kvs = KeyValueSystem.Factory.create();
        KeyValueStoreWriter writer = kvs.createStore(this.mStoreUri);
        this.putKeyValuePairs(writer);
        writer.close();
        KeyValueStoreReader reader = kvs.openStore(this.mStoreUri);
        boolean pass = this.getKeyValuePairs(reader);
        reader.close();
        return pass;
    }

    private void putKeyValuePairs(KeyValueStoreWriter writer) throws Exception {
        LOG.info("Putting key-value pairs...");
        for (int i = 0; i < 10; ++i) {
            byte[] key = ByteBuffer.allocate(4).putInt(i).array();
            byte[] value = BufferUtils.getIncreasingByteArray((int)524288);
            writer.put(key, value);
            this.mKeyValuePairs.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        }
    }

    private boolean getKeyValuePairs(KeyValueStoreReader reader) throws Exception {
        ByteBuffer gotValue;
        ByteBuffer expectedValue;
        LOG.info("Getting key-value pairs...");
        if (reader.size() != 10) {
            LOG.error("The key-value store has the wrong numbers of key-value pairs");
            return false;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> pair : this.mKeyValuePairs.entrySet()) {
            expectedValue = pair.getValue();
            if (expectedValue.equals(gotValue = reader.get(pair.getKey()))) continue;
            LOG.error("The value returned from the key-value store iterator is unexpected");
            return false;
        }
        for (KeyValuePair kv : reader) {
            expectedValue = this.mKeyValuePairs.get(kv.getKey());
            if (expectedValue.equals(gotValue = kv.getValue())) continue;
            LOG.error("The value returned from the key-value store iterator is not expected");
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        boolean result;
        if (args.length != 1) {
            System.out.println("Usage: java -cp " + RuntimeConstants.ALLUXIO_JAR + " " + KeyValueStoreOperations.class.getName() + " <key-value store URI>");
            System.exit(-1);
        }
        System.exit((result = CliUtils.runExample(new KeyValueStoreOperations(new AlluxioURI(args[0])))) ? 0 : 1);
    }
}

