/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue;

import alluxio.AlluxioURI;
import alluxio.RuntimeConstants;
import alluxio.cli.CliUtils;
import alluxio.client.keyvalue.KeyValuePair;
import alluxio.client.keyvalue.KeyValueStoreReader;
import alluxio.client.keyvalue.KeyValueSystem;
import alluxio.util.FormatUtils;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SameKeyValueStoresTest
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(SameKeyValueStoresTest.class);
    private final AlluxioURI mStoreUri1;
    private final AlluxioURI mStoreUri2;

    public SameKeyValueStoresTest(AlluxioURI storeUri1, AlluxioURI storeUri2) throws Exception {
        this.mStoreUri1 = storeUri1;
        this.mStoreUri2 = storeUri2;
    }

    @Override
    public Boolean call() throws Exception {
        KeyValueSystem kvs = KeyValueSystem.Factory.create();
        KeyValueStoreReader reader1 = kvs.openStore(this.mStoreUri1);
        KeyValueStoreReader reader2 = kvs.openStore(this.mStoreUri2);
        boolean pass = this.areTheSameStores(reader1, reader2);
        reader1.close();
        reader2.close();
        return pass;
    }

    private boolean areTheSameStores(KeyValueStoreReader reader1, KeyValueStoreReader reader2) throws Exception {
        int size2;
        int size1 = reader1.size();
        if (size1 != (size2 = reader2.size())) {
            LOG.error("store {} has {} pairs while another has {} pairs", new Object[]{this.mStoreUri1, size1, size2});
            return false;
        }
        for (KeyValuePair pair1 : reader1) {
            byte[] key1 = BufferUtils.newByteArrayFromByteBuffer((ByteBuffer)pair1.getKey());
            byte[] value1 = BufferUtils.newByteArrayFromByteBuffer((ByteBuffer)pair1.getValue());
            byte[] value2 = reader2.get(key1);
            if (value2 == null) {
                LOG.error("store {} has value for key {} while another has no value for the same key", (Object)this.mStoreUri1, (Object)FormatUtils.byteArrayToHexString((byte[])key1));
                return false;
            }
            if (ByteBuffer.wrap(value1).equals(ByteBuffer.wrap(value2))) continue;
            LOG.error("value for key {} are different in the two stores", (Object)FormatUtils.byteArrayToHexString((byte[])key1));
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        boolean result;
        if (args.length != 2) {
            System.out.println("Usage: java -cp " + RuntimeConstants.ALLUXIO_JAR + " " + SameKeyValueStoresTest.class.getName() + " <key-value store URI 1>" + " <key-value store URI 2>");
            System.exit(-1);
        }
        System.exit((result = CliUtils.runExample(new SameKeyValueStoresTest(new AlluxioURI(args[0]), new AlluxioURI(args[1])))) ? 0 : 1);
    }
}

