/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue;

import alluxio.AlluxioURI;
import alluxio.RuntimeConstants;
import alluxio.client.keyvalue.KeyValueIterator;
import alluxio.client.keyvalue.KeyValuePair;
import alluxio.client.keyvalue.KeyValueStoreReader;
import alluxio.client.keyvalue.KeyValueSystem;
import alluxio.util.FormatUtils;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;

public final class ShowKeyValueStore {
    private static void show(KeyValuePair pair, String scope) {
        String key = FormatUtils.byteArrayToHexString((byte[])BufferUtils.newByteArrayFromByteBuffer((ByteBuffer)pair.getKey()));
        String value = FormatUtils.byteArrayToHexString((byte[])BufferUtils.newByteArrayFromByteBuffer((ByteBuffer)pair.getValue()));
        switch (scope) {
            case "key": {
                System.out.println(key);
                break;
            }
            case "value": {
                System.out.println(value);
                break;
            }
            case "all": {
                System.out.printf("%s %s%n", key, value);
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unknown scope: %s, should be one of key/value/all", scope));
            }
        }
    }

    private ShowKeyValueStore() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2) {
            System.out.println("Usage: java -cp " + RuntimeConstants.ALLUXIO_JAR + " " + ShowKeyValueStore.class.getName() + " <key-value store URI>" + " <scope, be one of key/value/all>");
            System.exit(-1);
        }
        KeyValueStoreReader reader = KeyValueSystem.Factory.create().openStore(new AlluxioURI(args[0]));
        KeyValueIterator iterator = reader.iterator();
        while (iterator.hasNext()) {
            ShowKeyValueStore.show(iterator.next(), args[1]);
        }
        reader.close();
    }
}

