/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue.hadoop;

import alluxio.hadoop.mapreduce.KeyValueInputFormat;
import alluxio.hadoop.mapreduce.KeyValueOutputFormat;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public final class CloneStoreMapReduce {
    public static void main(String[] args) throws Exception {
        Configuration conf = new Configuration();
        Job job = new Job(conf);
        job.setJobName("CloneStoreMapReduce");
        job.setJarByClass(CloneStoreMapReduce.class);
        job.setOutputKeyClass(BytesWritable.class);
        job.setOutputValueClass(BytesWritable.class);
        job.setMapperClass(CloneStoreMapper.class);
        job.setReducerClass(CloneStoreReducer.class);
        job.setInputFormatClass(KeyValueInputFormat.class);
        job.setOutputFormatClass(KeyValueOutputFormat.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(args[0])});
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(args[1]));
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }

    public static class CloneStoreReducer
    extends Reducer<BytesWritable, BytesWritable, BytesWritable, BytesWritable> {
        public void reduce(BytesWritable key, Iterable<BytesWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            for (BytesWritable value : values) {
                context.write((Object)key, (Object)value);
            }
        }
    }

    public static class CloneStoreMapper
    extends Mapper<BytesWritable, BytesWritable, BytesWritable, BytesWritable> {
        public void map(BytesWritable key, BytesWritable value, Mapper.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)value);
        }
    }
}

