/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue;

import alluxio.AlluxioURI;
import alluxio.Configuration;
import alluxio.PropertyKey;
import alluxio.cli.CliUtils;
import alluxio.client.keyvalue.KeyValuePair;
import alluxio.client.keyvalue.KeyValueStoreReader;
import alluxio.client.keyvalue.KeyValueStoreWriter;
import alluxio.client.keyvalue.KeyValueSystem;
import alluxio.util.io.BufferUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyValueStoreOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(KeyValueStoreOperations.class);
    private final int mPartitionLength = 0x100000;
    private final int mNumKeyValuePairs = 10;
    private AlluxioURI mStoreUri;
    private Map<ByteBuffer, ByteBuffer> mKeyValuePairs = new HashMap<ByteBuffer, ByteBuffer>();

    public KeyValueStoreOperations(AlluxioURI storeUri) throws Exception {
        this.mStoreUri = storeUri;
    }

    @Override
    public Boolean call() throws Exception {
        Configuration.set((PropertyKey)PropertyKey.KEY_VALUE_ENABLED, (Object)String.valueOf(true));
        Configuration.set((PropertyKey)PropertyKey.KEY_VALUE_PARTITION_SIZE_BYTES_MAX, (Object)String.valueOf(0x100000));
        KeyValueSystem kvs = KeyValueSystem.Factory.create();
        KeyValueStoreWriter writer = kvs.createStore(this.mStoreUri);
        this.putKeyValuePairs(writer);
        writer.close();
        KeyValueStoreReader reader = kvs.openStore(this.mStoreUri);
        boolean pass = this.getKeyValuePairs(reader);
        reader.close();
        return pass;
    }

    private void putKeyValuePairs(KeyValueStoreWriter writer) throws Exception {
        LOG.info("Putting key-value pairs...");
        for (int i = 0; i < 10; ++i) {
            byte[] key = ByteBuffer.allocate(4).putInt(i).array();
            int valueLength = 524288;
            byte[] value = BufferUtils.getIncreasingByteArray((int)valueLength);
            writer.put(key, value);
            this.mKeyValuePairs.put(ByteBuffer.wrap(key), ByteBuffer.wrap(value));
        }
    }

    private boolean getKeyValuePairs(KeyValueStoreReader reader) throws Exception {
        ByteBuffer gotValue;
        ByteBuffer expectedValue;
        LOG.info("Getting key-value pairs...");
        if (reader.size() != 10) {
            LOG.error("The key-value store has the wrong numbers of key-value pairs");
            return false;
        }
        for (Map.Entry<ByteBuffer, ByteBuffer> pair : this.mKeyValuePairs.entrySet()) {
            expectedValue = pair.getValue();
            if (expectedValue.equals(gotValue = reader.get(pair.getKey()))) continue;
            LOG.error("The value returned from the key-value store iterator is unexpected");
            return false;
        }
        for (KeyValuePair kv : reader) {
            expectedValue = this.mKeyValuePairs.get(kv.getKey());
            if (expectedValue.equals(gotValue = kv.getValue())) continue;
            LOG.error("The value returned from the key-value store iterator is not expected");
            return false;
        }
        return true;
    }

    public static void main(String[] args) throws Exception {
        boolean result;
        if (args.length != 1) {
            System.out.println("Usage: java -cp target/alluxio-1.8.1-jar-with-dependencies.jar " + KeyValueStoreOperations.class.getName() + " <key-value store URI>");
            System.exit(-1);
        }
        if (!Configuration.getBoolean((PropertyKey)PropertyKey.KEY_VALUE_ENABLED)) {
            System.out.println("Alluxio key value service is disabled. To run this test, please set " + PropertyKey.KEY_VALUE_ENABLED + " to be true and restart the cluster.");
            System.exit(-1);
        }
        System.exit((result = CliUtils.runExample(new KeyValueStoreOperations(new AlluxioURI(args[0])))) ? 0 : 1);
    }
}

