/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples.keyvalue;

import alluxio.AlluxioURI;
import alluxio.client.keyvalue.KeyValueStoreReader;
import alluxio.client.keyvalue.KeyValueStoreWriter;
import alluxio.client.keyvalue.KeyValueSystem;

public final class KeyValueStoreQuickStart {
    private KeyValueStoreQuickStart() {
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.out.println("Usage: java -cp target/alluxio-1.8.1-jar-with-dependencies.jar " + KeyValueStoreQuickStart.class.getName() + " <key-value store URI>");
            System.exit(-1);
        }
        AlluxioURI storeUri = new AlluxioURI(args[0]);
        KeyValueSystem kvs = KeyValueSystem.Factory.create();
        KeyValueStoreWriter writer = kvs.createStore(storeUri);
        String key = "key";
        String value = "value";
        writer.put(key.getBytes(), value.getBytes());
        System.out.println(String.format("(%s, %s) is put into the key-value store", key, value));
        writer.close();
        KeyValueStoreReader reader = kvs.openStore(storeUri);
        System.out.println(String.format("Value for key '%s' got from the store is '%s'", key, new String(reader.get(key.getBytes()))));
        reader.close();
    }
}

