/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.client.file.FileSystem;
import alluxio.exception.AlluxioException;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class RunOperation {
    private static final String BASE_DIRECTORY = "/RunOperationDir";
    @Parameter(names={"-op", "-operation"}, description="the operation to perform. Options are [CreateEmptyFile, CreateAndDeleteEmptyFile]", required=true)
    private Operation mOperation;
    @Parameter(names={"-n", "-num"}, description="the number of times to perform the operation (total for all threads)")
    private int mTimes = 1;
    @Parameter(names={"-t", "-threads"}, description="the number of threads to use")
    private int mThreads = 1;
    private final FileSystem mFileSystem = FileSystem.Factory.get();
    private AtomicInteger mRemainingOps;

    public static void main(String[] args) {
        System.exit(new RunOperation().run(args));
    }

    public int run(String[] args) {
        JCommander jc = new JCommander((Object)this);
        jc.setProgramName("runOperation");
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e.toString());
            System.out.println();
            jc.usage();
            return -1;
        }
        this.mRemainingOps = new AtomicInteger(this.mTimes);
        ArrayList<OperationThread> threads = new ArrayList<OperationThread>();
        for (int i = 0; i < this.mThreads; ++i) {
            threads.add(new OperationThread());
        }
        long start = System.currentTimeMillis();
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            try {
                thread.join();
            }
            catch (InterruptedException e) {
                return -1;
            }
        }
        System.out.println("Completed in " + (System.currentTimeMillis() - start) + "ms");
        return 0;
    }

    private final class OperationThread
    extends Thread {
        private OperationThread() {
        }

        @Override
        public void run() {
            while (RunOperation.this.mRemainingOps.decrementAndGet() >= 0) {
                try {
                    this.applyOperation();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }

        private void applyOperation() throws IOException, AlluxioException {
            AlluxioURI uri = new AlluxioURI(String.format("%s/%s", RunOperation.BASE_DIRECTORY, UUID.randomUUID()));
            switch (RunOperation.this.mOperation) {
                case CreateEmptyFile: {
                    RunOperation.this.mFileSystem.createFile(uri).close();
                    break;
                }
                case CreateAndDeleteEmptyFile: {
                    RunOperation.this.mFileSystem.createFile(uri).close();
                    RunOperation.this.mFileSystem.delete(uri);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation: " + (Object)((Object)RunOperation.this.mOperation));
                }
            }
        }
    }

    static enum Operation {
        CreateEmptyFile,
        CreateAndDeleteEmptyFile;

    }
}

