/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.ClientContext;
import alluxio.client.block.BlockMasterClient;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.status.UnavailableException;
import alluxio.master.MasterClientContext;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.WaitForOptions;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.ImmutableMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AlluxioFrameworkIntegrationTest {
    private static final Logger LOG = LoggerFactory.getLogger(AlluxioFrameworkIntegrationTest.class);
    private static InstancedConfiguration sConf = new InstancedConfiguration(ConfigurationUtils.defaults());
    private static final String JDK_URL = "https://s3-us-west-2.amazonaws.com/alluxio-mesos/jdk-7u79-macosx-x64.tar.gz";
    private static final String JDK_PATH = "jdk1.7.0_79.jdk/Contents/Home";
    @Parameter(names={"-m", "--mesos"}, required=true, description="Address for locally-running Mesos, e.g. localhost:5050")
    private String mMesosAddress;
    @Parameter(names={"-a", "--alluxio"}, description="URL of an Alluxio tarball to test. Otherwise only test local Alluxio")
    private String mAlluxioUrl;
    @Parameter(names={"-h", "--help"}, help=true)
    private boolean mHelp = false;

    private AlluxioFrameworkIntegrationTest() {
    }

    private void run() throws Exception {
        AlluxioFrameworkIntegrationTest.checkMesosRunning();
        AlluxioFrameworkIntegrationTest.stopAlluxio();
        AlluxioFrameworkIntegrationTest.stopAlluxioFramework();
        this.runTests();
        LOG.info("All tests passed!");
    }

    private void runTests() throws Exception {
        LOG.info("Testing deployment with preinstalled alluxio and jdk");
        this.testMesosDeploy((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.INTEGRATION_MESOS_JDK_URL, (Object)"LOCAL", (Object)PropertyKey.INTEGRATION_MESOS_ALLUXIO_JAR_URL, (Object)"LOCAL"));
        LOG.info("Testing deployment with downloaded jdk");
        this.testMesosDeploy((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.INTEGRATION_MESOS_JDK_URL, (Object)JDK_URL, (Object)PropertyKey.INTEGRATION_MESOS_ALLUXIO_JAR_URL, (Object)"LOCAL", (Object)PropertyKey.INTEGRATION_MESOS_JDK_PATH, (Object)JDK_PATH));
        if (this.mAlluxioUrl != null) {
            LOG.info("Testing deployment with downloaded Alluxio");
            this.testMesosDeploy((Map<PropertyKey, String>)ImmutableMap.of((Object)PropertyKey.INTEGRATION_MESOS_JDK_URL, (Object)"LOCAL", (Object)PropertyKey.INTEGRATION_MESOS_ALLUXIO_JAR_URL, (Object)this.mAlluxioUrl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testMesosDeploy(Map<PropertyKey, String> properties) throws Exception {
        StringBuilder alluxioJavaOpts = new StringBuilder(System.getProperty("ALLUXIO_JAVA_OPTS", ""));
        for (Map.Entry<PropertyKey, String> entry : properties.entrySet()) {
            alluxioJavaOpts.append(String.format(" -D%s=%s", entry.getKey().toString(), entry.getValue()));
        }
        ImmutableMap env = ImmutableMap.of((Object)"ALLUXIO_JAVA_OPTS", (Object)alluxioJavaOpts.toString());
        try {
            this.startAlluxioFramework((Map<String, String>)env);
            LOG.info("Launched Alluxio cluster, waiting for worker to register with master");
            ClientContext ctx = ClientContext.create((AlluxioConfiguration)sConf);
            try (BlockMasterClient client = BlockMasterClient.Factory.create((MasterClientContext)MasterClientContext.newBuilder((ClientContext)ctx).build());){
                CommonUtils.waitFor((String)"Alluxio worker to register with master", () -> {
                    try {
                        try {
                            return !client.getWorkerInfoList().isEmpty();
                        }
                        catch (UnavailableException e) {
                            return false;
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }, (WaitForOptions)WaitForOptions.defaults().setTimeoutMs(900000));
            }
            LOG.info("Worker registered");
            AlluxioFrameworkIntegrationTest.basicAlluxioTests();
        }
        finally {
            AlluxioFrameworkIntegrationTest.stopAlluxioFramework();
        }
    }

    private void startAlluxioFramework(Map<String, String> extraEnv) {
        String startScript = PathUtils.concatPath((Object)sConf.get(PropertyKey.HOME), (Object[])new Object[]{"integration", "mesos", "bin", "alluxio-mesos-start.sh"});
        ProcessBuilder pb = new ProcessBuilder(startScript, this.mMesosAddress);
        Map<String, String> env = pb.environment();
        env.putAll(extraEnv);
        try {
            pb.start().waitFor();
        }
        catch (Exception e) {
            LOG.info("Failed to launch Alluxio on Mesos. Note that this test requires that Mesos is currently running.");
            throw new RuntimeException(e);
        }
    }

    private static void basicAlluxioTests() throws Exception {
        LOG.info("Running tests");
        FileSystem fs = FileSystem.Factory.create((AlluxioConfiguration)sConf);
        int listSize = fs.listStatus(new AlluxioURI("/")).size();
        if (listSize != 1) {
            throw new RuntimeException("Expected 1 path to exist at the root, but found " + listSize);
        }
        FileOutStream outStream = fs.createFile(new AlluxioURI("/test"));
        outStream.write("abc".getBytes());
        outStream.close();
        FileInStream inStream = fs.openFile(new AlluxioURI("/test"));
        String result = IOUtils.toString((InputStream)inStream);
        if (!result.equals("abc")) {
            throw new RuntimeException("Expected abc but got " + result);
        }
        LOG.info("Tests passed");
    }

    private static void checkMesosRunning() throws Exception {
        for (String processName : new String[]{"mesos-master", "mesos-slave"}) {
            if (AlluxioFrameworkIntegrationTest.processExists(processName)) continue;
            throw new IllegalStateException(String.format("Couldn't find local '%s' process. Mesos must be running locally to use this test", processName));
        }
    }

    private static boolean processExists(String processName) throws Exception {
        Process ps = Runtime.getRuntime().exec(new String[]{"ps", "ax"});
        InputStream psOutput = ps.getInputStream();
        Process processGrep = Runtime.getRuntime().exec(new String[]{"grep", processName});
        OutputStream processGrepInput = processGrep.getOutputStream();
        IOUtils.copy((InputStream)psOutput, (OutputStream)processGrepInput);
        InputStream processGrepOutput = processGrep.getInputStream();
        processGrepInput.close();
        Process filterGrep = Runtime.getRuntime().exec(new String[]{"grep", "-v", "grep"});
        OutputStream filterGrepInput = filterGrep.getOutputStream();
        IOUtils.copy((InputStream)processGrepOutput, (OutputStream)filterGrepInput);
        filterGrepInput.close();
        return IOUtils.readLines((InputStream)filterGrep.getInputStream()).size() >= 1;
    }

    private static void stopAlluxioFramework() throws Exception {
        String stopScript = PathUtils.concatPath((Object)sConf.get(PropertyKey.HOME), (Object[])new Object[]{"integration", "mesos", "bin", "alluxio-mesos-stop.sh"});
        ProcessBuilder pb = new ProcessBuilder(stopScript);
        pb.start().waitFor();
        CommonUtils.sleepMs((long)5000L);
    }

    private static void stopAlluxio() throws Exception {
        String stopScript = PathUtils.concatPath((Object)sConf.get(PropertyKey.HOME), (Object[])new Object[]{"bin", "alluxio-stop.sh"});
        ProcessBuilder pb = new ProcessBuilder(stopScript, "all");
        pb.start().waitFor();
    }

    public static void main(String[] args) throws Exception {
        AlluxioFrameworkIntegrationTest test = new AlluxioFrameworkIntegrationTest();
        JCommander jc = new JCommander((Object)test);
        jc.setProgramName(AlluxioFrameworkIntegrationTest.class.getName());
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            jc.usage();
            System.exit(1);
        }
        if (test.mHelp) {
            jc.usage();
        } else {
            test.run();
        }
    }
}

