/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.conf.Source;
import alluxio.examples.RelatedS3Operations;
import alluxio.examples.S3ASpecificOperations;
import alluxio.examples.UnderFileSystemCommonOperations;
import alluxio.underfs.UfsFileStatus;
import alluxio.underfs.UfsStatus;
import alluxio.underfs.UnderFileSystem;
import alluxio.underfs.UnderFileSystemConfiguration;
import alluxio.underfs.UnderFileSystemFactory;
import alluxio.underfs.UnderFileSystemFactoryRegistry;
import alluxio.underfs.options.DeleteOptions;
import alluxio.util.ConfigurationUtils;
import alluxio.util.io.PathUtils;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public final class UnderFileSystemContractTest {
    private static final String S3_IDENTIFIER = "s3";
    @Parameter(names={"--path"}, required=true, description="The under filesystem path to run tests against.")
    private String mUfsPath;
    @Parameter(names={"--help"}, help=true)
    private boolean mHelp = false;
    private InstancedConfiguration mConf = new InstancedConfiguration(ConfigurationUtils.defaults());
    private UnderFileSystem mUfs;

    private UnderFileSystemContractTest() {
    }

    private void run() throws Exception {
        UnderFileSystemConfiguration ufsConf = this.getUfsConf();
        UnderFileSystemFactory factory = UnderFileSystemFactoryRegistry.find((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
        if (factory == null || !factory.supportsPath(this.mUfsPath)) {
            System.out.printf("%s is not a valid path", this.mUfsPath);
            System.exit(1);
        }
        this.mConf.set(PropertyKey.UNDERFS_LISTING_LENGTH, (Object)"50");
        this.mConf.set(PropertyKey.USER_BLOCK_SIZE_BYTES_DEFAULT, (Object)"512B");
        this.mConf.set(PropertyKey.MASTER_JOURNAL_FLUSH_BATCH_TIME_MS, (Object)"1sec");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsPath, (UnderFileSystemConfiguration)ufsConf);
        this.runCommonOperations();
        if (this.mUfs.getUnderFSType().equals(S3_IDENTIFIER)) {
            this.runS3Operations();
        }
        System.out.println("All tests passed!");
    }

    private UnderFileSystemConfiguration getUfsConf() {
        return UnderFileSystemConfiguration.defaults((AlluxioConfiguration)this.mConf).createMountSpecificConf(this.mConf.copyProperties().entrySet().stream().filter(entry -> this.mConf.getSource((PropertyKey)entry.getKey()) == Source.SYSTEM_PROPERTY).filter(entry -> this.mConf.isSet((PropertyKey)entry.getKey()) && !((String)entry.getValue()).isEmpty()).collect(Collectors.toMap(entry -> ((PropertyKey)entry.getKey()).getName(), Map.Entry::getValue)));
    }

    private void runCommonOperations() throws Exception {
        String testDir = this.createTestDirectory();
        this.loadAndRunTests(new UnderFileSystemCommonOperations(this.mUfsPath, testDir, this.mUfs, this.mConf), testDir);
    }

    private void runS3Operations() throws Exception {
        this.mConf.set(PropertyKey.UNDERFS_S3_LIST_OBJECTS_V1, (Object)"true");
        this.mConf.set(PropertyKey.UNDERFS_S3_STREAMING_UPLOAD_ENABLED, (Object)"true");
        this.mConf.set(PropertyKey.UNDERFS_S3_STREAMING_UPLOAD_PARTITION_SIZE, (Object)"5MB");
        this.mConf.set(PropertyKey.UNDERFS_S3_INTERMEDIATE_UPLOAD_CLEAN_AGE, (Object)"0");
        this.mUfs = UnderFileSystem.Factory.create((String)this.mUfsPath, (UnderFileSystemConfiguration)this.getUfsConf());
        String testDir = this.createTestDirectory();
        this.loadAndRunTests(new S3ASpecificOperations(testDir, this.mUfs, this.mConf), testDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAndRunTests(Object operations, String testDir) throws Exception {
        try {
            Method[] tests;
            Field[] fields;
            Class<?> classToRun = operations.getClass();
            for (Field field : fields = classToRun.getDeclaredFields()) {
                field.setAccessible(true);
            }
            for (Method test : tests = classToRun.getDeclaredMethods()) {
                String testName = test.getName();
                if (!testName.endsWith("Test")) continue;
                System.out.printf("Running test: %s...", testName);
                try {
                    test.invoke(operations, new Object[0]);
                }
                catch (InvocationTargetException e) {
                    if (this.mUfs.getUnderFSType().equals(S3_IDENTIFIER)) {
                        this.logRelatedS3Operations(test);
                    }
                    throw new IOException(e.getTargetException());
                }
                System.out.println("Test Passed!");
                this.cleanupUfs(testDir);
            }
        }
        finally {
            this.mUfs.deleteDirectory(testDir, DeleteOptions.defaults().setRecursive(true));
            this.mUfs.close();
        }
    }

    private String createTestDirectory() throws IOException {
        String testDir = PathUtils.concatPath((Object)this.mUfsPath, (Object)UUID.randomUUID());
        this.mUfs.mkdirs(testDir);
        return testDir;
    }

    private void cleanupUfs(String directory) throws IOException {
        UfsStatus[] statuses;
        for (UfsStatus status : statuses = this.mUfs.listStatus(directory)) {
            if (status instanceof UfsFileStatus) {
                this.mUfs.deleteFile(PathUtils.concatPath((Object)directory, (Object)status.getName()));
                continue;
            }
            this.mUfs.deleteDirectory(PathUtils.concatPath((Object)directory, (Object)status.getName()), DeleteOptions.defaults().setRecursive(true));
        }
    }

    private void logRelatedS3Operations(Method test) {
        CharSequence[] ops;
        RelatedS3Operations annotation = test.getAnnotation(RelatedS3Operations.class);
        if (annotation != null && (ops = annotation.operations()).length > 0) {
            System.out.println("Related S3 operations: " + String.join((CharSequence)", ", ops));
        }
    }

    private static String getHelpMessage() {
        return "Test description:\nTest the integration between Alluxio and the under filesystem. If the given under filesystem is S3, this test can also be used as a S3 compatibility test to test if the target under filesystem can fulfill the minimum S3 compatibility requirements in order to work well with Alluxio through Alluxio's integration with S3. \nCommand line example: 'bin/alluxio runUfsTests --path s3://testPath -Daws.accessKeyId=<accessKeyId> -Daws.secretKeyId=<secretKeyId>-Dalluxio.underfs.s3.endpoint=<endpoint_url> -Dalluxio.underfs.s3.disable.dns.buckets=true'";
    }

    public static void main(String[] args) throws Exception {
        UnderFileSystemContractTest test = new UnderFileSystemContractTest();
        JCommander jc = new JCommander((Object)test);
        jc.setProgramName(UnderFileSystemContractTest.class.getName());
        try {
            jc.parse(args);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            jc.usage();
            System.out.println(UnderFileSystemContractTest.getHelpMessage());
            System.exit(1);
        }
        if (test.mHelp) {
            jc.usage();
            System.out.println(UnderFileSystemContractTest.getHelpMessage());
        } else {
            test.run();
        }
    }
}

