/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.conf.PropertyKey;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Performance {
    private static final Logger LOG = LoggerFactory.getLogger(Performance.class);
    private static final int RESULT_ARRAY_SIZE = 64;
    private static final String FOLDER = "/mnt/ramdisk/";
    private static String sFileName = null;
    private static int sBlockSizeBytes = -1;
    private static long sBlocksPerFile = -1L;
    private static int sThreads = -1;
    private static int sFiles = -1;
    private static boolean sDebugMode = false;
    private static long sFileBytes = -1L;
    private static long sFilesBytes = -1L;
    private static String sResultPrefix = null;
    private static long[] sResults = new long[64];
    private static int sBaseFileNumber = 0;
    private static boolean sAlluxioStreamingRead = false;

    private Performance() {
    }

    public static void logPerIteration(long startTimeMs, int times, String msg, int workerId) {
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000.0 * (double)sFileBytes / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(times + msg + workerId + " : " + result + " Mb/sec. Took " + takenTimeMs + " ms. ");
    }

    private static void memoryCopyTest(boolean write, boolean memoryOnly) {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        String msg = (write ? "Write" : "Read") + (memoryOnly ? "_Memory " : "_RamFile ");
        GeneralWorker[] workerThreads = new GeneralWorker[sThreads];
        int t = sFiles / sThreads;
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = new GeneralWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, memoryOnly, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = 1000.0 * (double)sFilesBytes / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + msg + " Test :  Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    private static void AlluxioTest(boolean write, alluxio.client.file.FileSystem fs) throws IOException {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] workerThreads = new Worker[sThreads];
        int t = sFiles / sThreads;
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = write ? new AlluxioWriterWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], fs) : new AlluxioReadWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], fs);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = (double)sFilesBytes * 1000.0 / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    private static void HdfsTest(boolean write) throws IOException {
        int thread;
        ByteBuffer[] bufs = new ByteBuffer[sThreads];
        for (int thread2 = 0; thread2 < sThreads; ++thread2) {
            ByteBuffer sRawData = ByteBuffer.allocate(sBlockSizeBytes);
            sRawData.order(ByteOrder.nativeOrder());
            for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                sRawData.putInt(k);
            }
            bufs[thread2] = sRawData;
        }
        Worker[] workerThreads = new Worker[sThreads];
        int t = sFiles / sThreads;
        String msg = write ? "Write " : "Read ";
        for (int thread3 = 0; thread3 < sThreads; ++thread3) {
            workerThreads[thread3] = new HdfsWorker(thread3, t * thread3, t * (thread3 + 1), bufs[thread3], write, msg);
        }
        long startTimeMs = System.currentTimeMillis();
        for (thread = 0; thread < sThreads; ++thread) {
            workerThreads[thread].start();
        }
        for (thread = 0; thread < sThreads; ++thread) {
            try {
                workerThreads[thread].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        long takenTimeMs = System.currentTimeMillis() - startTimeMs;
        double result = (double)sFilesBytes * 1000.0 / (double)takenTimeMs / 1024.0 / 1024.0;
        LOG.info(result + " Mb/sec. " + sResultPrefix + "Entire " + (write ? "Write " : "Read ") + " Took " + takenTimeMs + " ms. Current System Time: " + System.currentTimeMillis());
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 9) {
            System.out.println("java -cp target/alluxio-2.2.1-jar-with-dependencies.jar alluxio.examples.Performance <MasterIp> <FileNamePrefix> <WriteBlockSizeInBytes> <BlocksPerFile> <DebugMode:true/false> <Threads> <FilesPerThread> <TestCaseNumber> <BaseFileNumber>\n1: Files Write Test\n2: Files Read Test\n3: RamFile Write Test \n4: RamFile Read Test \n5: ByteBuffer Write Test \n6: ByteBuffer Read Test \n");
            System.exit(-1);
        }
        InstancedConfiguration conf = new InstancedConfiguration(ConfigurationUtils.defaults());
        HostAndPort masterAddress = HostAndPort.fromString((String)args[0]);
        sFileName = args[1];
        sBlockSizeBytes = Integer.parseInt(args[2]);
        sBlocksPerFile = Long.parseLong(args[3]);
        sDebugMode = "true".equals(args[4]);
        sThreads = Integer.parseInt(args[5]);
        sFiles = Integer.parseInt(args[6]) * sThreads;
        int testCase = Integer.parseInt(args[7]);
        sBaseFileNumber = Integer.parseInt(args[8]);
        sFileBytes = sBlocksPerFile * (long)sBlockSizeBytes;
        sFilesBytes = sFileBytes * (long)sFiles;
        long fileBufferBytes = conf.getBytes(PropertyKey.USER_FILE_BUFFER_BYTES);
        sResultPrefix = String.format("Threads %d FilesPerThread %d TotalFiles %d BLOCK_SIZE_KB %d BLOCKS_PER_FILE %d FILE_SIZE_MB %d Alluxio_WRITE_BUFFER_SIZE_KB %d BaseFileNumber %d : ", sThreads, sFiles / sThreads, sFiles, sBlockSizeBytes / 1024, sBlocksPerFile, sFileBytes / 0x100000L, fileBufferBytes / 1024L, sBaseFileNumber);
        CommonUtils.warmUpLoop();
        conf.set(PropertyKey.MASTER_HOSTNAME, (Object)masterAddress.getHost());
        conf.set(PropertyKey.MASTER_RPC_PORT, (Object)Integer.toString(masterAddress.getPort()));
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)conf);
        if (testCase == 1) {
            sResultPrefix = "AlluxioFilesWriteTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.AlluxioTest(true, FileSystem.Factory.create((FileSystemContext)fsContext));
        } else if (testCase == 2 || testCase == 9) {
            sResultPrefix = "AlluxioFilesReadTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            sAlluxioStreamingRead = 9 == testCase;
            Performance.AlluxioTest(false, FileSystem.Factory.create((FileSystemContext)fsContext));
        } else if (testCase == 3) {
            sResultPrefix = "RamFile Write " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(true, false);
        } else if (testCase == 4) {
            sResultPrefix = "RamFile Read " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(false, false);
        } else if (testCase == 5) {
            sResultPrefix = "ByteBuffer Write Test " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(true, true);
        } else if (testCase == 6) {
            sResultPrefix = "ByteBuffer Read Test " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.memoryCopyTest(false, true);
        } else if (testCase == 7) {
            sResultPrefix = "HdfsFilesWriteTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.HdfsTest(true);
        } else if (testCase == 8) {
            sResultPrefix = "HdfsFilesReadTest " + sResultPrefix;
            LOG.info(sResultPrefix);
            Performance.HdfsTest(false);
        } else {
            throw new RuntimeException("No Test Case " + testCase);
        }
        for (int k = 0; k < 64; ++k) {
            System.out.print(sResults[k] + " ");
        }
        System.out.println();
        System.exit(0);
    }

    public static class HdfsWorker
    extends Worker {
        private boolean mWrite;
        private String mMsg;
        private FileSystem mHdfsFs;

        public HdfsWorker(int id, int left, int right, ByteBuffer buf, boolean write, String msg) throws IOException {
            super(id, left, right, buf);
            this.mWrite = write;
            this.mMsg = msg;
            Configuration tConf = new Configuration();
            tConf.set("fs.default.name", sFileName);
            tConf.set("fs.defaultFS", sFileName);
            tConf.set("fs.hdfs.impl", "org.apache.hadoop.hdfs.DistributedFileSystem");
            tConf.set("dfs.client.read.shortcircuit", "true");
            tConf.set("dfs.domain.socket.path", "/var/lib/hadoop-hdfs/dn_socket");
            tConf.set("dfs.client.read.shortcircuit.skip.checksum", "true");
            this.mHdfsFs = FileSystem.get((Configuration)tConf);
        }

        public void io() throws IOException {
            if (sDebugMode) {
                this.mBuf.flip();
                LOG.info(FormatUtils.byteBufferToString((ByteBuffer)this.mBuf));
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            if (this.mWrite) {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = sFileName + (times + sBaseFileNumber);
                    FSDataOutputStream os = this.mHdfsFs.create(new Path(filePath));
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        this.mBuf.putInt(0, k + this.mWorkerId);
                        os.write(this.mBuf.array());
                        ++k;
                    }
                    os.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    int r;
                    long startTimeMs = System.currentTimeMillis();
                    String filePath = sFileName + (times + sBaseFileNumber);
                    FSDataInputStream is = this.mHdfsFs.open(new Path(filePath));
                    for (long len = sBlocksPerFile * (long)sBlockSizeBytes; len > 0L; len -= (long)r) {
                        r = is.read(this.mBuf.array());
                        Preconditions.checkState((r != -1 ? 1 : 0) != 0, (Object)"R == -1");
                    }
                    is.close();
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.io();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info(this.mMsg + this.mWorkerId + " just finished.");
        }
    }

    public static class AlluxioReadWorker
    extends Worker {
        private alluxio.client.file.FileSystem mFileSystem;

        public AlluxioReadWorker(int id, int left, int right, ByteBuffer buf, alluxio.client.file.FileSystem fs) {
            super(id, left, right, buf);
            this.mFileSystem = fs;
        }

        public void readPartition() throws IOException, AlluxioException {
            if (sDebugMode) {
                ByteBuffer buf = ByteBuffer.allocate((int)((long)sBlockSizeBytes * sBlocksPerFile));
                LOG.info("Verifying the reading data...");
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    FileInStream is = this.mFileSystem.openFile(new AlluxioURI(sFileName + (pId + sBaseFileNumber)));
                    is.read(buf.array());
                    buf.order(ByteOrder.nativeOrder());
                    int i = 0;
                    while ((long)i < sBlocksPerFile) {
                        for (int k = 0; k < sBlockSizeBytes / 4; ++k) {
                            int tmp = buf.getInt();
                            if (!(k == 0 && tmp == i + this.mWorkerId || k != 0 && tmp == k)) {
                                throw new IllegalStateException("WHAT? " + tmp + " " + k);
                            }
                            LOG.debug("Partition at {} is {}", (Object)k, (Object)tmp);
                        }
                        ++i;
                    }
                    is.close();
                }
            }
            long sum = 0L;
            if (sAlluxioStreamingRead) {
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    int r;
                    long startTimeMs = System.currentTimeMillis();
                    FileInStream is = this.mFileSystem.openFile(new AlluxioURI(sFileName + (pId + sBaseFileNumber)));
                    for (long len = sBlocksPerFile * (long)sBlockSizeBytes; len > 0L; len -= (long)r) {
                        r = is.read(this.mBuf.array());
                        Preconditions.checkState((r != -1 ? 1 : 0) != 0, (Object)"R == -1");
                    }
                    is.close();
                    Performance.logPerIteration(startTimeMs, pId, "th ReadAlluxioFile @ Worker ", pId);
                }
            } else {
                for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                    long startTimeMs = System.currentTimeMillis();
                    FileInStream is = this.mFileSystem.openFile(new AlluxioURI(sFileName + (pId + sBaseFileNumber)));
                    int i = 0;
                    while ((long)i < sBlocksPerFile) {
                        is.read(this.mBuf.array());
                        ++i;
                    }
                    sum += (long)this.mBuf.get(pId % 16);
                    if (sDebugMode) {
                        this.mBuf.order(ByteOrder.nativeOrder());
                        this.mBuf.flip();
                        LOG.info(FormatUtils.byteBufferToString((ByteBuffer)this.mBuf));
                    }
                    this.mBuf.clear();
                    Performance.logPerIteration(startTimeMs, pId, "th ReadAlluxioFile @ Worker ", pId);
                    is.close();
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.readPartition();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info("ReadWorker " + this.mWorkerId + " just finished.");
        }
    }

    public static class AlluxioWriterWorker
    extends Worker {
        private alluxio.client.file.FileSystem mFileSystem;

        public AlluxioWriterWorker(int id, int left, int right, ByteBuffer buf, alluxio.client.file.FileSystem fs) {
            super(id, left, right, buf);
            this.mFileSystem = fs;
        }

        public void writePartition() throws IOException, AlluxioException {
            if (sDebugMode) {
                this.mBuf.flip();
                LOG.info(FormatUtils.byteBufferToString((ByteBuffer)this.mBuf));
            }
            this.mBuf.flip();
            for (int pId = this.mLeft; pId < this.mRight; ++pId) {
                long startTimeMs = System.currentTimeMillis();
                FileOutStream os = this.mFileSystem.createFile(new AlluxioURI(sFileName + (pId + sBaseFileNumber)), CreateFilePOptions.newBuilder().setRecursive(true).build());
                int k = 0;
                while ((long)k < sBlocksPerFile) {
                    this.mBuf.putInt(0, k + this.mWorkerId);
                    os.write(this.mBuf.array());
                    ++k;
                }
                os.close();
                Performance.logPerIteration(startTimeMs, pId, "th WriteAlluxioFile @ Worker ", pId);
            }
        }

        @Override
        public void run() {
            try {
                this.writePartition();
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info("WriteWorker " + this.mWorkerId + " just finished.");
        }
    }

    public static class GeneralWorker
    extends Worker {
        private boolean mOneToMany;
        private boolean mMemoryOnly;
        private String mMsg;

        public GeneralWorker(int id, int left, int right, ByteBuffer buf, boolean oneToMany, boolean memoryOnly, String msg) {
            super(id, left, right, buf);
            this.mOneToMany = oneToMany;
            this.mMemoryOnly = memoryOnly;
            this.mMsg = msg;
        }

        public void memoryCopyPartition() throws IOException {
            if (sDebugMode) {
                this.mBuf.flip();
                LOG.info(FormatUtils.byteBufferToString((ByteBuffer)this.mBuf));
            }
            this.mBuf.flip();
            long sum = 0L;
            String str = "th " + this.mMsg + " @ Worker ";
            if (this.mOneToMany) {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)sFileBytes);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (times + sBaseFileNumber), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, sFileBytes);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        this.mBuf.putInt(0, k + this.mWorkerId);
                        dst.put(this.mBuf.array());
                        ++k;
                    }
                    dst.clear();
                    sum += (long)dst.get(times);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            } else {
                ByteBuffer dst = null;
                RandomAccessFile file = null;
                if (this.mMemoryOnly) {
                    dst = ByteBuffer.allocateDirect((int)sFileBytes);
                }
                for (int times = this.mLeft; times < this.mRight; ++times) {
                    long startTimeMs = System.currentTimeMillis();
                    if (!this.mMemoryOnly) {
                        file = new RandomAccessFile(Performance.FOLDER + (times + sBaseFileNumber), "rw");
                        dst = file.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, sFileBytes);
                    }
                    dst.order(ByteOrder.nativeOrder());
                    int k = 0;
                    while ((long)k < sBlocksPerFile) {
                        dst.get(this.mBuf.array());
                        ++k;
                    }
                    sum += (long)this.mBuf.get(times % 16);
                    dst.clear();
                    if (!this.mMemoryOnly) {
                        file.close();
                    }
                    Performance.logPerIteration(startTimeMs, times, str, this.mWorkerId);
                }
            }
            sResults[this.mWorkerId] = sum;
        }

        @Override
        public void run() {
            try {
                this.memoryCopyPartition();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
            LOG.info(this.mMsg + this.mWorkerId + " just finished.");
        }
    }

    public static abstract class Worker
    extends Thread {
        protected int mWorkerId;
        protected int mLeft;
        protected int mRight;
        protected ByteBuffer mBuf;

        public Worker(int id, int left, int right, ByteBuffer buf) {
            this.mWorkerId = id;
            this.mLeft = left;
            this.mRight = right;
            this.mBuf = buf;
        }
    }
}

