/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.cli.CliUtils;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.client.file.URIStatus;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.util.ConfigurationUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicCheckpoint
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicCheckpoint.class);
    private final String mFileFolder;
    private final int mNumFiles;
    private final FileSystemContext mFsContext;

    public BasicCheckpoint(String fileFolder, int numFiles, FileSystemContext fsContext) {
        this.mFileFolder = fileFolder;
        this.mNumFiles = numFiles;
        this.mFsContext = fsContext;
    }

    @Override
    public Boolean call() throws Exception {
        FileSystem fs = FileSystem.Factory.create((FileSystemContext)this.mFsContext);
        this.writeFile(fs);
        return this.readFile(fs);
    }

    private boolean readFile(FileSystem fs) throws IOException, AlluxioException {
        boolean pass = true;
        for (int i = 0; i < this.mNumFiles; ++i) {
            AlluxioURI filePath = new AlluxioURI(this.mFileFolder + "/part-" + i);
            LOG.debug("Reading data from {}", (Object)filePath);
            FileInStream is = fs.openFile(filePath);
            URIStatus status = fs.getStatus(filePath);
            ByteBuffer buf = ByteBuffer.allocate((int)status.getBlockSizeBytes());
            is.read(buf.array());
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < this.mNumFiles; ++k) {
                pass = pass && buf.getInt() == k;
            }
            is.close();
        }
        return pass;
    }

    private void writeFile(FileSystem fs) throws IOException, AlluxioException {
        for (int i = 0; i < this.mNumFiles; ++i) {
            ByteBuffer buf = ByteBuffer.allocate(80);
            buf.order(ByteOrder.nativeOrder());
            for (int k = 0; k < this.mNumFiles; ++k) {
                buf.putInt(k);
            }
            buf.flip();
            AlluxioURI filePath = new AlluxioURI(this.mFileFolder + "/part-" + i);
            LOG.debug("Writing data to {}", (Object)filePath);
            FileOutStream os = fs.createFile(filePath, CreateFilePOptions.newBuilder().setRecursive(true).build());
            os.write(buf.array());
            os.close();
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.out.println("java -cp target/alluxio-2.2.2-1-jar-with-dependencies.jar alluxio.examples.BasicCheckpoint <FileFolder> <Files>");
            System.exit(-1);
        }
        FileSystemContext fsContext = FileSystemContext.create((AlluxioConfiguration)new InstancedConfiguration(ConfigurationUtils.defaults()));
        boolean result = CliUtils.runExample(new BasicCheckpoint(args[0], Integer.parseInt(args[1]), fsContext));
        System.exit(result ? 0 : 1);
    }
}

