/*
 * Decompiled with CFR 0.152.
 */
package alluxio.examples;

import alluxio.AlluxioURI;
import alluxio.client.ReadType;
import alluxio.client.WriteType;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.client.file.FileSystemContext;
import alluxio.exception.AlluxioException;
import alluxio.grpc.CreateFilePOptions;
import alluxio.grpc.OpenFilePOptions;
import alluxio.util.CommonUtils;
import alluxio.util.FormatUtils;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class BasicOperations
implements Callable<Boolean> {
    private static final Logger LOG = LoggerFactory.getLogger(BasicOperations.class);
    private static final int NUMBERS = 20;
    private final AlluxioURI mFilePath;
    private final OpenFilePOptions mReadOptions;
    private final CreateFilePOptions mWriteOptions;
    private final FileSystemContext mFsContext;

    public BasicOperations(AlluxioURI filePath, ReadType readType, WriteType writeType, FileSystemContext fsContext) {
        this.mFilePath = filePath;
        this.mReadOptions = OpenFilePOptions.newBuilder().setReadType(readType.toProto()).build();
        this.mWriteOptions = CreateFilePOptions.newBuilder().setWriteType(writeType.toProto()).setRecursive(true).build();
        this.mFsContext = fsContext;
    }

    @Override
    public Boolean call() throws Exception {
        FileSystem fs = FileSystem.Factory.create((FileSystemContext)this.mFsContext);
        this.writeFile(fs);
        return this.readFile(fs);
    }

    private void writeFile(FileSystem fileSystem) throws IOException, AlluxioException {
        ByteBuffer buf = ByteBuffer.allocate(80);
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            buf.putInt(k);
        }
        LOG.debug("Writing data...");
        long startTimeMs = CommonUtils.getCurrentMs();
        FileOutStream os = fileSystem.createFile(this.mFilePath, this.mWriteOptions);
        os.write(buf.array());
        os.close();
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("writeFile to file " + this.mFilePath)));
    }

    private boolean readFile(FileSystem fileSystem) throws IOException, AlluxioException {
        boolean pass = true;
        LOG.debug("Reading data...");
        long startTimeMs = CommonUtils.getCurrentMs();
        FileInStream is = fileSystem.openFile(this.mFilePath, this.mReadOptions);
        ByteBuffer buf = ByteBuffer.allocate((int)is.remaining());
        is.read(buf.array());
        buf.order(ByteOrder.nativeOrder());
        for (int k = 0; k < 20; ++k) {
            pass = pass && buf.getInt() == k;
        }
        is.close();
        LOG.info(FormatUtils.formatTimeTakenMs((long)startTimeMs, (String)("readFile file " + this.mFilePath)));
        return pass;
    }
}

