/*
 * Decompiled with CFR 0.152.
 */
package alluxio.cli;

import alluxio.AlluxioURI;
import alluxio.client.file.FileInStream;
import alluxio.client.file.FileOutStream;
import alluxio.client.file.FileSystem;
import alluxio.conf.AlluxioConfiguration;
import alluxio.conf.InstancedConfiguration;
import alluxio.util.CommonUtils;
import alluxio.util.ConfigurationUtils;
import alluxio.util.FormatUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class MiniBenchmark {
    private static final Logger LOG = LoggerFactory.getLogger(MiniBenchmark.class);
    private static final Options OPTIONS = new Options().addOption("help", false, "Show help for this test.").addOption("type", true, "The operation type (either READ or WRITE).").addOption("fileSize", true, "The file size (e.g. 1GB).").addOption("iterations", true, "The number of iterations to run.").addOption("concurrency", true, "The number of concurrent readers or writers.");
    private static boolean sHelp;
    private static OperationType sType;
    private static long sFileSize;
    private static int sIterations;
    private static int sConcurrency;

    private MiniBenchmark() {
    }

    private static void usage() {
        new HelpFormatter().printHelp(String.format("java -cp %s %s -type <[READ, WRITE]> -fileSize <fileSize> -iterations <iterations> -concurrency <concurrency>", "target/alluxio-2.7.4-jar-with-dependencies.jar", MiniBenchmark.class.getCanonicalName()), "run a mini benchmark to write or read a file", OPTIONS, "", true);
    }

    private static boolean parseInputArgs(String[] args) {
        CommandLine cmd;
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(OPTIONS, args);
        }
        catch (ParseException e) {
            System.out.println("Failed to parse input args: " + (Object)((Object)e));
            return false;
        }
        sHelp = cmd.hasOption("help");
        sType = OperationType.valueOf(cmd.getOptionValue("type", "READ"));
        sFileSize = FormatUtils.parseSpaceSize((String)cmd.getOptionValue("fileSize", "1KB"));
        sIterations = Integer.parseInt(cmd.getOptionValue("iterations", "1"));
        sConcurrency = Integer.parseInt(cmd.getOptionValue("concurrency", "1"));
        return true;
    }

    public static void main(String[] args) throws Exception {
        if (!MiniBenchmark.parseInputArgs(args)) {
            MiniBenchmark.usage();
            System.exit(-1);
        }
        if (sHelp) {
            MiniBenchmark.usage();
            System.exit(0);
        }
        CommonUtils.warmUpLoop();
        InstancedConfiguration alluxioConf = new InstancedConfiguration(ConfigurationUtils.defaults());
        for (int i = 0; i < sIterations; ++i) {
            AtomicInteger count = new AtomicInteger(0);
            CyclicBarrier barrier = new CyclicBarrier(sConcurrency);
            ExecutorService executorService = Executors.newFixedThreadPool(sConcurrency);
            AtomicLong runtime = new AtomicLong(0L);
            block5: for (int j = 0; j < sConcurrency; ++j) {
                switch (sType) {
                    case READ: {
                        executorService.submit(() -> MiniBenchmark.lambda$main$0(barrier, runtime, count, (AlluxioConfiguration)alluxioConf));
                        continue block5;
                    }
                    case WRITE: {
                        executorService.submit(() -> MiniBenchmark.lambda$main$1(barrier, runtime, count, (AlluxioConfiguration)alluxioConf));
                        continue block5;
                    }
                    default: {
                        throw new RuntimeException("Unsupported type.");
                    }
                }
            }
            executorService.shutdown();
            Preconditions.checkState((boolean)executorService.awaitTermination(1L, TimeUnit.HOURS));
            double time = (double)runtime.get() * 1.0 / (double)sConcurrency / 1.0E9;
            System.out.printf("Iteration: %d; Duration: %f seconds; Aggregated throughput: %f GB/second.%n", i, time, (double)sConcurrency * 1.0 * (double)sFileSize / time / 1.073741824E9);
        }
    }

    private static void readFile(CyclicBarrier barrier, AtomicLong runTime, int count, AlluxioConfiguration alluxioConf) throws Exception {
        FileSystem fileSystem = FileSystem.Factory.create((AlluxioConfiguration)alluxioConf);
        byte[] buffer = new byte[(int)Math.min(sFileSize, 0x400000L)];
        barrier.await();
        long startTime = System.nanoTime();
        try (FileInStream inStream = fileSystem.openFile(MiniBenchmark.filename(count));){
            while (inStream.read(buffer) != -1) {
            }
        }
        runTime.addAndGet(System.nanoTime() - startTime);
    }

    private static void writeFile(CyclicBarrier barrier, AtomicLong runtime, int count, AlluxioConfiguration alluxioConf) throws Exception {
        FileSystem fileSystem = FileSystem.Factory.create((AlluxioConfiguration)alluxioConf);
        byte[] buffer = new byte[(int)Math.min(sFileSize, 0x400000L)];
        Arrays.fill(buffer, (byte)97);
        AlluxioURI path = MiniBenchmark.filename(count);
        if (fileSystem.exists(path)) {
            fileSystem.delete(path);
        }
        barrier.await();
        long startTime = System.nanoTime();
        try (FileOutStream outStream = fileSystem.createFile(path);){
            for (long bytesWritten = 0L; bytesWritten < sFileSize; bytesWritten += (long)buffer.length) {
                outStream.write(buffer, 0, (int)Math.min((long)buffer.length, sFileSize - bytesWritten));
            }
        }
        runtime.addAndGet(System.nanoTime() - startTime);
    }

    private static AlluxioURI filename(int count) {
        return new AlluxioURI("/default_mini_benchmark_" + count);
    }

    private static /* synthetic */ void lambda$main$1(CyclicBarrier barrier, AtomicLong runtime, AtomicInteger count, AlluxioConfiguration alluxioConf) {
        try {
            MiniBenchmark.writeFile(barrier, runtime, count.addAndGet(1), alluxioConf);
        }
        catch (Exception e) {
            LOG.error("Failed to write file.", (Throwable)e);
            System.exit(-1);
        }
    }

    private static /* synthetic */ void lambda$main$0(CyclicBarrier barrier, AtomicLong runtime, AtomicInteger count, AlluxioConfiguration alluxioConf) {
        try {
            MiniBenchmark.readFile(barrier, runtime, count.addAndGet(1), alluxioConf);
        }
        catch (Exception e) {
            LOG.error("Failed to read file.", (Throwable)e);
            System.exit(-1);
        }
    }

    static enum OperationType {
        READ,
        WRITE;

    }
}

